/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSComposite;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDouble;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSIndexComposite;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSNull;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSNumber;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSOperator;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSReadable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSWriteable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoReadAccessException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoWriteAccessException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NotMatrixException;

public class EPSArray
implements EPSIndexComposite,
EPSReadable,
EPSWriteable {
    protected EPSObject[] objects_;
    private boolean hasReadAccess_ = true;
    private boolean hasWriteAccess_ = true;

    public EPSArray(int n) {
        this.objects_ = new EPSObject[n];
        for (int i = 0; i < n; ++i) {
            this.objects_[i] = new EPSNull();
        }
    }

    public EPSArray(Vector<EPSObject> vector, boolean bl) {
        int n = vector.size();
        this.objects_ = new EPSObject[n];
        for (int i = 0; i < n; ++i) {
            this.objects_[i] = vector.get(i);
        }
        this.hasWriteAccess_ = !bl;
    }

    public EPSArray(Vector<EPSObject> vector) {
        this(vector, false);
    }

    public EPSArray(EPSObject[] ePSObjectArray, boolean bl) {
        this.objects_ = new EPSObject[ePSObjectArray.length];
        for (int i = 0; i < ePSObjectArray.length; ++i) {
            this.objects_[i] = ePSObjectArray[i];
        }
        this.hasWriteAccess_ = !bl;
    }

    public EPSArray(double[] dArray, boolean bl) {
        this.objects_ = new EPSObject[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.objects_[i] = new EPSDouble(dArray[i]);
        }
        this.hasWriteAccess_ = !bl;
    }

    public EPSArray(float[] fArray, boolean bl) {
        this.objects_ = new EPSObject[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            this.objects_[i] = new EPSDouble(fArray[i]);
        }
        this.hasWriteAccess_ = !bl;
    }

    public EPSArray(EPSObject[] ePSObjectArray) {
        this(ePSObjectArray, false);
    }

    public EPSArray(double[] dArray) {
        this(dArray, false);
    }

    public EPSArray(float[] fArray) {
        this(fArray, false);
    }

    private EPSArray() {
        this(0);
    }

    public void bind(EPSStack ePSStack) throws NoReadAccessException {
        if (!this.hasWriteAccess()) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            EPSOperator ePSOperator;
            EPSObject ePSObject = this.get(i);
            if (ePSObject instanceof EPSProc) {
                ((EPSProc)ePSObject).bind(ePSStack);
                continue;
            }
            if (ePSObject instanceof EPSArray) {
                ((EPSArray)ePSObject).bind(ePSStack);
                continue;
            }
            if (!(ePSObject instanceof EPSName) || (ePSOperator = ((EPSName)ePSObject).getOperator(ePSStack)) == null) continue;
            try {
                this.set(i, ePSOperator);
                continue;
            }
            catch (NoWriteAccessException noWriteAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void forall(EPSStack ePSStack, EPSProc ePSProc) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ePSStack.add(this.get(i));
            ePSStack.execObject(ePSProc);
            if (ePSStack.getExitStatus()) break;
        }
    }

    public int size() {
        return this.objects_.length;
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public void copy(EPSObject ePSObject) throws InvalidEPSObjectException, NoWriteAccessException {
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        if (!(ePSObject instanceof EPSArray)) {
            throw new InvalidEPSObjectException("(copy) not an array");
        }
        EPSObject[] ePSObjectArray = ((EPSArray)ePSObject).objects_;
        for (int i = 0; i < ePSObjectArray.length; ++i) {
            this.set(i, ePSObjectArray[i]);
        }
    }

    public void set(int n, EPSObject ePSObject) throws NoWriteAccessException, ArrayIndexOutOfBoundsException {
        if (!this.hasWriteAccess_) {
            throw new NoWriteAccessException("array has no write access");
        }
        if (n < 0 || n >= this.objects_.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.objects_[n] = ePSObject;
    }

    @Override
    public void put(EPSObject ePSObject, EPSObject ePSObject2) throws InvalidEPSObjectException, NoWriteAccessException {
        if (!(ePSObject instanceof EPSNumber)) {
            throw new InvalidEPSObjectException("(put) invalid index");
        }
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        this.set(((EPSNumber)ePSObject).intValue(), ePSObject2);
    }

    public EPSObject get(int n) throws NoReadAccessException {
        if (!this.hasReadAccess_) {
            throw new NoReadAccessException("array has no read access");
        }
        if (n < 0 || n >= this.objects_.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.objects_[n];
    }

    @Override
    public EPSObject get(EPSObject ePSObject) throws InvalidEPSObjectException, NoReadAccessException {
        if (!(ePSObject instanceof EPSNumber)) {
            throw new InvalidEPSObjectException("(get) invalid index");
        }
        return this.get(((EPSNumber)ePSObject).intValue());
    }

    public double getDouble(int n) throws InvalidEPSObjectException, NoReadAccessException {
        if (!this.hasReadAccess_) {
            throw new NoReadAccessException();
        }
        if (this.objects_[n] instanceof EPSNumber) {
            return ((EPSNumber)this.objects_[n]).doubleValue();
        }
        throw new InvalidEPSObjectException("array element " + n + " is not a number");
    }

    public int getInteger(int n) throws InvalidEPSObjectException, NoReadAccessException {
        if (!this.hasReadAccess_) {
            throw new NoReadAccessException();
        }
        if (this.objects_[n] instanceof EPSNumber) {
            return ((EPSNumber)this.objects_[n]).intValue();
        }
        throw new InvalidEPSObjectException("array element " + n + " is not a number");
    }

    public boolean isMatrix() {
        if (this.objects_.length != 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.objects_[i] instanceof EPSNumber) continue;
            return false;
        }
        return true;
    }

    public void setMatrix(double[] dArray) throws NotMatrixException, NoWriteAccessException {
        if (!this.hasWriteAccess_) {
            throw new NoWriteAccessException();
        }
        if (this.objects_.length != 6 || dArray.length != 6) {
            throw new NotMatrixException();
        }
        for (int i = 0; i < 6; ++i) {
            this.set(i, new EPSDouble(dArray[i]));
        }
    }

    public void setIdentity() throws NotMatrixException, NoWriteAccessException {
        if (!this.hasWriteAccess_) {
            throw new NoWriteAccessException();
        }
        if (this.objects_.length != 6) {
            throw new NotMatrixException();
        }
        this.set(0, new EPSDouble(1.0));
        this.set(1, new EPSDouble(0.0));
        this.set(2, new EPSDouble(0.0));
        this.set(3, new EPSDouble(1.0));
        this.set(4, new EPSDouble(0.0));
        this.set(5, new EPSDouble(0.0));
    }

    public double[] getDoubleArray() throws InvalidEPSObjectException {
        double[] dArray = new double[this.objects_.length];
        for (int i = 0; i < this.objects_.length; ++i) {
            if (!(this.objects_[i] instanceof EPSNumber)) {
                throw new InvalidEPSObjectException("not a numerical array");
            }
            dArray[i] = ((EPSNumber)this.objects_[i]).doubleValue();
        }
        return dArray;
    }

    public double[] getMatrix() throws NotMatrixException {
        double[] dArray = null;
        try {
            dArray = this.getDoubleArray();
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new NotMatrixException();
        }
        if (dArray.length != 6) {
            throw new NotMatrixException();
        }
        return dArray;
    }

    public AffineTransform getTransform() throws NotMatrixException {
        return new AffineTransform(this.getMatrix());
    }

    @Override
    public EPSComposite getInterval(int n, int n2) throws InvalidEPSObjectException, NoReadAccessException {
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        int n3 = this.size();
        if (n + n2 > n3) {
            throw new ArrayIndexOutOfBoundsException("array subscript out of bounds");
        }
        EPSArray ePSArray = new EPSArray(n2);
        for (int i = 0; i < n2; ++i) {
            try {
                ePSArray.set(i, this.objects_[n + i]);
                continue;
            }
            catch (NoWriteAccessException noWriteAccessException) {
                // empty catch block
            }
        }
        return ePSArray;
    }

    @Override
    public void putInterval(int n, EPSComposite ePSComposite) throws InvalidEPSObjectException, NoWriteAccessException, NoReadAccessException {
        if (!(ePSComposite instanceof EPSArray)) {
            throw new InvalidEPSObjectException("array putinterval requires array subinterval");
        }
        EPSArray ePSArray = (EPSArray)ePSComposite;
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        if (!ePSArray.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        for (int i = 0; i < ePSArray.size(); ++i) {
            this.set(i + n, ePSArray.objects_[i]);
        }
    }

    public String toString() {
        String string = "[";
        int n = this.objects_.length;
        for (int i = 0; i < n; ++i) {
            string = string + this.objects_[i];
            if (i == n - 1) continue;
            string = string + " ";
        }
        string = string + "]";
        return string;
    }

    @Override
    public EPSName pstype() {
        return new EPSName("arraytype");
    }

    @Override
    public boolean hasReadAccess() {
        return this.hasReadAccess_;
    }

    @Override
    public boolean hasWriteAccess() {
        return this.hasWriteAccess_;
    }

    @Override
    public void setReadAccess(boolean bl) throws InvalidEPSObjectException {
        this.hasReadAccess_ = bl;
    }

    @Override
    public void setWriteAccess(boolean bl) throws InvalidEPSObjectException {
        this.hasWriteAccess_ = bl;
    }

    @Override
    public Object clone() {
        EPSArray ePSArray = new EPSArray(this.objects_.length);
        for (int i = 0; i < this.objects_.length; ++i) {
            ePSArray.objects_[i] = (EPSObject)this.objects_[i].clone();
        }
        ePSArray.hasReadAccess_ = this.hasReadAccess_;
        ePSArray.hasWriteAccess_ = this.hasWriteAccess_;
        return ePSArray;
    }

    @Override
    public void makeEqual(EPSObject ePSObject) {
        EPSObject[] ePSObjectArray = ((EPSArray)ePSObject).objects_;
        for (int i = 0; i < ePSObjectArray.length; ++i) {
            this.objects_[i] = ePSObjectArray[i];
        }
        this.hasReadAccess_ = ((EPSArray)ePSObject).hasReadAccess_;
        this.hasWriteAccess_ = ((EPSArray)ePSObject).hasWriteAccess_;
    }
}

