/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSBoolean;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDict;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFile;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFilter;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSString;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;

public class EPSASCIIHexDecodeFilter
extends EPSFilter {
    public EPSASCIIHexDecodeFilter(EPSObject ePSObject) throws InvalidEPSObjectException {
        super(ePSObject);
    }

    public EPSASCIIHexDecodeFilter(EPSObject ePSObject, EPSDict ePSDict) throws InvalidEPSObjectException {
        super(ePSObject, ePSDict);
    }

    protected EPSASCIIHexDecodeFilter() {
    }

    @Override
    public String getName() {
        return "ASCIIHexDecode";
    }

    @Override
    public boolean isEncoding() {
        return false;
    }

    @Override
    public void decode(PrintWriter printWriter, EPSStack ePSStack) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        EPSObject ePSObject = this.getData();
        if (ePSObject instanceof EPSString) {
            char[] cArray = ((EPSString)ePSObject).getChars();
            char[] cArray2 = new char[2];
            for (int i = 0; i < cArray.length; ++i) {
                while (!EPSString.isHex(cArray[i]) && ++i < cArray.length && cArray[i] != '>') {
                    if (EPSString.isHex(cArray[i]) || Character.isWhitespace(cArray[i])) continue;
                    throw new IOException("Invalid hex character " + cArray[i]);
                }
                if (i < cArray.length) {
                    cArray2[0] = cArray[i];
                    ++i;
                    while (!EPSString.isHex(cArray[i]) && ++i < cArray.length && cArray[i] != '>') {
                        if (EPSString.isHex(cArray[i]) || Character.isWhitespace(cArray[i])) continue;
                        throw new IOException("Invalid hex character " + cArray[i]);
                    }
                    cArray2[1] = i == cArray.length ? 48 : cArray[i];
                    int n = Integer.parseInt(new String(cArray2), 16);
                    printWriter.print((char)n);
                    continue;
                }
                break;
            }
        } else if (ePSObject instanceof EPSFile) {
            EPSFile ePSFile = (EPSFile)ePSObject;
            char[] cArray = new char[2];
            boolean bl = false;
            while (!bl) {
                int n = ePSFile.read();
                if (n == 62 || n == -1) {
                    bl = true;
                } else {
                    while (!EPSString.isHex((char)n)) {
                        n = ePSFile.read();
                        if (n != 62 && n != -1) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        cArray[0] = (char)n;
                        n = ePSFile.read();
                        if (n == 62 || n == -1) {
                            bl = true;
                            n = 48;
                        }
                        while (!EPSString.isHex((char)n)) {
                            n = ePSFile.read();
                            if (n != 62 && n != -1) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            n = 48;
                        }
                        cArray[1] = (char)n;
                        int n2 = Integer.parseInt(new String(cArray), 16);
                        printWriter.print((char)n2);
                        continue;
                    }
                }
                break;
            }
        } else if (ePSObject instanceof EPSProc) {
            EPSProc ePSProc = (EPSProc)ePSObject;
            boolean bl = false;
            EPSString ePSString = new EPSString(0);
            EPSBoolean ePSBoolean = new EPSBoolean(true);
            while (!bl) {
                int n;
                ePSStack.add(ePSString);
                ePSStack.add(ePSBoolean);
                ePSStack.execProc(ePSProc);
                EPSString ePSString2 = ePSStack.popEPSString();
                char[] cArray = ePSString2.getChars();
                if (cArray.length == 0) {
                    bl = true;
                    break;
                }
                char[] cArray3 = new char[cArray.length];
                char[] cArray4 = new char[2];
                int n3 = 0;
                for (n = 0; n < cArray.length; ++n) {
                    while (!EPSString.isHex(cArray[n]) && ++n < cArray.length) {
                        if (cArray[n] == '>') {
                            bl = true;
                            break;
                        }
                        if (EPSString.isHex(cArray[n]) || Character.isWhitespace(cArray[n])) continue;
                        throw new IOException("Invalid hex character " + cArray[n]);
                    }
                    if (n >= cArray.length || bl) break;
                    cArray4[0] = cArray[n];
                    ++n;
                    while (!EPSString.isHex(cArray[n]) && ++n < cArray.length) {
                        if (cArray[n] == '>') {
                            bl = true;
                            break;
                        }
                        if (EPSString.isHex(cArray[n]) || Character.isWhitespace(cArray[n])) continue;
                        throw new IOException("Invalid hex character " + cArray[n]);
                    }
                    cArray4[1] = n >= cArray.length ? 48 : cArray[n];
                    int n4 = Integer.parseInt(new String(cArray4), 16);
                    printWriter.print((char)n4);
                    cArray3[n3] = (char)n4;
                    ++n3;
                }
                ePSString = new EPSString(n3);
                for (n = 0; n < n3; ++n) {
                    ePSString.put(n, cArray3[n]);
                }
            }
            ePSBoolean.set(false);
            ePSStack.add(ePSString);
            ePSStack.add(ePSBoolean);
            ePSStack.execProc(ePSProc);
        }
    }

    @Override
    public Object clone() {
        EPSASCIIHexDecodeFilter ePSASCIIHexDecodeFilter = new EPSASCIIHexDecodeFilter();
        ePSASCIIHexDecodeFilter.makeEqual(this);
        return ePSASCIIHexDecodeFilter;
    }
}

