/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSBoolean;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDict;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFile;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFilter;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSString;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;

public class EPSASCII85DecodeFilter
extends EPSFilter {
    public EPSASCII85DecodeFilter(EPSObject ePSObject) throws InvalidEPSObjectException {
        super(ePSObject);
    }

    public EPSASCII85DecodeFilter(EPSObject ePSObject, EPSDict ePSDict) throws InvalidEPSObjectException {
        super(ePSObject, ePSDict);
    }

    protected EPSASCII85DecodeFilter() {
    }

    @Override
    public String getName() {
        return "ASCII85Decode";
    }

    @Override
    public boolean isEncoding() {
        return false;
    }

    private void decode(PrintWriter printWriter, int[] nArray, int n) {
        int[] nArray2 = new int[4];
        int n2 = nArray[0] * 52200625 + nArray[1] * 614125 + nArray[2] * 7225 + nArray[3] * 85 + nArray[4];
        nArray2[0] = n2 / 0x1000000;
        nArray2[1] = (n2 -= nArray2[0] * 0x1000000) / 65536;
        nArray2[2] = (n2 -= nArray2[1] * 65536) / 256;
        nArray2[3] = n2 -= nArray2[2] * 256;
        for (int i = 0; i < 4 && i < n; ++i) {
            printWriter.print((char)nArray2[i]);
        }
    }

    @Override
    public void decode(PrintWriter printWriter, EPSStack ePSStack) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        EPSObject ePSObject = this.getData();
        if (ePSObject instanceof EPSString) {
            char[] cArray = ((EPSString)ePSObject).getChars();
            int[] nArray = new int[5];
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                while (Character.isWhitespace(cArray[i]) && ++i != cArray.length) {
                }
                nArray[n++] = cArray[i];
                if (n != 5) continue;
                this.decode(printWriter, nArray, 5);
                n = 0;
            }
            if (n > 1 && n < 5) {
                this.decode(printWriter, nArray, n);
            }
        } else if (ePSObject instanceof EPSFile) {
            EPSFile ePSFile = (EPSFile)ePSObject;
            boolean bl = false;
            int[] nArray = new int[5];
            while (!bl) {
                int n;
                int n2 = 0;
                int n3 = -1;
                n2 = 0;
                while (n2 < 5) {
                    nArray[n2] = n3 == -1 ? ePSFile.read() : n3;
                    while (Character.isWhitespace(nArray[n2])) {
                        nArray[n2] = ePSFile.read();
                    }
                    if (nArray[n2] == -1) {
                        bl = true;
                        break;
                    }
                    if (nArray[n2] == 122) {
                        for (n = 0; n < 5; ++n) {
                            nArray[n] = 0;
                        }
                        n2 = 5;
                        break;
                    }
                    if (nArray[n2] == 126 && (n3 = ePSFile.read()) == 62) {
                        --n2;
                        bl = true;
                        break;
                    }
                    int n4 = n2++;
                    nArray[n4] = nArray[n4] - 33;
                }
                if (bl) {
                    if (n2 >= 1) {
                        for (n = n2 + 1; n < 5; ++n) {
                            nArray[n] = 84;
                        }
                    }
                    break;
                }
                this.decode(printWriter, nArray, n2);
            }
        } else if (ePSObject instanceof EPSProc) {
            EPSProc ePSProc = (EPSProc)ePSObject;
            boolean bl = false;
            EPSString ePSString = new EPSString(0);
            EPSBoolean ePSBoolean = new EPSBoolean(true);
            int n = 0;
            int[] nArray = new int[5];
            while (!bl) {
                ePSStack.add(ePSString);
                ePSStack.add(ePSBoolean);
                ePSStack.execProc(ePSProc);
                EPSString ePSString2 = ePSStack.popEPSString();
                char[] cArray = ePSString2.getChars();
                if (cArray.length == 0) {
                    bl = true;
                    break;
                }
                for (int i = 0; i < cArray.length; ++i) {
                    while (Character.isWhitespace(cArray[i]) && ++i != cArray.length) {
                    }
                    nArray[n++] = cArray[i];
                    if (n != 5) continue;
                    this.decode(printWriter, nArray, 5);
                    n = 0;
                }
            }
            if (n > 1 && n < 5) {
                this.decode(printWriter, nArray, n);
            }
            ePSBoolean.set(false);
            ePSStack.add(ePSString);
            ePSStack.add(ePSBoolean);
            ePSStack.execProc(ePSProc);
        }
    }

    @Override
    public Object clone() {
        EPSASCII85DecodeFilter ePSASCII85DecodeFilter = new EPSASCII85DecodeFilter();
        ePSASCII85DecodeFilter.makeEqual(this);
        return ePSASCII85DecodeFilter;
    }
}

