/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;

public class SVG {
    public static void save(JDRGroup jDRGroup, String string, PrintWriter printWriter) throws IOException {
        BBox bBox = jDRGroup.getBBox();
        double d = bBox.getWidth();
        double d2 = bBox.getHeight();
        printWriter.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        printWriter.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\"");
        printWriter.println("         \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
        printWriter.println("<svg width=\"" + d + "\" height=\"" + d2 + "\"");
        printWriter.println("     viewBox=\"" + bBox.getMinX() + " " + bBox.getMinY() + " " + bBox.getMaxX() + " " + bBox.getMaxY() + "\"");
        printWriter.println("     transform=\"scale(1.25,1.25)\"");
        printWriter.println("     version=\"1.1\"");
        printWriter.println("     xmlns=\"http://www.w3.org/2000/svg\"");
        printWriter.println("     xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        printWriter.println("   <title>" + string + "</title>");
        if (!jDRGroup.description.equals("")) {
            printWriter.println("   <desc>" + jDRGroup.description + "</desc>");
        }
        printWriter.println("   <defs>");
        JDRBasicStroke.svgDefs(printWriter, jDRGroup);
        JDRGradient.svgDefs(printWriter, jDRGroup);
        JDRRadial.svgDefs(printWriter, jDRGroup);
        printWriter.println("   </defs>");
        for (int i = 0; i < jDRGroup.size(); ++i) {
            jDRGroup.get(i).saveSVG(printWriter);
        }
        printWriter.println("</svg>");
    }

    public static void savePoint(PrintWriter printWriter, double d, double d2) {
        printWriter.print("" + d + " " + d2 + " ");
    }

    public static void savePoint(PrintWriter printWriter, Point2D point2D) {
        printWriter.print("" + point2D.getX() + " " + point2D.getY() + " ");
    }
}

