/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFontBase;

public class PGF {
    public static NumberFormat df = new DecimalFormat("#####0.0#####", new DecimalFormatSymbols(Locale.ENGLISH));
    protected static DateFormat dateFormat = DateFormat.getDateTimeInstance();

    public static void save(JDRGroup jDRGroup, PrintWriter printWriter, String string) throws IOException {
        BBox bBox = jDRGroup.getBBox();
        double d = -bBox.getMinX();
        double d2 = -bBox.getMaxY();
        AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, d, -d2);
        printWriter.println("% " + string);
        printWriter.println("% " + dateFormat.format(new Date()));
        printWriter.println("\\begin{pgfpicture}{0bp}{0bp}{" + PGF.format(bBox.getWidth()) + "bp}{" + PGF.format(bBox.getHeight()) + "bp}");
        printWriter.print(jDRGroup.pgf(affineTransform));
        printWriter.println("\\end{pgfpicture}");
    }

    public static void saveDoc(JDRGroup jDRGroup, JDRPaper jDRPaper, LaTeXFontBase laTeXFontBase, String string, PrintWriter printWriter, String string2) throws IOException {
        BBox bBox = jDRGroup.getBBox();
        int n = (int)laTeXFontBase.getNormalSize();
        double d = -bBox.getMinX();
        double d2 = -bBox.getMaxY();
        AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, d, -d2);
        printWriter.println("% " + string2);
        printWriter.println("% " + dateFormat.format(new Date()));
        if (n >= 10 || n <= 12) {
            printWriter.println("\\documentclass[" + n + "pt]{article}");
        } else if (n == 25) {
            printWriter.println("\\documentclass{a0poster}");
        } else {
            printWriter.println("\\documentclass[" + n + "pt]{extarticle}");
        }
        printWriter.println("\\usepackage[" + jDRPaper.tex() + ",top=" + PGF.format(bBox.getMinY()) + "bp,left=" + PGF.format(bBox.getMinX()) + "bp,width=" + PGF.format(bBox.getWidth()) + "bp,height=" + PGF.format(bBox.getHeight()) + "bp]{geometry}");
        printWriter.println("\\usepackage{pgf}");
        if (jDRGroup.anyTextPaths()) {
            printWriter.println("\\usepgflibrary{decorations.text}");
        }
        printWriter.print(string);
        printWriter.println("\\pagestyle{empty}");
        printWriter.println("\\begin{document}\\noindent");
        printWriter.println("\\begin{pgfpicture}{0bp}{0bp}{" + PGF.format(bBox.getWidth()) + "bp}{" + PGF.format(bBox.getHeight()) + "bp}");
        printWriter.print(jDRGroup.pgf(affineTransform));
        printWriter.println("\\end{pgfpicture}");
        printWriter.println("\\end{document}");
    }

    public static String format(double d) {
        return df.format(d);
    }

    public static String point(AffineTransform affineTransform, double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Point2D point2D = affineTransform.transform(double_, null);
        return PGF.point(point2D.getX(), point2D.getY());
    }

    public static String point(double d, double d2) {
        return new String("\\pgfpoint{" + PGF.format(d) + "bp}{" + PGF.format(d2) + "bp}");
    }

    public static String transform(double[] dArray) {
        return "\\pgftransformcm{" + PGF.format(dArray[0]) + "}{" + PGF.format(dArray[1]) + "}{" + PGF.format(dArray[2]) + "}{" + PGF.format(dArray[3]) + "}{" + PGF.point(dArray[4], dArray[5]) + "}";
    }

    public static String transform(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        PGF.transform(dArray);
        return PGF.transform(dArray);
    }
}

