/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io;

import uk.ac.uea.cmp.nlct.jdr.io.JDRMessage;

public class JDRDefaultMessage
implements JDRMessage {
    private int progressMax = 100;
    private int progressValue = 0;
    private boolean indeterminate_ = true;
    private boolean showMessages = false;
    private boolean suspended = false;

    @Override
    public void setIndeterminate(boolean bl) {
        this.indeterminate_ = bl;
    }

    @Override
    public boolean isIndeterminate() {
        return this.indeterminate_;
    }

    @Override
    public void incrementProgress() {
        this.setProgress(this.progressValue + 1);
    }

    @Override
    public int getProgress() {
        return this.progressValue;
    }

    @Override
    public void setProgress(int n) {
        this.progressValue = n;
        if (this.showMessages) {
            if (this.isIndeterminate()) {
                System.out.print(".");
            } else {
                int n2 = (int)Math.round((double)n / (double)this.progressMax * 100.0);
                if (n2 < 10) {
                    System.out.print("  " + n2 + "%");
                } else if (n2 < 99) {
                    System.out.print(" " + n2 + "%");
                } else {
                    System.out.print("" + n2 + "%");
                }
                System.out.print("\b\b\b\b");
            }
        }
    }

    @Override
    public void setMaxProgress(int n) {
        this.progressMax = n;
    }

    @Override
    public int getMaxProgress() {
        return this.progressMax;
    }

    @Override
    public void resetProgress(int n) {
        this.progressMax = n;
        this.progressValue = 0;
    }

    @Override
    public void resetProgress() {
        this.resetProgress(this.progressMax);
    }

    @Override
    public void hideMessages() {
        if (!this.suspended) {
            this.showMessages = false;
        }
    }

    @Override
    public void displayMessages() {
        if (!this.suspended) {
            this.showMessages = true;
        }
    }

    @Override
    public void suspend() {
        this.suspended = true;
    }

    @Override
    public void resume() {
        this.suspended = false;
    }

    @Override
    public void message(String string) {
        if (this.showMessages && !this.suspended) {
            System.out.print(string);
        }
    }

    @Override
    public void message(Exception exception) {
        if (this.showMessages && !this.suspended) {
            System.out.print(exception.getMessage());
        }
    }

    @Override
    public void messageln(String string) {
        if (this.showMessages && !this.suspended) {
            System.out.println(string);
        }
    }

    @Override
    public void messageln(Exception exception) {
        if (this.showMessages && !this.suspended) {
            System.out.println(exception.getMessage());
        }
    }

    @Override
    public void warning(String string) {
        System.err.println("Warning: " + string);
    }

    @Override
    public void warning(Exception exception) {
        System.err.println("Warning: " + exception.getMessage());
    }

    @Override
    public void error(String string) {
        System.err.println("Error: " + string);
    }

    @Override
    public void error(Exception exception) {
        System.err.println("Error: " + exception.getMessage());
    }

    @Override
    public void internalerror(String string) {
        System.err.println("Internal error: " + string);
    }

    @Override
    public void internalerror(Exception exception) {
        System.err.println("Internal error: " + exception.getMessage());
        exception.printStackTrace();
    }

    @Override
    public void fatalerror(String string) {
        System.err.println("Fatal error: " + string);
    }

    @Override
    public void fatalerror(Exception exception) {
        System.err.println("Fatal error: " + exception.getMessage());
    }
}

