/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidSettingsIDException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicPathStyleListener;
import uk.ac.uea.cmp.nlct.jdr.JDRBezierLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmapListener;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYKListener;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSBListener;
import uk.ac.uea.cmp.nlct.jdr.JDRColorListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGradientListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGrayListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGridLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRGroupListener;
import uk.ac.uea.cmp.nlct.jdr.JDRLineLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRMissingTopLevelException;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialBezierLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialLineLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegmentLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathStyleLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialGridListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRectangularGridListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRotationalPatternListener;
import uk.ac.uea.cmp.nlct.jdr.JDRScaledPatternListener;
import uk.ac.uea.cmp.nlct.jdr.JDRSegmentLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRSegmentLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRSpiralPatternListener;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRTextListener;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPathStyleListener;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparentListener;
import uk.ac.uea.cmp.nlct.jdr.NotJDRException;
import uk.ac.uea.cmp.nlct.jdr.UnknownJDRVersionException;
import uk.ac.uea.cmp.nlct.jdr.io.JDRDefaultMessage;
import uk.ac.uea.cmp.nlct.jdr.io.JDRMessage;

public class JDR {
    public static final float currentVersion = 1.6f;
    public static final int NO_SETTINGS = 0;
    public static final int ALL_SETTINGS = 1;
    public static final int PAPER_ONLY = 2;
    private static float _lastLoadedVersion = 0.0f;
    private static int lastLoadedSettings_ = -1;
    public static boolean bitmapReplaced = false;
    private static JDRPaintLoader paintLoader = new JDRPaintLoader();
    private static JDRObjectLoader objectLoader = new JDRObjectLoader();
    private static JDRSegmentLoader segmentLoader = new JDRSegmentLoader();
    private static JDRPathStyleLoader pathStyleLoader = new JDRPathStyleLoader();
    private static JDRGridLoader gridLoader = new JDRGridLoader();
    public static final int OPTIMIZE_SPEED = 0;
    public static final int OPTIMIZE_MEMORY = 1;
    private static int optimize = 0;
    public static JDRMessage messageSystem = new JDRDefaultMessage();

    protected JDR() {
    }

    public static void save(JDRGroup jDRGroup, DataOutputStream dataOutputStream) throws IOException, InvalidFormatException {
        try {
            JDR.save(jDRGroup, dataOutputStream, 1.6f);
        }
        catch (UnknownJDRVersionException unknownJDRVersionException) {
            messageSystem.internalerror(unknownJDRVersionException);
        }
    }

    public static void save(JDRGroup jDRGroup, CanvasSettings canvasSettings, DataOutputStream dataOutputStream) throws IOException, InvalidFormatException {
        try {
            JDR.save(jDRGroup, canvasSettings, dataOutputStream, 1.6f);
        }
        catch (UnknownJDRVersionException unknownJDRVersionException) {
            messageSystem.internalerror(unknownJDRVersionException);
        }
    }

    public static void save(JDRGroup jDRGroup, CanvasSettings canvasSettings, DataOutputStream dataOutputStream, int n) throws IOException, InvalidFormatException, InvalidSettingsIDException {
        try {
            JDR.save(jDRGroup, canvasSettings, dataOutputStream, 1.6f, n);
        }
        catch (UnknownJDRVersionException unknownJDRVersionException) {
            messageSystem.internalerror(unknownJDRVersionException);
        }
    }

    public static void save(JDRGroup jDRGroup, CanvasSettings canvasSettings, DataOutputStream dataOutputStream, float f, int n) throws IOException, InvalidFormatException, InvalidSettingsIDException, UnknownJDRVersionException {
        switch (n) {
            case 0: {
                JDR.save(jDRGroup, dataOutputStream, f);
                break;
            }
            case 1: {
                JDR.save(jDRGroup, canvasSettings, dataOutputStream, f);
                break;
            }
            case 2: {
                JDR.save(jDRGroup, canvasSettings.paper, dataOutputStream, f);
                break;
            }
            default: {
                throw new InvalidSettingsIDException(n);
            }
        }
    }

    public static void save(JDRGroup jDRGroup, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException, UnknownJDRVersionException {
        JDR.addAllListeners();
        dataOutputStream.writeChars("JDR");
        String string = "";
        if (f == 1.0f) {
            string = "1.0";
        } else if (f == 1.1f) {
            string = "1.1";
        } else if (f == 1.2f) {
            string = "1.2";
        } else if (f == 1.3f) {
            string = "1.3";
        } else if (f == 1.4f) {
            string = "1.4";
        } else if (f == 1.5f) {
            string = "1.5";
        } else if (f == 1.6f) {
            string = "1.6";
        } else {
            throw new UnknownJDRVersionException("" + f);
        }
        dataOutputStream.writeInt(string.length());
        dataOutputStream.writeChars(string);
        if (f < 1.3f) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeByte(0);
        }
        objectLoader.saveJDR(jDRGroup, dataOutputStream, f);
    }

    public static void save(JDRGroup jDRGroup, CanvasSettings canvasSettings, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException, UnknownJDRVersionException {
        JDR.addAllListeners();
        dataOutputStream.writeChars("JDR");
        String string = "";
        if (f == 1.0f) {
            string = "1.0";
        } else if (f == 1.1f) {
            string = "1.1";
        } else if (f == 1.2f) {
            string = "1.2";
        } else if (f == 1.3f) {
            string = "1.3";
        } else if (f == 1.4f) {
            string = "1.4";
        } else if (f == 1.5f) {
            string = "1.5";
        } else if (f == 1.6f) {
            string = "1.6";
        } else {
            throw new UnknownJDRVersionException("" + f);
        }
        dataOutputStream.writeInt(string.length());
        dataOutputStream.writeChars(string);
        if (f < 1.3f) {
            dataOutputStream.writeBoolean(true);
        } else {
            dataOutputStream.writeByte(1);
        }
        canvasSettings.save(dataOutputStream, f);
        objectLoader.saveJDR(jDRGroup, dataOutputStream, f);
    }

    public static void save(JDRGroup jDRGroup, JDRPaper jDRPaper, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException, UnknownJDRVersionException {
        JDR.addAllListeners();
        dataOutputStream.writeChars("JDR");
        String string = "";
        if (f == 1.0f) {
            string = "1.0";
        } else if (f == 1.1f) {
            string = "1.1";
        } else if (f == 1.2f) {
            string = "1.2";
        } else if (f == 1.3f) {
            string = "1.3";
        } else if (f == 1.4f) {
            string = "1.4";
        } else if (f == 1.5f) {
            string = "1.5";
        } else if (f == 1.6f) {
            string = "1.6";
        } else {
            throw new UnknownJDRVersionException("" + f);
        }
        dataOutputStream.writeInt(string.length());
        dataOutputStream.writeChars(string);
        if (f < 1.3f) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeByte(2);
            jDRPaper.save(dataOutputStream, f);
        }
        objectLoader.saveJDR(jDRGroup, dataOutputStream, f);
    }

    public static JDRGroup load(DataInputStream dataInputStream, CanvasSettings canvasSettings) throws IOException, InvalidFormatException {
        int n;
        JDR.addAllListeners();
        bitmapReplaced = false;
        char[] cArray = new char[3];
        for (n = 0; n < 3; ++n) {
            cArray[n] = dataInputStream.readChar();
        }
        if (!new String(cArray).equals("JDR")) {
            throw new NotJDRException();
        }
        n = dataInputStream.readInt();
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray2[i] = dataInputStream.readChar();
        }
        String string = new String(cArray2);
        if (string.equals("1.0")) {
            _lastLoadedVersion = 1.0f;
        } else if (string.equals("1.1")) {
            _lastLoadedVersion = 1.1f;
        } else if (string.equals("1.2")) {
            _lastLoadedVersion = 1.2f;
        } else if (string.equals("1.3")) {
            _lastLoadedVersion = 1.3f;
        } else if (string.equals("1.4")) {
            _lastLoadedVersion = 1.4f;
        } else if (string.equals("1.5")) {
            _lastLoadedVersion = 1.5f;
        } else if (string.equals("1.6")) {
            _lastLoadedVersion = 1.6f;
        } else {
            throw new UnknownJDRVersionException(string);
        }
        byte by = _lastLoadedVersion < 1.3f ? (dataInputStream.readBoolean() ? (byte)1 : 0) : dataInputStream.readByte();
        if (by == 1) {
            CanvasSettings.read(canvasSettings, dataInputStream, _lastLoadedVersion);
        } else if (by == 2) {
            canvasSettings.paper = JDRPaper.read(dataInputStream, _lastLoadedVersion);
        } else if (by != 0) {
            throw new InvalidSettingsIDException(by);
        }
        lastLoadedSettings_ = by;
        JDRObject jDRObject = objectLoader.loadJDR(dataInputStream, _lastLoadedVersion);
        if (!(jDRObject instanceof JDRGroup)) {
            throw new JDRMissingTopLevelException();
        }
        return (JDRGroup)jDRObject;
    }

    private static void addAllListeners() {
        if (paintLoader.getListeners().isEmpty()) {
            paintLoader.addListener(new JDRColorListener());
            paintLoader.addListener(new JDRTransparentListener());
            paintLoader.addListener(new JDRColorCMYKListener());
            paintLoader.addListener(new JDRGradientListener());
            paintLoader.addListener(new JDRRadialListener());
            paintLoader.addListener(new JDRGrayListener());
            paintLoader.addListener(new JDRColorHSBListener());
        }
        if (objectLoader.getListeners().isEmpty()) {
            objectLoader.addListener(new JDRGroupListener());
            objectLoader.addListener(new JDRPathListener());
            objectLoader.addListener(new JDRTextListener());
            objectLoader.addListener(new JDRBitmapListener());
            objectLoader.addListener(new JDRTextPathListener());
            objectLoader.addListener(new JDRSymmetricPathListener());
            objectLoader.addListener(new JDRRotationalPatternListener());
            objectLoader.addListener(new JDRScaledPatternListener());
            objectLoader.addListener(new JDRSpiralPatternListener());
        }
        if (segmentLoader.getListeners().isEmpty()) {
            segmentLoader.addListener(new JDRSegmentLoaderListener());
            segmentLoader.addListener(new JDRLineLoaderListener());
            segmentLoader.addListener(new JDRBezierLoaderListener());
            segmentLoader.addListener(new JDRPartialSegmentLoaderListener());
            segmentLoader.addListener(new JDRPartialLineLoaderListener());
            segmentLoader.addListener(new JDRPartialBezierLoaderListener());
        }
        if (pathStyleLoader.getListeners().isEmpty()) {
            pathStyleLoader.addListener(new JDRBasicPathStyleListener());
            pathStyleLoader.addListener(new JDRTextPathStyleListener());
        }
        if (gridLoader.getListeners().isEmpty()) {
            gridLoader.addListener(new JDRRectangularGridListener());
            gridLoader.addListener(new JDRRadialGridListener());
        }
    }

    public static float getLastLoadedVersion() {
        return _lastLoadedVersion;
    }

    public static int getLastLoadedSettingsID() {
        return lastLoadedSettings_;
    }

    public static JDRPaintLoader getPaintLoader() {
        JDR.addAllListeners();
        return paintLoader;
    }

    public static JDRObjectLoader getObjectLoader() {
        JDR.addAllListeners();
        return objectLoader;
    }

    public static JDRSegmentLoader getSegmentLoader() {
        JDR.addAllListeners();
        return segmentLoader;
    }

    public static JDRPathStyleLoader getPathStyleLoader() {
        JDR.addAllListeners();
        return pathStyleLoader;
    }

    public static JDRGridLoader getGridLoader() {
        JDR.addAllListeners();
        return gridLoader;
    }

    public static int getOptimize() {
        return optimize;
    }

    public static void setOptimize(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Setting " + n + " is invalid");
        }
        optimize = n;
    }
}

