/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io;

import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathException;
import uk.ac.uea.cmp.nlct.jdr.JDRBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFontBase;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSArray;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDict;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFile;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFont;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSSaveState;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSSystemDict;
import uk.ac.uea.cmp.nlct.jdr.io.eps.GraphicsState;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoReadAccessException;

public class EPS {
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance();
    protected JDRGroup group;
    protected Vector<GraphicsState> graphicsStack;
    protected double[] deviceDefault;
    protected GraphicsState graphicsState;
    private EPSStack stack;
    protected String bitmapbase;
    protected int bitmapN = 0;
    protected int verbose = 0;
    private static String warningString = "";
    private EPSFile currentfile = null;
    private LaTeXFontBase latexFontBase;
    private EPSSystemDict systemDict;
    private EPSDict fontDirectory;
    private EPSDict globalDict;
    private Random random;
    private long seed;
    private Vector<EPSSaveState> savedStates;

    private EPS() {
    }

    protected EPS(String string, double d, BufferedReader bufferedReader) {
        this.group = new JDRGroup();
        this.currentfile = new EPSFile(bufferedReader);
        this.systemDict = new EPSSystemDict();
        this.globalDict = new EPSDict();
        this.fontDirectory = new EPSDict();
        this.graphicsStack = new Vector();
        this.savedStates = new Vector();
        this.deviceDefault = new double[]{1.0, 0.0, 0.0, -1.0, 0.0, 0.0};
        this.latexFontBase = new LaTeXFontBase(d);
        this.stack = new EPSStack(this);
        this.graphicsState = new GraphicsState(this, this.deviceDefault);
        this.graphicsStack.add(this.graphicsState);
        this.seed = new Date().getTime();
        this.random = new Random(this.seed);
        this.bitmapbase = string;
        this.bitmapN = 0;
    }

    public static void save(JDRGroup jDRGroup, PrintWriter printWriter, String string) throws IOException {
        BBox bBox = jDRGroup.getBBox();
        printWriter.println("%!PS-Adobe-3.0 EPSF-3.0");
        printWriter.println("%%Creator: " + string);
        if (!jDRGroup.description.equals("")) {
            printWriter.println("%%Title: " + jDRGroup.description);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        printWriter.println("%%CreationDate: " + dateFormat.format(gregorianCalendar.getTime()));
        printWriter.println("%%LanguageLevel: " + jDRGroup.psLevel());
        double d = -bBox.getMinX();
        double d2 = -bBox.getMaxY();
        printWriter.println("%%BoundingBox: 0 0 " + (int)bBox.getWidth() + " " + (int)bBox.getHeight());
        printWriter.println("%%HiResBoundingBox: 0.0 0.0 " + bBox.getWidth() + " " + bBox.getHeight());
        printWriter.println("%%EndComments");
        printWriter.println("gsave");
        printWriter.println("" + d + " " + -d2 + " translate");
        printWriter.println("1 -1 scale");
        printWriter.println("[] 0 setdash");
        printWriter.println("10 setmiterlimit");
        printWriter.println("1 setlinewidth");
        printWriter.println("0 setlinecap");
        printWriter.println("0 setlinejoin");
        jDRGroup.saveEPS(printWriter);
        printWriter.println("grestore");
        printWriter.println("%%Trailer");
        printWriter.println("%%EOF");
    }

    public static void fillPath(Shape shape, JDRPaint jDRPaint, PrintWriter printWriter) throws IOException {
        if (!(jDRPaint instanceof JDRTransparent)) {
            EPS.savePath(shape, printWriter);
            BBox bBox = new BBox(shape.getBounds());
            jDRPaint.saveEPS(printWriter, bBox);
            if (jDRPaint instanceof JDRGradient || jDRPaint instanceof JDRRadial) {
                printWriter.println("clip shfill");
            } else {
                printWriter.println("fill");
            }
        }
    }

    public static void drawPath(Shape shape, JDRPaint jDRPaint, PrintWriter printWriter) throws IOException {
        if (!(jDRPaint instanceof JDRTransparent)) {
            EPS.savePath(shape, printWriter);
            jDRPaint.saveEPS(printWriter, null);
            printWriter.println("stroke");
        }
    }

    public static void savePoint(PrintWriter printWriter, double d, double d2) {
        printWriter.print("" + d + " " + d2 + " ");
    }

    public static void savePoint(PrintWriter printWriter, Point2D point2D) {
        printWriter.print("" + point2D.getX() + " " + point2D.getY() + " ");
    }

    public static void savePath(Shape shape, PrintWriter printWriter) throws IOException {
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        PathIterator pathIterator = shape.getPathIterator(null);
        printWriter.println("newpath");
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 4: {
                    printWriter.println("closepath");
                    break;
                }
                case 0: {
                    printWriter.println("" + dArray[0] + " " + dArray[1] + " moveto");
                    d = dArray[0];
                    d2 = dArray[1];
                    break;
                }
                case 1: {
                    printWriter.println("" + dArray[0] + " " + dArray[1] + " lineto");
                    d = dArray[0];
                    d2 = dArray[1];
                    break;
                }
                case 2: {
                    JDRBezier jDRBezier = JDRBezier.quadToCubic(d, d2, dArray[0], dArray[1], dArray[2], dArray[3]);
                    printWriter.println("" + jDRBezier.getControl1().x + " " + jDRBezier.getControl1().y + " " + jDRBezier.getControl2().x + " " + jDRBezier.getControl2().y + " " + jDRBezier.getEnd().x + " " + jDRBezier.getEnd().y + " curveto");
                    d = dArray[2];
                    d2 = dArray[3];
                    break;
                }
                case 3: {
                    printWriter.println("" + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5] + " curveto");
                    d = dArray[4];
                    d2 = dArray[5];
                }
            }
            pathIterator.next();
        }
    }

    public static JDRGroup load(BufferedReader bufferedReader, String string) throws IOException, InvalidFormatException, EOFException, NoninvertibleTransformException {
        return EPS.load(bufferedReader, string, 0, 10.0);
    }

    public static JDRGroup load(BufferedReader bufferedReader, String string, int n, double d) throws IOException, InvalidFormatException, NoninvertibleTransformException {
        Object object;
        String string2 = "";
        EPS ePS = new EPS(string, d, bufferedReader);
        String string3 = ePS.currentfile.readline();
        warningString = "";
        if (!string3.matches("%!PS-Adobe-\\d\\.\\d EPSF-\\d\\.\\d")) {
            throw new InvalidFormatException("Unable to determine file type from '" + string3 + "'");
        }
        ePS.currentfile.mark(256);
        string3 = ePS.currentfile.readline();
        BBox bBox = null;
        while (string3.startsWith("%")) {
            double d2;
            double d3;
            double d4;
            double d5;
            String[] stringArray;
            if (string3.startsWith("%%BoundingBox:") && bBox == null) {
                object = string3.replaceFirst("%%BoundingBox: *", "");
                if (!((String)object).startsWith("(atend)") && (stringArray = ((String)object).split(" +")).length >= 4) {
                    d5 = Double.parseDouble(stringArray[0]);
                    d4 = Double.parseDouble(stringArray[1]);
                    d3 = Double.parseDouble(stringArray[2]);
                    d2 = Double.parseDouble(stringArray[3]);
                    bBox = new BBox(d5, d4, d3, d2);
                }
            } else if (string3.startsWith("%%HiResBoundingBox:")) {
                object = string3.replaceFirst("%%HiResBoundingBox: *", "");
                if (!((String)object).startsWith("(atend)") && (stringArray = ((String)object).split(" +")).length >= 4) {
                    d5 = Double.parseDouble(stringArray[0]);
                    d4 = Double.parseDouble(stringArray[1]);
                    d3 = Double.parseDouble(stringArray[2]);
                    d2 = Double.parseDouble(stringArray[3]);
                    bBox = new BBox(d5, d4, d3, d2);
                }
            } else if (string3.startsWith("%%Title:")) {
                string2 = string3.replaceFirst("%%Title: *", "");
            } else if (string3.startsWith("%%BeginPreview")) {
                while (!string3.startsWith("%%EndPreview")) {
                    string3 = ePS.currentfile.readline();
                    if (string3 != null) continue;
                    throw new EOFException("End of file reached while parsing preview");
                }
            }
            ePS.currentfile.mark(256);
            string3 = ePS.currentfile.readline();
        }
        ePS.currentfile.reset();
        ePS.verbose = n;
        ePS.currentfile.execute(ePS);
        ePS.group.description = string2;
        if (ePS.group != null && (object = ePS.group.getBBox()) != null) {
            ePS.group.translate(-((BBox)object).getMinX(), -((BBox)object).getMinY());
        }
        return ePS.group;
    }

    public void processObject(EPSObject ePSObject) throws InvalidFormatException, InvalidPathException, NoninvertibleTransformException, IOException {
        this.stack.processObject(ePSObject);
    }

    public EPSStack getStack() {
        return this.stack;
    }

    public void printlnMessage(String string) {
        if (this.verbose > 0) {
            JDR.messageSystem.messageln(string);
        }
    }

    public void printMessage(String string) {
        if (this.verbose > 0) {
            JDR.messageSystem.message(string);
        }
    }

    public void resetProgress() {
        if (this.verbose > 0) {
            JDR.messageSystem.resetProgress();
        }
    }

    public void setIndeterminate(boolean bl) {
        if (this.verbose > 0) {
            JDR.messageSystem.setIndeterminate(bl);
        }
    }

    public void incrementProgress() {
        if (this.verbose > 0) {
            JDR.messageSystem.incrementProgress();
        }
    }

    public int getVerbose() {
        return this.verbose;
    }

    public static void warning(EPSFile ePSFile, String string) {
        String string2 = System.getProperty("line.separator", "\n");
        if (ePSFile.getType() == 0) {
            warningString = warningString + "Warning (line " + ePSFile.getLineNum() + "): " + string + string2;
            JDR.messageSystem.warning("(line " + ePSFile.getLineNum() + "): " + string);
        } else {
            JDR.messageSystem.warning("(line " + ePSFile.getLineNum() + " of " + ePSFile.getName() + "): " + string);
            warningString = warningString + "Warning (line " + ePSFile.getLineNum() + " of " + ePSFile.getName() + "): " + string + string2;
        }
    }

    public void warning(String string) {
        EPS.warning(this.currentfile, string);
    }

    public int getLineNum() {
        return this.currentfile.getLineNum();
    }

    public static String getWarnings() {
        return warningString;
    }

    public GraphicsState getCurrentGraphicsState() {
        return this.graphicsStack.lastElement();
    }

    public void addGraphicsState(GraphicsState graphicsState) {
        this.graphicsStack.add(graphicsState);
    }

    public GraphicsState popGraphicsState() {
        int n = this.graphicsStack.size();
        if (n <= 1) {
            return null;
        }
        GraphicsState graphicsState = null;
        try {
            graphicsState = this.graphicsStack.remove(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return graphicsState;
    }

    public void grestoreall() {
        EPSSaveState ePSSaveState = this.savedStates.lastElement();
        if (ePSSaveState == null) {
            return;
        }
        this.savedStates.remove(this.savedStates.size() - 1);
        while (this.graphicsStack.lastElement() != ePSSaveState.getGraphicsState() && this.graphicsStack.size() > 1) {
            this.popGraphicsState();
        }
    }

    public EPSSaveState saveState() {
        EPSSaveState ePSSaveState = new EPSSaveState(this);
        this.savedStates.add(ePSSaveState);
        return ePSSaveState;
    }

    public EPSFile getCurrentFile() {
        return this.currentfile;
    }

    public String getNextBitmapName(String string) {
        ++this.bitmapN;
        return this.bitmapbase + this.bitmapN + "." + string;
    }

    public void addJDRObject(JDRCompleteObject jDRCompleteObject) {
        this.group.add(jDRCompleteObject);
    }

    public void setToDefault(EPSArray ePSArray) throws InvalidFormatException {
        ePSArray.setMatrix(this.deviceDefault);
    }

    public LaTeXFontBase getLaTeXFontBase() {
        return this.latexFontBase;
    }

    public EPSSystemDict getSystemDict() {
        return this.systemDict;
    }

    public EPSDict getGlobalDict() {
        return this.globalDict;
    }

    public int getRandomInt() {
        return this.random.nextInt();
    }

    public void setRandomSeed(long l) {
        this.seed = l;
        this.random.setSeed(this.seed);
    }

    public long getRandomSeed() {
        return this.seed;
    }

    public double getNormalSize() {
        return this.latexFontBase.getNormalSize();
    }

    public EPSFont getFontDict(String string) {
        EPSFont ePSFont;
        try {
            ePSFont = (EPSFont)this.fontDirectory.get(string);
        }
        catch (NoReadAccessException noReadAccessException) {
            return new EPSFont(string, this.latexFontBase);
        }
        if (ePSFont != null) {
            return ePSFont;
        }
        ePSFont = new EPSFont(string, this.latexFontBase);
        this.fontDirectory.put(string, ePSFont);
        return ePSFont;
    }
}

