/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidSettingsIDException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicPathStyleListener;
import uk.ac.uea.cmp.nlct.jdr.JDRBezierLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmapListener;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYKListener;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSBListener;
import uk.ac.uea.cmp.nlct.jdr.JDRColorListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGradientListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGrayListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGridLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRGroupListener;
import uk.ac.uea.cmp.nlct.jdr.JDRLineLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRMissingTopLevelException;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialBezierLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialLineLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegmentLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathStyleLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialGridListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRectangularGridListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRotationalPatternListener;
import uk.ac.uea.cmp.nlct.jdr.JDRScaledPatternListener;
import uk.ac.uea.cmp.nlct.jdr.JDRSegmentLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRSegmentLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRSpiralPatternListener;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRTextListener;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPathStyleListener;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparentListener;
import uk.ac.uea.cmp.nlct.jdr.NotAJRException;
import uk.ac.uea.cmp.nlct.jdr.UnknownAJRVersionException;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class AJR {
    public static final float currentVersion = 1.6f;
    public static int buffLength = 255;
    private static float _lastLoadedVersion = 0.0f;
    private static int _lastLoadedSettings = -1;
    private static int lineNum_ = 0;
    private static JDRPaintLoader paintLoader = new JDRPaintLoader();
    private static JDRObjectLoader objectLoader = new JDRObjectLoader();
    private static JDRSegmentLoader segmentLoader = new JDRSegmentLoader();
    private static JDRPathStyleLoader pathStyleLoader = new JDRPathStyleLoader();
    private static JDRGridLoader gridLoader = new JDRGridLoader();

    protected AJR() {
    }

    public static void save(JDRGroup jDRGroup, PrintWriter printWriter) throws IOException, InvalidFormatException {
        try {
            AJR.save(jDRGroup, printWriter, 1.6f);
        }
        catch (UnknownAJRVersionException unknownAJRVersionException) {
            JDR.messageSystem.internalerror(unknownAJRVersionException);
        }
    }

    public static void save(JDRGroup jDRGroup, CanvasSettings canvasSettings, PrintWriter printWriter) throws IOException, InvalidFormatException {
        try {
            AJR.save(jDRGroup, canvasSettings, printWriter, 1.6f);
        }
        catch (UnknownAJRVersionException unknownAJRVersionException) {
            JDR.messageSystem.internalerror(unknownAJRVersionException);
        }
    }

    public static void save(JDRGroup jDRGroup, CanvasSettings canvasSettings, PrintWriter printWriter, int n) throws IOException, InvalidFormatException, InvalidSettingsIDException {
        try {
            AJR.save(jDRGroup, canvasSettings, printWriter, 1.6f, n);
        }
        catch (UnknownAJRVersionException unknownAJRVersionException) {
            JDR.messageSystem.internalerror(unknownAJRVersionException);
        }
    }

    public static void save(JDRGroup jDRGroup, CanvasSettings canvasSettings, PrintWriter printWriter, float f, int n) throws IOException, InvalidFormatException, InvalidSettingsIDException, UnknownAJRVersionException {
        switch (n) {
            case 0: {
                AJR.save(jDRGroup, printWriter, f);
                break;
            }
            case 1: {
                AJR.save(jDRGroup, canvasSettings, printWriter, f);
                break;
            }
            case 2: {
                AJR.save(jDRGroup, canvasSettings.paper, printWriter, f);
                break;
            }
            default: {
                throw new InvalidSettingsIDException(n);
            }
        }
    }

    public static void save(JDRGroup jDRGroup, PrintWriter printWriter, float f) throws IOException, InvalidFormatException, UnknownAJRVersionException {
        AJR.addAllListeners();
        String string = "";
        if (f == 1.0f) {
            string = "1.0";
        } else if (f == 1.1f) {
            string = "1.1";
        } else if (f == 1.2f) {
            string = "1.2";
        } else if (f == 1.3f) {
            string = "1.3";
        } else if (f == 1.4f) {
            string = "1.4";
        } else if (f == 1.5f) {
            string = "1.5";
        } else if (f == 1.6f) {
            string = "1.6";
        } else {
            throw new UnknownAJRVersionException("" + f);
        }
        printWriter.println("AJR " + string);
        printWriter.println("0");
        objectLoader.saveAJR(jDRGroup, printWriter, f);
    }

    public static void save(JDRGroup jDRGroup, CanvasSettings canvasSettings, PrintWriter printWriter, float f) throws IOException, InvalidFormatException, UnknownAJRVersionException {
        AJR.addAllListeners();
        String string = "";
        if (f == 1.0f) {
            string = "1.0";
        } else if (f == 1.1f) {
            string = "1.1";
        } else if (f == 1.2f) {
            string = "1.2";
        } else if (f == 1.3f) {
            string = "1.3";
        } else if (f == 1.4f) {
            string = "1.4";
        } else if (f == 1.5f) {
            string = "1.5";
        } else if (f == 1.6f) {
            string = "1.6";
        } else {
            throw new UnknownAJRVersionException("" + f);
        }
        printWriter.println("AJR " + string);
        printWriter.print("1 ");
        canvasSettings.saveAJR(printWriter, f);
        printWriter.println();
        objectLoader.saveAJR(jDRGroup, printWriter, f);
    }

    public static void save(JDRGroup jDRGroup, JDRPaper jDRPaper, PrintWriter printWriter, float f) throws IOException, InvalidFormatException, UnknownAJRVersionException {
        AJR.addAllListeners();
        String string = "";
        if (f == 1.0f) {
            string = "1.0";
        } else if (f == 1.1f) {
            string = "1.1";
        } else if (f == 1.2f) {
            string = "1.2";
        } else if (f == 1.3f) {
            string = "1.3";
        } else if (f == 1.4f) {
            string = "1.4";
        } else if (f == 1.5f) {
            string = "1.5";
        } else if (f == 1.6f) {
            string = "1.6";
        } else {
            throw new UnknownAJRVersionException("" + f);
        }
        printWriter.println("AJR " + string);
        if (f >= 1.3f) {
            printWriter.print("2 ");
            jDRPaper.saveAJR(printWriter, f);
        } else {
            printWriter.print("0 ");
        }
        printWriter.println();
        objectLoader.saveAJR(jDRGroup, printWriter, f);
    }

    public static JDRGroup load(BufferedReader bufferedReader, CanvasSettings canvasSettings) throws IOException, InvalidFormatException {
        AJR.addAllListeners();
        JDR.bitmapReplaced = false;
        lineNum_ = 1;
        String string = AJR.readWord(bufferedReader);
        if (!string.equals("AJR")) {
            throw new NotAJRException("Not an AJR file. ('" + string + "' found)");
        }
        String string2 = AJR.readWord(bufferedReader);
        if (string2.equals("1.0")) {
            _lastLoadedVersion = 1.0f;
        } else if (string2.equals("1.1")) {
            _lastLoadedVersion = 1.1f;
        } else if (string2.equals("1.2")) {
            _lastLoadedVersion = 1.2f;
        } else if (string2.equals("1.3")) {
            _lastLoadedVersion = 1.3f;
        } else if (string2.equals("1.4")) {
            _lastLoadedVersion = 1.4f;
        } else if (string2.equals("1.5")) {
            _lastLoadedVersion = 1.5f;
        } else if (string2.equals("1.6")) {
            _lastLoadedVersion = 1.6f;
        } else {
            throw new UnknownAJRVersionException(string2);
        }
        int n = _lastLoadedVersion < 1.3f ? (AJR.readBoolean(bufferedReader) ? 1 : 0) : AJR.readInt(bufferedReader);
        if (n == 1) {
            CanvasSettings.readAJR(canvasSettings, bufferedReader, _lastLoadedVersion);
        } else if (n == 2) {
            canvasSettings.paper = JDRPaper.readAJR(bufferedReader, _lastLoadedVersion);
        } else if (n != 0) {
            throw new InvalidSettingsIDException(n);
        }
        _lastLoadedSettings = n;
        JDRGroup jDRGroup = null;
        try {
            jDRGroup = (JDRGroup)objectLoader.loadAJR(bufferedReader, _lastLoadedVersion);
        }
        catch (ClassCastException classCastException) {
            throw new JDRMissingTopLevelException();
        }
        return jDRGroup;
    }

    public static String readWord(BufferedReader bufferedReader) throws IOException, EOFException, BufferOverflowException {
        int n = bufferedReader.read();
        if (n == 10) {
            ++lineNum_;
        }
        while (n == 32 || n == 9 || n == 10 || n == 13 || n == 12) {
            n = bufferedReader.read();
            if (n != 10) continue;
            ++lineNum_;
        }
        char[] cArray = new char[buffLength];
        int n2 = 0;
        while (n != 32 && n != 9 && n != 10 && n != 13 && n != 12) {
            if (n == -1) {
                throw new EOFException("EOF found while reading word");
            }
            if (n2 == buffLength) {
                throw new BufferOverflowException();
            }
            cArray[n2++] = (char)n;
            n = bufferedReader.read();
        }
        if (n == 10) {
            ++lineNum_;
        }
        return new String(cArray).substring(0, n2);
    }

    public static int readInt(BufferedReader bufferedReader) throws IOException, EOFException, InvalidFormatException {
        String string = AJR.readWord(bufferedReader);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("Integer expected, '" + string + "' found (line " + lineNum_ + ")");
        }
    }

    public static float readFloat(BufferedReader bufferedReader) throws IOException, EOFException, InvalidFormatException {
        String string = AJR.readWord(bufferedReader);
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("Number expected, '" + string + "' found (line " + lineNum_ + ")");
        }
    }

    public static double readDouble(BufferedReader bufferedReader) throws IOException, EOFException, InvalidFormatException {
        String string = AJR.readWord(bufferedReader);
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("Number expected, '" + string + "' found (line " + lineNum_ + ")");
        }
    }

    public static boolean readBoolean(BufferedReader bufferedReader) throws IOException, EOFException, InvalidFormatException {
        String string = AJR.readWord(bufferedReader);
        try {
            int n = Integer.parseInt(string);
            if (n == 0) {
                return false;
            }
            if (n == 1) {
                return true;
            }
            throw new NumberFormatException();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("'1' or '0' expected, '" + string + "' found (line " + lineNum_ + ")");
        }
    }

    public static String readString(BufferedReader bufferedReader, int n) throws IOException, EOFException, InvalidFormatException {
        if (n <= 0) {
            throw new InvalidFormatException("positive value required for string length (line " + lineNum_ + ")");
        }
        int n2 = bufferedReader.read();
        if (n2 == 10) {
            ++lineNum_;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            if (n2 == -1) {
                throw new EOFException("EOF found while reading word");
            }
            cArray[i] = (char)n2;
            n2 = bufferedReader.read();
            if (n2 != 10) continue;
            ++lineNum_;
        }
        return new String(cArray);
    }

    public static char readChar(BufferedReader bufferedReader) throws IOException, EOFException {
        int n = bufferedReader.read();
        if (n == -1) {
            throw new EOFException();
        }
        if (n == 10) {
            ++lineNum_;
        }
        while (n == 32 || n == 9 || n == 10 || n == 13) {
            n = bufferedReader.read();
            if (n == -1) {
                throw new EOFException();
            }
            if (n != 10) continue;
            ++lineNum_;
        }
        return (char)n;
    }

    public static void writeBoolean(PrintWriter printWriter, boolean bl) {
        printWriter.print(bl ? "1 " : "0 ");
    }

    public static void writeChar(PrintWriter printWriter, char c) {
        printWriter.print("" + c + " ");
    }

    public static void writeInt(PrintWriter printWriter, int n) {
        printWriter.print("" + n + " ");
    }

    public static void writeFloat(PrintWriter printWriter, float f) {
        printWriter.print("" + f + " ");
    }

    public static void writeDouble(PrintWriter printWriter, double d) {
        printWriter.print("" + d + " ");
    }

    public static int getLineNum() {
        return lineNum_;
    }

    public static float getLastLoadedVersion() {
        return _lastLoadedVersion;
    }

    public static int getLastLoadedSettingsID() {
        return _lastLoadedSettings;
    }

    private static void addAllListeners() {
        if (paintLoader.getListeners().isEmpty()) {
            paintLoader.addListener(new JDRColorListener());
            paintLoader.addListener(new JDRTransparentListener());
            paintLoader.addListener(new JDRColorCMYKListener());
            paintLoader.addListener(new JDRGradientListener());
            paintLoader.addListener(new JDRRadialListener());
            paintLoader.addListener(new JDRGrayListener());
            paintLoader.addListener(new JDRColorHSBListener());
        }
        if (objectLoader.getListeners().isEmpty()) {
            objectLoader.addListener(new JDRGroupListener());
            objectLoader.addListener(new JDRPathListener());
            objectLoader.addListener(new JDRTextListener());
            objectLoader.addListener(new JDRBitmapListener());
            objectLoader.addListener(new JDRTextPathListener());
            objectLoader.addListener(new JDRSymmetricPathListener());
            objectLoader.addListener(new JDRRotationalPatternListener());
            objectLoader.addListener(new JDRScaledPatternListener());
            objectLoader.addListener(new JDRSpiralPatternListener());
        }
        if (segmentLoader.getListeners().isEmpty()) {
            segmentLoader.addListener(new JDRSegmentLoaderListener());
            segmentLoader.addListener(new JDRLineLoaderListener());
            segmentLoader.addListener(new JDRBezierLoaderListener());
            segmentLoader.addListener(new JDRPartialSegmentLoaderListener());
            segmentLoader.addListener(new JDRPartialLineLoaderListener());
            segmentLoader.addListener(new JDRPartialBezierLoaderListener());
        }
        if (pathStyleLoader.getListeners().isEmpty()) {
            pathStyleLoader.addListener(new JDRBasicPathStyleListener());
            pathStyleLoader.addListener(new JDRTextPathStyleListener());
        }
        if (gridLoader.getListeners().isEmpty()) {
            gridLoader.addListener(new JDRRectangularGridListener());
            gridLoader.addListener(new JDRRadialGridListener());
        }
    }

    public static JDRPaintLoader getPaintLoader() {
        AJR.addAllListeners();
        return paintLoader;
    }

    public static JDRObjectLoader getObjectLoader() {
        AJR.addAllListeners();
        return objectLoader;
    }

    public static JDRSegmentLoader getSegmentLoader() {
        AJR.addAllListeners();
        return segmentLoader;
    }

    public static JDRPathStyleLoader getPathStyleLoader() {
        AJR.addAllListeners();
        return pathStyleLoader;
    }

    public static JDRGridLoader getGridLoader() {
        AJR.addAllListeners();
        return gridLoader;
    }
}

