/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class RadialPaintContext
implements PaintContext {
    private Point2D startPt;
    private double radius;
    private Color startCol;
    private Color endCol;

    public RadialPaintContext(Point2D point2D, Color color, Point2D point2D2, Color color2) {
        this.startPt = point2D;
        this.radius = point2D.distance(point2D2);
        this.startCol = color;
        this.endCol = color2;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
        int[] nArray = new int[n3 * n4 * 4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = this.startPt.distance(n + j, n2 + i);
                double d2 = d / this.radius;
                int n5 = (i * n3 + j) * 4;
                int n6 = this.startCol.getRed();
                int n7 = this.startCol.getGreen();
                int n8 = this.startCol.getBlue();
                int n9 = this.startCol.getAlpha();
                int n10 = this.endCol.getRed();
                int n11 = this.endCol.getGreen();
                int n12 = this.endCol.getBlue();
                int n13 = this.endCol.getAlpha();
                nArray[n5 + 0] = (int)((double)n6 + d2 * (double)(n10 - n6));
                nArray[n5 + 1] = (int)((double)n7 + d2 * (double)(n11 - n7));
                nArray[n5 + 2] = (int)((double)n8 + d2 * (double)(n12 - n8));
                nArray[n5 + 3] = (int)((double)n9 + d2 * (double)(n13 - n9));
            }
        }
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }
}

