/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class LaTeXFontBase {
    private double[] baselineskip = new double[13];
    private double[] fontsize = new double[13];
    private static double max_deviation = 5.0;
    public static final int TINY = 0;
    public static final int SCRIPTSIZE = 1;
    public static final int FOOTNOTESIZE = 2;
    public static final int SMALL = 3;
    public static final int NORMALSIZE = 4;
    public static final int LARGE = 5;
    public static final int XLARGE = 6;
    public static final int XXLARGE = 7;
    public static final int HUGE = 8;
    public static final int XHUGE = 9;
    public static final int VERYHUGE = 10;
    public static final int XVERYHUGE = 11;
    public static final int XXVERYHUGE = 12;
    public static final int NUM_SIZES = 13;

    public LaTeXFontBase() {
        this(10.0);
    }

    public LaTeXFontBase(double d) {
        this.setNormalSize(d);
    }

    public void setNormalSize(double d) {
        if (d >= 24.0) {
            this.setFontSize(0, 12.0, 14.0);
            this.setFontSize(1, 14.4f, 18.0);
            this.setFontSize(2, 17.28f, 22.0);
            this.setFontSize(3, 20.74f, 25.0);
            this.setFontSize(4, 24.88f, 30.0);
            this.setFontSize(5, 29.86f, 37.0);
            this.setFontSize(6, 35.83f, 45.0);
            this.setFontSize(7, 43.0, 54.0);
            this.setFontSize(8, 51.6f, 64.0);
            this.setFontSize(9, 61.92f, 77.0);
            this.setFontSize(10, 74.3f, 93.0);
            this.setFontSize(11, 89.16f, 112.0);
            this.setFontSize(12, 107.0, 134.0);
        } else if (d >= 19.0) {
            this.setFontSize(0, 10.0, 11.0);
            this.setFontSize(1, 12.0, 14.0);
            this.setFontSize(2, 14.0, 17.0);
            this.setFontSize(3, 17.0, 22.0);
            this.setFontSize(4, 20.0, 25.0);
            this.setFontSize(5, 25.0, 30.0);
            this.setFontSize(6, 29.86f, 35.0);
            this.setFontSize(7, 35.83f, 41.0);
            this.setFontSize(8, 42.99f, 52.0);
            this.setFontSize(9, 51.59f, 63.0);
            this.setFontSize(10, 51.59f, 63.0);
            this.setFontSize(11, 51.59f, 63.0);
            this.setFontSize(12, 51.59f, 63.0);
        } else if (d >= 16.0) {
            this.setFontSize(0, 8.0, 9.0);
            this.setFontSize(1, 10.0, 11.0);
            this.setFontSize(2, 12.0, 14.0);
            this.setFontSize(3, 14.0, 17.0);
            this.setFontSize(4, 17.0, 22.0);
            this.setFontSize(5, 20.0, 25.0);
            this.setFontSize(6, 25.0, 30.0);
            this.setFontSize(7, 29.86f, 35.0);
            this.setFontSize(8, 35.83f, 41.0);
            this.setFontSize(9, 42.99f, 52.0);
            this.setFontSize(10, 42.99f, 52.0);
            this.setFontSize(11, 42.99f, 52.0);
            this.setFontSize(12, 42.99f, 52.0);
        } else if (d >= 13.0) {
            this.setFontSize(0, 6.0, 7.0);
            this.setFontSize(1, 8.0, 9.5);
            this.setFontSize(2, 10.0, 12.0);
            this.setFontSize(3, 12.0, 14.0);
            this.setFontSize(4, 14.0, 17.0);
            this.setFontSize(5, 17.0, 22.0);
            this.setFontSize(6, 20.0, 25.0);
            this.setFontSize(7, 25.0, 30.0);
            this.setFontSize(8, 29.86f, 35.0);
            this.setFontSize(9, 35.83f, 40.0);
            this.setFontSize(10, 35.83f, 40.0);
            this.setFontSize(11, 35.83f, 40.0);
            this.setFontSize(12, 35.83f, 40.0);
        } else if (d >= 12.0) {
            this.setFontSize(0, 6.0, 7.0);
            this.setFontSize(1, 8.0, 9.5);
            this.setFontSize(2, 10.0, 12.0);
            this.setFontSize(3, 11.0, 13.6f);
            this.setFontSize(4, 12.0, 14.5);
            this.setFontSize(5, 14.0, 18.0);
            this.setFontSize(6, 17.0, 22.0);
            this.setFontSize(7, 20.0, 25.0);
            this.setFontSize(8, 25.0, 30.0);
            this.setFontSize(9, 25.0, 30.0);
            this.setFontSize(10, 25.0, 30.0);
            this.setFontSize(11, 25.0, 30.0);
            this.setFontSize(12, 25.0, 30.0);
        } else if (d >= 11.0) {
            this.setFontSize(0, 6.0, 7.0);
            this.setFontSize(1, 8.0, 9.5);
            this.setFontSize(2, 9.0, 11.0);
            this.setFontSize(3, 10.0, 12.0);
            this.setFontSize(4, 11.0, 13.6f);
            this.setFontSize(5, 12.0, 14.0);
            this.setFontSize(6, 14.0, 18.0);
            this.setFontSize(7, 17.0, 22.0);
            this.setFontSize(8, 20.0, 25.0);
            this.setFontSize(9, 25.0, 30.0);
            this.setFontSize(10, 25.0, 30.0);
            this.setFontSize(11, 25.0, 30.0);
            this.setFontSize(12, 25.0, 30.0);
        } else if (d >= 10.0) {
            this.setFontSize(0, 5.0, 6.0);
            this.setFontSize(1, 7.0, 8.0);
            this.setFontSize(2, 8.0, 9.5);
            this.setFontSize(3, 9.0, 11.0);
            this.setFontSize(4, 10.0, 12.0);
            this.setFontSize(5, 12.0, 14.0);
            this.setFontSize(6, 14.0, 18.0);
            this.setFontSize(7, 17.0, 22.0);
            this.setFontSize(8, 20.0, 25.0);
            this.setFontSize(9, 25.0, 30.0);
            this.setFontSize(10, 25.0, 30.0);
            this.setFontSize(11, 25.0, 30.0);
            this.setFontSize(12, 25.0, 30.0);
        } else if (d >= 9.0) {
            this.setFontSize(0, 5.0, 6.0);
            this.setFontSize(1, 6.0, 7.0);
            this.setFontSize(2, 7.0, 8.0);
            this.setFontSize(3, 8.0, 9.0);
            this.setFontSize(4, 9.0, 11.0);
            this.setFontSize(5, 10.0, 12.0);
            this.setFontSize(6, 11.0, 13.0);
            this.setFontSize(7, 12.0, 14.0);
            this.setFontSize(8, 14.0, 18.0);
            this.setFontSize(9, 17.0, 22.0);
            this.setFontSize(10, 17.0, 22.0);
            this.setFontSize(11, 17.0, 22.0);
            this.setFontSize(12, 17.0, 22.0);
        } else {
            this.setFontSize(0, 5.0, 6.0);
            this.setFontSize(1, 5.0, 6.0);
            this.setFontSize(2, 6.0, 7.0);
            this.setFontSize(3, 7.0, 8.0);
            this.setFontSize(4, 8.0, 9.5);
            this.setFontSize(5, 10.0, 11.0);
            this.setFontSize(6, 11.0, 12.0);
            this.setFontSize(7, 12.0, 14.0);
            this.setFontSize(8, 14.0, 18.0);
            this.setFontSize(9, 17.0, 22.0);
            this.setFontSize(10, 17.0, 22.0);
            this.setFontSize(11, 17.0, 22.0);
            this.setFontSize(12, 17.0, 22.0);
        }
    }

    private void setFontSize(int n, double d, double d2) {
        this.fontsize[n] = d;
        this.baselineskip[n] = d2;
    }

    public int getLaTeXSize(double d) {
        double d2 = JDRUnit.pt.fromBp(d);
        int n = 0;
        double d3 = Math.abs(this.fontsize[0] - d2);
        for (int i = 1; i < 13; ++i) {
            double d4 = Math.abs(this.fontsize[i] - d2);
            if (!(d4 < d3)) continue;
            d3 = d4;
            n = i;
        }
        if (d3 > max_deviation) {
            return -1;
        }
        return n;
    }

    public String getLaTeXCmd(double d) {
        int n = this.getLaTeXSize(d);
        double d2 = this.getNormalSize();
        switch (n) {
            case 0: {
                return "\\tiny";
            }
            case 1: {
                return "\\scriptsize";
            }
            case 2: {
                return "\\footnotesize";
            }
            case 3: {
                return "\\small";
            }
            case 4: {
                return "\\normalsize";
            }
            case 5: {
                return "\\large";
            }
            case 6: {
                return "\\Large";
            }
            case 7: {
                return "\\LARGE";
            }
            case 8: {
                return "\\huge";
            }
            case 9: {
                return "\\Huge";
            }
            case 10: {
                if (d2 >= 24.0) {
                    return "\\veryHuge";
                }
            }
            case 11: {
                if (d2 >= 24.0) {
                    return "\\VeryHuge";
                }
            }
            case 12: {
                if (!(d2 >= 24.0)) break;
                return "\\VERYHuge";
            }
        }
        double d3 = JDRUnit.pt.fromBp(d);
        return "\\fontsize{" + PGF.format(d3) + "}{" + PGF.format(d3) + "}\\selectfont";
    }

    public double getBaselineskip(int n) {
        return this.baselineskip[n];
    }

    public double getFontSize(int n) {
        return this.fontsize[n];
    }

    public double getNormalSize() {
        return this.getFontSize(4);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LaTeXFontBase)) {
            return false;
        }
        LaTeXFontBase laTeXFontBase = (LaTeXFontBase)object;
        for (int i = 0; i < 13; ++i) {
            if (this.baselineskip[i] != laTeXFontBase.baselineskip[i]) {
                return false;
            }
            if (this.fontsize[i] == laTeXFontBase.fontsize[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = "LaTeXFontBase[normalsize=";
        string = string + this.getNormalSize();
        string = string + ",maxDeviation=" + max_deviation + "]";
        return string;
    }
}

