/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.util.HashMap;
import java.util.Set;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidLatexFontFamilyLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidLatexFontSeriesLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidLatexFontShapeLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidLatexFontSizeLengthException;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class LaTeXFont
implements Cloneable,
Serializable {
    private String family = "\\rmfamily";
    private String weight = "\\mdseries";
    private String shape = "\\upshape";
    private String size = "\\normalsize";
    public static HashMap<String, String> javaMapping = null;
    public static HashMap<String, LaTeXFont> psMapping = null;

    public LaTeXFont(String string, String string2, String string3, String string4) {
        this.setFamily(string);
        this.setWeight(string2);
        this.setShape(string3);
        this.setSize(string4);
    }

    public LaTeXFont() {
        this.family = "\\rmfamily";
        this.weight = "\\mdseries";
        this.shape = "\\upshape";
        this.size = "\\normalsize";
    }

    public String getFamily() {
        return this.family;
    }

    public String getWeight() {
        return this.weight;
    }

    public String getShape() {
        return this.shape;
    }

    public String getSize() {
        return this.size;
    }

    public void setFamily(String string) {
        this.family = string;
    }

    public void setWeight(String string) {
        this.weight = string;
    }

    public void setShape(String string) {
        this.shape = string;
    }

    public void setSize(String string) {
        this.size = string;
    }

    public void save(DataOutputStream dataOutputStream, float f) throws IOException {
        dataOutputStream.writeInt(this.family.length());
        dataOutputStream.writeChars(this.family);
        dataOutputStream.writeInt(this.weight.length());
        dataOutputStream.writeChars(this.weight);
        dataOutputStream.writeInt(this.shape.length());
        dataOutputStream.writeChars(this.shape);
        dataOutputStream.writeInt(this.size.length());
        dataOutputStream.writeChars(this.size);
    }

    public static LaTeXFont read(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        int n;
        char[] cArray;
        LaTeXFont laTeXFont = new LaTeXFont();
        int n2 = dataInputStream.readInt();
        if (n2 < 0) {
            throw new InvalidLatexFontFamilyLengthException(n2);
        }
        if (n2 > 0) {
            cArray = new char[n2];
            for (n = 0; n < n2; ++n) {
                cArray[n] = dataInputStream.readChar();
            }
            laTeXFont.setFamily(new String(cArray));
        }
        if ((n2 = dataInputStream.readInt()) < 0) {
            throw new InvalidLatexFontSeriesLengthException(n2);
        }
        if (n2 > 0) {
            cArray = new char[n2];
            for (n = 0; n < n2; ++n) {
                cArray[n] = dataInputStream.readChar();
            }
            laTeXFont.setWeight(new String(cArray));
        }
        if ((n2 = dataInputStream.readInt()) < 0) {
            throw new InvalidLatexFontShapeLengthException(n2);
        }
        if (n2 > 0) {
            cArray = new char[n2];
            for (n = 0; n < n2; ++n) {
                cArray[n] = dataInputStream.readChar();
            }
            laTeXFont.setShape(new String(cArray));
        }
        if ((n2 = dataInputStream.readInt()) < 0) {
            throw new InvalidLatexFontSizeLengthException(n2);
        }
        if (n2 > 0) {
            cArray = new char[n2];
            for (n = 0; n < n2; ++n) {
                cArray[n] = dataInputStream.readChar();
            }
            laTeXFont.setSize(new String(cArray));
        }
        return laTeXFont;
    }

    public void saveAJR(PrintWriter printWriter, float f) throws IOException {
        AJR.writeInt(printWriter, this.family.length());
        printWriter.println(this.family);
        AJR.writeInt(printWriter, this.weight.length());
        printWriter.println(this.weight);
        AJR.writeInt(printWriter, this.shape.length());
        printWriter.println(this.shape);
        AJR.writeInt(printWriter, this.size.length());
        printWriter.println(this.size);
    }

    public static LaTeXFont readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        LaTeXFont laTeXFont = new LaTeXFont();
        int n = AJR.readInt(bufferedReader);
        if (n < 0) {
            throw new InvalidLatexFontFamilyLengthException(n, AJR.getLineNum());
        }
        if (n > 0) {
            laTeXFont.setFamily(AJR.readString(bufferedReader, n));
        }
        if ((n = AJR.readInt(bufferedReader)) < 0) {
            throw new InvalidLatexFontSeriesLengthException(n, AJR.getLineNum());
        }
        if (n > 0) {
            laTeXFont.setWeight(AJR.readString(bufferedReader, n));
        }
        if ((n = AJR.readInt(bufferedReader)) < 0) {
            throw new InvalidLatexFontShapeLengthException(n, AJR.getLineNum());
        }
        if (n > 0) {
            laTeXFont.setShape(AJR.readString(bufferedReader, n));
        }
        if ((n = AJR.readInt(bufferedReader)) < 0) {
            throw new InvalidLatexFontSizeLengthException(n, AJR.getLineNum());
        }
        if (n > 0) {
            laTeXFont.setSize(AJR.readString(bufferedReader, n));
        }
        return laTeXFont;
    }

    public String tex() {
        String string = this.family;
        if (this.family.matches("\\[a-zA-Z]+\\Z")) {
            string = string + " ";
        }
        string = string + this.weight;
        if (this.weight.matches("\\[a-zA-Z]+\\Z")) {
            string = string + " ";
        }
        string = string + this.shape;
        if (this.shape.matches("\\[a-zA-Z]+\\Z")) {
            string = string + " ";
        }
        string = string + this.size;
        if (this.size.matches("\\[a-zA-Z]+\\Z")) {
            string = string + " ";
        }
        return string;
    }

    public Object clone() {
        return new LaTeXFont(this.family, this.weight, this.shape, this.size);
    }

    public void makeEqual(LaTeXFont laTeXFont) {
        this.family = laTeXFont.family;
        this.weight = laTeXFont.weight;
        this.shape = laTeXFont.shape;
        this.size = laTeXFont.size;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LaTeXFont)) {
            return false;
        }
        LaTeXFont laTeXFont = (LaTeXFont)object;
        if (!this.family.equals(laTeXFont.family)) {
            return false;
        }
        if (!this.weight.equals(laTeXFont.weight)) {
            return false;
        }
        if (!this.shape.equals(laTeXFont.shape)) {
            return false;
        }
        return this.size.equals(laTeXFont.size);
    }

    public static void loadPostScriptMappings(File file) throws IOException, InvalidFormatException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        psMapping = new HashMap();
        String string = bufferedReader.readLine();
        int n = 1;
        while (string != null) {
            if (string.equals("") || string.startsWith("#")) continue;
            String[] stringArray = string.split("=");
            if (stringArray.length != 2) {
                throw new InvalidFormatException("(" + file.getName() + ") invalid key=val format", n);
            }
            String string2 = stringArray[0];
            if ((stringArray = stringArray[1].split(",")).length != 3) {
                throw new InvalidFormatException("(" + file.getName() + ") invalid value", n);
            }
            LaTeXFont laTeXFont = new LaTeXFont(stringArray[0], stringArray[1], stringArray[2], "\\normalsize");
            psMapping.put(string2, laTeXFont);
            string = bufferedReader.readLine();
            ++n;
        }
        bufferedReader.close();
    }

    public static void loadJavaMappings(File file) throws IOException, InvalidFormatException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        javaMapping = new HashMap();
        String string = bufferedReader.readLine();
        int n = 1;
        while (string != null) {
            if (string.equals("") || string.startsWith("#")) continue;
            String[] stringArray = string.split("=");
            if (stringArray.length != 2) {
                throw new InvalidFormatException("(" + file.getName() + ") invalid key=val format", n);
            }
            javaMapping.put(stringArray[0], stringArray[1]);
            string = bufferedReader.readLine();
            ++n;
        }
        bufferedReader.close();
    }

    public static String fromJavaFamily(String string) {
        if (javaMapping == null) {
            return LaTeXFont.defaultFromJavaFamily(string);
        }
        String string2 = javaMapping.get(string);
        if (string2 != null) {
            return string2;
        }
        Set<String> set = javaMapping.keySet();
        for (String string3 : set) {
            if (!string.matches(string3)) continue;
            return javaMapping.get(string3);
        }
        return LaTeXFont.defaultFromJavaFamily(string);
    }

    public static String defaultFromJavaFamily(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("typewriter") || string2.indexOf("mono") != -1 || string2.indexOf("courier") != -1) {
            return "\\ttfamily";
        }
        if (string2.indexOf("sans") != -1) {
            return "\\sffamily";
        }
        return "\\rmfamily";
    }

    public static LaTeXFont fromPostScript(String string) {
        if (psMapping == null) {
            return LaTeXFont.defaultFromPostScript(string);
        }
        LaTeXFont laTeXFont = psMapping.get(string);
        if (laTeXFont != null) {
            return laTeXFont;
        }
        Set<String> set = psMapping.keySet();
        for (String string2 : set) {
            if (!string.matches(string2)) continue;
            return psMapping.get(string2);
        }
        return LaTeXFont.defaultFromPostScript(string);
    }

    public static LaTeXFont defaultFromPostScript(String string) {
        String string2 = string.toLowerCase();
        String string3 = "\\mdseries";
        if (string2.matches(".*bold.*")) {
            string3 = "\\bfseries";
        }
        String string4 = "\\upshape";
        if (string2.matches(".*italic.*")) {
            string4 = "\\itshape";
        } else if (string2.matches(".*oblique.*")) {
            string4 = "\\slshape";
        }
        string2 = string2.replaceAll("(oblique)|(bold)|(italic)", "");
        string2 = string2.replaceFirst("[\\.]", " ");
        string2 = string2.replaceFirst("^/", "");
        string2 = string2.replaceFirst(" *$", "");
        String string5 = "\\rmfamily";
        if (string2.matches("times")) {
            string5 = "\\rmfamily";
        } else if (string2.matches("helvetica")) {
            string5 = "\\sffamily";
        } else if (string2.matches("courier")) {
            string5 = "\\ttfamily";
        } else if (string2.matches("mono")) {
            string5 = "\\ttfamily";
        } else if (string2.matches("sans")) {
            string5 = "\\sffamily";
        }
        return new LaTeXFont(string5, string3, string4, "\\normalsize");
    }

    public String info() {
        return "family=" + this.family + ",weight=" + this.weight + ",shape=" + this.shape + ",size=" + this.size;
    }
}

