/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.GraphicsConfiguration;
import java.awt.geom.AffineTransform;
import uk.ac.uea.cmp.nlct.jdr.InvalidDimensionException;
import uk.ac.uea.cmp.nlct.jdr.InvalidUnitException;

public class JDRUnit {
    private String label;
    private double factor;
    private static double normalizingFactor = 1.0;
    private int id = -1;
    public static final byte PT = 0;
    public static final byte IN = 1;
    public static final byte CM = 2;
    public static final byte BP = 3;
    public static final byte MM = 4;
    public static final byte PC = 5;
    public static final byte DD = 6;
    public static final byte CC = 7;
    public static final JDRUnit pt = new JDRUnit("pt", 1.0, 0);
    public static final JDRUnit bp = new JDRUnit("bp", 1.00375, 3);
    public static final JDRUnit in = new JDRUnit("in", 72.27, 1);
    public static final JDRUnit cm = new JDRUnit("cm", 28.4528, 2);
    public static final JDRUnit mm = new JDRUnit("mm", 2.84528, 4);
    public static final JDRUnit pc = new JDRUnit("pc", 12.0, 5);
    public static final JDRUnit dd = new JDRUnit("dd", 1.07001, 6);
    public static final JDRUnit cc = new JDRUnit("cc", 12.8401, 7);

    public JDRUnit(String string, double d) {
        this.label = string;
        this.factor = d;
    }

    private JDRUnit(String string, double d, int n) {
        this.label = string;
        this.factor = d;
        this.id = n;
    }

    public double toPt(double d) {
        return d * this.factor;
    }

    public double fromPt(double d) {
        return d / this.factor;
    }

    public double toBp(double d) {
        return this.toUnit(d, bp);
    }

    public double fromBp(double d) {
        return this.fromUnit(d, bp);
    }

    public double toPixel(double d) {
        return this.toBp(d) * normalizingFactor;
    }

    public double fromPixel(double d) {
        return this.fromBp(d / normalizingFactor);
    }

    public double toUnit(double d, JDRUnit jDRUnit) {
        return jDRUnit.fromPt(this.toPt(d));
    }

    public double fromUnit(double d, JDRUnit jDRUnit) {
        return this.fromPt(jDRUnit.toPt(d));
    }

    public static double getNormalizingFactor() {
        return normalizingFactor;
    }

    public static void setNormalizingFactor(double d) {
        normalizingFactor = d;
    }

    public static void setNormalizingFactor(GraphicsConfiguration graphicsConfiguration) {
        AffineTransform affineTransform = graphicsConfiguration.getDefaultTransform();
        affineTransform.concatenate(graphicsConfiguration.getNormalizingTransform());
        JDRUnit.setNormalizingFactor(affineTransform.getScaleX());
    }

    public static double parseUnit(String string) throws InvalidDimensionException, InvalidUnitException {
        JDRUnit jDRUnit = bp;
        String[] stringArray = string.split("[-+0-9.]*", 2);
        if (stringArray[1].equals("pt")) {
            jDRUnit = pt;
        } else if (stringArray[1].equals("bp")) {
            jDRUnit = bp;
        } else if (stringArray[1].equals("in")) {
            jDRUnit = in;
        } else if (stringArray[1].equals("mm")) {
            jDRUnit = mm;
        } else if (stringArray[1].equals("cm")) {
            jDRUnit = cm;
        } else if (stringArray[1].equals("pc")) {
            jDRUnit = pc;
        } else if (stringArray[1].equals("dd")) {
            jDRUnit = dd;
        } else if (stringArray[1].equals("cc")) {
            jDRUnit = cc;
        } else if (stringArray[1].equals("")) {
            jDRUnit = bp;
        } else {
            throw new InvalidUnitException(stringArray[1]);
        }
        int n = string.lastIndexOf(stringArray[1]);
        try {
            double d = Double.parseDouble(string.substring(0, n));
            return jDRUnit.toBp(d);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDimensionException(string);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "JDRUnit@" + this.label + "@" + this.factor;
    }

    public int getID() {
        return this.id;
    }

    public static JDRUnit getUnit(int n) {
        switch (n) {
            case 0: {
                return pt;
            }
            case 1: {
                return in;
            }
            case 2: {
                return cm;
            }
            case 3: {
                return bp;
            }
            case 4: {
                return mm;
            }
            case 5: {
                return pc;
            }
            case 6: {
                return dd;
            }
            case 7: {
                return cc;
            }
        }
        return null;
    }
}

