/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class JDRTransform
implements Cloneable,
Serializable {
    private double[] originalBoundsX = new double[4];
    private double[] originalBoundsY = new double[4];
    private double[] flatmatrix;

    public JDRTransform() {
        this(new BBox(0, 0, 0, 0));
    }

    public JDRTransform(double[] dArray) {
        this(new BBox(0, 0, 0, 0));
        this.setTransformation(dArray);
    }

    public JDRTransform(Rectangle2D rectangle2D) {
        this(new BBox(rectangle2D));
    }

    public JDRTransform(BBox bBox) {
        this.originalBoundsX[0] = bBox.getMinX();
        this.originalBoundsY[0] = bBox.getMinY();
        this.originalBoundsX[1] = bBox.getMinX();
        this.originalBoundsY[1] = bBox.getMaxY();
        this.originalBoundsX[2] = bBox.getMaxX();
        this.originalBoundsY[2] = bBox.getMaxY();
        this.originalBoundsX[3] = bBox.getMaxX();
        this.originalBoundsY[3] = bBox.getMinY();
        this.flatmatrix = new double[6];
        this.flatmatrix[4] = 0.0;
        this.flatmatrix[5] = 0.0;
        this.reset();
    }

    public void reset() {
        this.flatmatrix[0] = 1.0;
        this.flatmatrix[1] = 0.0;
        this.flatmatrix[2] = 0.0;
        this.flatmatrix[3] = 1.0;
    }

    public void updateOriginalBounds(Rectangle2D rectangle2D) {
        this.updateOriginalBounds(new BBox(rectangle2D));
    }

    public void updateOriginalBounds(BBox bBox) {
        this.originalBoundsX[0] = bBox.getMinX();
        this.originalBoundsY[0] = bBox.getMinY();
        this.originalBoundsX[1] = bBox.getMinX();
        this.originalBoundsY[1] = bBox.getMaxY();
        this.originalBoundsX[2] = bBox.getMaxX();
        this.originalBoundsY[2] = bBox.getMaxY();
        this.originalBoundsX[3] = bBox.getMaxX();
        this.originalBoundsY[3] = bBox.getMinY();
        this.setTransformation(this.flatmatrix);
    }

    public void setTransformation(double[] dArray) {
        for (int i = 0; i < 6; ++i) {
            this.flatmatrix[i] = dArray[i];
        }
    }

    public AffineTransform getAffineTransform() {
        return new AffineTransform(this.flatmatrix);
    }

    public void getTransformation(double[] dArray) {
        for (int i = 0; i < 6; ++i) {
            dArray[i] = this.flatmatrix[i];
        }
    }

    public void makeEqual(JDRTransform jDRTransform) {
        double[] dArray = new double[6];
        jDRTransform.getTransformation(dArray);
        for (int i = 0; i < 6; ++i) {
            this.flatmatrix[i] = dArray[i];
        }
        this.updateOriginalBounds(jDRTransform.getOriginalBBox());
    }

    public JDRPoint getTopLeft() {
        BBox bBox = this.getBBox();
        return new JDRPoint(bBox.getMinX(), bBox.getMinY());
    }

    public JDRPoint getAnchor() {
        double d = this.originalBoundsX[0];
        double d2 = 0.0;
        double d3 = this.flatmatrix[0];
        double d4 = this.flatmatrix[1];
        double d5 = this.flatmatrix[2];
        double d6 = this.flatmatrix[3];
        double d7 = this.flatmatrix[4];
        double d8 = this.flatmatrix[5];
        double d9 = d3 * d + d5 * d2 + d7;
        double d10 = d4 * d + d6 * d2 + d8;
        return new JDRPoint(d9, d10);
    }

    public JDRPoint getOriginalAnchor() {
        return new JDRPoint(this.originalBoundsX[0], 0.0);
    }

    public JDRPoint getOriginalTopLeft() {
        return new JDRPoint(this.originalBoundsX[0], this.originalBoundsY[0]);
    }

    public JDRPoint getCentre() {
        BBox bBox = this.getBBox();
        return new JDRPoint(bBox.getMinX() + 0.5 * bBox.getWidth(), bBox.getMinY() + 0.5 * bBox.getHeight());
    }

    public Object clone() {
        JDRTransform jDRTransform = new JDRTransform();
        jDRTransform.makeEqual(this);
        return jDRTransform;
    }

    public BBox getOriginalBBox() {
        return new BBox(this.originalBoundsX[0], this.originalBoundsY[0], this.originalBoundsX[2], this.originalBoundsY[2]);
    }

    public BBox getBBox() {
        double d = this.flatmatrix[0];
        double d2 = this.flatmatrix[1];
        double d3 = this.flatmatrix[2];
        double d4 = this.flatmatrix[3];
        double d5 = this.flatmatrix[4];
        double d6 = this.flatmatrix[5];
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        for (int i = 0; i < 4; ++i) {
            dArray[i] = d * this.originalBoundsX[i] + d3 * this.originalBoundsY[i] + d5;
            dArray2[i] = d2 * this.originalBoundsX[i] + d4 * this.originalBoundsY[i] + d6;
        }
        double d7 = dArray[0];
        double d8 = dArray2[0];
        double d9 = d7;
        double d10 = d8;
        for (int i = 1; i < 4; ++i) {
            if (dArray[i] < d7) {
                d7 = dArray[i];
            }
            if (dArray[i] > d9) {
                d9 = dArray[i];
            }
            if (dArray2[i] < d8) {
                d8 = dArray2[i];
            }
            if (!(dArray2[i] > d10)) continue;
            d10 = dArray2[i];
        }
        return new BBox(d7, d8, d9, d10);
    }

    public void transform(JDRObject jDRObject) {
        jDRObject.transform(this.flatmatrix);
    }

    public void concat(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = new AffineTransform(this.flatmatrix);
        affineTransform2.concatenate(affineTransform);
        affineTransform2.getMatrix(this.flatmatrix);
    }

    public void concat(JDRTransform jDRTransform) {
        this.concat(jDRTransform.flatmatrix);
    }

    public void concat(double[] dArray) {
        double d = this.flatmatrix[0];
        double d2 = this.flatmatrix[1];
        double d3 = this.flatmatrix[2];
        double d4 = this.flatmatrix[3];
        double d5 = this.flatmatrix[4];
        double d6 = this.flatmatrix[5];
        this.flatmatrix[0] = dArray[0] * d + dArray[2] * d2;
        this.flatmatrix[1] = dArray[1] * d + dArray[3] * d2;
        this.flatmatrix[2] = dArray[0] * d3 + dArray[2] * d4;
        this.flatmatrix[3] = dArray[1] * d3 + dArray[3] * d4;
        this.flatmatrix[4] = dArray[0] * d5 + dArray[2] * d6 + dArray[4];
        this.flatmatrix[5] = dArray[1] * d5 + dArray[3] * d6 + dArray[5];
    }

    public void preConcatenate(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = new AffineTransform(this.flatmatrix);
        affineTransform2.preConcatenate(affineTransform);
        affineTransform2.getMatrix(this.flatmatrix);
    }

    public void setPosition(double d, double d2) {
        this.flatmatrix[4] = d;
        this.flatmatrix[5] = d2;
    }

    public void translate(double d, double d2) {
        this.flatmatrix[4] = this.flatmatrix[4] + d;
        this.flatmatrix[5] = this.flatmatrix[5] + d2;
    }

    public void rotate(double d) {
        JDRPoint jDRPoint = this.getCentre();
        this.rotate(jDRPoint.getPoint(), d);
    }

    public void rotate(Point2D point2D, double d) {
        this.translate(-point2D.getX(), -point2D.getY());
        double[] dArray = new double[6];
        double d2 = Math.cos(-d);
        double d3 = Math.sin(-d);
        dArray[0] = this.flatmatrix[0] * d2 + this.flatmatrix[1] * d3;
        dArray[1] = this.flatmatrix[1] * d2 - this.flatmatrix[0] * d3;
        dArray[2] = this.flatmatrix[2] * d2 + this.flatmatrix[3] * d3;
        dArray[3] = this.flatmatrix[3] * d2 - this.flatmatrix[2] * d3;
        dArray[4] = this.flatmatrix[4] * d2 + this.flatmatrix[5] * d3;
        dArray[5] = this.flatmatrix[5] * d2 - this.flatmatrix[4] * d3;
        this.setTransformation(dArray);
        this.translate(point2D.getX(), point2D.getY());
    }

    public void scale(double d, double d2) {
        BBox bBox = this.getBBox();
        Point2D.Double double_ = new Point2D.Double(bBox.getMinX(), bBox.getMinY());
        this.scale(double_, d, d2);
    }

    public void scale(Point2D point2D, double d, double d2) {
        this.translate(-point2D.getX(), -point2D.getY());
        this.flatmatrix[0] = this.flatmatrix[0] * d;
        this.flatmatrix[1] = this.flatmatrix[1] * d2;
        this.flatmatrix[2] = this.flatmatrix[2] * d;
        this.flatmatrix[3] = this.flatmatrix[3] * d2;
        this.flatmatrix[4] = this.flatmatrix[4] * d;
        this.flatmatrix[5] = this.flatmatrix[5] * d2;
        this.translate(point2D.getX(), point2D.getY());
    }

    public void shear(double d, double d2) {
        BBox bBox = this.getBBox();
        Point2D.Double double_ = new Point2D.Double(bBox.getMinX(), bBox.getMaxY());
        this.shear(double_, d, d2);
    }

    public void shear(Point2D point2D, double d, double d2) {
        this.translate(-point2D.getX(), -point2D.getY());
        double d3 = this.flatmatrix[0];
        double d4 = this.flatmatrix[1];
        double d5 = this.flatmatrix[2];
        double d6 = this.flatmatrix[3];
        double d7 = this.flatmatrix[4];
        double d8 = this.flatmatrix[5];
        this.flatmatrix[0] = d3 - d * d4;
        this.flatmatrix[1] = d4 - d2 * d3;
        this.flatmatrix[2] = d5 - d * d6;
        this.flatmatrix[3] = d6 - d2 * d5;
        this.flatmatrix[4] = d7 - d * d8;
        this.flatmatrix[5] = d8 - d2 * d7;
        this.translate(point2D.getX(), point2D.getY());
    }

    public void saveEPS(PrintWriter printWriter) {
        printWriter.println("[" + this.flatmatrix[0] + " " + this.flatmatrix[1] + " " + this.flatmatrix[2] + " " + this.flatmatrix[3] + " " + this.flatmatrix[4] + " " + this.flatmatrix[5] + "] concat");
        printWriter.println("1 -1 scale");
    }

    public String svg() {
        return "transform=\"matrix(" + this.flatmatrix[0] + "," + this.flatmatrix[1] + "," + this.flatmatrix[2] + "," + this.flatmatrix[3] + "," + this.flatmatrix[4] + "," + this.flatmatrix[5] + ")\"";
    }

    public String pgf(AffineTransform affineTransform, double d, double d2, String string) {
        String string2 = System.getProperty("line.separator", "\n");
        String string3 = "\\begin{pgfscope}" + string2;
        BBox bBox = this.getOriginalBBox();
        double d3 = bBox.getMaxY();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.concatenate(affineTransform);
        affineTransform2.concatenate(this.getAffineTransform());
        affineTransform2.concatenate(new AffineTransform(1.0, 0.0, 0.0, -1.0, d, d3 - d2));
        string3 = string3 + PGF.transform(affineTransform2) + string2 + string + string2;
        string3 = string3 + "\\end{pgfscope}" + string2;
        return string3;
    }

    public void save(DataOutputStream dataOutputStream, float f) throws IOException {
        for (int i = 0; i < 6; ++i) {
            dataOutputStream.writeDouble(this.flatmatrix[i]);
        }
    }

    public static double[] read(DataInputStream dataInputStream, float f) throws IOException, EOFException {
        double[] dArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray[i] = dataInputStream.readDouble();
        }
        return dArray;
    }

    public void saveAJR(PrintWriter printWriter, float f) throws IOException {
        for (int i = 0; i < 6; ++i) {
            AJR.writeDouble(printWriter, this.flatmatrix[i]);
        }
    }

    public static double[] readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        double[] dArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray[i] = AJR.readDouble(bufferedReader);
        }
        return dArray;
    }

    public String toString() {
        String string = "JDRTransform:";
        for (int i = 0; i < 6; ++i) {
            string = string + " " + this.flatmatrix[i];
        }
        return string;
    }

    public String info() {
        return "[[" + this.flatmatrix[0] + "," + this.flatmatrix[2] + "," + this.flatmatrix[4] + "]" + "[" + this.flatmatrix[1] + "," + this.flatmatrix[3] + "," + this.flatmatrix[5] + "]" + "]";
    }
}

