/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontShapeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontSizeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontWeightException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidHAlignException;
import uk.ac.uea.cmp.nlct.jdr.InvalidTextLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidVAlignException;
import uk.ac.uea.cmp.nlct.jdr.InvalidWindingRuleException;
import uk.ac.uea.cmp.nlct.jdr.JDRFont;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPathStyleListener;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRText;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPath;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPathStyleListener;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFont;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRTextPathStroke
implements JDRStroke {
    private String text;
    private Font font;
    private JDRFont jdrFont = new JDRFont();
    private int halign;
    private int valign;
    public LaTeXFont latexFont = new LaTeXFont();
    public String latexText;
    private AffineTransform af = new AffineTransform();
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BASE = 2;
    public static final int BOTTOM = 3;
    private static final float FLATNESS = 1.0f;
    private double[] matrix;
    private static JDRPathStyleListener pathStyleListener = new JDRTextPathStyleListener();

    public JDRTextPathStroke(String string, Font font) {
        this.text = string;
        this.latexText = string;
        this.halign = 0;
        this.valign = 2;
        this.jdrFont.setFamily(font.getName());
        try {
            this.jdrFont.setWeight(font.isBold() ? 1 : 0);
        }
        catch (InvalidFontWeightException invalidFontWeightException) {
            // empty catch block
        }
        try {
            this.jdrFont.setShape(font.isItalic() ? 1 : 0);
        }
        catch (InvalidFontShapeException invalidFontShapeException) {
            // empty catch block
        }
        try {
            this.jdrFont.setSize(font.getSize());
        }
        catch (InvalidFontSizeException invalidFontSizeException) {
            // empty catch block
        }
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
        this.matrix = new double[6];
        this.matrix[0] = 1.0;
        this.matrix[1] = 0.0;
        this.matrix[2] = 0.0;
        this.matrix[3] = 1.0;
        this.matrix[4] = 0.0;
        this.matrix[5] = 0.0;
    }

    public JDRTextPathStroke(JDRText jDRText) {
        this.text = jDRText.getText();
        this.latexText = jDRText.getLaTeXText();
        this.jdrFont = (JDRFont)jDRText.getJDRFont().clone();
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
        this.latexFont = (LaTeXFont)jDRText.latexFont.clone();
        this.halign = jDRText.pgfHalign;
        this.valign = jDRText.pgfValign;
        this.matrix = jDRText.getTransformation(null);
        this.matrix[4] = 0.0;
        this.matrix[5] = 0.0;
    }

    public JDRTextPathStroke() {
        this("", "", new JDRFont(), 0, 2, new LaTeXFont());
    }

    protected JDRTextPathStroke(String string, String string2, JDRFont jDRFont, int n, int n2, LaTeXFont laTeXFont) {
        this.text = string;
        this.latexText = string2;
        this.jdrFont = jDRFont;
        this.latexFont = laTeXFont;
        this.halign = n;
        this.valign = n2;
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
        this.matrix = new double[6];
        this.matrix[0] = 1.0;
        this.matrix[1] = 0.0;
        this.matrix[2] = 0.0;
        this.matrix[3] = 1.0;
        this.matrix[4] = 0.0;
        this.matrix[5] = 0.0;
    }

    @Override
    public Object clone() {
        JDRTextPathStroke jDRTextPathStroke = new JDRTextPathStroke(this.text, this.font);
        jDRTextPathStroke.latexText = this.latexText;
        jDRTextPathStroke.latexFont = (LaTeXFont)this.latexFont.clone();
        jDRTextPathStroke.halign = this.halign;
        jDRTextPathStroke.valign = this.valign;
        for (int i = 0; i < 6; ++i) {
            jDRTextPathStroke.matrix[i] = this.matrix[i];
        }
        return jDRTextPathStroke;
    }

    public JDRText getJDRText(Graphics graphics) {
        JDRText jDRText = new JDRText();
        jDRText.jdrFont = (JDRFont)this.jdrFont.clone();
        jDRText.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
        jDRText.latexFont = (LaTeXFont)this.latexFont.clone();
        jDRText.setText(graphics, this.text, this.latexText);
        jDRText.pgfHalign = this.halign;
        jDRText.pgfValign = this.valign;
        jDRText.setTransformation(this.matrix);
        return jDRText;
    }

    public JDRText getJDRText() {
        return this.getJDRText(null);
    }

    public void setFont(String string, int n, int n2, int n3) throws InvalidFontWeightException, InvalidFontShapeException, InvalidFontSizeException {
        this.setFontFamily(string);
        this.setFontSeries(n);
        this.setFontShape(n2);
        this.setFontSize(n3);
    }

    public void setFontFamily(String string) {
        this.jdrFont.setFamily(string);
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
    }

    public void setFontSeries(int n) throws InvalidFontWeightException {
        this.jdrFont.setWeight(n);
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
    }

    public void setFontShape(int n) throws InvalidFontShapeException {
        this.jdrFont.setShape(n);
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
    }

    public void setFontSize(int n) throws InvalidFontSizeException {
        this.jdrFont.setSize(n);
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
    }

    public String getFontFamily() {
        return this.jdrFont.getFamily();
    }

    public int getFontSeries() {
        return this.jdrFont.getWeight();
    }

    public int getFontShape() {
        return this.jdrFont.getShape();
    }

    private int getFontWeight() {
        int n = 0;
        n += this.getFontSeries() == 0 ? 0 : 1;
        return n += this.getFontShape() == 0 ? 0 : 2;
    }

    public int getFontSize() {
        return this.jdrFont.getSize();
    }

    public Font getFont() {
        return this.font;
    }

    public JDRFont getJDRFont() {
        return this.jdrFont;
    }

    public String getText() {
        return this.text;
    }

    public String getLaTeXText() {
        return this.latexText;
    }

    public void setLaTeXFont(LaTeXFont laTeXFont) {
        this.latexFont = laTeXFont;
    }

    public LaTeXFont getLaTeXFont() {
        return this.latexFont;
    }

    public void setLaTeXFont(String string, String string2, String string3, String string4) {
        this.latexFont.setFamily(string);
        this.latexFont.setWeight(string3);
        this.latexFont.setShape(string4);
        this.latexFont.setSize(string2);
    }

    public void setLaTeXFamily(String string) {
        this.latexFont.setFamily(string);
    }

    public void setLaTeXSeries(String string) {
        this.latexFont.setWeight(string);
    }

    public void setLaTeXShape(String string) {
        this.latexFont.setShape(string);
    }

    public void setLaTeXSize(String string) {
        this.latexFont.setSize(string);
    }

    public String getLaTeXFamily() {
        return this.latexFont.getFamily();
    }

    public String getLaTeXSeries() {
        return this.latexFont.getWeight();
    }

    public String getLaTeXSize() {
        return this.latexFont.getSize();
    }

    public String getLaTeXShape() {
        return this.latexFont.getShape();
    }

    public void setText(String string) {
        this.latexText = this.text = string.replaceAll("[\t\r\n]", " ");
    }

    public void setText(String string, String string2) {
        this.text = string.replaceAll("[\t\r\n]", " ");
        this.latexText = string2.replaceAll("[\t\r\n]", " ");
    }

    public void setLaTeXText(String string) {
        this.latexText = string.replaceAll("[\t\r\n]", " ");
    }

    public void setHAlign(int n) throws InvalidHAlignException {
        if (n < 0 || n > 2) {
            throw new InvalidHAlignException(n);
        }
        this.halign = n;
    }

    public int getHAlign() {
        return this.halign;
    }

    public void setVAlign(int n) throws InvalidVAlignException {
        if (n < 0 || n > 3) {
            throw new InvalidVAlignException(n);
        }
        this.valign = n;
    }

    public int getVAlign() {
        return this.valign;
    }

    @Override
    public void saveEPS(JDRShape jDRShape, PrintWriter printWriter) {
    }

    public static JDRTextPathStroke read(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        Object object;
        int n;
        LaTeXFont laTeXFont;
        JDRFont jDRFont = JDRFont.read(dataInputStream, f);
        double[] dArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray[i] = dataInputStream.readDouble();
        }
        String string = null;
        byte by = 0;
        int n2 = 2;
        if (dataInputStream.readBoolean()) {
            laTeXFont = LaTeXFont.read(dataInputStream, f);
            by = dataInputStream.readByte();
            if (by < 0 || by > 2) {
                throw new InvalidHAlignException(by);
            }
            n2 = dataInputStream.readByte();
            if (n2 < 0 || n2 > 3) {
                throw new InvalidVAlignException(n2);
            }
            n = dataInputStream.readInt();
            if (n > 0) {
                object = new char[n];
                for (int i = 0; i < n; ++i) {
                    object[i] = dataInputStream.readChar();
                }
                string = new String((char[])object);
            }
        } else {
            laTeXFont = new LaTeXFont();
        }
        n = dataInputStream.readInt();
        object = "";
        if (n <= 0) {
            throw new InvalidTextLengthException(n);
        }
        Object object2 = new char[n];
        for (int i = 0; i < n; ++i) {
            object2[i] = dataInputStream.readChar();
        }
        object = new String((char[])object2);
        object2 = new JDRTextPathStroke((String)object, string, jDRFont, by, n2, laTeXFont);
        ((JDRTextPathStroke)object2).setTransformation(dArray);
        return object2;
    }

    @Override
    public void save(DataOutputStream dataOutputStream, float f) throws IOException {
        this.jdrFont.save(dataOutputStream, f);
        for (int i = 0; i < 6; ++i) {
            dataOutputStream.writeDouble(this.matrix[i]);
        }
        dataOutputStream.writeBoolean(true);
        this.latexFont.save(dataOutputStream, f);
        dataOutputStream.writeByte((byte)this.halign);
        dataOutputStream.writeByte((byte)this.valign);
        if (this.latexText == null || this.latexText.equals(this.text)) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(this.latexText.length());
            dataOutputStream.writeChars(this.latexText);
        }
        dataOutputStream.writeInt(this.text.length());
        dataOutputStream.writeChars(this.text);
    }

    public static JDRTextPathStroke readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        int n;
        LaTeXFont laTeXFont;
        JDRFont jDRFont = JDRFont.readAJR(bufferedReader, f);
        double[] dArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray[i] = AJR.readDouble(bufferedReader);
        }
        String string = null;
        int n2 = 0;
        int n3 = 2;
        if (AJR.readBoolean(bufferedReader)) {
            laTeXFont = LaTeXFont.readAJR(bufferedReader, f);
            n2 = AJR.readInt(bufferedReader);
            if (n2 < 0 || n2 > 2) {
                throw new InvalidHAlignException(n2);
            }
            n3 = AJR.readInt(bufferedReader);
            if (n3 < 0 || n3 > 3) {
                throw new InvalidVAlignException(n3);
            }
            n = AJR.readInt(bufferedReader);
            if (n > 0) {
                string = AJR.readString(bufferedReader, n);
            }
        } else {
            laTeXFont = new LaTeXFont();
        }
        n = AJR.readInt(bufferedReader);
        String string2 = "";
        if (n <= 0) {
            throw new InvalidTextLengthException(n);
        }
        string2 = AJR.readString(bufferedReader, n);
        JDRTextPathStroke jDRTextPathStroke = new JDRTextPathStroke(string2, string, jDRFont, n2, n3, laTeXFont);
        jDRTextPathStroke.setTransformation(dArray);
        return jDRTextPathStroke;
    }

    @Override
    public void saveAJR(PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        this.jdrFont.saveAJR(printWriter, f);
        for (int i = 0; i < 6; ++i) {
            AJR.writeDouble(printWriter, this.matrix[i]);
        }
        AJR.writeBoolean(printWriter, true);
        this.latexFont.saveAJR(printWriter, f);
        AJR.writeInt(printWriter, this.halign);
        AJR.writeInt(printWriter, this.valign);
        if (this.latexText == null || this.latexText.equals(this.text)) {
            AJR.writeInt(printWriter, 0);
        } else {
            AJR.writeInt(printWriter, this.latexText.length());
            printWriter.println(this.latexText);
        }
        AJR.writeInt(printWriter, this.text.length());
        printWriter.println(this.text);
    }

    @Override
    public Area getStrokedArea(JDRShape jDRShape) {
        return new Area(this.getStrokedPath(jDRShape));
    }

    @Override
    public Shape getStrokedPath(JDRShape jDRShape) {
        return this.createStrokedShape(jDRShape.getGeneralPath());
    }

    @Override
    public void drawPath(JDRShape jDRShape, Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.fill(jDRShape.getStrokedPath());
    }

    @Override
    public void drawPath(JDRShape jDRShape, GeneralPath generalPath, Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.fill(this.createStrokedShape(generalPath));
    }

    @Override
    public void setWindingRule(int n) throws InvalidWindingRuleException {
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "TextPathStroke:" + string;
        string2 = string2 + "text: " + this.text + string;
        string2 = string2 + "LaTeX equivalent: " + this.latexText + string;
        string2 = string2 + "font: " + this.jdrFont.info() + string;
        string2 = string2 + "LaTeX font: " + this.latexFont.info() + string;
        string2 = string2 + "HAlign: " + this.halign + string;
        string2 = string2 + "VAlign: " + this.valign + string;
        string2 = string2 + "Matrix: [";
        for (int i = 0; i < 6; ++i) {
            if (i != 0) {
                string2 = string2 + ",";
            }
            string2 = string2 + this.matrix[i];
        }
        string2 = string2 + "]";
        return string2;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        Font font = this.font.deriveFont(new AffineTransform(this.matrix));
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, this.text);
        TextLayout textLayout = new TextLayout(this.text, font, fontRenderContext);
        float f = textLayout.getDescent();
        float f2 = textLayout.getAscent();
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f3 = (float)this.matrix[4];
        float f4 = (float)this.matrix[5];
        switch (this.valign) {
            case 0: {
                f4 = -f2;
                break;
            }
            case 1: {
                f4 = f - (float)rectangle2D.getHeight() * 0.5f;
                break;
            }
            case 3: {
                f4 = f;
            }
        }
        if (this.halign != 0) {
            double d = JDRTextPathStroke.measurePathLength(shape);
            f3 = this.halign == 1 ? (float)(d - rectangle2D.getWidth()) * 0.5f : (float)(d - rectangle2D.getWidth());
        }
        GeneralPath generalPath = new GeneralPath();
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        int n = 0;
        boolean bl = false;
        float f11 = 0.0f;
        int n2 = 0;
        int n3 = glyphVector.getNumGlyphs();
        if (n3 == 0) {
            return generalPath;
        }
        float f12 = 0.0f;
        while (n2 < n3 && !flatteningPathIterator.isDone()) {
            n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f5 = f7 = fArray[0];
                    f6 = f8 = fArray[1];
                    generalPath.moveTo(f5, f6);
                    bl = true;
                    f12 = glyphVector.getGlyphMetrics(n2).getAdvance() * 0.5f;
                    f11 = f12 + f3;
                    break;
                }
                case 4: {
                    fArray[0] = f5;
                    fArray[1] = f6;
                }
                case 1: {
                    f9 = fArray[0];
                    f10 = fArray[1];
                    float f13 = f9 - f7;
                    float f14 = f10 - f8;
                    double d = Math.sqrt(f13 * f13 + f14 * f14);
                    if (d >= (double)f11) {
                        double d2 = 1.0 / d;
                        double d3 = Math.atan2(f14, f13);
                        while (n2 < n3 && d >= (double)f11) {
                            Shape shape2 = glyphVector.getGlyphOutline(n2);
                            Point2D point2D = glyphVector.getGlyphPosition(n2);
                            double d4 = point2D.getX();
                            double d5 = point2D.getY() + (double)f4;
                            double d6 = (double)f7 + (double)(f11 * f13) * d2;
                            double d7 = (double)f8 + (double)(f11 * f14) * d2;
                            double d8 = f12;
                            f12 = n2 < n3 - 1 ? glyphVector.getGlyphMetrics(n2 + 1).getAdvance() * 0.5f : 0.0f;
                            this.af.setToTranslation(d6, d7);
                            this.af.rotate(d3);
                            this.af.translate(-d4 - d8, -d5);
                            generalPath.append(this.af.createTransformedShape(shape2), false);
                            ++n2;
                            f11 = (float)((double)f11 + (d8 + (double)f12));
                        }
                    }
                    f11 = (float)((double)f11 - d);
                    bl = false;
                    f7 = f9;
                    f8 = f10;
                }
            }
            flatteningPathIterator.next();
        }
        return generalPath;
    }

    public static float measurePathLength(Shape shape) {
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n = 0;
        double d = 0.0;
        while (!flatteningPathIterator.isDone()) {
            n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f = f3 = fArray[0];
                    f2 = f4 = fArray[1];
                    break;
                }
                case 4: {
                    fArray[0] = f;
                    fArray[1] = f2;
                }
                case 1: {
                    f5 = fArray[0];
                    f6 = fArray[1];
                    double d2 = f5 - f3;
                    double d3 = f6 - f4;
                    d += Math.sqrt(d2 * d2 + d3 * d3);
                    f3 = f5;
                    f4 = f6;
                }
            }
            flatteningPathIterator.next();
        }
        return (float)d;
    }

    public JDRGroup split(Graphics2D graphics2D, JDRTextPath jDRTextPath) {
        GeneralPath generalPath = jDRTextPath.getGeneralPath();
        JDRGroup jDRGroup = new JDRGroup();
        double[] dArray = new double[6];
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        Font font = this.getFont().deriveFont(new AffineTransform(this.matrix));
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, this.text);
        TextLayout textLayout = new TextLayout(this.text, font, fontRenderContext);
        float f = textLayout.getDescent();
        float f2 = textLayout.getAscent();
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f3 = (float)this.matrix[5];
        float f4 = (float)this.matrix[4];
        switch (this.valign) {
            case 0: {
                f3 = -f2;
                break;
            }
            case 1: {
                f3 = f - (float)rectangle2D.getHeight() * 0.5f;
                break;
            }
            case 3: {
                f3 = f;
            }
        }
        if (this.halign != 0) {
            double d = JDRTextPathStroke.measurePathLength(generalPath);
            f4 = this.halign == 1 ? (float)(d - rectangle2D.getWidth()) * 0.5f : (float)(d - rectangle2D.getWidth());
        }
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(generalPath.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        int n = 0;
        boolean bl = false;
        float f11 = 0.0f;
        int n2 = 0;
        int n3 = glyphVector.getNumGlyphs();
        if (n3 == 0) {
            return jDRGroup;
        }
        float f12 = 0.0f;
        while (n2 < n3 && !flatteningPathIterator.isDone()) {
            n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f5 = f7 = fArray[0];
                    f6 = f8 = fArray[1];
                    bl = true;
                    f12 = glyphVector.getGlyphMetrics(n2).getAdvance() * 0.5f;
                    f11 = f12 + f4;
                    break;
                }
                case 4: {
                    fArray[0] = f5;
                    fArray[1] = f6;
                }
                case 1: {
                    f9 = fArray[0];
                    f10 = fArray[1];
                    float f13 = f9 - f7;
                    float f14 = f10 - f8;
                    double d = Math.sqrt(f13 * f13 + f14 * f14);
                    if (d >= (double)f11) {
                        double d2 = 1.0 / d;
                        double d3 = Math.atan2(f14, f13);
                        while (n2 < n3 && d >= (double)f11) {
                            Shape shape = glyphVector.getGlyphOutline(n2);
                            Point2D point2D = glyphVector.getGlyphPosition(n2);
                            double d4 = (double)f7 + (double)(f11 * f13) * d2;
                            double d5 = (double)f8 + (double)(f11 * f14) * d2;
                            double d6 = f12;
                            f12 = n2 < n3 - 1 ? glyphVector.getGlyphMetrics(n2 + 1).getAdvance() * 0.5f : 0.0f;
                            char c = this.text.charAt(n2);
                            if (!Character.isWhitespace(c) && glyphVector.getGlyphMetrics(n2).isStandard()) {
                                JDRText jDRText = new JDRText(graphics2D, "" + c);
                                this.af.setToIdentity();
                                this.af.translate(d4, d5 - (double)f3);
                                this.af.rotate(d3);
                                this.af.translate(-d6, 0.0);
                                this.af.concatenate(new AffineTransform(this.matrix[0], this.matrix[1], this.matrix[2], this.matrix[3], 0.0, 0.0));
                                this.af.getMatrix(dArray);
                                jDRText.setTransformation(dArray);
                                jDRText.setLaTeXFamily(this.getLaTeXFamily());
                                jDRText.setLaTeXSize(this.getLaTeXSize());
                                jDRText.setLaTeXSeries(this.getLaTeXSeries());
                                jDRText.setLaTeXShape(this.getLaTeXShape());
                                jDRText.setTextPaint(jDRTextPath.getLinePaint());
                                try {
                                    jDRText.setFont(graphics2D, this.getFontFamily(), this.getFontSeries(), this.getFontShape(), this.getFontSize());
                                    jDRText.setVAlign(this.getVAlign());
                                    jDRText.setHAlign(this.getHAlign());
                                }
                                catch (InvalidFormatException invalidFormatException) {
                                    // empty catch block
                                }
                                jDRGroup.add(jDRText);
                            }
                            ++n2;
                            f11 = (float)((double)f11 + (d6 + (double)f12));
                        }
                    }
                    f11 = (float)((double)f11 - d);
                    bl = false;
                    f7 = f9;
                    f8 = f10;
                }
            }
            flatteningPathIterator.next();
        }
        jDRGroup.setSelected(jDRTextPath.isSelected());
        return jDRGroup;
    }

    public double[] getTransformation(double[] dArray) {
        if (dArray == null) {
            dArray = new double[6];
        }
        for (int i = 0; i < 6; ++i) {
            dArray[i] = this.matrix[i];
        }
        return dArray;
    }

    public void setTransformation(double[] dArray) {
        this.matrix = dArray;
    }

    @Override
    public JDRPathStyleListener getPathStyleListener() {
        return pathStyleListener;
    }
}

