/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPath;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPathStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class JDRTextPathListener
extends JDRPathListener {
    @Override
    public char getJDRid(float f) {
        return f < 1.5f ? (char)'G' : 'X';
    }

    @Override
    public void writeJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRTextPath jDRTextPath = (JDRTextPath)jDRObject;
        if (f < 1.5f) {
            JDRGroup jDRGroup = jDRTextPath.separate();
            JDRObjectLoaderListener jDRObjectLoaderListener = jDRGroup.getListener();
            jDRObjectLoaderListener.writeJDR(jDRGroup, dataOutputStream, f);
        } else if (f < 1.6f) {
            JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
            jDRPaintLoader.saveJDR(jDRTextPath.getTextPaint(), dataOutputStream, f);
            jDRTextPath.getStroke().save(dataOutputStream, f);
            this.writeJDRPathSpecs(jDRTextPath, dataOutputStream, f);
        } else {
            JDRObjectLoader jDRObjectLoader = JDR.getObjectLoader();
            jDRObjectLoader.saveJDR(jDRTextPath.getUnderlyingShape(), dataOutputStream, f);
        }
    }

    @Override
    public JDRObject readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        JDRShape jDRShape;
        if (f < 1.5f) {
            throw new InvalidFormatException("Text-path not supported in JDR version " + f);
        }
        if (f < 1.6f) {
            jDRShape = new JDRPath();
            JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
            jDRShape.setLinePaint(jDRPaintLoader.loadJDR(dataInputStream, f));
            jDRShape.setFillPaint(JDRTransparent.Transparent);
            jDRShape.setStroke(JDRTextPathStroke.read(dataInputStream, f));
            this.readJDRPathSpecs(jDRShape, dataInputStream, f);
        } else {
            JDRObjectLoader jDRObjectLoader = JDR.getObjectLoader();
            JDRObject jDRObject = jDRObjectLoader.loadJDR(dataInputStream, f);
            if (!(jDRObject instanceof JDRShape)) {
                throw new InvalidFormatException("Text-path object must have a shape as the underlying object");
            }
            jDRShape = (JDRShape)jDRObject;
        }
        return new JDRTextPath(jDRShape);
    }

    @Override
    public char getAJRid(float f) {
        return f < 1.5f ? (char)'G' : 'X';
    }

    @Override
    public void writeAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRTextPath jDRTextPath = (JDRTextPath)jDRObject;
        if (f < 1.5f) {
            JDRGroup jDRGroup = jDRTextPath.separate();
            JDRObjectLoaderListener jDRObjectLoaderListener = jDRGroup.getListener();
            jDRObjectLoaderListener.writeAJR(jDRGroup, printWriter, f);
        } else if (f < 1.6f) {
            JDRPaintLoader jDRPaintLoader = AJR.getPaintLoader();
            jDRPaintLoader.saveAJR(jDRTextPath.getTextPaint(), printWriter, f);
            jDRTextPath.getStroke().saveAJR(printWriter, f);
            this.writeAJRPathSpecs(jDRTextPath, printWriter, f);
        } else {
            JDRObjectLoader jDRObjectLoader = AJR.getObjectLoader();
            jDRObjectLoader.saveAJR(jDRTextPath.getUnderlyingShape(), printWriter, f);
        }
    }

    @Override
    public JDRObject readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        JDRShape jDRShape;
        if (f < 1.5f) {
            throw new InvalidFormatException("Text-path not supported in JDR version " + f);
        }
        if (f < 1.6f) {
            jDRShape = new JDRPath();
            JDRPaintLoader jDRPaintLoader = AJR.getPaintLoader();
            jDRShape.setLinePaint(jDRPaintLoader.loadAJR(bufferedReader, f));
            jDRShape.setFillPaint(JDRTransparent.Transparent);
            jDRShape.setStroke(JDRTextPathStroke.readAJR(bufferedReader, f));
            this.readAJRPathSpecs(jDRShape, bufferedReader, f);
        } else {
            JDRObjectLoader jDRObjectLoader = AJR.getObjectLoader();
            JDRObject jDRObject = jDRObjectLoader.loadAJR(bufferedReader, f);
            if (!(jDRObject instanceof JDRShape)) {
                throw new InvalidFormatException("Text-path object must have a shape as the underlying object");
            }
            jDRShape = (JDRShape)jDRObject;
        }
        return new JDRTextPath(jDRShape);
    }
}

