/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.EmptyPathException;
import uk.ac.uea.cmp.nlct.jdr.FlowFrame;
import uk.ac.uea.cmp.nlct.jdr.IllFittingPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontShapeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontSizeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontWeightException;
import uk.ac.uea.cmp.nlct.jdr.InvalidHAlignException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidVAlignException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRCompoundShape;
import uk.ac.uea.cmp.nlct.jdr.JDRFont;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPathIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPointIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRShading;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPath;
import uk.ac.uea.cmp.nlct.jdr.JDRText;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPathStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFont;

public class JDRTextPath
extends JDRCompoundShape
implements JDRTextual {
    private static JDRTextPathListener textPathListener = new JDRTextPathListener();
    private JDRShape path_;

    public JDRTextPath(JDRShape jDRShape, JDRText jDRText) {
        this.path_ = jDRShape;
        this.setStroke(new JDRTextPathStroke(jDRText));
        this.setTextPaint(jDRText.getTextPaint());
    }

    public JDRTextPath(JDRShape jDRShape, JDRTextPathStroke jDRTextPathStroke) {
        this.path_ = jDRShape;
        this.setStroke(jDRTextPathStroke);
        this.setTextPaint(jDRShape.getLinePaint());
    }

    public JDRTextPath(int n, JDRPaint jDRPaint, JDRTextPathStroke jDRTextPathStroke) {
        this.path_ = new JDRPath(n);
        this.setStroke(jDRTextPathStroke);
        this.setTextPaint(jDRPaint);
    }

    public JDRTextPath(JDRShape jDRShape) {
        this.path_ = jDRShape;
        if (!(jDRShape.getStroke() instanceof JDRTextPathStroke)) {
            this.setStroke(new JDRTextPathStroke());
        }
    }

    @Override
    public JDRStroke getStroke() {
        return this.path_.getStroke();
    }

    @Override
    public void setStroke(JDRStroke jDRStroke) {
        this.path_.setStroke(jDRStroke);
    }

    @Override
    public JDRPaint getTextPaint() {
        return this.path_.getLinePaint();
    }

    @Override
    public void setTextPaint(JDRPaint jDRPaint) {
        this.path_.setLinePaint(jDRPaint);
    }

    @Override
    public JDRPaint getFillPaint() {
        return JDRTransparent.Transparent;
    }

    @Override
    public void setFillPaint(JDRPaint jDRPaint) {
    }

    @Override
    public JDRPaint getLinePaint() {
        return this.path_.getLinePaint();
    }

    @Override
    public void setLinePaint(JDRPaint jDRPaint) {
        this.path_.setLinePaint(jDRPaint);
    }

    public JDRShape getJDRShape() {
        JDRShape jDRShape = (JDRShape)this.path_.clone();
        if (!(this.path_ instanceof JDRTextual)) {
            jDRShape.setStroke(new JDRBasicStroke());
        }
        return jDRShape;
    }

    public JDRText getJDRText(Graphics graphics) {
        JDRText jDRText = ((JDRTextPathStroke)this.getStroke()).getJDRText(graphics);
        JDRPoint jDRPoint = this.getFirstSegment().getStart();
        jDRText.setPosition(jDRPoint.x, jDRPoint.y);
        jDRText.setTextPaint(this.getLinePaint());
        return jDRText;
    }

    public JDRText getJDRText() {
        return this.getJDRText(null);
    }

    @Override
    public JDRGroup separate(Graphics graphics) {
        JDRShape jDRShape = this.getJDRShape();
        JDRText jDRText = this.getJDRText(graphics);
        jDRText.updateBounds(graphics);
        JDRGroup jDRGroup = new JDRGroup();
        jDRGroup.add(jDRShape);
        jDRGroup.add(jDRText);
        return jDRGroup;
    }

    public JDRGroup separate() {
        return this.separate(null);
    }

    @Override
    public JDRGroup split(Graphics2D graphics2D) {
        return ((JDRTextPathStroke)this.getStroke()).split(graphics2D, this);
    }

    @Override
    public void setHAlign(int n) throws InvalidHAlignException {
        ((JDRTextPathStroke)this.getStroke()).setHAlign(n);
    }

    @Override
    public void setVAlign(int n) throws InvalidVAlignException {
        ((JDRTextPathStroke)this.getStroke()).setVAlign(n);
    }

    @Override
    public void setAlign(int n, int n2) throws InvalidHAlignException, InvalidVAlignException {
        this.setHAlign(n);
        this.setVAlign(n2);
    }

    @Override
    public int getHAlign() {
        return ((JDRTextPathStroke)this.getStroke()).getHAlign();
    }

    @Override
    public int getVAlign() {
        return ((JDRTextPathStroke)this.getStroke()).getVAlign();
    }

    @Override
    public void setText(Graphics graphics, String string, String string2) {
        ((JDRTextPathStroke)this.getStroke()).setText(string, string2);
    }

    @Override
    public void setText(Graphics graphics, String string) {
        ((JDRTextPathStroke)this.getStroke()).setText(string);
    }

    @Override
    public void setLaTeXText(String string) {
        ((JDRTextPathStroke)this.getStroke()).setLaTeXText(string);
    }

    @Override
    public String getText() {
        return ((JDRTextPathStroke)this.getStroke()).getText();
    }

    @Override
    public String getLaTeXText() {
        return ((JDRTextPathStroke)this.getStroke()).getLaTeXText();
    }

    @Override
    public void setFont(Graphics graphics, String string, int n, int n2, int n3) throws InvalidFontWeightException, InvalidFontShapeException, InvalidFontSizeException {
        ((JDRTextPathStroke)this.getStroke()).setFont(string, n, n2, n3);
    }

    @Override
    public void setFontFamily(Graphics graphics, String string) {
        ((JDRTextPathStroke)this.getStroke()).setFontFamily(string);
    }

    @Override
    public void setFontSeries(Graphics graphics, int n) throws InvalidFontWeightException {
        ((JDRTextPathStroke)this.getStroke()).setFontSeries(n);
    }

    @Override
    public void setFontShape(Graphics graphics, int n) throws InvalidFontShapeException {
        ((JDRTextPathStroke)this.getStroke()).setFontShape(n);
    }

    @Override
    public void setFontSize(Graphics graphics, int n) throws InvalidFontSizeException {
        ((JDRTextPathStroke)this.getStroke()).setFontSize(n);
    }

    @Override
    public String getFontFamily() {
        return ((JDRTextPathStroke)this.getStroke()).getFontFamily();
    }

    @Override
    public int getFontSeries() {
        return ((JDRTextPathStroke)this.getStroke()).getFontSeries();
    }

    @Override
    public int getFontShape() {
        return ((JDRTextPathStroke)this.getStroke()).getFontShape();
    }

    @Override
    public int getFontSize() {
        return ((JDRTextPathStroke)this.getStroke()).getFontSize();
    }

    @Override
    public Font getFont() {
        return ((JDRTextPathStroke)this.getStroke()).getFont();
    }

    @Override
    public JDRFont getJDRFont() {
        return ((JDRTextPathStroke)this.getStroke()).getJDRFont();
    }

    @Override
    public void setLaTeXFamily(String string) {
        ((JDRTextPathStroke)this.getStroke()).setLaTeXFamily(string);
    }

    @Override
    public void setLaTeXSize(String string) {
        ((JDRTextPathStroke)this.getStroke()).setLaTeXSize(string);
    }

    @Override
    public void setLaTeXSeries(String string) {
        ((JDRTextPathStroke)this.getStroke()).setLaTeXSeries(string);
    }

    @Override
    public void setLaTeXShape(String string) {
        ((JDRTextPathStroke)this.getStroke()).setLaTeXShape(string);
    }

    @Override
    public void setLaTeXFont(String string, String string2, String string3, String string4) {
        ((JDRTextPathStroke)this.getStroke()).setLaTeXFont(string, string2, string3, string4);
    }

    @Override
    public void setLaTeXFont(LaTeXFont laTeXFont) {
        ((JDRTextPathStroke)this.getStroke()).setLaTeXFont(laTeXFont);
    }

    @Override
    public String getLaTeXFamily() {
        return ((JDRTextPathStroke)this.getStroke()).getLaTeXFamily();
    }

    @Override
    public String getLaTeXShape() {
        return ((JDRTextPathStroke)this.getStroke()).getLaTeXShape();
    }

    @Override
    public String getLaTeXSeries() {
        return ((JDRTextPathStroke)this.getStroke()).getLaTeXSeries();
    }

    @Override
    public String getLaTeXSize() {
        return ((JDRTextPathStroke)this.getStroke()).getLaTeXSize();
    }

    @Override
    public void makeEqual(JDRObject jDRObject) {
        JDRTextPath jDRTextPath = (JDRTextPath)jDRObject;
        super.makeEqual(jDRTextPath);
        this.path_.makeEqual(jDRTextPath.getUnderlyingShape());
    }

    @Override
    public Object clone() {
        JDRTextPath jDRTextPath = new JDRTextPath((JDRShape)this.path_.clone());
        jDRTextPath.setSelected(this.isSelected());
        jDRTextPath.description = this.description;
        if (this.flowframe != null) {
            jDRTextPath.flowframe = (FlowFrame)this.flowframe.clone();
        }
        return jDRTextPath;
    }

    @Override
    public JDRShape breakPath() throws InvalidPathException {
        return new JDRTextPath(this.path_.breakPath(), (JDRTextPathStroke)this.getStroke());
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        JDRPaint jDRPaint = this.getTextPaint();
        Area area = this.getStrokedArea();
        BBox bBox = null;
        if (jDRPaint instanceof JDRShading) {
            bBox = new BBox(area.getBounds2D());
        }
        graphics2D.setPaint(jDRPaint.getPaint(bBox));
        graphics2D.fill(area);
        graphics2D.setPaint(paint);
    }

    public void draw(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d);
        Shape shape = affineTransform.createTransformedShape(this.getStrokedPath());
        graphics2D.setPaint(this.getTextPaint().getPaint(this.getBBox()));
        graphics2D.fill(shape);
        graphics2D.setPaint(paint);
    }

    @Override
    public void drawDraft(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        this.path_.drawDraft(graphics, d);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d);
        Shape shape = affineTransform.createTransformedShape(this.getStrokedPath());
        graphics2D.setPaint(this.getTextPaint().getPaint(this.getBBox()));
        graphics2D.fill(shape);
        graphics2D.setPaint(paint);
    }

    @Override
    public BBox getControlBBox() {
        return this.path_.getControlBBox();
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return "";
        }
        String string = System.getProperty("line.separator");
        String string2 = "";
        if (!this.description.equals("")) {
            string2 = string2 + "% " + this.description + string;
        }
        JDRTextPathStroke jDRTextPathStroke = (JDRTextPathStroke)this.getStroke();
        string2 = string2 + "\\begin{pgfscope}" + jDRTextPathStroke.getLaTeXFont().tex() + string;
        String string3 = this.getLaTeXText();
        if (string3 == null) {
            string3 = this.getText();
        }
        string2 = string2 + "\\pgfset{decoration/text={|" + this.getLinePaint().pgf(bBox) + "|" + string3 + "}}" + string;
        string2 = string2 + "\\pgfdecoratepath{text along path}{";
        string2 = string2 + this.path_.pgfPath(affineTransform);
        string2 = string2 + "}" + string;
        string2 = string2 + "\\end{pgfscope}";
        return string2;
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        try {
            JDRShape jDRShape = this.outlineToPath();
            jDRShape.saveSVG(printWriter);
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        try {
            JDRShape jDRShape = this.outlineToPath();
            jDRShape.saveEPS(printWriter);
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
    }

    @Override
    public JDRShape getFullPath() throws EmptyPathException, IllFittingPathException {
        JDRTextPath jDRTextPath = new JDRTextPath(this.path_.getFullPath(), (JDRTextPathStroke)this.getStroke().clone());
        return jDRTextPath;
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return textPathListener;
    }

    @Override
    public double[] getTransformation(double[] dArray) {
        return ((JDRTextPathStroke)this.getStroke()).getTransformation(dArray);
    }

    @Override
    public void setTransformation(double[] dArray) {
        ((JDRTextPathStroke)this.getStroke()).setTransformation(dArray);
    }

    @Override
    public JDRShape reverse() throws InvalidPathException {
        JDRTextPath jDRTextPath = new JDRTextPath(this.path_.reverse(), (JDRTextPathStroke)this.getStroke().clone());
        return jDRTextPath;
    }

    @Override
    public JDRShape exclusiveOr(JDRShape jDRShape) throws InvalidPathException {
        return new JDRTextPath(this.path_.exclusiveOr(jDRShape), (JDRTextPathStroke)this.getStroke().clone());
    }

    @Override
    public JDRShape pathUnion(JDRShape jDRShape) throws InvalidPathException {
        return new JDRTextPath(this.path_.pathUnion(jDRShape), (JDRTextPathStroke)this.getStroke().clone());
    }

    @Override
    public JDRShape intersect(JDRShape jDRShape) throws InvalidPathException {
        return new JDRTextPath(this.path_.intersect(jDRShape), (JDRTextPathStroke)this.getStroke().clone());
    }

    @Override
    public JDRShape subtract(JDRShape jDRShape) throws InvalidPathException {
        return new JDRTextPath(this.path_.subtract(jDRShape), (JDRTextPathStroke)this.getStroke().clone());
    }

    public String toString() {
        String string = "TextPath: text=" + this.getText();
        string = string + ", size=" + this.size() + ", segments=[";
        for (int i = 0; i < this.size(); ++i) {
            string = string + this.get(i) + ",";
        }
        string = string + "]";
        return string;
    }

    @Override
    public JDRTextual getTextual() {
        return this;
    }

    @Override
    public boolean hasTextual() {
        return true;
    }

    @Override
    public JDRShape getUnderlyingShape() {
        return this.path_;
    }

    @Override
    public void setUnderlyingShape(JDRShape jDRShape) {
        this.path_ = jDRShape;
    }

    @Override
    public JDRPathIterator getIterator() {
        return this.path_.getIterator();
    }

    @Override
    public JDRPointIterator getPointIterator() {
        return this.path_.getPointIterator();
    }

    @Override
    public int size() {
        return this.path_.size();
    }

    @Override
    public int getCapacity() {
        return this.path_.getCapacity();
    }

    @Override
    public void setCapacity(int n) throws IllegalArgumentException {
        this.path_.setCapacity(n);
    }

    @Override
    public void open() {
        this.path_.open();
    }

    @Override
    public void open(boolean bl) {
        this.path_.open(bl);
    }

    @Override
    public void close(JDRPathSegment jDRPathSegment) throws EmptyPathException, IllFittingPathException {
        this.path_.close(jDRPathSegment);
    }

    @Override
    public boolean isClosed() {
        return this.path_.isClosed();
    }

    @Override
    public boolean segmentHasEnd(JDRPathSegment jDRPathSegment) {
        return this.path_.segmentHasEnd(jDRPathSegment);
    }

    @Override
    public int getIndex(JDRPathSegment jDRPathSegment) {
        return this.path_.getIndex(jDRPathSegment);
    }

    @Override
    public int getLastIndex(JDRPathSegment jDRPathSegment) {
        return this.path_.getLastIndex(jDRPathSegment);
    }

    @Override
    public JDRPathSegment get(int n) throws ArrayIndexOutOfBoundsException {
        return this.path_.get(n);
    }

    @Override
    public JDRPathSegment getLastSegment() {
        return this.path_.getLastSegment();
    }

    @Override
    public JDRPathSegment getFirstSegment() {
        return this.path_.getLastSegment();
    }

    @Override
    public JDRPoint getFirstControl() {
        return this.path_.getFirstControl();
    }

    @Override
    public JDRPoint getLastControl() {
        return this.path_.getLastControl();
    }

    @Override
    public void stopEditing() {
        this.path_.stopEditing();
    }

    @Override
    public int getSelectedControlIndex() {
        return this.path_.getSelectedControlIndex();
    }

    @Override
    protected void selectControl(JDRPoint jDRPoint, int n, int n2) {
        this.path_.selectControl(jDRPoint, n, n2);
    }

    @Override
    public JDRPathSegment getSelectedSegment() {
        return this.path_.getSelectedSegment();
    }

    @Override
    public JDRPoint getSelectedControl() {
        return this.path_.getSelectedControl();
    }

    @Override
    public int getSelectedIndex() {
        return this.path_.getSelectedIndex();
    }

    @Override
    public GeneralPath getGeneralPath() {
        return this.path_.getGeneralPath();
    }

    @Override
    public JDRPathSegment setSegment(int n, JDRPathSegment jDRPathSegment) throws ArrayIndexOutOfBoundsException {
        return this.path_.setSegment(n, jDRPathSegment);
    }

    @Override
    public void add(JDRSegment jDRSegment) {
        this.path_.add(jDRSegment);
    }

    @Override
    public JDRPoint addPoint() {
        return this.path_.addPoint();
    }

    @Override
    public void makeContinuous(boolean bl) {
        this.path_.makeContinuous(bl);
    }

    @Override
    public void convertSegment(int n, JDRPathSegment jDRPathSegment) {
        this.path_.convertSegment(n, jDRPathSegment);
    }

    @Override
    public JDRPathSegment remove(int n) throws ArrayIndexOutOfBoundsException {
        return this.path_.remove(n);
    }

    @Override
    public JDRPathSegment remove(JDRPathSegment jDRPathSegment) throws ArrayIndexOutOfBoundsException {
        return this.path_.remove(jDRPathSegment);
    }

    @Override
    public JDRPathSegment removeSelectedSegment() throws ArrayIndexOutOfBoundsException {
        return this.path_.removeSelectedSegment();
    }

    @Override
    public JDRSegment removeSegment(int n) throws ArrayIndexOutOfBoundsException {
        return this.path_.removeSegment(n);
    }

    @Override
    public void translateControl(JDRPathSegment jDRPathSegment, JDRPoint jDRPoint, double d, double d2) {
        this.path_.translateControl(jDRPathSegment, jDRPoint, d, d2);
    }

    @Override
    public void translateParams(double d, double d2) {
    }

    @Override
    public void scaleParams(Point2D point2D, double d, double d2) {
    }

    @Override
    public void shearParams(Point2D point2D, double d, double d2) {
    }

    @Override
    public void rotateParams(Point2D point2D, double d) {
    }

    @Override
    public boolean showPath() {
        return false;
    }

    @Override
    public boolean hasSymmetricPath() {
        return this.path_.hasSymmetricPath();
    }

    @Override
    public void fade(double d) {
        this.getTextPaint().fade(d);
    }

    @Override
    public JDRSymmetricPath getSymmetricPath() {
        return this.path_.getSymmetricPath();
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "TextPath:" + string;
        string2 = string2 + "Underlying shape: " + this.path_.info();
        return string2;
    }

    @Override
    public String[] getDescriptionInfo() {
        return new String[]{this.getText(), this.getLaTeXText()};
    }

    @Override
    public int getTotalPathSegments() {
        if (this.path_ instanceof JDRCompoundShape) {
            return ((JDRCompoundShape)this.path_).getTotalPathSegments();
        }
        return this.path_.size();
    }

    @Override
    protected void setSelectedElements(int n, int n2, JDRPathSegment jDRPathSegment, JDRPoint jDRPoint) {
        this.path_.setSelectedElements(n, n2, jDRPathSegment, jDRPoint);
    }
}

