/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidHAlignException;
import uk.ac.uea.cmp.nlct.jdr.InvalidTextLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidVAlignException;
import uk.ac.uea.cmp.nlct.jdr.JDRFont;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRText;
import uk.ac.uea.cmp.nlct.jdr.JDRTransform;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFont;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class JDRTextListener
implements JDRObjectLoaderListener {
    @Override
    public char getJDRid(float f) {
        return 'T';
    }

    @Override
    public void writeJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRText jDRText = (JDRText)jDRObject;
        jDRText.getJDRFont().save(dataOutputStream, f);
        jDRText.getTransform().save(dataOutputStream, f);
        dataOutputStream.writeBoolean(true);
        jDRText.getLaTeXFont().save(dataOutputStream, f);
        dataOutputStream.writeByte((byte)jDRText.getHAlign());
        dataOutputStream.writeByte((byte)jDRText.getVAlign());
        String string = jDRText.getLaTeXText();
        if (string.equals(jDRText.getText())) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeChars(string);
        }
        JDRPaint jDRPaint = jDRText.getTextPaint();
        JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
        jDRPaintLoader.saveJDR(jDRPaint, dataOutputStream, f);
        dataOutputStream.writeInt(jDRText.getText().length());
        dataOutputStream.writeChars(jDRText.getText());
    }

    @Override
    public JDRObject readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        int n;
        Object object;
        JDRFont jDRFont = JDRFont.read(dataInputStream, f);
        double[] dArray = JDRTransform.read(dataInputStream, f);
        LaTeXFont laTeXFont = new LaTeXFont();
        String string = null;
        byte by = 0;
        int n2 = 2;
        if (dataInputStream.readBoolean()) {
            laTeXFont = LaTeXFont.read(dataInputStream, f);
            by = dataInputStream.readByte();
            if (by < 0 || by > 2) {
                throw new InvalidHAlignException(by);
            }
            n2 = dataInputStream.readByte();
            if (n2 < 0 || n2 > 3) {
                throw new InvalidVAlignException(n2);
            }
            int n3 = dataInputStream.readInt();
            if (n3 > 0) {
                object = new char[n3];
                for (n = 0; n < n3; ++n) {
                    object[n] = dataInputStream.readChar();
                }
                string = new String((char[])object);
            }
        }
        JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
        object = jDRPaintLoader.loadJDR(dataInputStream, f);
        n = dataInputStream.readInt();
        String string2 = "";
        if (n <= 0) {
            throw new InvalidTextLengthException(n);
        }
        Object object2 = new char[n];
        for (int i = 0; i < n; ++i) {
            object2[i] = dataInputStream.readChar();
        }
        string2 = new String((char[])object2);
        object2 = new JDRTransform(dArray);
        JDRText jDRText = new JDRText((JDRTransform)object2, jDRFont.getFamily(), jDRFont.getWeight(), jDRFont.getShape(), jDRFont.getSize(), string2);
        jDRText.setTextPaint((JDRPaint)object);
        jDRText.setLaTeXFont(laTeXFont);
        jDRText.pgfHalign = by;
        jDRText.pgfValign = n2;
        if (string != null) {
            jDRText.setLaTeXText(string);
        }
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        jDRText.updateBounds(graphics2D);
        graphics2D.dispose();
        return jDRText;
    }

    @Override
    public char getAJRid(float f) {
        return 'T';
    }

    @Override
    public void writeAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRText jDRText = (JDRText)jDRObject;
        jDRText.getJDRFont().saveAJR(printWriter, f);
        jDRText.getTransform().saveAJR(printWriter, f);
        AJR.writeBoolean(printWriter, true);
        jDRText.getLaTeXFont().saveAJR(printWriter, f);
        AJR.writeInt(printWriter, jDRText.getHAlign());
        AJR.writeInt(printWriter, jDRText.getVAlign());
        String string = jDRText.getLaTeXText();
        if (string.equals(jDRText.getText())) {
            AJR.writeInt(printWriter, 0);
        } else {
            AJR.writeInt(printWriter, string.length());
            printWriter.println(string);
        }
        JDRPaint jDRPaint = jDRText.getTextPaint();
        JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
        jDRPaintLoader.saveAJR(jDRPaint, printWriter, f);
        AJR.writeInt(printWriter, jDRText.getText().length());
        printWriter.println(jDRText.getText());
    }

    @Override
    public JDRObject readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        JDRFont jDRFont = JDRFont.readAJR(bufferedReader, f);
        double[] dArray = JDRTransform.readAJR(bufferedReader, f);
        LaTeXFont laTeXFont = new LaTeXFont();
        String string = null;
        int n = 0;
        int n2 = 2;
        if (AJR.readBoolean(bufferedReader)) {
            laTeXFont = LaTeXFont.readAJR(bufferedReader, f);
            n = AJR.readInt(bufferedReader);
            if (n < 0 || n > 2) {
                throw new InvalidHAlignException(n);
            }
            n2 = AJR.readInt(bufferedReader);
            if (n2 < 0 || n2 > 3) {
                throw new InvalidVAlignException(n2);
            }
            int n3 = AJR.readInt(bufferedReader);
            if (n3 > 0) {
                string = AJR.readString(bufferedReader, n3);
            }
        }
        JDRPaintLoader jDRPaintLoader = AJR.getPaintLoader();
        JDRPaint jDRPaint = jDRPaintLoader.loadAJR(bufferedReader, f);
        int n4 = AJR.readInt(bufferedReader);
        String string2 = "";
        if (n4 <= 0) {
            throw new InvalidTextLengthException(n4);
        }
        string2 = AJR.readString(bufferedReader, n4);
        JDRTransform jDRTransform = new JDRTransform(dArray);
        JDRText jDRText = new JDRText(jDRTransform, jDRFont.getFamily(), jDRFont.getWeight(), jDRFont.getShape(), jDRFont.getSize(), string2);
        jDRText.setTextPaint(jDRPaint);
        jDRText.setLaTeXFont(laTeXFont);
        jDRText.pgfHalign = n;
        jDRText.pgfValign = n2;
        if (string != null) {
            jDRText.setLaTeXText(string);
        }
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        jDRText.updateBounds(graphics2D);
        graphics2D.dispose();
        return jDRText;
    }
}

