/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.EmptyGroupException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontShapeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontSizeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontWeightException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidHAlignException;
import uk.ac.uea.cmp.nlct.jdr.InvalidVAlignException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRFont;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRShading;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPath;
import uk.ac.uea.cmp.nlct.jdr.JDRTextListener;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.JDRTransform;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFont;
import uk.ac.uea.cmp.nlct.jdr.MissingMoveException;

public class JDRText
extends JDRCompleteObject
implements JDRTextual {
    private String text;
    protected JDRFont jdrFont = new JDRFont();
    protected Font font;
    private JDRTransform jdrtransform;
    public LaTeXFont latexFont = new LaTeXFont();
    public String latexText;
    protected int pgfValign;
    protected int pgfHalign;
    public static final int PGF_HALIGN_LEFT = 0;
    public static final int PGF_HALIGN_CENTRE = 1;
    public static final int PGF_HALIGN_RIGHT = 2;
    public static final int PGF_VALIGN_TOP = 0;
    public static final int PGF_VALIGN_CENTRE = 1;
    public static final int PGF_VALIGN_BASE = 2;
    public static final int PGF_VALIGN_BOTTOM = 3;
    private static JDRTextListener textListener = new JDRTextListener();
    private JDRPaint textPaint;

    public JDRText() {
        try {
            this.init("SansSerif", 0, 0, 10);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    public JDRText(Point2D point2D) {
        try {
            this.init("SansSerif", 0, 0, 10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public JDRText(Graphics graphics, Point2D point2D, String string) {
        try {
            this.init(graphics, "SansSerif", 0, 0, 10, string);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public JDRText(Graphics graphics, String string) {
        try {
            this.init(graphics, "SansSerif", 0, 0, 10, string);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    public JDRText(Graphics graphics, String string, int n, int n2, int n3, String string2) throws InvalidFontWeightException, InvalidFontShapeException, InvalidFontSizeException {
        this.init(graphics, string, n, n2, n3, string2);
        this.setPosition(0.0, 0.0);
    }

    public JDRText(Graphics graphics, Font font, String string) {
        String string2 = font.getName();
        int n = font.isBold() ? 1 : 0;
        int n2 = font.isItalic() ? 1 : 0;
        int n3 = font.getSize();
        try {
            this.init(graphics, string2, n, n2, n3, string);
        }
        catch (InvalidFontShapeException invalidFontShapeException) {
        }
        catch (InvalidFontWeightException invalidFontWeightException) {
        }
        catch (InvalidFontSizeException invalidFontSizeException) {
            // empty catch block
        }
        this.setPosition(0.0, 0.0);
    }

    public JDRText(Graphics graphics, Point2D point2D, String string, int n, int n2, int n3, String string2) throws InvalidFontWeightException, InvalidFontShapeException, InvalidFontSizeException {
        this.init(graphics, string, n, n2, n3, string2);
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public JDRText(JDRTransform jDRTransform, String string, int n, int n2, int n3, String string2) throws InvalidFontWeightException, InvalidFontShapeException, InvalidFontSizeException {
        this.jdrtransform = (JDRTransform)jDRTransform.clone();
        this.init(string, n, n2, n3, string2);
        this.setFont(string, n, n2, n3);
    }

    private void init(String string, int n, int n2, int n3) throws InvalidFontWeightException, InvalidFontShapeException, InvalidFontSizeException {
        this.jdrtransform = new JDRTransform();
        this.init(string, n, n2, n3, "");
        this.setFont(string, n, n2, n3);
    }

    private void init(Graphics graphics, String string, int n, int n2, int n3, String string2) throws InvalidFontWeightException, InvalidFontShapeException, InvalidFontSizeException {
        this.jdrtransform = new JDRTransform();
        this.init(string, n, n2, n3, string2);
        this.setFont((Graphics2D)graphics, string, n, n2, n3);
    }

    private void init(String string, int n, int n2, int n3, String string2) {
        this.text = string2.replaceAll("[\t\r\n]", " ");
        this.latexFont = new LaTeXFont();
        this.latexText = this.text;
        this.pgfValign = 2;
        this.pgfHalign = 0;
        try {
            this.setTextPaint(new JDRColor(0.0, 0.0, 0.0));
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    @Override
    public void setTextPaint(JDRPaint jDRPaint) {
        this.textPaint = jDRPaint;
    }

    @Override
    public JDRPaint getTextPaint() {
        return this.textPaint;
    }

    @Override
    public void fade(double d) {
        this.textPaint.fade(d);
    }

    @Override
    public void reset() {
        this.jdrtransform.reset();
    }

    public double getWidth(Graphics graphics) {
        this.updateBounds(graphics);
        return this.getBBox().getWidth();
    }

    @Override
    public void updateBounds(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.text.equals("")) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
            double d = fontMetrics.getHeight();
            double d2 = fontMetrics.getDescent();
            this.jdrtransform.updateOriginalBounds(new BBox(0.0, d2 - d, 0.0, d2));
        } else {
            String string = this.text;
            if (string.startsWith(" ")) {
                string = "_" + string.substring(1);
            }
            if (string.endsWith(" ")) {
                string = string.substring(0, string.length() - 1) + "_";
            }
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            TextLayout textLayout = new TextLayout(string, this.font, fontRenderContext);
            this.jdrtransform.updateOriginalBounds(textLayout.getBounds());
        }
    }

    @Override
    public void setFont(Graphics graphics, String string, int n, int n2, int n3) throws InvalidFontWeightException, InvalidFontShapeException, InvalidFontSizeException {
        this.setFont(string, n, n2, n3);
        this.updateBounds(graphics);
    }

    private void setFont(String string, int n, int n2, int n3) throws InvalidFontWeightException, InvalidFontShapeException, InvalidFontSizeException {
        this.jdrFont.setFamily(string);
        this.jdrFont.setWeight(n);
        this.jdrFont.setShape(n2);
        this.jdrFont.setSize(n3);
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
    }

    @Override
    public void setFontFamily(Graphics graphics, String string) {
        this.jdrFont.setFamily(string);
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
        this.updateBounds(graphics);
    }

    @Override
    public void setFontSeries(Graphics graphics, int n) throws InvalidFontWeightException {
        this.jdrFont.setWeight(n);
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
        this.updateBounds(graphics);
    }

    @Override
    public void setFontShape(Graphics graphics, int n) throws InvalidFontShapeException {
        this.jdrFont.setShape(n);
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
        this.updateBounds(graphics);
    }

    @Override
    public void setFontSize(Graphics graphics, int n) throws InvalidFontSizeException {
        this.jdrFont.setSize(n);
        this.font = new Font(this.jdrFont.getFamily(), this.getFontWeight(), this.jdrFont.getSize());
        this.updateBounds(graphics);
    }

    @Override
    public String getFontFamily() {
        return this.jdrFont.getFamily();
    }

    @Override
    public int getFontSeries() {
        return this.jdrFont.getWeight();
    }

    @Override
    public int getFontShape() {
        return this.jdrFont.getShape();
    }

    private int getFontWeight() {
        int n = 0;
        n += this.getFontSeries() == 0 ? 0 : 1;
        return n += this.getFontShape() == 0 ? 0 : 2;
    }

    @Override
    public int getFontSize() {
        return this.jdrFont.getSize();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public JDRFont getJDRFont() {
        return this.jdrFont;
    }

    @Override
    public JDRGroup split(Graphics2D graphics2D) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        BBox bBox = this.getBBox();
        JDRGroup jDRGroup = new JDRGroup();
        int n = this.text.length();
        for (int i = 0; i < n; ++i) {
            char c = this.text.charAt(i);
            if (c == ' ') continue;
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.text, 0, i + 1, (Graphics)graphics2D);
            int n2 = fontMetrics.charWidth(c);
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getWidth() - (double)n2, 0.0);
            JDRText jDRText = new JDRText((Graphics)graphics2D, double_, "" + c);
            jDRText.setTextPaint(this.getTextPaint());
            jDRText.jdrFont.makeEqual(this.jdrFont);
            jDRText.font = this.getFont();
            jDRText.latexFont.makeEqual(this.latexFont);
            jDRText.pgfValign = this.pgfValign;
            jDRText.pgfHalign = this.pgfHalign;
            jDRText.transform(this.jdrtransform);
            jDRText.updateBounds(graphics2D);
            jDRGroup.add(jDRText);
        }
        jDRGroup.setSelected(this.isSelected());
        return jDRGroup;
    }

    public Shape getOutline(FontRenderContext fontRenderContext) {
        TextLayout textLayout = new TextLayout(this.text, this.font, fontRenderContext);
        return textLayout.getOutline(this.jdrtransform.getAffineTransform());
    }

    public JDRGroup convertToPath(Graphics2D graphics2D) throws MissingMoveException, EmptyGroupException {
        return this.convertToPath(graphics2D, new JDRBasicStroke());
    }

    public JDRGroup convertToPath(Graphics2D graphics2D, JDRStroke jDRStroke) throws MissingMoveException, EmptyGroupException {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        BBox bBox = this.getBBox();
        JDRGroup jDRGroup = new JDRGroup();
        int n = this.text.length();
        JDRPaint jDRPaint = this.getTextPaint();
        for (int i = 0; i < n; ++i) {
            char c = this.text.charAt(i);
            if (c == ' ') continue;
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.text, 0, i + 1, (Graphics)graphics2D);
            int n2 = fontMetrics.charWidth(c);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(rectangle2D.getWidth() - (double)n2, 0.0);
            TextLayout textLayout = new TextLayout("" + c, this.font, fontRenderContext);
            Shape shape = textLayout.getOutline(affineTransform);
            PathIterator pathIterator = shape.getPathIterator(null);
            JDRPath jDRPath = null;
            double[] dArray = new double[6];
            double d = 0.0;
            double d2 = 0.0;
            boolean bl = true;
            while (!pathIterator.isDone()) {
                int n3 = pathIterator.currentSegment(dArray);
                switch (n3) {
                    case 0: {
                        if (bl) {
                            bl = false;
                            d = dArray[0];
                            d2 = dArray[1];
                            jDRPath = new JDRPath(new JDRTransparent(), jDRPaint, (JDRStroke)jDRStroke.clone());
                            break;
                        }
                        JDRSegment jDRSegment = new JDRSegment(d, d2, dArray[0], dArray[1]);
                        d = dArray[0];
                        d2 = dArray[1];
                        if (jDRPath == null) {
                            throw new MissingMoveException();
                        }
                        jDRPath.add(jDRSegment);
                        break;
                    }
                    case 1: {
                        JDRSegment jDRSegment = new JDRLine(d, d2, dArray[0], dArray[1]);
                        d = dArray[0];
                        d2 = dArray[1];
                        jDRPath.add(jDRSegment);
                        if (jDRPath != null) break;
                        throw new MissingMoveException();
                    }
                    case 2: {
                        JDRBezier jDRBezier = JDRBezier.quadToCubic(d, d2, dArray[0], dArray[1], dArray[2], dArray[3]);
                        d = dArray[2];
                        d2 = dArray[3];
                        jDRPath.add(jDRBezier);
                        if (jDRPath != null) break;
                        throw new MissingMoveException();
                    }
                    case 3: {
                        JDRBezier jDRBezier = new JDRBezier(d, d2, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                        d = dArray[4];
                        d2 = dArray[5];
                        jDRPath.add(jDRBezier);
                        if (jDRPath != null) break;
                        throw new MissingMoveException();
                    }
                }
                pathIterator.next();
            }
            if (jDRPath == null) continue;
            jDRGroup.add(jDRPath);
        }
        if (jDRGroup.size() == 0) {
            throw new EmptyGroupException();
        }
        jDRGroup.setSelected(this.isSelected());
        this.jdrtransform.transform(jDRGroup);
        return jDRGroup;
    }

    public void preConcatenate(AffineTransform affineTransform) {
        this.jdrtransform.preConcatenate(affineTransform);
    }

    @Override
    public void transform(double[] dArray) {
        this.jdrtransform.concat(dArray);
    }

    public void transform(JDRTransform jDRTransform) {
        this.jdrtransform.concat(jDRTransform);
    }

    public void transform(AffineTransform affineTransform) {
        this.jdrtransform.concat(affineTransform);
    }

    @Override
    public void rotate(double d) {
        this.jdrtransform.rotate(d);
    }

    @Override
    public void rotate(Point2D point2D, double d) {
        this.jdrtransform.rotate(point2D, d);
    }

    @Override
    public void scaleX(double d) {
        this.scale(d, 1.0);
    }

    @Override
    public void scaleX(Point2D point2D, double d) {
        this.scale(point2D, d, 1.0);
    }

    @Override
    public void scaleY(double d) {
        this.scale(1.0, d);
    }

    @Override
    public void scaleY(Point2D point2D, double d) {
        this.scale(point2D, 1.0, d);
    }

    @Override
    public void scale(double d, double d2) {
        this.jdrtransform.scale(d, d2);
    }

    @Override
    public void scale(Point2D point2D, double d, double d2) {
        this.jdrtransform.scale(point2D, d, d2);
    }

    @Override
    public void shearX(double d) {
        this.shear(d, 0.0);
    }

    @Override
    public void shearX(Point2D point2D, double d) {
        this.shear(point2D, d, 0.0);
    }

    @Override
    public void shearY(double d) {
        this.shear(0.0, d);
    }

    @Override
    public void shearY(Point2D point2D, double d) {
        this.shear(point2D, 0.0, d);
    }

    @Override
    public void shear(Point2D point2D, double d) {
        this.shear(point2D, d, d);
    }

    @Override
    public void shear(double d) {
        this.shear(d, d);
    }

    @Override
    public void shear(double d, double d2) {
        this.jdrtransform.shear(d, d2);
    }

    @Override
    public void shear(Point2D point2D, double d, double d2) {
        this.jdrtransform.shear(point2D, d, d2);
    }

    @Override
    public void translate(double d, double d2) {
        this.jdrtransform.translate(d, d2);
    }

    public void setPosition(double d, double d2) {
        this.jdrtransform.setPosition(d, d2);
    }

    @Override
    public BBox getBBox() {
        return this.jdrtransform.getBBox();
    }

    public JDRPoint getStart() {
        return this.jdrtransform.getAnchor();
    }

    public JDRPoint getCentre() {
        return this.jdrtransform.getCentre();
    }

    @Override
    public void setText(Graphics graphics, String string) {
        this.latexText = this.text = string.replaceAll("[\t\r\n]", " ");
        this.updateBounds(graphics);
    }

    @Override
    public void setText(Graphics graphics, String string, String string2) {
        this.setText(string, string2);
        this.updateBounds(graphics);
    }

    public void setText(String string, String string2) {
        this.text = string.replaceAll("[\t\r\n]", " ");
        this.latexText = string2 == null ? this.text : string2.replaceAll("[\t\r\n]", " ");
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setLaTeXText(String string) {
        this.latexText = string.replaceAll("[\t\r\n]", " ");
    }

    @Override
    public String getLaTeXText() {
        return this.latexText;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.text, this.font, fontRenderContext);
        AffineTransform affineTransform = this.jdrtransform.getAffineTransform();
        Shape shape = textLayout.getOutline(affineTransform);
        BBox bBox = null;
        if (this.getTextPaint() instanceof JDRShading) {
            Rectangle rectangle = shape.getBounds();
            bBox = new BBox(rectangle);
        }
        graphics2D.setPaint(this.getTextPaint().getPaint(bBox));
        graphics2D.fill(shape);
    }

    public void drawWithAnchors(Graphics graphics, Paint paint) {
        Cloneable cloneable;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = this.jdrtransform.getAffineTransform();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        graphics2D.setTransform(new AffineTransform());
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.text, this.font, fontRenderContext);
        affineTransform.preConcatenate(affineTransform2);
        graphics2D.setTransform(affineTransform);
        if (this.getTextPaint() instanceof JDRShading) {
            cloneable = textLayout.getBounds();
            BBox bBox = new BBox((Rectangle2D)cloneable);
            graphics2D.setPaint(this.getTextPaint().getPaint(bBox));
        } else {
            graphics2D.setPaint(this.getTextPaint().getColor());
        }
        textLayout.draw(graphics2D, 0.0f, 0.0f);
        graphics2D.setPaint(paint);
        cloneable = this.getPGFAnchor();
        double d = 1.0;
        graphics2D.fill(new Ellipse2D.Double(((Point2D)cloneable).getX() - d, ((Point2D)cloneable).getY() - d, 2.0 * d, 2.0 * d));
        graphics2D.setTransform(affineTransform2);
    }

    public void fill(Graphics graphics) {
    }

    @Override
    public Object clone() {
        JDRText jDRText = null;
        try {
            jDRText = new JDRText(this.jdrtransform, this.getFontFamily(), this.getFontSeries(), this.getFontShape(), this.getFontSize(), this.text);
            jDRText.makeEqual(this);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return jDRText;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof JDRText)) {
            return false;
        }
        JDRText jDRText = (JDRText)object;
        if (!this.getTextPaint().equals(jDRText.getTextPaint())) {
            return false;
        }
        if (!this.jdrFont.equals(jDRText.jdrFont)) {
            return false;
        }
        if (!this.text.equals(jDRText.getText())) {
            return false;
        }
        if (this.latexText == null || jDRText.latexText == null ? this.latexText != jDRText.latexText : !this.latexText.equals(jDRText.latexText)) {
            return false;
        }
        if (!this.jdrtransform.equals(jDRText.jdrtransform)) {
            return false;
        }
        if (!this.latexFont.equals(jDRText.latexFont)) {
            return false;
        }
        if (this.pgfValign != jDRText.pgfValign) {
            return false;
        }
        return this.pgfHalign == jDRText.pgfHalign;
    }

    public void makeEqual(JDRText jDRText) {
        super.makeEqual(jDRText);
        this.setTextPaint((JDRPaint)jDRText.getTextPaint().clone());
        this.text = jDRText.getText();
        this.jdrFont.makeEqual(jDRText.jdrFont);
        this.font = jDRText.getFont();
        this.jdrtransform.makeEqual(jDRText.getTransform());
        this.latexFont.makeEqual(jDRText.latexFont);
        this.pgfValign = jDRText.pgfValign;
        this.pgfHalign = jDRText.pgfHalign;
        this.latexText = jDRText.latexText;
    }

    public JDRTransform getTransform() {
        return this.jdrtransform;
    }

    @Override
    public double[] getTransformation(double[] dArray) {
        if (dArray == null) {
            dArray = new double[6];
        }
        this.jdrtransform.getTransformation(dArray);
        return dArray;
    }

    @Override
    public void setTransformation(double[] dArray) {
        this.jdrtransform.setTransformation(dArray);
    }

    @Override
    public void setLaTeXFamily(String string) {
        this.latexFont.setFamily(string);
    }

    @Override
    public void setLaTeXSize(String string) {
        this.latexFont.setSize(string);
    }

    @Override
    public void setLaTeXSeries(String string) {
        this.latexFont.setWeight(string);
    }

    @Override
    public void setLaTeXShape(String string) {
        this.latexFont.setShape(string);
    }

    @Override
    public void setLaTeXFont(String string, String string2, String string3, String string4) {
        this.latexFont.setFamily(string);
        this.latexFont.setSize(string2);
        this.latexFont.setWeight(string3);
        this.latexFont.setShape(string4);
    }

    @Override
    public void setLaTeXFont(LaTeXFont laTeXFont) {
        this.latexFont = laTeXFont;
    }

    @Override
    public void setVAlign(int n) throws InvalidVAlignException {
        if (n < 0 || n > 3) {
            throw new InvalidVAlignException(n);
        }
        this.pgfValign = n;
    }

    @Override
    public void setHAlign(int n) throws InvalidHAlignException {
        if (n < 0 || n > 2) {
            throw new InvalidHAlignException(n);
        }
        this.pgfHalign = n;
    }

    @Override
    public void setAlign(int n, int n2) throws InvalidHAlignException, InvalidVAlignException {
        this.setHAlign(n);
        this.setVAlign(n2);
    }

    @Override
    public int getHAlign() {
        return this.pgfHalign;
    }

    @Override
    public int getVAlign() {
        return this.pgfValign;
    }

    @Override
    public String getLaTeXFamily() {
        return this.latexFont.getFamily();
    }

    @Override
    public String getLaTeXSeries() {
        return this.latexFont.getWeight();
    }

    @Override
    public String getLaTeXShape() {
        return this.latexFont.getShape();
    }

    @Override
    public String getLaTeXSize() {
        return this.latexFont.getSize();
    }

    public LaTeXFont getLaTeXFont() {
        return this.latexFont;
    }

    private Point2D getPGFAnchor() {
        double d = 0.0;
        double d2 = 0.0;
        BBox bBox = this.jdrtransform.getOriginalBBox();
        switch (this.pgfValign) {
            case 0: {
                d2 = bBox.getMinY();
                break;
            }
            case 1: {
                d2 = bBox.getMidY();
                break;
            }
            case 2: {
                d2 = 0.0;
                break;
            }
            case 3: {
                d2 = bBox.getMaxY();
            }
        }
        switch (this.pgfHalign) {
            case 0: {
                d = 0.0;
                break;
            }
            case 1: {
                d = bBox.getMidX();
                break;
            }
            case 2: {
                d = bBox.getMinX() + bBox.getMaxX();
            }
        }
        return new Point2D.Double(d, d2);
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        JDRPaint jDRPaint;
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        String string3 = "";
        double d = 0.0;
        double d2 = 0.0;
        BBox bBox = this.jdrtransform.getOriginalBBox();
        switch (this.pgfValign) {
            case 0: {
                string2 = "top";
                d2 = bBox.getMaxY() - bBox.getMinY();
                break;
            }
            case 1: {
                string2 = "center";
                d2 = bBox.getMidY() - bBox.getMinY();
                break;
            }
            case 2: {
                string2 = "base";
                d2 = bBox.getMaxY();
                break;
            }
            case 3: {
                string2 = "bottom";
                d2 = 0.0;
            }
        }
        switch (this.pgfHalign) {
            case 0: {
                string3 = "left";
                d = 0.0;
                break;
            }
            case 1: {
                string3 = "center";
                d = bBox.getMidX();
                break;
            }
            case 2: {
                string3 = "right";
                d = bBox.getMinX() + bBox.getMaxX();
            }
        }
        String string4 = "";
        if (!this.description.equals("")) {
            string4 = string4 + "% " + this.description + string;
        }
        string4 = (jDRPaint = this.getTextPaint()) instanceof JDRTransparent ? string4 + "\\pgftext[" + string3 + "," + string2 + "]{" + this.latexFont.tex() + string + "\\phantom{" + this.latexText + "}}" : string4 + "\\pgftext[" + string3 + "," + string2 + "]{" + this.latexFont.tex() + string + jDRPaint.pgf(bBox) + this.latexText + "}";
        return this.jdrtransform.pgf(affineTransform, d, d2, string4);
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        JDRPaint jDRPaint = this.getTextPaint();
        if (jDRPaint instanceof JDRTransparent) {
            return;
        }
        printWriter.println("gsave");
        String string = this.getFont().getPSName();
        if (string.equals("SansSerif.plain")) {
            string = "Helvetica";
        } else if (string.equals("SansSerif.bold")) {
            string = "Helvetica-Bold";
        } else if (string.equals("SansSerif.italic")) {
            string = "Helvetica-Oblique";
        } else if (string.equals("SansSerif.bolditalic")) {
            string = "Helvetica-BoldOblique";
        } else if (string.equals("Serif.plain")) {
            string = "Times-Roman";
        } else if (string.equals("Serif.bold")) {
            string = "Times-Bold";
        } else if (string.equals("Serif.italic")) {
            string = "Times-Italic";
        } else if (string.equals("Serif.bolditalic")) {
            string = "Times-BoldItalic";
        } else if (string.equals("Monospaced.plain")) {
            string = "Courier";
        } else if (string.equals("Monospaced.bold")) {
            string = "Courier-Bold";
        } else if (string.equals("Monospaced.italic")) {
            string = "Courier-Oblique";
        } else if (string.equals("Monospaced.bolditalic")) {
            string = "Courier-BoldOblique";
        }
        printWriter.println("/" + string + " findfont");
        printWriter.println("" + this.jdrFont.getSize() + " scalefont");
        printWriter.println("setfont");
        this.jdrtransform.saveEPS(printWriter);
        printWriter.println("0 0 moveto");
        String string2 = "";
        char[] cArray = this.text.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            string2 = cArray[i] == '\\' ? string2 + "\\\\" : (cArray[i] == '(' ? string2 + "\\(" : (cArray[i] == ')' ? string2 + "\\)" : string2 + cArray[i]));
        }
        printWriter.println("(" + string2 + ")");
        if (jDRPaint instanceof JDRGradient || jDRPaint instanceof JDRRadial) {
            printWriter.println("true charpath");
            BBox bBox = this.jdrtransform.getOriginalBBox();
            double d = -bBox.getMaxY();
            double d2 = -bBox.getMinY();
            double d3 = bBox.getMinX();
            double d4 = bBox.getMaxX();
            bBox.reset(d3, d, d4, d2);
            jDRPaint.saveEPS(printWriter, bBox);
            printWriter.println("clip shfill");
        } else {
            jDRPaint.saveEPS(printWriter, null);
            printWriter.println("show");
        }
        printWriter.println("grestore");
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        printWriter.println("   <text x=\"0\" y=\"0\" ");
        printWriter.println("   " + this.getTextPaint().svgFill());
        printWriter.println("       " + this.jdrFont.svg() + " " + this.jdrtransform.svg() + ">");
        printWriter.println(this.text);
        printWriter.println("   </text>");
    }

    public String toString() {
        return "JDRText:" + this.text + "@" + this.jdrtransform;
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return textListener;
    }

    public void escapeTeXChars() {
        boolean bl = false;
        String string = "";
        int n = this.text.length();
        block12: for (int i = 0; i < n; ++i) {
            char c = this.text.charAt(i);
            switch (c) {
                case '\\': {
                    string = string + "\\textbackslash ";
                    bl = true;
                    continue block12;
                }
                case '^': {
                    string = string + "\\textasciicirum ";
                    bl = true;
                    continue block12;
                }
                case '~': {
                    string = string + "\\textasciitilde ";
                    bl = true;
                    continue block12;
                }
                case '$': {
                    string = string + "\\$";
                    bl = true;
                    continue block12;
                }
                case '&': {
                    string = string + "\\&";
                    bl = true;
                    continue block12;
                }
                case '#': {
                    string = string + "\\#";
                    bl = true;
                    continue block12;
                }
                case '%': {
                    string = string + "\\%";
                    bl = true;
                    continue block12;
                }
                case '_': {
                    string = string + "\\_";
                    bl = true;
                    continue block12;
                }
                case '{': {
                    string = string + "\\{";
                    bl = true;
                    continue block12;
                }
                case '}': {
                    string = string + "\\}";
                    bl = true;
                    continue block12;
                }
                default: {
                    string = string + c;
                }
            }
        }
        if (bl) {
            this.latexText = string;
        }
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "Text:" + string;
        string2 = string2 + "contents: " + this.text + string;
        string2 = string2 + "LaTeX equivalent: " + this.latexText + string;
        string2 = string2 + "Paint: " + this.getTextPaint() + string;
        string2 = string2 + "font: " + this.jdrFont.info() + string;
        string2 = string2 + "LaTeX font: " + this.latexFont.info() + string;
        string2 = string2 + "start: " + this.getStart() + string;
        string2 = string2 + "pgfHalign: " + this.pgfHalign + string;
        string2 = string2 + "pgfValign: " + this.pgfValign + string;
        string2 = string2 + "pgfanchor: " + this.getPGFAnchor() + string;
        string2 = string2 + "transformation: " + this.jdrtransform.info() + string;
        string2 = string2 + "original bounds: " + this.jdrtransform.getOriginalBBox().info() + string;
        return string2 + super.info();
    }

    @Override
    public JDRTextual getTextual() {
        return this;
    }

    @Override
    public boolean hasTextual() {
        return true;
    }

    @Override
    public boolean hasShape() {
        return false;
    }

    @Override
    public boolean hasSymmetricPath() {
        return false;
    }

    @Override
    public JDRSymmetricPath getSymmetricPath() {
        return null;
    }

    @Override
    public boolean hasPattern() {
        return false;
    }

    @Override
    public JDRPattern getPattern() {
        return null;
    }

    @Override
    public String[] getDescriptionInfo() {
        return new String[]{this.getText(), this.latexText};
    }
}

