/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRSegmentLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPath;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class JDRSymmetricPathListener
extends JDRPathListener {
    @Override
    public char getJDRid(float f) {
        return (double)f < 1.6 ? (char)'G' : 'S';
    }

    @Override
    public char getAJRid(float f) {
        return (double)f < 1.6 ? (char)'G' : 'S';
    }

    @Override
    public void writeJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRSymmetricPath jDRSymmetricPath = (JDRSymmetricPath)jDRObject;
        JDRObjectLoader jDRObjectLoader = JDR.getObjectLoader();
        if ((double)f < 1.6) {
            JDRGroup jDRGroup = jDRSymmetricPath.separate(null);
            JDRObjectLoaderListener jDRObjectLoaderListener = jDRGroup.getListener();
            jDRObjectLoaderListener.writeJDR(jDRGroup, dataOutputStream, f);
        } else {
            jDRObjectLoader.saveJDR(jDRSymmetricPath.getUnderlyingShape(), dataOutputStream, f);
            dataOutputStream.writeBoolean(jDRSymmetricPath.isAnchored());
            JDRSegmentLoader jDRSegmentLoader = JDR.getSegmentLoader();
            if (!jDRSymmetricPath.isAnchored()) {
                jDRSegmentLoader.saveJDR(jDRSymmetricPath.getJoin(), dataOutputStream, f);
            }
            JDRLine jDRLine = jDRSymmetricPath.getSymmetry();
            dataOutputStream.writeDouble(jDRLine.start.x);
            dataOutputStream.writeDouble(jDRLine.start.y);
            dataOutputStream.writeDouble(jDRLine.end.x);
            dataOutputStream.writeDouble(jDRLine.end.y);
            dataOutputStream.writeBoolean(jDRSymmetricPath.isClosed());
            if (jDRSymmetricPath.isClosed()) {
                JDRPartialSegment jDRPartialSegment = jDRSymmetricPath.getClosingSegment();
                dataOutputStream.writeBoolean(jDRPartialSegment == null);
                if (jDRPartialSegment != null) {
                    jDRSegmentLoader.saveJDR(jDRPartialSegment, dataOutputStream, f);
                }
            }
        }
    }

    @Override
    public JDRObject readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        JDRObjectLoader jDRObjectLoader = JDR.getObjectLoader();
        JDRObject jDRObject = jDRObjectLoader.loadJDR(dataInputStream, f);
        if (!(jDRObject instanceof JDRShape)) {
            throw new InvalidFormatException("Shape specs expected for underlying symmetric path object.");
        }
        JDRSymmetricPath jDRSymmetricPath = new JDRSymmetricPath((JDRShape)jDRObject);
        boolean bl = dataInputStream.readBoolean();
        JDRPartialSegment jDRPartialSegment = null;
        JDRSegmentLoader jDRSegmentLoader = JDR.getSegmentLoader();
        if (!bl) {
            jDRPartialSegment = (JDRPartialSegment)jDRSegmentLoader.loadJDR(dataInputStream, f);
        }
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        double d3 = dataInputStream.readDouble();
        double d4 = dataInputStream.readDouble();
        jDRSymmetricPath.setSymmetry(d, d2, d3, d4);
        jDRSymmetricPath.setJoin(jDRPartialSegment);
        boolean bl2 = dataInputStream.readBoolean();
        if (bl2) {
            boolean bl3 = dataInputStream.readBoolean();
            if (!bl3) {
                JDRPartialSegment jDRPartialSegment2 = (JDRPartialSegment)jDRSegmentLoader.loadJDR(dataInputStream, f);
                jDRSymmetricPath.close(jDRPartialSegment2);
            } else {
                jDRSymmetricPath.close();
            }
        }
        return jDRSymmetricPath;
    }

    @Override
    public void writeAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRSymmetricPath jDRSymmetricPath = (JDRSymmetricPath)jDRObject;
        JDRObjectLoader jDRObjectLoader = AJR.getObjectLoader();
        if ((double)f < 1.6) {
            JDRGroup jDRGroup = jDRSymmetricPath.separate(null);
            JDRObjectLoaderListener jDRObjectLoaderListener = jDRGroup.getListener();
            jDRObjectLoaderListener.writeAJR(jDRGroup, printWriter, f);
        } else {
            jDRObjectLoader.saveAJR(jDRSymmetricPath.getUnderlyingShape(), printWriter, f);
            AJR.writeBoolean(printWriter, jDRSymmetricPath.isAnchored());
            JDRSegmentLoader jDRSegmentLoader = AJR.getSegmentLoader();
            if (!jDRSymmetricPath.isAnchored()) {
                jDRSegmentLoader.saveAJR(jDRSymmetricPath.getJoin(), printWriter, f);
            }
            JDRLine jDRLine = jDRSymmetricPath.getSymmetry();
            AJR.writeDouble(printWriter, jDRLine.start.x);
            AJR.writeDouble(printWriter, jDRLine.start.y);
            AJR.writeDouble(printWriter, jDRLine.end.x);
            AJR.writeDouble(printWriter, jDRLine.end.y);
            AJR.writeBoolean(printWriter, jDRSymmetricPath.isClosed());
            if (jDRSymmetricPath.isClosed()) {
                JDRPartialSegment jDRPartialSegment = jDRSymmetricPath.getClosingSegment();
                AJR.writeBoolean(printWriter, jDRPartialSegment == null);
                if (jDRPartialSegment != null) {
                    jDRSegmentLoader.saveAJR(jDRPartialSegment, printWriter, f);
                }
            }
            printWriter.println();
        }
    }

    @Override
    public JDRObject readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        JDRObjectLoader jDRObjectLoader = AJR.getObjectLoader();
        JDRObject jDRObject = jDRObjectLoader.loadAJR(bufferedReader, f);
        if (!(jDRObject instanceof JDRShape)) {
            throw new InvalidFormatException("Shape specs expected for underlying text path object", AJR.getLineNum());
        }
        JDRSymmetricPath jDRSymmetricPath = new JDRSymmetricPath((JDRShape)jDRObject);
        boolean bl = AJR.readBoolean(bufferedReader);
        JDRPartialSegment jDRPartialSegment = null;
        JDRSegmentLoader jDRSegmentLoader = AJR.getSegmentLoader();
        if (!bl) {
            jDRPartialSegment = (JDRPartialSegment)jDRSegmentLoader.loadAJR(bufferedReader, f);
        }
        double d = AJR.readDouble(bufferedReader);
        double d2 = AJR.readDouble(bufferedReader);
        double d3 = AJR.readDouble(bufferedReader);
        double d4 = AJR.readDouble(bufferedReader);
        jDRSymmetricPath.setSymmetry(d, d2, d3, d4);
        jDRSymmetricPath.setJoin(jDRPartialSegment);
        boolean bl2 = AJR.readBoolean(bufferedReader);
        if (bl2) {
            boolean bl3 = AJR.readBoolean(bufferedReader);
            if (!bl3) {
                JDRPartialSegment jDRPartialSegment2 = (JDRPartialSegment)jDRSegmentLoader.loadAJR(bufferedReader, f);
                jDRSymmetricPath.close(jDRPartialSegment2);
            } else {
                jDRSymmetricPath.close();
            }
        }
        return jDRSymmetricPath;
    }
}

