/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.EmptyPathException;
import uk.ac.uea.cmp.nlct.jdr.FlowFrame;
import uk.ac.uea.cmp.nlct.jdr.IllFittingPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRCompoundShape;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialLine;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPathIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPointIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPathIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetryLinePoint;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPath;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class JDRSymmetricPath
extends JDRCompoundShape {
    private boolean markerSymmetry = true;
    private boolean closed = false;
    private JDRShape path_;
    private JDRPartialSegment join;
    private JDRLine line_;
    private JDRPartialSegment closingSegment = null;
    private static JDRPathListener symmetricPathListener = new JDRSymmetricPathListener();
    protected JDRSymmetricPathIterator iterator;
    protected JDRPointIterator pointIterator;

    public JDRSymmetricPath(JDRShape jDRShape, boolean bl, JDRLine jDRLine) {
        this.path_ = jDRShape;
        this.selected = this.path_.isSelected();
        this.setSymmetry(jDRLine);
        this.join = bl ? null : new JDRPartialSegment(this.path_.getLastControl(), this.line_);
        this.initIterators();
        if (this.path_.isClosed()) {
            this.path_.open(false);
            try {
                this.close(2);
            }
            catch (EmptyPathException emptyPathException) {
                // empty catch block
            }
        }
    }

    protected JDRSymmetricPath(JDRShape jDRShape, JDRPartialSegment jDRPartialSegment, JDRLine jDRLine) {
        this.path_ = jDRShape;
        this.selected = this.path_.isSelected();
        this.line_ = jDRLine;
        this.join = jDRPartialSegment;
        if (this.join != null) {
            this.join.setSymmetryLine(this.line_);
            this.join.setStart(this.path_.getLastControl());
        }
        this.initIterators();
        if (this.path_.isClosed()) {
            this.path_.open(false);
            try {
                this.close(2);
            }
            catch (EmptyPathException emptyPathException) {
                // empty catch block
            }
        }
    }

    public JDRSymmetricPath(JDRShape jDRShape) {
        this.path_ = jDRShape;
        this.selected = this.path_.isSelected();
        this.join = null;
        JDRPoint jDRPoint = this.path_.getLastControl();
        BBox bBox = jDRShape.getBBox();
        this.line_ = new JDRLine(new JDRSymmetryLinePoint(jDRPoint.x, bBox.getMinY()), new JDRSymmetryLinePoint(jDRPoint.x, bBox.getMaxY()));
        this.initIterators();
        if (this.path_.isClosed()) {
            this.path_.open(false);
            try {
                this.close(2);
            }
            catch (EmptyPathException emptyPathException) {
                // empty catch block
            }
        }
    }

    public JDRSymmetricPath(JDRLine jDRLine, int n, JDRPaint jDRPaint, JDRPaint jDRPaint2, JDRStroke jDRStroke) {
        this.path_ = new JDRPath(n, jDRPaint, jDRPaint2, jDRStroke);
        this.setSymmetry(jDRLine);
        this.join = null;
        this.initIterators();
    }

    public JDRSymmetricPath() {
        this.path_ = new JDRPath();
        this.join = null;
        this.line_ = new JDRLine(new JDRSymmetryLinePoint(0.0, 1.0), new JDRSymmetryLinePoint(0.0, -1.0));
        this.initIterators();
    }

    public JDRSymmetricPath(int n, JDRPaint jDRPaint, JDRPaint jDRPaint2, JDRStroke jDRStroke) {
        this.path_ = new JDRPath(n, jDRPaint, jDRPaint2, jDRStroke);
        this.join = null;
        this.initIterators();
    }

    protected void initIterators() {
        this.iterator = new JDRSymmetricPathIterator(this);
        this.pointIterator = new JDRPointIterator(this);
    }

    @Override
    public JDRPathIterator getIterator() {
        this.iterator.reset();
        return this.iterator;
    }

    @Override
    public JDRPointIterator getPointIterator() {
        this.pointIterator.reset();
        return this.pointIterator;
    }

    @Override
    public JDRPathSegment getFirstSegment() {
        return this.path_.getFirstSegment();
    }

    @Override
    public JDRPathSegment getLastSegment() {
        return this.line_;
    }

    @Override
    public JDRPoint getFirstControl() {
        return this.path_.getFirstControl();
    }

    @Override
    public JDRPoint getLastControl() {
        return this.line_.getEnd();
    }

    @Override
    public JDRShape getUnderlyingShape() {
        return this.path_;
    }

    @Override
    public void setUnderlyingShape(JDRShape jDRShape) {
        this.path_ = jDRShape;
        if (this.join == null) {
            this.moveToLine(this.path_.getLastSegment().getEnd());
        } else {
            this.join.setStart(this.path_.getLastSegment().getEnd());
        }
        if (this.isClosed()) {
            if (this.closingSegment == null) {
                this.moveToLine(this.path_.getFirstControl());
            } else {
                this.closingSegment.setEnd(this.path_.getFirstControl());
            }
        }
    }

    @Override
    public void add(JDRSegment jDRSegment) {
        this.path_.add(jDRSegment);
    }

    @Override
    public JDRShape getFullPath() throws EmptyPathException, IllFittingPathException {
        return (JDRShape)this.getFullObject();
    }

    public JDRCompleteObject getFullObject() throws EmptyPathException, IllFittingPathException {
        int n = this.path_.size();
        JDRShape jDRShape = this.path_.getFullPath();
        if (this.join != null) {
            jDRShape.add(this.join.getFullSegment());
        }
        for (int i = n - 1; i >= 0; --i) {
            jDRShape.add((JDRSegment)this.getReflected(i).reverse());
        }
        if (this.closingSegment != null) {
            jDRShape.close(this.closingSegment.getFullSegment());
        }
        return jDRShape;
    }

    @Override
    public Object clone() {
        JDRSymmetricPath jDRSymmetricPath = new JDRSymmetricPath((JDRShape)this.path_.clone(), true, (JDRLine)this.line_.clone());
        jDRSymmetricPath.makeEqual(this);
        return jDRSymmetricPath;
    }

    @Override
    public void makeEqual(JDRObject jDRObject) {
        super.makeEqual(jDRObject);
        JDRSymmetricPath jDRSymmetricPath = (JDRSymmetricPath)jDRObject;
        this.path_.makeEqual(jDRSymmetricPath.path_);
        this.line_.makeEqual(jDRSymmetricPath.line_);
        JDRPartialSegment jDRPartialSegment = this.join == null ? (jDRSymmetricPath.join == null ? null : (JDRPartialSegment)jDRSymmetricPath.join.clone()) : (jDRSymmetricPath.join == null ? null : (JDRPartialSegment)jDRSymmetricPath.join.clone());
        this.setJoin(jDRPartialSegment);
        if (!jDRSymmetricPath.isClosed()) {
            this.open();
            return;
        }
        if (jDRSymmetricPath.closingSegment != null) {
            try {
                this.close((JDRPathSegment)jDRSymmetricPath.closingSegment.clone());
            }
            catch (InvalidPathException invalidPathException) {}
        } else {
            try {
                this.close(2);
            }
            catch (EmptyPathException emptyPathException) {
                // empty catch block
            }
        }
    }

    protected void moveToLine(JDRPoint jDRPoint) {
        jDRPoint.moveToLine(this.line_);
    }

    @Override
    public void translateControl(JDRPathSegment jDRPathSegment, JDRPoint jDRPoint, double d, double d2) {
        Cloneable cloneable;
        this.path_.translateControl(jDRPathSegment, jDRPoint, d, d2);
        if (this.join == null) {
            cloneable = this.path_.getLastControl();
            if (this.line_ == jDRPathSegment) {
                jDRPoint = cloneable;
            }
            if (jDRPoint == cloneable) {
                this.moveToLine(jDRPoint);
            }
        }
        if (this.isClosed()) {
            if (this.closingSegment == null) {
                cloneable = this.path_.getFirstControl();
                if (this.line_ == jDRPathSegment) {
                    jDRPoint = cloneable;
                }
                if (jDRPoint == cloneable) {
                    this.moveToLine(jDRPoint);
                }
            } else if (jDRPathSegment == this.closingSegment && jDRPoint == this.closingSegment.getStart()) {
                cloneable = jDRPoint.getReflection(this.line_);
                this.path_.getFirstSegment().setStart((Point2D)cloneable);
            } else if (jDRPoint == this.path_.getFirstControl()) {
                cloneable = jDRPoint.getReflection(this.line_);
                this.closingSegment.setStart((Point2D)cloneable);
            } else if (jDRPathSegment == this.line_) {
                this.closingSegment.setEnd(this.getFirstSegment().getStart());
            }
        }
    }

    @Override
    public void setCapacity(int n) throws IllegalArgumentException {
        this.path_.setCapacity(n);
    }

    @Override
    public int getCapacity() {
        return this.path_.getCapacity();
    }

    @Override
    public JDRPoint addPoint() {
        return this.path_.addPoint();
    }

    @Override
    public void makeContinuous(boolean bl) {
        int n = this.path_.size();
        JDRPathSegment jDRPathSegment = this.getSelectedSegment();
        JDRPoint jDRPoint = this.getSelectedControl();
        int n2 = this.getSelectedIndex();
        if (n2 == 0 && this.isClosed() && bl) {
            Point2D point2D;
            if (!(jDRPathSegment instanceof JDRBezier)) {
                return;
            }
            JDRBezier jDRBezier = (JDRBezier)jDRPathSegment;
            if (this.closingSegment == null) {
                point2D = this.line_.getdP();
                point2D.setLocation(point2D.getY(), -point2D.getX());
            } else {
                point2D = this.closingSegment.getdP1();
            }
            jDRBezier.setStartGradient(point2D);
            return;
        }
        if (n2 < n - 1) {
            this.path_.makeContinuous(bl);
            return;
        }
        if (jDRPathSegment == null) {
            return;
        }
        if (n2 == n - 1) {
            if (!(jDRPathSegment instanceof JDRBezier)) {
                return;
            }
            JDRBezier jDRBezier = (JDRBezier)jDRPathSegment;
            if (jDRPoint == jDRBezier.getControl1()) {
                this.path_.makeContinuous(bl);
                return;
            }
            if (jDRPoint != jDRBezier.getControl2()) {
                return;
            }
            if (this.join == null) {
                Point2D point2D = this.line_.getdP();
                point2D.setLocation(point2D.getY(), -point2D.getX());
                jDRBezier.setEndGradient(point2D);
                return;
            }
            jDRBezier.setEndGradient(this.join.getdP0());
            return;
        }
        if (!(jDRPathSegment instanceof JDRPartialBezier)) {
            return;
        }
        JDRPartialBezier jDRPartialBezier = (JDRPartialBezier)jDRPathSegment;
        if (jDRPartialBezier == this.join) {
            if (jDRPoint != jDRPartialBezier.getControl1()) {
                return;
            }
            JDRSegment jDRSegment = (JDRSegment)this.path_.getLastSegment();
            Point2D point2D = jDRSegment.getdP1();
            jDRPartialBezier.setGradient(point2D);
            return;
        }
        if (jDRPartialBezier == this.closingSegment) {
            if (jDRPoint != jDRPartialBezier.getControl1()) {
                return;
            }
            Point2D point2D = this.getReflected(0).reverse().getdP1();
            jDRPartialBezier.setGradient(point2D);
        }
    }

    @Override
    protected void stopEditing() {
        this.path_.stopEditing();
        this.editMode = false;
    }

    @Override
    public void setEditMode(boolean bl) {
        if (bl) {
            this.selectNextControl();
        } else {
            this.stopEditing();
        }
    }

    @Override
    public int getSelectedControlIndex() {
        return this.path_.getSelectedControlIndex();
    }

    @Override
    public JDRPathSegment removeSelectedSegment() {
        int n = this.getSelectedIndex();
        if (n < this.path_.size()) {
            return this.remove(n);
        }
        return null;
    }

    @Override
    public JDRPathSegment remove(JDRPathSegment jDRPathSegment) {
        int n = this.path_.size();
        for (int i = 0; i < n; ++i) {
            if (this.get(i) != jDRPathSegment) continue;
            return this.remove(i);
        }
        return null;
    }

    @Override
    public JDRSegment removeSegment(int n) throws ArrayIndexOutOfBoundsException {
        return (JDRSegment)this.path_.remove(n);
    }

    @Override
    public JDRPathSegment setSegment(int n, JDRPathSegment jDRPathSegment) throws ArrayIndexOutOfBoundsException {
        int n2 = this.path_.size();
        if (n < n2) {
            return this.path_.setSegment(n, jDRPathSegment);
        }
        int n3 = 0;
        if (this.join != null) {
            if (n == n2) {
                JDRPartialSegment jDRPartialSegment = this.join;
                this.setJoin((JDRPartialSegment)jDRPathSegment);
                return jDRPartialSegment;
            }
            ++n3;
        }
        if (this.closingSegment != null && n == n2 + n3) {
            JDRPartialSegment jDRPartialSegment = this.closingSegment;
            this.closingSegment = (JDRPartialSegment)jDRPathSegment;
            this.closingSegment.setSymmetryLine(this.line_);
            return jDRPartialSegment;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    @Override
    public JDRSegment remove(int n) {
        JDRSegment jDRSegment;
        JDRSegment jDRSegment2 = (JDRSegment)this.path_.get(n);
        JDRPoint jDRPoint = jDRSegment2.getEnd();
        JDRPoint jDRPoint2 = this.getSelectedControl();
        int n2 = this.getSelectedControlIndex();
        if (jDRPoint == jDRPoint2 || jDRSegment2 instanceof JDRBezier && jDRPoint2 == ((JDRBezier)jDRSegment2).control2) {
            jDRPoint = jDRSegment2.getStart();
        }
        if (n == 0) {
            if (this.isClosed()) {
                this.closingSegment.setStart(jDRPoint);
            }
        } else {
            jDRSegment = (JDRSegment)this.path_.get(n - 1);
            if (n == this.path_.size() - 1 && this.isAnchored()) {
                this.moveToLine(jDRSegment.getEnd());
            } else {
                jDRSegment.setEnd(jDRPoint);
            }
        }
        jDRSegment = this.path_.removeSegment(n);
        this.stopEditing();
        jDRPoint = this.selectControl(n2);
        if (jDRPoint == null) {
            this.selectControl(0);
        }
        return jDRSegment;
    }

    @Override
    public int getSelectedIndex() {
        return this.path_.getSelectedIndex();
    }

    @Override
    public JDRPoint getSelectedControl() {
        return this.path_.getSelectedControl();
    }

    @Override
    public JDRPathSegment getSelectedSegment() {
        return this.path_.getSelectedSegment();
    }

    @Override
    public boolean segmentHasEnd(JDRPathSegment jDRPathSegment) {
        if (jDRPathSegment instanceof JDRPartialSegment) {
            return false;
        }
        if (jDRPathSegment == this.line_) {
            return true;
        }
        return this.isAnchored() && jDRPathSegment == this.path_.getLastSegment();
    }

    @Override
    public int size() {
        return this.getTotalBaseSegments();
    }

    public int getTotalBaseSegments() {
        int n = this.path_.size() + 1;
        if (this.join != null) {
            ++n;
        }
        if (this.closingSegment != null) {
            ++n;
        }
        return n;
    }

    @Override
    public int getTotalPathSegments() {
        int n = 2 * this.path_.size();
        if (this.join != null) {
            ++n;
        }
        if (this.closingSegment != null) {
            ++n;
        }
        return n;
    }

    @Override
    public JDRPathSegment get(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = this.path_.size();
        if (n < n2) {
            return this.path_.get(n);
        }
        int n3 = 0;
        if (this.join != null) {
            if (n == n2) {
                return this.join;
            }
            ++n3;
        }
        if (this.closingSegment != null) {
            if (n == n2 + n3) {
                return this.closingSegment;
            }
            ++n3;
        }
        if (n == n2 + n3) {
            return this.line_;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    @Override
    public int getIndex(JDRPathSegment jDRPathSegment) {
        int n;
        int n2 = this.path_.size();
        for (n = 0; n < n2; ++n) {
            JDRPathSegment jDRPathSegment2 = this.path_.get(n);
            if (jDRPathSegment2 != jDRPathSegment) continue;
            return n;
        }
        if (this.join != null) {
            if (this.join == jDRPathSegment) {
                return n;
            }
            ++n;
        }
        if (this.closingSegment != null) {
            if (this.closingSegment == jDRPathSegment) {
                return n;
            }
            ++n;
        }
        if (this.line_ == jDRPathSegment) {
            return n;
        }
        return -1;
    }

    @Override
    public int getLastIndex(JDRPathSegment jDRPathSegment) {
        int n = this.path_.size();
        int n2 = 0;
        if (this.join != null) {
            if (jDRPathSegment == this.join) {
                return n;
            }
            ++n2;
        }
        if (this.closingSegment != null) {
            if (jDRPathSegment == this.closingSegment) {
                return n + n2;
            }
            ++n2;
        }
        if (jDRPathSegment == this.line_) {
            return n + n2;
        }
        return this.path_.getLastIndex(jDRPathSegment);
    }

    public JDRPathSegment getReflected(int n) {
        return this.get(n).getReflection(this.line_);
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.showPath()) {
            super.draw(graphics);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            this.path_.draw(graphics);
            AffineTransform affineTransform2 = this.line_.getReflectionTransform(null);
            affineTransform2.preConcatenate(affineTransform);
            graphics2D.setTransform(affineTransform2);
            this.path_.draw(graphics);
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public void drawDraft(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.path_.drawDraft(graphics, d);
        if (this.join != null) {
            this.join.drawDraft(graphics, d, false);
        }
        graphics2D.setPaint(draftColor);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        affineTransform.concatenate(this.line_.getReflectionTransform(null));
        GeneralPath generalPath = this.path_.getGeneralPath();
        generalPath.transform(affineTransform);
        graphics2D.draw(generalPath);
        if (this.closingSegment != null) {
            this.closingSegment.drawDraft(graphics, d, false);
            this.closingSegment.start.draw(graphics, d);
        }
        this.line_.drawDraft(graphics, d, true);
    }

    @Override
    public BBox getControlBBox() {
        BBox bBox = this.path_.getControlBBox();
        if (bBox == null) {
            return null;
        }
        for (int i = 0; i < this.path_.size(); ++i) {
            JDRSegment jDRSegment = (JDRSegment)this.path_.get(i);
            jDRSegment.mergeReflectedBBox(this.line_, bBox);
        }
        if (this.join != null) {
            this.join.mergeControlBBox(bBox);
        }
        if (this.closingSegment != null) {
            this.closingSegment.mergeControlBBox(bBox);
        }
        this.line_.mergeControlBBox(bBox);
        return bBox;
    }

    @Override
    public void mergeControlBBox(BBox bBox) {
        this.path_.mergeControlBBox(bBox);
        for (int i = 0; i < this.path_.size(); ++i) {
            JDRSegment jDRSegment = (JDRSegment)this.path_.get(i);
            jDRSegment.mergeReflectedBBox(this.line_, bBox);
        }
        if (this.join != null) {
            this.join.mergeControlBBox(bBox);
        }
        if (this.closingSegment != null) {
            this.closingSegment.mergeControlBBox(bBox);
        }
        this.line_.mergeControlBBox(bBox);
    }

    @Override
    public void convertSegment(int n, JDRPathSegment jDRPathSegment) {
        JDRPathSegment jDRPathSegment2 = this.get(n);
        JDRPoint jDRPoint = this.getSelectedControl();
        int n2 = this.getSelectedControlIndex();
        if (n < this.path_.size()) {
            this.path_.convertSegment(n, jDRPathSegment);
            if (this.join != null && jDRPathSegment2.getEnd() == this.join.getStart()) {
                this.join.setStart(jDRPathSegment.getEnd());
            }
            return;
        }
        this.setSegment(n, jDRPathSegment);
        try {
            int n3 = jDRPathSegment2.getControlIndex(jDRPoint);
            jDRPoint = jDRPathSegment.getStart();
            if (n3 > 0) {
                n2 -= n3;
            }
            this.setSelectedElements(n, n2, jDRPathSegment, jDRPoint);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public void shearParams(Point2D point2D, double d, double d2) {
        if (this.join != null) {
            this.join.shear(point2D, d, d2);
        }
        this.line_.shear(point2D, d, d2);
        if (this.closingSegment != null) {
            this.closingSegment.shear(point2D, d, d2);
            this.closingSegment.setEnd(this.getFirstControl());
        }
    }

    @Override
    public void scaleParams(Point2D point2D, double d, double d2) {
        if (this.join != null) {
            this.join.scale(point2D, d, d2);
        }
        this.line_.scale(point2D, d, d2);
        if (this.closingSegment != null) {
            this.closingSegment.scale(point2D, d, d2);
            this.closingSegment.setEnd(this.getFirstControl());
        }
    }

    @Override
    public void rotateParams(Point2D point2D, double d) {
        if (this.join != null) {
            this.join.rotate(point2D, d);
        }
        this.line_.rotate(point2D, d);
        if (this.closingSegment != null) {
            this.closingSegment.rotate(point2D, d);
            this.closingSegment.setEnd(this.getFirstControl());
        }
    }

    @Override
    public void translateParams(double d, double d2) {
        if (this.join != null) {
            this.join.translate(d, d2);
        }
        this.line_.translate(d, d2);
        if (this.closingSegment != null) {
            this.closingSegment.translate(d, d2);
            this.closingSegment.setEnd(this.getFirstControl());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void open() {
        this.closed = false;
        this.closingSegment = null;
    }

    @Override
    public void open(boolean bl) {
        this.open();
    }

    @Override
    public void close(int n) throws EmptyPathException {
        if (this.isEmpty()) {
            throw new EmptyPathException();
        }
        JDRSegment jDRSegment = (JDRSegment)this.path_.getFirstSegment();
        try {
            switch (n) {
                case 0: {
                    this.close(new JDRPartialLine());
                    return;
                }
                case 1: {
                    JDRPartialBezier jDRPartialBezier = new JDRPartialBezier();
                    this.close(jDRPartialBezier);
                    JDRSegment jDRSegment2 = ((JDRSegment)jDRSegment.getReflection(this.line_)).reverse();
                    Point2D point2D = jDRSegment2.getdP1();
                    jDRPartialBezier.setGradient(point2D);
                    return;
                }
                case 2: {
                    this.moveToLine(jDRSegment.getStart());
                    this.closed = true;
                    this.closingSegment = null;
                    return;
                }
            }
        }
        catch (IllFittingPathException illFittingPathException) {
            // empty catch block
        }
    }

    @Override
    public void close(JDRPathSegment jDRPathSegment) throws EmptyPathException, IllFittingPathException {
        if (jDRPathSegment == null) {
            this.close(2);
            return;
        }
        if (!(jDRPathSegment instanceof JDRPartialSegment)) {
            throw new IllFittingPathException("Can't close a symmetric path with a full segment");
        }
        this.closed = true;
        this.closingSegment = (JDRPartialSegment)jDRPathSegment;
        this.closingSegment.setSymmetryLine(this.line_);
        this.closingSegment.setEnd(this.path_.getFirstSegment().getStart());
    }

    @Override
    public JDRShape breakPath() throws InvalidPathException {
        JDRLine jDRLine = (JDRLine)this.line_.clone();
        JDRPartialSegment jDRPartialSegment = null;
        if (this.getJoin() != null) {
            jDRPartialSegment = (JDRPartialSegment)this.getJoin().clone();
        }
        JDRShape jDRShape = this.path_.breakPath();
        JDRSymmetricPath jDRSymmetricPath = new JDRSymmetricPath(jDRShape, jDRPartialSegment, jDRLine);
        this.setJoin(new JDRPartialSegment(this.path_.getLastSegment().getEnd(), this.line_));
        return jDRSymmetricPath;
    }

    @Override
    public Shape getStrokedPath() {
        Shape shape;
        if (this.showPath()) {
            shape = this.getStroke().getStrokedPath(this);
        } else {
            shape = this.path_.getStrokedPath();
            AffineTransform affineTransform = this.line_.getReflectionTransform(null);
            GeneralPath generalPath = new GeneralPath(shape);
            generalPath.transform(affineTransform);
            generalPath.append(shape, false);
            shape = generalPath;
        }
        return shape;
    }

    @Override
    public Area getStrokedArea() {
        Area area;
        if (this.showPath()) {
            area = this.getStroke().getStrokedArea(this);
        } else {
            area = this.path_.getStrokedArea();
            AffineTransform affineTransform = this.line_.getReflectionTransform(null);
            Area area2 = new Area(area);
            area2.transform(affineTransform);
            area.add(area2);
        }
        return area;
    }

    @Override
    public JDRStroke getStroke() {
        return this.path_.getStroke();
    }

    @Override
    public void setStroke(JDRStroke jDRStroke) {
        this.path_.setStroke(jDRStroke);
    }

    @Override
    public void fade(double d) {
        this.path_.fade(d);
    }

    @Override
    public JDRPaint getLinePaint() {
        return this.path_.getLinePaint();
    }

    @Override
    public void setLinePaint(JDRPaint jDRPaint) {
        this.path_.setLinePaint(jDRPaint);
    }

    @Override
    public JDRPaint getFillPaint() {
        return this.path_.getFillPaint();
    }

    @Override
    public void setFillPaint(JDRPaint jDRPaint) {
        this.path_.setFillPaint(jDRPaint);
    }

    @Override
    public JDRGroup separate(Graphics graphics) throws InvalidPathException {
        JDRPath jDRPath;
        JDRGroup jDRGroup = new JDRGroup();
        JDRShape jDRShape = this.getUnderlyingShape();
        if (jDRShape instanceof JDRTextPath) {
            return ((JDRTextPath)jDRShape).separate(graphics);
        }
        jDRGroup.add(jDRShape);
        if (this.join != null) {
            jDRPath = new JDRPath();
            jDRPath.setLinePaint(this.getLinePaint());
            jDRPath.setFillPaint(this.getFillPaint());
            jDRPath.setStroke(this.getStroke() instanceof JDRBasicStroke ? (JDRStroke)this.getStroke().clone() : new JDRBasicStroke());
            if (this.join.isGap()) {
                jDRPath.add(new JDRLine(this.join.getStart(), this.join.getEnd()));
            } else {
                jDRPath.add(this.join.getFullSegment());
            }
            jDRGroup.add(jDRPath);
        }
        JDRShape jDRShape2 = jDRShape.reflection(this.line_);
        jDRGroup.add(jDRShape2);
        if (this.closingSegment != null) {
            jDRPath = new JDRPath();
            jDRPath.setLinePaint(this.getLinePaint());
            jDRPath.setFillPaint(this.getFillPaint());
            jDRPath.setStroke(this.getStroke() instanceof JDRBasicStroke ? (JDRStroke)this.getStroke().clone() : new JDRBasicStroke());
            jDRPath.add(this.closingSegment.getFullSegment());
            jDRGroup.add(jDRPath);
        }
        jDRPath = new JDRPath();
        jDRPath.setLinePaint(this.getLinePaint());
        jDRPath.setFillPaint(this.getFillPaint());
        jDRPath.setStroke(new JDRBasicStroke());
        jDRPath.add(this.line_);
        jDRGroup.add(jDRPath);
        return jDRGroup;
    }

    @Override
    public GeneralPath getGeneralPath() {
        if (this.isEmpty()) {
            return null;
        }
        JDRStroke jDRStroke = this.getStroke();
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        if (jDRStroke != null) {
            generalPath2.setWindingRule(jDRStroke.getWindingRule());
            generalPath.setWindingRule(jDRStroke.getWindingRule());
        }
        boolean bl = this.isClosed() && (this.join != null && this.join.isGap() || this.closingSegment != null && this.closingSegment.isGap());
        int n = this.path_.size();
        JDRPathSegment jDRPathSegment = this.path_.getFirstSegment();
        generalPath2.moveTo((float)jDRPathSegment.getStart().x, (float)jDRPathSegment.getStart().y);
        jDRPathSegment.appendToGeneralPath(generalPath2);
        jDRPathSegment = this.getReflected(n - 1).reverse();
        generalPath.moveTo((float)jDRPathSegment.getStart().x, (float)jDRPathSegment.getStart().y);
        jDRPathSegment.appendToGeneralPath(generalPath);
        boolean bl2 = false;
        for (int i = 1; i < n; ++i) {
            jDRPathSegment = this.path_.get(i);
            jDRPathSegment.appendToGeneralPath(generalPath2);
            jDRPathSegment = this.getReflected(n - i - 1).reverse();
            if (jDRPathSegment.isGap() && bl && !bl2) {
                generalPath.closePath();
                bl2 = true;
            }
            jDRPathSegment.appendToGeneralPath(generalPath);
        }
        if (bl) {
            generalPath2.closePath();
            JDRPoint jDRPoint = this.path_.getLastSegment().getEnd();
            generalPath2.moveTo((float)jDRPoint.getX(), (float)jDRPoint.getY());
        }
        if (this.join != null) {
            this.join.appendToGeneralPath(generalPath2);
        }
        if (bl && !bl2) {
            generalPath.closePath();
        }
        generalPath2.append(generalPath, true);
        if (this.closingSegment != null) {
            this.closingSegment.appendToGeneralPath(generalPath2);
        }
        if (this.isClosed() && !bl) {
            generalPath2.closePath();
        }
        return generalPath2;
    }

    @Override
    public JDRShape reverse() throws InvalidPathException {
        int n = this.path_.size();
        if (n == 0) {
            throw new EmptyPathException();
        }
        JDRSymmetricPath jDRSymmetricPath = new JDRSymmetricPath(this.line_, n, (JDRPaint)this.getLinePaint().clone(), (JDRPaint)this.getFillPaint().clone(), (JDRStroke)this.getStroke().clone());
        jDRSymmetricPath.flowframe = this.flowframe == null ? null : (FlowFrame)this.flowframe.clone();
        jDRSymmetricPath.description = this.description;
        jDRSymmetricPath.setSelected(this.isSelected());
        JDRPathSegment jDRPathSegment = null;
        for (int i = 0; i < n; ++i) {
            jDRPathSegment = this.getReflected(i);
            jDRSymmetricPath.add((JDRSegment)jDRPathSegment);
        }
        if (this.join != null) {
            if (this.isJoinLine()) {
                jDRSymmetricPath.setJoin(new JDRPartialLine(jDRPathSegment.getEnd(), jDRSymmetricPath.getSymmetry()));
            } else if (this.isJoinBezier()) {
                jDRSymmetricPath.setJoin(new JDRPartialBezier(jDRPathSegment.getEnd(), new JDRPoint(((JDRPartialBezier)this.join).getControl2()), jDRSymmetricPath.getSymmetry()));
            } else {
                jDRSymmetricPath.setJoin(new JDRPartialSegment(jDRPathSegment.getEnd(), jDRSymmetricPath.getSymmetry()));
            }
        }
        return jDRSymmetricPath;
    }

    @Override
    public JDRShape intersect(JDRShape jDRShape) throws InvalidPathException {
        return this.path_.intersect(jDRShape);
    }

    @Override
    public JDRShape pathUnion(JDRShape jDRShape) throws InvalidPathException {
        return this.path_.pathUnion(jDRShape);
    }

    @Override
    public JDRShape exclusiveOr(JDRShape jDRShape) throws InvalidPathException {
        return this.path_.exclusiveOr(jDRShape);
    }

    @Override
    public JDRShape subtract(JDRShape jDRShape) throws InvalidPathException {
        return this.path_.subtract(jDRShape);
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return symmetricPathListener;
    }

    public String toString() {
        String string = "SymmetricPath: join=" + this.join + ", symmetry: " + this.line_ + ", marker symmetry=" + this.markerSymmetry + ", size=" + this.size() + ", segments=[";
        for (int i = 0; i < this.size(); ++i) {
            string = string + this.get(i) + ",";
        }
        string = string + "]";
        return string;
    }

    public boolean isAnchored() {
        return this.join == null;
    }

    public void setJoin(JDRPartialSegment jDRPartialSegment) {
        boolean bl = this.isJoinBezier() && this.join.isEdited();
        this.join = jDRPartialSegment;
        if (this.join == null) {
            this.moveToLine(this.path_.getLastSegment().getEnd());
        } else {
            this.join.setStart(this.path_.getLastSegment().getEnd());
            this.join.setSymmetryLine(this.line_);
        }
        if (bl) {
            this.selectControl(this.path_.getLastSegment().getEnd());
        }
    }

    public JDRPartialSegment getJoin() {
        return this.join;
    }

    public JDRPartialSegment getClosingSegment() {
        return this.closingSegment;
    }

    public boolean isJoinLine() {
        if (this.join == null) {
            return false;
        }
        return this.join instanceof JDRPartialLine;
    }

    public boolean isClosingSegmentLine() {
        if (this.closingSegment == null) {
            return false;
        }
        return this.closingSegment instanceof JDRPartialLine;
    }

    public boolean isJoinBezier() {
        if (this.join == null) {
            return false;
        }
        return this.join instanceof JDRPartialBezier;
    }

    public boolean isClosingSegmentBezier() {
        if (this.closingSegment == null) {
            return false;
        }
        return this.closingSegment instanceof JDRPartialBezier;
    }

    public void setSymmetry(double d, double d2, double d3, double d4) {
        if (this.line_ == null) {
            this.line_ = new JDRLine(new JDRSymmetryLinePoint(d, d2), new JDRSymmetryLinePoint(d3, d4));
        } else {
            this.line_.setStart(d, d2);
            this.line_.setEnd(d3, d4);
        }
        if (this.join != null) {
            this.join.setSymmetryLine(this.line_);
        }
    }

    public void setSymmetry(JDRLine jDRLine) {
        this.line_ = jDRLine;
        if (jDRLine == null) {
            return;
        }
        JDRPoint jDRPoint = this.line_.getStart();
        if (!(jDRPoint instanceof JDRSymmetryLinePoint)) {
            this.line_.setStart(new JDRSymmetryLinePoint(jDRPoint.x, jDRPoint.y));
        }
        if (!((jDRPoint = this.line_.getEnd()) instanceof JDRSymmetryLinePoint)) {
            this.line_.setEnd(new JDRSymmetryLinePoint(jDRPoint.x, jDRPoint.y));
        }
    }

    public JDRLine getSymmetry() {
        return this.line_;
    }

    public void setMarkerSymmetry(boolean bl) {
        this.markerSymmetry = bl;
    }

    public boolean hasMarkerSymmetry() {
        return this.markerSymmetry;
    }

    @Override
    public void selectControl(JDRPoint jDRPoint, int n, int n2) {
        this.stopEditing();
        this.selected = true;
        if (n2 < this.path_.size()) {
            this.path_.selectControl(jDRPoint, n, n2);
        } else {
            JDRPathSegment jDRPathSegment = this.get(n2);
            this.stopEditing();
            this.setSelectedElements(n2, n, jDRPathSegment, jDRPoint);
            jDRPoint.setSelected(true);
            jDRPathSegment.setSelected(true);
        }
        this.editMode = true;
    }

    @Override
    public int psLevel() {
        return this.path_.psLevel();
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        JDRPaint jDRPaint = this.getFillPaint();
        GeneralPath generalPath = this.getGeneralPath();
        printWriter.println("gsave");
        EPS.fillPath(generalPath, jDRPaint, printWriter);
        printWriter.println("grestore");
        printWriter.println("gsave");
        this.getStroke().saveEPS(this, printWriter);
        printWriter.println("grestore");
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        JDRPathSegment jDRPathSegment = this.get(0);
        printWriter.print("   <path d=\"M ");
        jDRPathSegment.getStart().saveSVG(printWriter);
        jDRPathSegment.saveSVG(printWriter);
        JDRPathIterator jDRPathIterator = this.getIterator();
        while (jDRPathIterator.hasNext()) {
            jDRPathSegment = jDRPathIterator.next();
            jDRPathSegment.saveSVG(printWriter);
        }
        if (this.isClosed()) {
            printWriter.print("z");
        }
        printWriter.println("\"");
        printWriter.println("      " + this.getLinePaint().svgLine());
        printWriter.println("      " + this.getFillPaint().svgFill());
        if (this.getStroke() instanceof JDRBasicStroke) {
            printWriter.println("      " + ((JDRBasicStroke)this.getStroke()).svg(this.getLinePaint()));
        }
        printWriter.println("   />");
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return "";
        }
        String string = System.getProperty("line.separator", "\n");
        String string2 = new String("");
        if (!this.description.equals("")) {
            string2 = string2 + "% " + this.description + string;
        }
        string2 = string2 + this.pgfPath(affineTransform);
        String string3 = new String();
        JDRPaint jDRPaint = this.getFillPaint();
        JDRPaint jDRPaint2 = this.getLinePaint();
        string3 = string3 + "\\begin{pgfscope}" + string;
        if (this.getStroke() instanceof JDRBasicStroke) {
            string3 = string3 + ((JDRBasicStroke)this.getStroke()).pgf();
        }
        if (jDRPaint instanceof JDRTransparent) {
            string3 = string3 + string2;
            if (!(jDRPaint2 instanceof JDRTransparent)) {
                string3 = string3 + jDRPaint2.pgfstrokecolor(bBox);
                string3 = string3 + string;
                string3 = string3 + "\\pgfusepath{stroke}" + string;
            }
        } else {
            string3 = string3 + string2;
            string3 = string3 + jDRPaint.pgffillcolor(bBox);
            if (this.getStroke() instanceof JDRBasicStroke) {
                string3 = string3 + (((JDRBasicStroke)this.getStroke()).windingRule == 0 ? "\\pgfseteorule" : "\\pgfsetnonzerorule");
            }
            if (jDRPaint instanceof JDRGradient || jDRPaint instanceof JDRRadial) {
                string3 = string3 + jDRPaint2.pgfstrokecolor(bBox);
                string3 = string3 + string;
                if (jDRPaint2 instanceof JDRTransparent) {
                    string3 = string3 + "\\pgfsetstrokeopacity{0.0}" + string;
                }
                string3 = string3 + "\\pgfusepath{stroke}" + string;
            } else if (jDRPaint2 instanceof JDRTransparent) {
                string3 = string3 + "\\pgfusepath{fill}" + string;
            } else {
                string3 = string3 + "\\pgfusepath{fill}" + string;
                string3 = string3 + string2;
                string3 = string3 + jDRPaint2.pgfstrokecolor(bBox);
                string3 = string3 + string;
                string3 = string3 + "\\pgfusepath{stroke}" + string;
            }
        }
        string3 = string3 + "\\end{pgfscope}" + string;
        string3 = string3 + this.pgfMarkers(affineTransform, bBox);
        return string3;
    }

    @Override
    public String pgfPath(AffineTransform affineTransform) {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        JDRPathSegment jDRPathSegment = this.get(0);
        string2 = string2 + "\\pgfpathmoveto{" + jDRPathSegment.getStart().pgf(affineTransform) + "}" + string;
        JDRPathIterator jDRPathIterator = this.getIterator();
        while (jDRPathIterator.hasNext()) {
            jDRPathSegment = jDRPathIterator.next();
            string2 = string2 + jDRPathSegment.pgf(affineTransform) + string;
        }
        if (this.isClosed()) {
            string2 = string2 + "\\pgfclosepath" + string;
        }
        return string2;
    }

    public String pgfMarkers(AffineTransform affineTransform, BBox bBox) {
        String string = "";
        if (this.getStroke() instanceof JDRBasicStroke) {
            JDRBasicStroke jDRBasicStroke = (JDRBasicStroke)this.getStroke();
            if (jDRBasicStroke.getStartArrow().getType() == 0 && jDRBasicStroke.getEndArrow().getType() == 0 && jDRBasicStroke.getMidArrow().getType() == 0) {
                return string;
            }
            JDRPaint jDRPaint = this.getLinePaint();
            JDRPathIterator jDRPathIterator = this.getIterator();
            while (jDRPathIterator.hasNext()) {
                JDRPathSegment jDRPathSegment = jDRPathIterator.next();
                JDRMarker jDRMarker = jDRPathSegment.getStartMarker();
                if (jDRMarker != null && jDRMarker.getType() != 0) {
                    string = string + jDRMarker.pgfShape(jDRPaint, bBox, jDRPathSegment, true, affineTransform);
                }
                if ((jDRMarker = jDRPathSegment.getEndMarker()) == null || jDRMarker.getType() == 0) continue;
                string = string + jDRMarker.pgfShape(jDRPaint, bBox, jDRPathSegment, false, affineTransform);
            }
        }
        return string;
    }

    @Override
    public JDRTextual getTextual() {
        return this.path_.getTextual();
    }

    @Override
    public boolean hasTextual() {
        return this.path_.hasTextual();
    }

    @Override
    public boolean showPath() {
        return this.path_.showPath();
    }

    @Override
    public boolean hasSymmetricPath() {
        return true;
    }

    @Override
    public JDRSymmetricPath getSymmetricPath() {
        return this;
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "SymmetricPath:" + string;
        string2 = string2 + "line of symmetry: " + this.line_.info() + string;
        string2 = string2 + "anchored: " + this.isAnchored() + string;
        if (this.join != null) {
            string2 = string2 + "join segment: " + this.join.info();
        }
        if (this.closingSegment != null) {
            string2 = string2 + "closing segment: " + this.closingSegment.info();
        }
        string2 = string2 + "Underlying shape:" + this.path_.info();
        return string2;
    }

    @Override
    protected void setSelectedElements(int n, int n2, JDRPathSegment jDRPathSegment, JDRPoint jDRPoint) {
        this.path_.setSelectedElements(n, n2, jDRPathSegment, jDRPoint);
    }

    @Override
    public String[] getDescriptionInfo() {
        return this.getUnderlyingShape().getDescriptionInfo();
    }
}

