/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidReplicaException;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAdjustPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAnchorPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRSpiralPatternListener;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;

public class JDRSpiralPattern
extends JDRPattern {
    private double angle_;
    private double distance_;
    private static JDRPathListener shapeListener = new JDRSpiralPatternListener();

    public JDRSpiralPattern(JDRShape jDRShape, JDRPoint jDRPoint, JDRPoint jDRPoint2, double d, double d2, int n, boolean bl) throws InvalidReplicaException {
        this.setNumReplicas(n);
        this.path_ = jDRShape;
        this.setPatternAnchor(jDRPoint);
        this.setPatternAdjust(jDRPoint2);
        this.setDistance(d2);
        this.angle_ = d;
        this.singlemode_ = bl;
        this.initIterators();
    }

    public JDRSpiralPattern(JDRShape jDRShape, JDRPoint jDRPoint, JDRPoint jDRPoint2, double d, double d2, int n, boolean bl, boolean bl2) throws InvalidReplicaException {
        this.setNumReplicas(n);
        this.path_ = jDRShape;
        this.setPatternAnchor(jDRPoint);
        this.setPatternAdjust(jDRPoint2);
        this.setDistance(d2);
        this.angle_ = d;
        this.singlemode_ = bl;
        this.showoriginal_ = bl2;
        this.initIterators();
    }

    public JDRSpiralPattern(JDRShape jDRShape, JDRPoint jDRPoint, double d, double d2, int n, boolean bl) throws InvalidReplicaException {
        this.path_ = jDRShape;
        this.setNumReplicas(n);
        this.setPatternAnchor(jDRPoint);
        this.setDefaultPatternAdjust();
        this.setDistance(d2);
        this.angle_ = d;
        this.singlemode_ = bl;
        this.initIterators();
    }

    public JDRSpiralPattern() {
        this.path_ = new JDRPath();
        this.point_ = new JDRPatternAnchorPoint();
        this.adjust_ = new JDRPatternAdjustPoint();
        this.angle_ = 0.7853981633974483;
        this.replicas_ = 1;
        this.distance_ = 1.0;
        this.singlemode_ = true;
        this.initIterators();
    }

    public JDRSpiralPattern(int n, JDRPaint jDRPaint, JDRPaint jDRPaint2, JDRStroke jDRStroke) {
        this.path_ = new JDRPath(n, jDRPaint, jDRPaint2, jDRStroke);
        this.point_ = new JDRPatternAnchorPoint();
        this.adjust_ = new JDRPatternAdjustPoint();
        this.angle_ = 0.7853981633974483;
        this.replicas_ = 4;
        this.distance_ = 1.0;
        this.singlemode_ = true;
        this.initIterators();
    }

    @Override
    public boolean hasAdjust() {
        return true;
    }

    @Override
    public JDRPattern createTemplate() {
        try {
            return new JDRSpiralPattern(null, null, null, this.angle_, this.distance_, this.replicas_, this.singlemode_);
        }
        catch (InvalidFormatException invalidFormatException) {
            return null;
        }
    }

    @Override
    public void makeParametersEqual(JDRPattern jDRPattern) {
        JDRSpiralPattern jDRSpiralPattern = (JDRSpiralPattern)jDRPattern;
        this.angle_ = jDRSpiralPattern.angle_;
        this.distance_ = jDRSpiralPattern.distance_;
    }

    @Override
    public void getReplicaTransform(double[] dArray, int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = (double)n * this.angle_;
        if (this.adjust_ != null) {
            d = this.point_.x - this.adjust_.x;
            d2 = this.point_.y - this.adjust_.y;
            d3 = Math.sqrt(d * d + d2 * d2);
            d4 += Math.atan2(d2, d);
        }
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = this.distance_ / (Math.PI * 2);
        double d8 = d3 + d7 * d4;
        dArray[0] = d5;
        dArray[1] = d6;
        dArray[2] = -d6;
        dArray[3] = d5;
        dArray[4] = d5 * (d8 - this.point_.x) + this.point_.y * d6 + this.point_.x;
        dArray[5] = d6 * (d8 - this.point_.x) + this.point_.y * (1.0 - d5);
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return shapeListener;
    }

    public String toString() {
        String string = "SpiralPattern: point=" + this.point_ + ", angle: " + this.angle_ + ", distance: " + this.distance_ + ", replicas: " + this.replicas_ + ", size=" + this.size() + ", segments=[";
        for (int i = 0; i < this.size(); ++i) {
            string = string + this.get(i) + ",";
        }
        string = string + "]";
        return string;
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "SpiralPattern:" + string;
        string2 = string2 + "anchor: " + this.point_.info() + string;
        string2 = string2 + "adjust: " + this.adjust_.info() + string;
        string2 = string2 + "angle: " + this.angle_ + string;
        string2 = string2 + "distance: " + this.distance_ + string;
        string2 = string2 + "replicas: " + this.replicas_;
        string2 = string2 + "Underlying shape:" + this.path_.info();
        return string2;
    }

    public double getRotationAngle() {
        return this.angle_;
    }

    public void setRotationAngle(double d) {
        this.angle_ = d;
    }

    public void setDistance(double d) {
        this.distance_ = d;
    }

    public double getDistance() {
        return this.distance_;
    }

    @Override
    public String[] getDescriptionInfo() {
        return new String[]{"" + this.replicas_, "(" + this.angle_ + ":" + this.distance_ + ")"};
    }
}

