/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.EmptyPathException;
import uk.ac.uea.cmp.nlct.jdr.IllFittingPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPathIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPathStyleListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPointIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRShading;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;

public abstract class JDRShape
extends JDRCompleteObject {
    public static final int CLOSE_LINE = 0;
    public static final int CLOSE_CONT = 1;
    public static final int CLOSE_MERGE_ENDS = 2;

    public abstract JDRPathIterator getIterator();

    public abstract JDRPointIterator getPointIterator();

    public abstract JDRShape reverse() throws InvalidPathException;

    public JDRShape reflection(JDRLine jDRLine) throws InvalidPathException {
        JDRShape jDRShape = (JDRShape)this.clone();
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint = jDRPointIterator.next();
            jDRPoint.reflect2D(jDRLine);
        }
        return jDRShape;
    }

    public abstract JDRShape exclusiveOr(JDRShape var1) throws InvalidPathException;

    public abstract JDRShape pathUnion(JDRShape var1) throws InvalidPathException;

    public abstract JDRShape intersect(JDRShape var1) throws InvalidPathException;

    public abstract JDRShape subtract(JDRShape var1) throws InvalidPathException;

    public JDRShape outlineToPath() throws InvalidPathException {
        Area area = this.getStrokedArea();
        PathIterator pathIterator = area.getPathIterator(null);
        double[] dArray = new double[6];
        int n = pathIterator.currentSegment(dArray);
        double d = dArray[0];
        double d2 = dArray[1];
        Point2D.Double double_ = new Point2D.Double(dArray[0], dArray[1]);
        pathIterator.next();
        JDRPath jDRPath = new JDRPath(this.getCapacity());
        jDRPath.setLinePaint(new JDRTransparent());
        jDRPath.setFillPaint((JDRPaint)this.getLinePaint().clone());
        boolean bl = false;
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 3: {
                    JDRSegment jDRSegment = new JDRBezier(double_, new Point2D.Double(dArray[0], dArray[1]), new Point2D.Double(dArray[2], dArray[3]), new Point2D.Double(dArray[4], dArray[5]));
                    double_ = new Point2D.Double(dArray[4], dArray[4]);
                    jDRPath.add(jDRSegment);
                    break;
                }
                case 2: {
                    JDRSegment jDRSegment = JDRBezier.quadToCubic(((Point2D)double_).getX(), ((Point2D)double_).getY(), dArray[0], dArray[1], dArray[2], dArray[3]);
                    double_ = new Point2D.Double(dArray[4], dArray[4]);
                    jDRPath.add(jDRSegment);
                    break;
                }
                case 1: {
                    JDRSegment jDRSegment = new JDRLine(((Point2D)double_).getX(), ((Point2D)double_).getY(), dArray[0], dArray[1]);
                    double_ = new Point2D.Double(dArray[0], dArray[1]);
                    jDRPath.add(jDRSegment);
                    break;
                }
                case 0: {
                    JDRSegment jDRSegment = new JDRSegment(((Point2D)double_).getX(), ((Point2D)double_).getY(), dArray[0], dArray[1]);
                    double_ = new Point2D.Double(dArray[0], dArray[1]);
                    jDRPath.add(jDRSegment);
                    break;
                }
                case 4: {
                    bl = true;
                }
            }
            pathIterator.next();
        }
        if (bl) {
            jDRPath.close(new JDRSegment(((Point2D)double_).getX(), ((Point2D)double_).getY(), d, d2));
        }
        return jDRPath;
    }

    public abstract JDRShape breakPath() throws InvalidPathException;

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract int getCapacity();

    public abstract void setCapacity(int var1) throws IllegalArgumentException;

    public abstract void open();

    public abstract void open(boolean var1);

    public void close() throws EmptyPathException {
        this.close(0);
    }

    public abstract void close(int var1) throws EmptyPathException;

    public abstract void close(JDRPathSegment var1) throws EmptyPathException, IllFittingPathException;

    public abstract boolean isClosed();

    public abstract boolean segmentHasEnd(JDRPathSegment var1);

    public abstract int getIndex(JDRPathSegment var1);

    public abstract int getLastIndex(JDRPathSegment var1);

    public abstract JDRPathSegment get(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract JDRPathSegment getLastSegment();

    public abstract JDRPathSegment getFirstSegment();

    public JDRPoint getFirstControl() {
        JDRPathSegment jDRPathSegment = this.getFirstSegment();
        if (jDRPathSegment == null) {
            return null;
        }
        return jDRPathSegment.getStart();
    }

    public JDRPoint getLastControl() {
        JDRPathSegment jDRPathSegment = this.getLastSegment();
        if (jDRPathSegment == null) {
            return null;
        }
        if (this.segmentHasEnd(jDRPathSegment)) {
            return jDRPathSegment.getEnd();
        }
        try {
            return jDRPathSegment.getControl(jDRPathSegment.controlCount() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return jDRPathSegment.getStart();
        }
    }

    public int getControlIndex(JDRPoint jDRPoint) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        int n = 0;
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint2 = jDRPointIterator.next();
            if (jDRPoint2 == jDRPoint) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected abstract void stopEditing();

    public int getControlIndex(Point2D point2D) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        int n = 0;
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint = jDRPointIterator.next();
            if (jDRPoint.contains(point2D)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public abstract int getSelectedControlIndex();

    public JDRPoint selectControl(int n) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        int n2 = 0;
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint = jDRPointIterator.next();
            if (n2 == n) {
                this.selectControl(jDRPoint, n2, jDRPointIterator.getCurrentSegmentIndex());
                return jDRPoint;
            }
            ++n2;
        }
        return null;
    }

    public JDRPoint selectControl(Point point) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        int n = 0;
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint = jDRPointIterator.next();
            if (jDRPoint.contains(point)) {
                this.selectControl(jDRPoint, n, jDRPointIterator.getCurrentSegmentIndex());
                return jDRPoint;
            }
            ++n;
        }
        return null;
    }

    public JDRPoint selectControl(JDRPoint jDRPoint) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        int n = 0;
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint2 = jDRPointIterator.next();
            if (jDRPoint2.contains(jDRPoint)) {
                this.selectControl(jDRPoint2, n, jDRPointIterator.getCurrentSegmentIndex());
                return jDRPoint2;
            }
            ++n;
        }
        return null;
    }

    public JDRPoint selectPreviousControl() {
        int n = this.getSelectedControlIndex();
        int n2 = this.getSelectedIndex();
        JDRPoint jDRPoint = this.getSelectedControl();
        if (n == 0) {
            JDRPointIterator jDRPointIterator = this.getPointIterator();
            while (jDRPointIterator.hasNext()) {
                jDRPoint = jDRPointIterator.next();
            }
            n = jDRPointIterator.getCurrentPointIndex();
            n2 = jDRPointIterator.getCurrentSegmentIndex();
            this.selectControl(jDRPoint, n, n2);
            return jDRPoint;
        }
        JDRPathSegment jDRPathSegment = this.get(n2);
        int n3 = this.segmentHasEnd(jDRPathSegment) && jDRPoint == jDRPathSegment.getEnd() ? jDRPathSegment.controlCount() - 1 : jDRPathSegment.getControlIndex(jDRPoint) - 1;
        if (n3 < 0) {
            n3 = this.segmentHasEnd(jDRPathSegment = this.get(--n2)) ? jDRPathSegment.controlCount() : jDRPathSegment.controlCount() - 1;
        }
        jDRPoint = n3 == jDRPathSegment.controlCount() ? jDRPathSegment.getEnd() : jDRPathSegment.getControl(n3);
        this.selectControl(jDRPoint, --n, n2);
        return jDRPoint;
    }

    public JDRPoint selectNextControl() {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        int n = this.getSelectedControlIndex();
        int n2 = this.getSelectedIndex();
        JDRPoint jDRPoint = this.getSelectedControl();
        try {
            jDRPointIterator.set(n, n2, jDRPoint);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = 0;
            n2 = 0;
            jDRPoint = null;
            jDRPointIterator.reset();
        }
        catch (NoSuchElementException noSuchElementException) {
            n = 0;
            n2 = 0;
            jDRPoint = null;
            jDRPointIterator.reset();
        }
        try {
            jDRPoint = jDRPointIterator.next();
            n = jDRPointIterator.getCurrentPointIndex();
            n2 = jDRPointIterator.getCurrentSegmentIndex();
        }
        catch (NoSuchElementException noSuchElementException) {
            jDRPoint = this.getFirstControl();
            n = 0;
            n2 = 0;
        }
        this.selectControl(jDRPoint, n, n2);
        return jDRPoint;
    }

    protected abstract void selectControl(JDRPoint var1, int var2, int var3);

    public abstract JDRPathSegment getSelectedSegment();

    public abstract JDRPoint getSelectedControl();

    public abstract int getSelectedIndex();

    @Override
    public BBox getBBox() {
        if (this.isEmpty()) {
            return null;
        }
        Rectangle2D rectangle2D = this.getStrokedPath().getBounds2D();
        if (rectangle2D.getWidth() == 0.0 && rectangle2D.getHeight() == 0.0) {
            BBox bBox = null;
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                JDRPathSegment jDRPathSegment = this.get(i);
                if (bBox == null) {
                    bBox = jDRPathSegment.getBBox();
                    continue;
                }
                jDRPathSegment.mergeControlBBox(bBox);
            }
            return bBox;
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = d + rectangle2D.getWidth();
        double d4 = d2 + rectangle2D.getHeight();
        return new BBox(d, d2, d3, d4);
    }

    @Override
    public void mergeBBox(BBox bBox) {
        if (this.isEmpty()) {
            return;
        }
        Rectangle2D rectangle2D = this.getStrokedPath().getBounds2D();
        if (rectangle2D.getWidth() == 0.0 && rectangle2D.getHeight() == 0.0) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                JDRPathSegment jDRPathSegment = this.get(i);
                jDRPathSegment.mergeControlBBox(bBox);
            }
            return;
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = d + rectangle2D.getWidth();
        double d4 = d2 + rectangle2D.getHeight();
        bBox.merge(d, d2, d3, d4);
    }

    @Override
    public BBox getControlBBox() {
        if (this.isEmpty()) {
            return null;
        }
        BBox bBox = null;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            JDRPathSegment jDRPathSegment = this.get(i);
            if (bBox == null) {
                bBox = jDRPathSegment.getControlBBox();
                continue;
            }
            jDRPathSegment.mergeControlBBox(bBox);
        }
        return bBox;
    }

    public void mergeControlBBox(BBox bBox) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            JDRPathSegment jDRPathSegment = this.get(i);
            jDRPathSegment.mergeControlBBox(bBox);
        }
    }

    public Shape getStrokedPath() {
        return this.getStroke().getStrokedPath(this);
    }

    public Area getStrokedArea() {
        return this.getStroke().getStrokedArea(this);
    }

    public abstract GeneralPath getGeneralPath();

    public abstract JDRPathSegment setSegment(int var1, JDRPathSegment var2) throws ArrayIndexOutOfBoundsException;

    public abstract void add(JDRSegment var1);

    public abstract JDRPoint addPoint();

    public abstract void makeContinuous(boolean var1);

    public abstract void convertSegment(int var1, JDRPathSegment var2);

    public abstract JDRPathSegment remove(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract JDRSegment removeSegment(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract JDRPathSegment remove(JDRPathSegment var1);

    public abstract JDRPathSegment removeSelectedSegment();

    public abstract void translateControl(JDRPathSegment var1, JDRPoint var2, double var3, double var5);

    @Override
    public void transform(double[] dArray) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint = jDRPointIterator.next();
            jDRPoint.transform(dArray);
        }
    }

    @Override
    public void translate(double d, double d2) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint = jDRPointIterator.next();
            jDRPoint.translate(d, d2);
        }
    }

    @Override
    public void scale(Point2D point2D, double d, double d2) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint = jDRPointIterator.next();
            jDRPoint.scale(point2D, d, d2);
        }
    }

    @Override
    public void shear(Point2D point2D, double d, double d2) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint = jDRPointIterator.next();
            jDRPoint.shear(point2D, d, d2);
        }
    }

    @Override
    public void rotate(Point2D point2D, double d) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint = jDRPointIterator.next();
            jDRPoint.rotate(point2D, d);
        }
    }

    @Override
    public void drawControls(Graphics graphics, boolean bl) {
        JDRPointIterator jDRPointIterator = this.getPointIterator();
        while (jDRPointIterator.hasNext()) {
            JDRPoint jDRPoint = jDRPointIterator.next();
            jDRPoint.draw(graphics);
        }
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        BBox bBox = null;
        JDRPaint jDRPaint = this.getLinePaint();
        JDRPaint jDRPaint2 = this.getFillPaint();
        if (jDRPaint2 instanceof JDRShading || jDRPaint instanceof JDRShading) {
            bBox = this.getBBox();
        }
        GeneralPath generalPath = this.getGeneralPath();
        if (!(jDRPaint2 instanceof JDRTransparent)) {
            graphics2D.setPaint(jDRPaint2.getPaint(bBox));
            graphics2D.fill(generalPath);
        }
        if (jDRPaint instanceof JDRTransparent) {
            if (this.getStroke() instanceof JDRBasicStroke) {
                ((JDRBasicStroke)this.getStroke()).drawMarkers(this, graphics);
            }
        } else {
            graphics2D.setPaint(jDRPaint.getPaint(bBox));
            this.getStroke().drawPath(this, generalPath, graphics);
        }
    }

    @Override
    public void drawDraft(Graphics graphics) {
        this.drawDraft(graphics, 1.0);
    }

    public void drawDraft(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        GeneralPath generalPath = this.getGeneralPath();
        generalPath.transform(AffineTransform.getScaleInstance(d, d));
        graphics2D.setPaint(draftColor);
        graphics2D.draw(generalPath);
        JDRPathSegment jDRPathSegment = this.getSelectedSegment();
        if (jDRPathSegment != null) {
            jDRPathSegment.drawSelectedNoControls(graphics, d);
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            jDRPathSegment = this.get(i);
            jDRPathSegment.drawControls(graphics, this.segmentHasEnd(jDRPathSegment), d);
        }
    }

    public void fill(Graphics graphics) {
        if (this.isEmpty()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        GeneralPath generalPath = this.getGeneralPath();
        graphics2D.fill(generalPath);
    }

    public String pgfPath(AffineTransform affineTransform) {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        JDRPathSegment jDRPathSegment = this.get(0);
        string2 = string2 + "\\pgfpathmoveto{" + jDRPathSegment.getStart().pgf(affineTransform) + "}" + string;
        JDRPathIterator jDRPathIterator = this.getIterator();
        while (jDRPathIterator.hasNext()) {
            jDRPathSegment = jDRPathIterator.next();
            string2 = string2 + jDRPathSegment.pgf(affineTransform) + string;
        }
        if (this.isClosed()) {
            string2 = string2 + "\\pgfclosepath" + string;
        }
        return string2;
    }

    public abstract JDRShape getFullPath() throws EmptyPathException, IllFittingPathException;

    public abstract boolean showPath();

    public abstract void setLinePaint(JDRPaint var1);

    public abstract JDRPaint getLinePaint();

    public abstract void setFillPaint(JDRPaint var1);

    public abstract JDRPaint getFillPaint();

    public abstract void setStroke(JDRStroke var1);

    public abstract JDRStroke getStroke();

    public JDRPathStyleListener getPathStyleListener() {
        return this.getStroke().getPathStyleListener();
    }

    protected abstract void setSelectedElements(int var1, int var2, JDRPathSegment var3, JDRPoint var4);

    protected static void printGeneralPath(GeneralPath generalPath) {
        int n;
        PathIterator pathIterator = generalPath.getPathIterator(null);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 4: {
                    System.out.println("Close sub-path");
                    break;
                }
                case 3: {
                    System.out.println("Cubic to: (" + dArray[0] + "," + dArray[1] + ") " + "(" + dArray[2] + "," + dArray[3] + ") " + "(" + dArray[4] + "," + dArray[5] + ")");
                    break;
                }
                case 1: {
                    System.out.println("Line to: (" + dArray[0] + "," + dArray[1] + ")");
                    break;
                }
                case 0: {
                    System.out.println("Move to: (" + dArray[0] + "," + dArray[1] + ")");
                    break;
                }
                case 2: {
                    System.out.println("Quad to: (" + dArray[0] + "," + dArray[1] + ") " + "(" + dArray[2] + "," + dArray[3] + ")");
                }
            }
            pathIterator.next();
        }
        n = pathIterator.getWindingRule();
        System.out.println("Winding rule: " + (n == 0 ? "Even-Odd" : "Non-Zero"));
    }

    @Override
    public String[] getDescriptionInfo() {
        return new String[]{"" + this.size()};
    }

    @Override
    public boolean hasShape() {
        return true;
    }
}

