/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import java.util.Enumeration;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidSegmentIDException;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRSegmentLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRSegmentLoader {
    private Vector<JDRSegmentLoaderListener> listeners_ = new Vector();

    public void saveJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        dataOutputStream.writeChar(jDRObject.getListener().getJDRid(f));
        jDRObject.getListener().writeJDR(jDRObject, dataOutputStream, f);
    }

    public JDRObject loadJDR(double d, double d2, DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        char c = dataInputStream.readChar();
        Enumeration<JDRSegmentLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRSegmentLoaderListener jDRSegmentLoaderListener = enumeration.nextElement();
            if (jDRSegmentLoaderListener.getJDRid(f) != c) continue;
            return jDRSegmentLoaderListener.readJDR(d, d2, dataInputStream, f);
        }
        throw new InvalidSegmentIDException(c);
    }

    public JDRObject loadJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        char c = dataInputStream.readChar();
        Enumeration<JDRSegmentLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRSegmentLoaderListener jDRSegmentLoaderListener = enumeration.nextElement();
            if (jDRSegmentLoaderListener.getJDRid(f) != c) continue;
            return jDRSegmentLoaderListener.readJDR(dataInputStream, f);
        }
        throw new InvalidSegmentIDException(c);
    }

    public void saveAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        AJR.writeChar(printWriter, jDRObject.getListener().getAJRid(f));
        jDRObject.getListener().writeAJR(jDRObject, printWriter, f);
    }

    public JDRObject loadAJR(double d, double d2, BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        char c = AJR.readChar(bufferedReader);
        Enumeration<JDRSegmentLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRSegmentLoaderListener jDRSegmentLoaderListener = enumeration.nextElement();
            if (jDRSegmentLoaderListener.getAJRid(f) != c) continue;
            return jDRSegmentLoaderListener.readAJR(d, d2, bufferedReader, f);
        }
        throw new InvalidSegmentIDException(c, AJR.getLineNum());
    }

    public JDRObject loadAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        char c = AJR.readChar(bufferedReader);
        Enumeration<JDRSegmentLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRSegmentLoaderListener jDRSegmentLoaderListener = enumeration.nextElement();
            if (jDRSegmentLoaderListener.getAJRid(f) != c) continue;
            return jDRSegmentLoaderListener.readAJR(bufferedReader, f);
        }
        throw new InvalidSegmentIDException(c, AJR.getLineNum());
    }

    public void addListener(JDRSegmentLoaderListener jDRSegmentLoaderListener) {
        this.listeners_.add(jDRSegmentLoaderListener);
    }

    public Vector<JDRSegmentLoaderListener> getListeners() {
        return this.listeners_;
    }
}

