/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRSegmentLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class JDRSegment
extends JDRObject
implements JDRPathSegment {
    protected JDRMarker startMarker = null;
    protected JDRMarker endMarker = null;
    public static Stroke guideStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{1.0f, 5.0f}, 0.0f);
    protected JDRPoint start;
    protected JDRPoint end;
    private static JDRSegmentLoaderListener listener = new JDRSegmentLoaderListener();

    public JDRSegment() {
        this.init(new JDRPoint(0.0, 0.0), new JDRPoint(0.0, 0.0));
    }

    public JDRSegment(double d, double d2, double d3, double d4) {
        this.init(d, d2, d3, d4);
    }

    public JDRSegment(Point point, Point point2) {
        this.init(point, point2);
    }

    public JDRSegment(Point2D point2D, Point2D point2D2) {
        this.init(point2D, point2D2);
    }

    public JDRSegment(JDRPoint jDRPoint, JDRPoint jDRPoint2) {
        this.init(jDRPoint, jDRPoint2);
    }

    private void init(double d, double d2, double d3, double d4) {
        this.start = new JDRPoint(d, d2);
        this.end = new JDRPoint(d3, d4);
    }

    private void init(Point point, Point point2) {
        this.start = new JDRPoint(point);
        this.end = new JDRPoint(point2);
    }

    private void init(Point2D point2D, Point2D point2D2) {
        this.start = new JDRPoint(point2D);
        this.end = new JDRPoint(point2D2);
    }

    private void init(JDRPoint jDRPoint, JDRPoint jDRPoint2) {
        this.start = jDRPoint;
        this.end = jDRPoint2;
    }

    @Override
    public JDRSegment reverse() {
        JDRSegment jDRSegment = (JDRSegment)this.clone();
        jDRSegment.start.x = this.end.x;
        jDRSegment.start.y = this.end.y;
        jDRSegment.end.x = this.start.x;
        jDRSegment.end.y = this.start.y;
        return jDRSegment;
    }

    @Override
    public void rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.start.x;
        double d5 = this.start.y;
        this.start.x = d4 * d2 - d5 * d3;
        this.start.y = d4 * d3 + d5 * d2;
        d4 = this.end.x;
        d5 = this.end.y;
        this.end.x = d4 * d2 - d5 * d3;
        this.end.y = d4 * d3 + d5 * d2;
    }

    public void rotate(Point2D point2D, double d, boolean bl) {
        this.start.rotate(point2D, d);
        if (bl) {
            this.end.rotate(point2D, d);
        }
    }

    @Override
    public void scale(double d, double d2) {
        this.start.x = d * this.start.x;
        this.start.y = d2 * this.start.y;
        this.end.x = d * this.end.x;
        this.end.y = d2 * this.end.y;
    }

    @Override
    public void scaleX(double d) {
        this.start.x = d * this.start.x;
        this.end.x = d * this.end.x;
    }

    @Override
    public void scaleY(double d) {
        this.start.y = d * this.start.y;
        this.end.y = d * this.end.y;
    }

    public void scale(Point2D point2D, double d, double d2, boolean bl) {
        this.start.scale(point2D, d, d2);
        if (bl) {
            this.end.scale(point2D, d, d2);
        }
    }

    @Override
    public void shear(double d, double d2) {
        this.start.shear(d, d2);
        this.end.shear(d, d2);
    }

    public void shear(Point2D point2D, double d, double d2, boolean bl) {
        this.start.shear(point2D, d, d2);
        if (bl) {
            this.end.shear(point2D, d, d2);
        }
    }

    @Override
    public void translate(double d, double d2) {
        this.start.translate(d, d2);
        this.end.translate(d, d2);
    }

    public void translate(double d, double d2, boolean bl) {
        this.start.translate(d, d2);
        if (bl) {
            this.end.translate(d, d2);
        }
    }

    @Override
    public void transform(double[] dArray) {
        this.start.transform(dArray);
        this.end.transform(dArray);
    }

    @Override
    public JDRPathSegment getReflection(JDRLine jDRLine) {
        Point2D point2D = this.start.getReflection(jDRLine);
        Point2D point2D2 = this.end.getReflection(jDRLine);
        return new JDRSegment(point2D, point2D2);
    }

    public BBox getReflectedBBox(JDRLine jDRLine) {
        Point2D point2D = this.end.getReflection(jDRLine);
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        int n = this.controlCount();
        for (int i = 0; i < n; ++i) {
            point2D = this.getControl(i).getReflection(jDRLine);
            if (point2D.getX() < d) {
                d = point2D.getX();
            } else if (point2D.getX() > d3) {
                d3 = point2D.getX();
            }
            if (point2D.getY() < d2) {
                d2 = point2D.getY();
                continue;
            }
            if (!(point2D.getY() > d4)) continue;
            d4 = point2D.getY();
        }
        point2D = null;
        return new BBox(d, d2, d3, d4);
    }

    public void mergeReflectedBBox(JDRLine jDRLine, BBox bBox) {
        double d = bBox.getMinX();
        double d2 = bBox.getMinY();
        double d3 = bBox.getMaxX();
        double d4 = bBox.getMaxY();
        Point2D point2D = this.end.getReflection(jDRLine);
        if (point2D.getX() < d) {
            d = point2D.getX();
        } else if (point2D.getX() > d3) {
            d3 = point2D.getX();
        }
        if (point2D.getY() < d2) {
            d2 = point2D.getY();
        } else if (point2D.getY() > d4) {
            d4 = point2D.getY();
        }
        int n = this.controlCount();
        for (int i = 0; i < n; ++i) {
            point2D = this.getControl(i).getReflection(jDRLine);
            if (point2D.getX() < d) {
                d = point2D.getX();
            } else if (point2D.getX() > d3) {
                d3 = point2D.getX();
            }
            if (point2D.getY() < d2) {
                d2 = point2D.getY();
                continue;
            }
            if (!(point2D.getY() > d4)) continue;
            d4 = point2D.getY();
        }
        point2D = null;
        bBox.reset(d, d2, d3, d4);
    }

    @Override
    public BBox getBBox() {
        double d = this.end.x;
        double d2 = this.end.y;
        double d3 = this.end.x;
        double d4 = this.end.y;
        int n = this.controlCount();
        for (int i = 0; i < n; ++i) {
            JDRPoint jDRPoint = this.getControl(i);
            if (jDRPoint.x < d) {
                d = jDRPoint.x;
            } else if (jDRPoint.x > d3) {
                d3 = jDRPoint.x;
            }
            if (jDRPoint.y < d2) {
                d2 = jDRPoint.y;
                continue;
            }
            if (!(jDRPoint.y > d4)) continue;
            d4 = jDRPoint.y;
        }
        return new BBox(d, d2, d3, d4);
    }

    @Override
    public void mergeBBox(BBox bBox) {
        double d = this.end.x;
        double d2 = this.end.y;
        double d3 = this.end.x;
        double d4 = this.end.y;
        int n = this.controlCount();
        for (int i = 0; i < n; ++i) {
            JDRPoint jDRPoint = this.getControl(i);
            if (jDRPoint.x < d) {
                d = jDRPoint.x;
            } else if (jDRPoint.x > d3) {
                d3 = jDRPoint.x;
            }
            if (jDRPoint.y < d2) {
                d2 = jDRPoint.y;
                continue;
            }
            if (!(jDRPoint.y > d4)) continue;
            d4 = jDRPoint.y;
        }
        bBox.merge(d, d2, d3, d4);
    }

    @Override
    public BBox getControlBBox() {
        BBox bBox = this.end.getBBox();
        int n = this.controlCount();
        for (int i = 0; i < n; ++i) {
            JDRPoint jDRPoint = this.getControl(i);
            jDRPoint.mergeBBox(bBox);
        }
        return bBox;
    }

    @Override
    public void mergeControlBBox(BBox bBox) {
        this.end.mergeBBox(bBox);
        int n = this.controlCount();
        for (int i = 0; i < n; ++i) {
            JDRPoint jDRPoint = this.getControl(i);
            jDRPoint.mergeBBox(bBox);
        }
    }

    @Override
    public Point2D getdP(double d) {
        return this.getdP();
    }

    @Override
    public Point2D getdP() {
        return new Point2D.Double(this.end.x - this.start.x, this.end.y - this.start.y);
    }

    @Override
    public Point2D getdP0() {
        return this.getdP();
    }

    @Override
    public Point2D getdP1() {
        return this.getdP();
    }

    @Override
    public Point2D getP(double d) {
        return new Point2D.Double(this.start.x + (this.end.x - this.start.x) * d, this.start.y + (this.end.y - this.start.y) * d);
    }

    public double getY(double d) {
        double d2;
        double d3 = this.getStartX();
        double d4 = this.getEndX();
        double d5 = this.getStartY();
        double d6 = d5 + (d - d3) * ((d2 = this.getEndY()) - d5) / (d4 - d3);
        if (Double.isNaN(d6)) {
            return d5;
        }
        return d6;
    }

    public double getX(double d) {
        double d2;
        double d3 = this.getStartX();
        double d4 = this.getEndX();
        double d5 = this.getStartY();
        double d6 = d3 + (d - d5) * (d4 - d3) / ((d2 = this.getEndY()) - d5);
        if (Double.isNaN(d6)) {
            return d3;
        }
        return d6;
    }

    @Override
    public void drawControls(Graphics graphics, boolean bl) {
        this.start.draw(graphics);
        if (bl) {
            this.end.draw(graphics);
        }
    }

    @Override
    public void drawControls(Graphics graphics, boolean bl, double d) {
        this.start.draw(graphics, d);
        if (bl) {
            this.end.draw(graphics, d);
        }
    }

    public void drawEndPoint(Graphics graphics) {
        this.end.draw(graphics);
    }

    public void drawStartPoint(Graphics graphics) {
        this.start.draw(graphics);
    }

    @Override
    public void draw(Graphics graphics, double d) {
    }

    @Override
    public void draw(Graphics graphics) {
    }

    @Override
    public void drawSelectedNoControls(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(this.start.getSelectedPaint());
        graphics2D.setStroke(guideStroke);
        graphics2D.drawLine((int)(this.start.x * d), (int)(this.start.y * d), (int)(this.end.x * d), (int)(this.end.y * d));
        graphics2D.setStroke(stroke);
    }

    @Override
    public void drawDraft(Graphics graphics, double d, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isSelected()) {
            this.drawSelectedNoControls(graphics, d);
        }
        this.start.draw(graphics, d);
        if (bl) {
            this.end.draw(graphics, d);
        }
    }

    @Override
    public JDRPathSegment split() {
        JDRPoint jDRPoint = new JDRPoint(this.getP(0.5));
        JDRSegment jDRSegment = new JDRSegment(jDRPoint, this.end);
        this.end = jDRPoint;
        return jDRSegment;
    }

    @Override
    public Object clone() {
        JDRSegment jDRSegment = new JDRSegment((JDRPoint)this.start.clone(), (JDRPoint)this.end.clone());
        jDRSegment.makeEqual(this);
        return jDRSegment;
    }

    public void makeEqual(JDRSegment jDRSegment) {
        super.makeEqual(jDRSegment);
        this.start.makeEqual(jDRSegment.start);
        this.end.makeEqual(jDRSegment.end);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof JDRSegment)) {
            return false;
        }
        JDRSegment jDRSegment = (JDRSegment)object;
        return this.start.equals(jDRSegment.start) && this.end.equals(jDRSegment.end);
    }

    @Override
    public JDRPoint getStart() {
        return this.start;
    }

    @Override
    public double getStartX() {
        return this.start.x;
    }

    @Override
    public double getStartY() {
        return this.start.y;
    }

    @Override
    public double getEndX() {
        return this.end.x;
    }

    @Override
    public double getEndY() {
        return this.end.y;
    }

    @Override
    public JDRPoint getEnd() {
        return this.end;
    }

    @Override
    public void setStart(JDRPoint jDRPoint) {
        this.start = jDRPoint;
    }

    @Override
    public void setStart(Point2D point2D) {
        this.start.x = point2D.getX();
        this.start.y = point2D.getY();
    }

    @Override
    public void setEnd(JDRPoint jDRPoint) {
        this.end = jDRPoint;
    }

    public void setStart(double d, double d2) {
        this.start.x = d;
        this.start.y = d2;
    }

    public void setEnd(double d, double d2) {
        this.end.x = d;
        this.end.y = d2;
    }

    @Override
    public void setEditedControls(boolean bl) {
        this.start.selected = bl;
        this.end.selected = bl;
    }

    @Override
    public JDRPoint getControl(Point point, boolean bl) {
        if (this.start.contains(point)) {
            return this.start;
        }
        if (bl && this.end.contains(point)) {
            return this.end;
        }
        return null;
    }

    @Override
    public void setSelected(boolean bl) {
        this.selected = bl;
        if (!bl) {
            this.start.selected = false;
            this.end.selected = false;
        }
    }

    public JDRPoint getEditedControl() {
        if (this.start.selected) {
            return this.start;
        }
        if (this.end.selected) {
            return this.end;
        }
        return null;
    }

    @Override
    public JDRPathSegment convertToLine() {
        return new JDRLine(this.start, this.end);
    }

    @Override
    public JDRPathSegment convertToSegment() {
        return new JDRSegment(this.start, this.end);
    }

    @Override
    public JDRPathSegment convertToBezier() {
        JDRBezier jDRBezier = new JDRBezier(this.start, this.end);
        return jDRBezier;
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        printWriter.print("M ");
        this.end.saveSVG(printWriter);
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        this.end.saveEPS(printWriter);
        printWriter.println("moveto");
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        return "\\pgfpathmoveto{" + this.end.pgf(affineTransform) + "}";
    }

    @Override
    public void appendToGeneralPath(GeneralPath generalPath) {
        generalPath.moveTo((float)this.end.x, (float)this.end.y);
    }

    public void appendReflectionToGeneralPath(GeneralPath generalPath, JDRLine jDRLine) {
        Point2D point2D = this.start.getReflection(jDRLine);
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
    }

    public String toString() {
        return "JDRSegment:(" + this.start.x + "," + this.start.y + ")(" + this.end.x + "," + this.end.y + "),startMarker=" + this.startMarker + ",endMarker=" + this.endMarker;
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return listener;
    }

    public String info() {
        return "segment[" + this.start.info() + "," + this.end.info() + "]";
    }

    @Override
    public JDRMarker getStartMarker() {
        return this.startMarker;
    }

    @Override
    public JDRMarker getEndMarker() {
        return this.endMarker;
    }

    @Override
    public void setStartMarker(JDRMarker jDRMarker) {
        this.startMarker = jDRMarker;
    }

    @Override
    public void setEndMarker(JDRMarker jDRMarker) {
        this.endMarker = jDRMarker;
    }

    @Override
    public int controlCount() {
        return 1;
    }

    @Override
    public JDRPoint getControl(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.start;
        }
        throw new IndexOutOfBoundsException("No control point at index " + n);
    }

    @Override
    public int getControlIndex(JDRPoint jDRPoint) throws NoSuchElementException {
        if (jDRPoint == this.start) {
            return 0;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean isGap() {
        return true;
    }
}

