/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAdjustPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAnchorPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRScaledPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class JDRScaledPatternListener
extends JDRPathListener {
    @Override
    public char getJDRid(float f) {
        return (double)f < 1.6 ? (char)'G' : 'C';
    }

    @Override
    public char getAJRid(float f) {
        return (double)f < 1.6 ? (char)'G' : 'C';
    }

    @Override
    public void writeJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRScaledPattern jDRScaledPattern = (JDRScaledPattern)jDRObject;
        JDRObjectLoader jDRObjectLoader = JDR.getObjectLoader();
        if ((double)f < 1.6) {
            JDRGroup jDRGroup = jDRScaledPattern.separate(null);
            JDRObjectLoaderListener jDRObjectLoaderListener = jDRGroup.getListener();
            jDRObjectLoaderListener.writeJDR(jDRGroup, dataOutputStream, f);
        } else {
            jDRObjectLoader.saveJDR(jDRScaledPattern.getUnderlyingShape(), dataOutputStream, f);
            JDRPoint jDRPoint = jDRScaledPattern.getPatternAnchor();
            dataOutputStream.writeDouble(jDRPoint.x);
            dataOutputStream.writeDouble(jDRPoint.y);
            JDRPoint jDRPoint2 = jDRScaledPattern.getPatternAdjust();
            if (jDRPoint2 == null) {
                jDRPoint2 = jDRPoint;
            }
            dataOutputStream.writeDouble(jDRPoint2.x);
            dataOutputStream.writeDouble(jDRPoint2.y);
            dataOutputStream.writeDouble(jDRScaledPattern.getScaleX());
            dataOutputStream.writeDouble(jDRScaledPattern.getScaleY());
            dataOutputStream.writeInt(jDRScaledPattern.getNumReplicas());
            dataOutputStream.writeBoolean(jDRScaledPattern.isSinglePath());
            dataOutputStream.writeBoolean(jDRScaledPattern.showOriginal());
        }
    }

    @Override
    public JDRObject readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        JDRObjectLoader jDRObjectLoader = JDR.getObjectLoader();
        JDRObject jDRObject = jDRObjectLoader.loadJDR(dataInputStream, f);
        if (!(jDRObject instanceof JDRShape)) {
            throw new InvalidFormatException("Shape specs expected for underlying scaled pattern object.");
        }
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        double d3 = dataInputStream.readDouble();
        double d4 = dataInputStream.readDouble();
        double d5 = dataInputStream.readDouble();
        double d6 = dataInputStream.readDouble();
        int n = dataInputStream.readInt();
        boolean bl = dataInputStream.readBoolean();
        boolean bl2 = dataInputStream.readBoolean();
        return new JDRScaledPattern((JDRShape)jDRObject, new JDRPatternAnchorPoint(d, d2), new JDRPatternAdjustPoint(d3, d4), d5, d6, n, bl, bl2);
    }

    @Override
    public void writeAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRScaledPattern jDRScaledPattern = (JDRScaledPattern)jDRObject;
        JDRObjectLoader jDRObjectLoader = AJR.getObjectLoader();
        if ((double)f < 1.6) {
            JDRGroup jDRGroup = jDRScaledPattern.separate(null);
            JDRObjectLoaderListener jDRObjectLoaderListener = jDRGroup.getListener();
            jDRObjectLoaderListener.writeAJR(jDRGroup, printWriter, f);
        } else {
            jDRObjectLoader.saveAJR(jDRScaledPattern.getUnderlyingShape(), printWriter, f);
            JDRPoint jDRPoint = jDRScaledPattern.getPatternAnchor();
            AJR.writeDouble(printWriter, jDRPoint.x);
            AJR.writeDouble(printWriter, jDRPoint.y);
            JDRPoint jDRPoint2 = jDRScaledPattern.getPatternAdjust();
            if (jDRPoint2 == null) {
                jDRPoint2 = jDRPoint;
            }
            AJR.writeDouble(printWriter, jDRPoint2.x);
            AJR.writeDouble(printWriter, jDRPoint2.y);
            AJR.writeDouble(printWriter, jDRScaledPattern.getScaleX());
            AJR.writeDouble(printWriter, jDRScaledPattern.getScaleY());
            AJR.writeInt(printWriter, jDRScaledPattern.getNumReplicas());
            AJR.writeBoolean(printWriter, jDRScaledPattern.isSinglePath());
            AJR.writeBoolean(printWriter, jDRScaledPattern.showOriginal());
            printWriter.println();
        }
    }

    @Override
    public JDRObject readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        JDRObjectLoader jDRObjectLoader = AJR.getObjectLoader();
        JDRObject jDRObject = jDRObjectLoader.loadAJR(bufferedReader, f);
        if (!(jDRObject instanceof JDRShape)) {
            throw new InvalidFormatException("Shape specs expected for underlying scaled pattern object", AJR.getLineNum());
        }
        double d = AJR.readDouble(bufferedReader);
        double d2 = AJR.readDouble(bufferedReader);
        double d3 = AJR.readDouble(bufferedReader);
        double d4 = AJR.readDouble(bufferedReader);
        double d5 = AJR.readDouble(bufferedReader);
        double d6 = AJR.readDouble(bufferedReader);
        int n = AJR.readInt(bufferedReader);
        boolean bl = AJR.readBoolean(bufferedReader);
        boolean bl2 = AJR.readBoolean(bufferedReader);
        return new JDRScaledPattern((JDRShape)jDRObject, new JDRPatternAnchorPoint(d, d2), new JDRPatternAdjustPoint(d3, d4), d5, d6, n, bl, bl2);
    }
}

