/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import uk.ac.uea.cmp.nlct.jdr.InvalidReplicaException;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAdjustPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAnchorPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRScaledPatternListener;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;

public class JDRScaledPattern
extends JDRPattern {
    private double scalex_;
    private double scaley_;
    private static JDRPathListener shapeListener = new JDRScaledPatternListener();

    public JDRScaledPattern(JDRShape jDRShape, JDRPoint jDRPoint, JDRPoint jDRPoint2, double d, double d2, int n, boolean bl) throws InvalidReplicaException {
        this.setNumReplicas(n);
        this.setPatternAnchor(jDRPoint);
        this.setPatternAdjust(jDRPoint2);
        this.path_ = jDRShape;
        this.singlemode_ = bl;
        this.scalex_ = d;
        this.scaley_ = d2;
        this.initIterators();
    }

    public JDRScaledPattern(JDRShape jDRShape, JDRPoint jDRPoint, JDRPoint jDRPoint2, double d, double d2, int n, boolean bl, boolean bl2) throws InvalidReplicaException {
        this.setNumReplicas(n);
        this.setPatternAnchor(jDRPoint);
        this.setPatternAdjust(jDRPoint2);
        this.path_ = jDRShape;
        this.singlemode_ = bl;
        this.showoriginal_ = bl2;
        this.scalex_ = d;
        this.scaley_ = d2;
        this.initIterators();
    }

    public JDRScaledPattern(JDRShape jDRShape, JDRPoint jDRPoint, double d, double d2, int n, boolean bl) throws InvalidReplicaException {
        this.path_ = jDRShape;
        this.setNumReplicas(n);
        this.setPatternAnchor(jDRPoint);
        this.setDefaultPatternAdjust();
        this.singlemode_ = bl;
        this.scalex_ = d;
        this.scaley_ = d2;
        this.initIterators();
    }

    public JDRScaledPattern(JDRShape jDRShape, JDRPoint jDRPoint, double d, double d2, int n, boolean bl, boolean bl2) throws InvalidReplicaException {
        this.path_ = jDRShape;
        this.setNumReplicas(n);
        this.setPatternAnchor(jDRPoint);
        this.setDefaultPatternAdjust();
        this.singlemode_ = bl;
        this.showoriginal_ = bl2;
        this.scalex_ = d;
        this.scaley_ = d2;
        this.initIterators();
    }

    public JDRScaledPattern() {
        this.path_ = new JDRPath();
        this.point_ = new JDRPatternAnchorPoint();
        this.adjust_ = new JDRPatternAdjustPoint();
        this.replicas_ = 1;
        this.singlemode_ = true;
        this.scalex_ = 2.0;
        this.scaley_ = 2.0;
        this.initIterators();
    }

    public JDRScaledPattern(int n, JDRPaint jDRPaint, JDRPaint jDRPaint2, JDRStroke jDRStroke) {
        this.path_ = new JDRPath(n, jDRPaint, jDRPaint2, jDRStroke);
        this.point_ = new JDRPatternAnchorPoint();
        this.adjust_ = new JDRPatternAdjustPoint();
        this.replicas_ = 1;
        this.singlemode_ = true;
        this.scalex_ = 2.0;
        this.scaley_ = 2.0;
        this.initIterators();
    }

    @Override
    public boolean hasAdjust() {
        return true;
    }

    @Override
    public JDRPattern createTemplate() {
        try {
            return new JDRScaledPattern(null, null, null, this.scalex_, this.scaley_, this.replicas_, this.singlemode_);
        }
        catch (InvalidReplicaException invalidReplicaException) {
            return null;
        }
    }

    @Override
    public void makeParametersEqual(JDRPattern jDRPattern) {
        JDRScaledPattern jDRScaledPattern = (JDRScaledPattern)jDRPattern;
        this.scalex_ = jDRScaledPattern.scalex_;
        this.scaley_ = jDRScaledPattern.scaley_;
    }

    @Override
    public void getReplicaTransform(double[] dArray, int n) {
        if (n == 1) {
            dArray[0] = this.scalex_;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
            dArray[3] = this.scaley_;
            dArray[4] = this.point_.x * (1.0 - this.scalex_);
            dArray[5] = this.point_.y * (1.0 - this.scaley_);
            return;
        }
        double d = (double)n * this.scalex_;
        double d2 = (double)n * this.scaley_;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.adjust_ != null && this.path_ != null) {
            JDRPoint jDRPoint = this.path_.getFirstControl();
            d3 = this.adjust_.x - this.scalex_ * jDRPoint.x + this.point_.x * (this.scalex_ - 1.0);
            d4 = this.adjust_.y - this.scaley_ * jDRPoint.y + this.point_.y * (this.scaley_ - 1.0);
        }
        int n2 = n - 1;
        dArray[0] = d;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        dArray[3] = d2;
        dArray[4] = this.point_.x * (1.0 - d) + d3 * (double)n2;
        dArray[5] = this.point_.y * (1.0 - d2) + d4 * (double)n2;
    }

    @Override
    public void translateAdjust(double d, double d2) {
        if (this.adjust_ != null) {
            this.adjust_.translate(d, d2);
            if (this.path_ != null) {
                JDRPoint jDRPoint = this.path_.getFirstControl();
                this.adjust_.moveToLine(this.point_.x, this.point_.y, this.scalex_ * jDRPoint.x + this.point_.x * (1.0 - this.scalex_), this.scaley_ * jDRPoint.y + this.point_.y * (1.0 - this.scaley_));
            }
        }
    }

    @Override
    public void translateAnchor(double d, double d2) {
        this.point_.translate(d, d2);
        this.translateAdjust(-d, -d2);
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return shapeListener;
    }

    public String toString() {
        String string = "ScaledPattern: point=" + this.point_ + ", scalex: " + this.scalex_ + ", scalex: " + this.scaley_ + ", replicas: " + this.replicas_ + ", size=" + this.size() + ", segments=[";
        for (int i = 0; i < this.size(); ++i) {
            string = string + this.get(i) + ",";
        }
        string = string + "]";
        return string;
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "ScaledPattern:" + string;
        string2 = string2 + "point of rotation: " + this.point_.info() + string;
        string2 = string2 + "x scale factor: " + this.scalex_ + string;
        string2 = string2 + "y scale factor: " + this.scaley_ + string;
        string2 = string2 + "replicas: " + this.replicas_;
        string2 = string2 + "Underlying shape:" + this.path_.info();
        return string2;
    }

    public double getScaleX() {
        return this.scalex_;
    }

    public double getScaleY() {
        return this.scaley_;
    }

    public void setScaleX(double d) {
        this.scalex_ = d;
    }

    public void setScaleY(double d) {
        this.scaley_ = d;
    }

    public void setScale(double d, double d2) {
        this.scalex_ = this.scalex_;
        this.scaley_ = d2;
    }

    @Override
    public String[] getDescriptionInfo() {
        return new String[]{"" + this.replicas_, "" + this.scalex_ + ", " + this.scaley_};
    }
}

