/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAnchorPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRRotationalPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class JDRRotationalPatternListener
extends JDRPathListener {
    @Override
    public char getJDRid(float f) {
        return (double)f < 1.6 ? (char)'G' : 'R';
    }

    @Override
    public char getAJRid(float f) {
        return (double)f < 1.6 ? (char)'G' : 'R';
    }

    @Override
    public void writeJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRRotationalPattern jDRRotationalPattern = (JDRRotationalPattern)jDRObject;
        JDRObjectLoader jDRObjectLoader = JDR.getObjectLoader();
        if ((double)f < 1.6) {
            JDRGroup jDRGroup = jDRRotationalPattern.separate(null);
            JDRObjectLoaderListener jDRObjectLoaderListener = jDRGroup.getListener();
            jDRObjectLoaderListener.writeJDR(jDRGroup, dataOutputStream, f);
        } else {
            jDRObjectLoader.saveJDR(jDRRotationalPattern.getUnderlyingShape(), dataOutputStream, f);
            JDRPoint jDRPoint = jDRRotationalPattern.getPatternAnchor();
            dataOutputStream.writeDouble(jDRPoint.x);
            dataOutputStream.writeDouble(jDRPoint.y);
            dataOutputStream.writeDouble(jDRRotationalPattern.getRotationAngle());
            dataOutputStream.writeInt(jDRRotationalPattern.getNumReplicas());
            dataOutputStream.writeBoolean(jDRRotationalPattern.isSinglePath());
            dataOutputStream.writeBoolean(jDRRotationalPattern.showOriginal());
        }
    }

    @Override
    public JDRObject readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        JDRObjectLoader jDRObjectLoader = JDR.getObjectLoader();
        JDRObject jDRObject = jDRObjectLoader.loadJDR(dataInputStream, f);
        if (!(jDRObject instanceof JDRShape)) {
            throw new InvalidFormatException("Shape specs expected for underlying rotational pattern object.");
        }
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        double d3 = dataInputStream.readDouble();
        int n = dataInputStream.readInt();
        boolean bl = dataInputStream.readBoolean();
        boolean bl2 = dataInputStream.readBoolean();
        return new JDRRotationalPattern((JDRShape)jDRObject, new JDRPatternAnchorPoint(d, d2), d3, n, bl, bl2);
    }

    @Override
    public void writeAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRRotationalPattern jDRRotationalPattern = (JDRRotationalPattern)jDRObject;
        JDRObjectLoader jDRObjectLoader = AJR.getObjectLoader();
        if ((double)f < 1.6) {
            JDRGroup jDRGroup = jDRRotationalPattern.separate(null);
            JDRObjectLoaderListener jDRObjectLoaderListener = jDRGroup.getListener();
            jDRObjectLoaderListener.writeAJR(jDRGroup, printWriter, f);
        } else {
            jDRObjectLoader.saveAJR(jDRRotationalPattern.getUnderlyingShape(), printWriter, f);
            JDRPoint jDRPoint = jDRRotationalPattern.getPatternAnchor();
            AJR.writeDouble(printWriter, jDRPoint.x);
            AJR.writeDouble(printWriter, jDRPoint.y);
            AJR.writeDouble(printWriter, jDRRotationalPattern.getRotationAngle());
            AJR.writeInt(printWriter, jDRRotationalPattern.getNumReplicas());
            AJR.writeBoolean(printWriter, jDRRotationalPattern.isSinglePath());
            AJR.writeBoolean(printWriter, jDRRotationalPattern.showOriginal());
            printWriter.println();
        }
    }

    @Override
    public JDRObject readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        JDRObjectLoader jDRObjectLoader = AJR.getObjectLoader();
        JDRObject jDRObject = jDRObjectLoader.loadAJR(bufferedReader, f);
        if (!(jDRObject instanceof JDRShape)) {
            throw new InvalidFormatException("Shape specs expected for underlying rotational pattern object", AJR.getLineNum());
        }
        double d = AJR.readDouble(bufferedReader);
        double d2 = AJR.readDouble(bufferedReader);
        double d3 = AJR.readDouble(bufferedReader);
        int n = AJR.readInt(bufferedReader);
        boolean bl = AJR.readBoolean(bufferedReader);
        boolean bl2 = AJR.readBoolean(bufferedReader);
        return new JDRRotationalPattern((JDRShape)jDRObject, new JDRPatternAnchorPoint(d, d2), d3, n, bl, bl2);
    }
}

