/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import uk.ac.uea.cmp.nlct.jdr.InvalidReplicaException;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAnchorPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRRotationalPatternListener;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;

public class JDRRotationalPattern
extends JDRPattern {
    private double angle_;
    private static JDRPathListener shapeListener = new JDRRotationalPatternListener();

    public JDRRotationalPattern(JDRShape jDRShape, JDRPoint jDRPoint, double d, int n, boolean bl) throws InvalidReplicaException {
        this.setNumReplicas(n);
        this.path_ = jDRShape;
        this.setPatternAnchor(jDRPoint);
        this.angle_ = d;
        this.singlemode_ = bl;
        this.initIterators();
    }

    public JDRRotationalPattern(JDRShape jDRShape, JDRPoint jDRPoint, double d, int n, boolean bl, boolean bl2) throws InvalidReplicaException {
        this.setNumReplicas(n);
        this.path_ = jDRShape;
        this.setPatternAnchor(jDRPoint);
        this.angle_ = d;
        this.singlemode_ = bl;
        this.showoriginal_ = bl2;
        this.initIterators();
    }

    public JDRRotationalPattern() {
        this.path_ = new JDRPath();
        this.point_ = new JDRPatternAnchorPoint();
        this.angle_ = Math.PI;
        this.replicas_ = 1;
        this.singlemode_ = true;
        this.initIterators();
    }

    public JDRRotationalPattern(int n, JDRPaint jDRPaint, JDRPaint jDRPaint2, JDRStroke jDRStroke) {
        this.path_ = new JDRPath(n, jDRPaint, jDRPaint2, jDRStroke);
        this.point_ = new JDRPatternAnchorPoint();
        this.angle_ = 1.5707963267948966;
        this.replicas_ = 4;
        this.singlemode_ = true;
        this.initIterators();
    }

    @Override
    public JDRPattern createTemplate() {
        try {
            return new JDRRotationalPattern(null, null, this.angle_, this.replicas_, this.singlemode_);
        }
        catch (InvalidReplicaException invalidReplicaException) {
            return null;
        }
    }

    @Override
    public void makeParametersEqual(JDRPattern jDRPattern) {
        JDRRotationalPattern jDRRotationalPattern = (JDRRotationalPattern)jDRPattern;
        this.angle_ = jDRRotationalPattern.angle_;
    }

    @Override
    public void getReplicaTransform(double[] dArray, int n) {
        double d = (double)n * this.angle_;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = -d3;
        dArray[3] = d2;
        dArray[4] = this.point_.x - this.point_.x * d2 + this.point_.y * d3;
        dArray[5] = this.point_.y - this.point_.x * d3 - this.point_.y * d2;
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return shapeListener;
    }

    public String toString() {
        String string = "RotationalPattern: point=" + this.point_ + ", angle: " + this.angle_ + ", replicas: " + this.replicas_ + ", size=" + this.size() + ", segments=[";
        for (int i = 0; i < this.size(); ++i) {
            string = string + this.get(i) + ",";
        }
        string = string + "]";
        return string;
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "RotationalPattern:" + string;
        string2 = string2 + "point of rotation: " + this.point_.info() + string;
        string2 = string2 + "angle of rotation: " + this.angle_ + string;
        string2 = string2 + "replicas: " + this.replicas_;
        string2 = string2 + "Underlying shape:" + this.path_.info();
        return string2;
    }

    public double getRotationAngle() {
        return this.angle_;
    }

    public void setRotationAngle(double d) {
        this.angle_ = d;
    }

    @Override
    public String[] getDescriptionInfo() {
        return new String[]{"" + this.replicas_, "" + this.angle_};
    }
}

