/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidUnitIDException;
import uk.ac.uea.cmp.nlct.jdr.JDRGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRGridLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRectangularGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRRectangularGridListener
implements JDRGridLoaderListener {
    @Override
    public byte getJDRid(float f) {
        return 0;
    }

    @Override
    public void writeJDR(JDRGrid jDRGrid, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRRectangularGrid jDRRectangularGrid = (JDRRectangularGrid)jDRGrid;
        dataOutputStream.writeByte((byte)jDRRectangularGrid.getUnit().getID());
        if (f < 1.6f) {
            dataOutputStream.writeInt((int)Math.round(jDRRectangularGrid.getMajorInterval()));
        } else {
            dataOutputStream.writeDouble(jDRRectangularGrid.getMajorInterval());
        }
        dataOutputStream.writeInt(jDRRectangularGrid.getSubDivisions());
    }

    @Override
    public JDRGrid readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        byte by = dataInputStream.readByte();
        JDRUnit jDRUnit = JDRUnit.getUnit(by);
        if (jDRUnit == null) {
            throw new InvalidUnitIDException(by);
        }
        double d = f < 1.6f ? (double)dataInputStream.readInt() : dataInputStream.readDouble();
        int n = dataInputStream.readInt();
        return new JDRRectangularGrid(jDRUnit, d, n);
    }

    @Override
    public byte getAJRid(float f) {
        return 0;
    }

    @Override
    public void writeAJR(JDRGrid jDRGrid, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRRectangularGrid jDRRectangularGrid = (JDRRectangularGrid)jDRGrid;
        AJR.writeInt(printWriter, jDRRectangularGrid.getUnit().getID());
        if (f < 1.6f) {
            AJR.writeInt(printWriter, (int)Math.round(jDRRectangularGrid.getMajorInterval()));
        } else {
            AJR.writeDouble(printWriter, jDRRectangularGrid.getMajorInterval());
        }
        AJR.writeInt(printWriter, jDRRectangularGrid.getSubDivisions());
    }

    @Override
    public JDRGrid readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        int n = AJR.readInt(bufferedReader);
        JDRUnit jDRUnit = JDRUnit.getUnit(n);
        if (jDRUnit == null) {
            throw new InvalidUnitIDException(n, AJR.getLineNum());
        }
        double d = f < 1.6f ? (double)AJR.readInt(bufferedReader) : AJR.readDouble(bufferedReader);
        int n2 = AJR.readInt(bufferedReader);
        return new JDRRectangularGrid(jDRUnit, d, n2);
    }
}

