/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import uk.ac.uea.cmp.nlct.jdr.InvalidGridArgumentException;
import uk.ac.uea.cmp.nlct.jdr.JDRGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRGridLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.JDRRectangularGridListener;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;

public class JDRRectangularGrid
extends JDRGrid {
    private static JDRRectangularGridListener listener = new JDRRectangularGridListener();
    private double majorDivisions;
    private int subDivisions;
    private JDRUnit unit;

    public JDRRectangularGrid() {
        try {
            this.set(JDRUnit.bp, 100.0, 10);
        }
        catch (InvalidGridArgumentException invalidGridArgumentException) {
            // empty catch block
        }
    }

    public JDRRectangularGrid(JDRUnit jDRUnit, double d, int n) throws InvalidGridArgumentException {
        this.set(jDRUnit, d, n);
    }

    @Override
    public Object clone() {
        JDRRectangularGrid jDRRectangularGrid = null;
        try {
            jDRRectangularGrid = new JDRRectangularGrid(this.unit, this.majorDivisions, this.subDivisions);
        }
        catch (InvalidGridArgumentException invalidGridArgumentException) {
            // empty catch block
        }
        return jDRRectangularGrid;
    }

    public void set(JDRUnit jDRUnit, double d, int n) throws InvalidGridArgumentException {
        this.setUnit(jDRUnit);
        this.setMajorInterval(d);
        this.setSubDivisions(n);
    }

    public void setUnit(JDRUnit jDRUnit) {
        this.unit = jDRUnit;
    }

    public void setMajorInterval(double d) throws InvalidGridArgumentException {
        if (d <= 0.0) {
            throw new InvalidGridArgumentException(d);
        }
        this.majorDivisions = d;
    }

    public void setSubDivisions(int n) throws InvalidGridArgumentException {
        if (n < 0) {
            throw new InvalidGridArgumentException(n);
        }
        this.subDivisions = n;
    }

    public JDRUnit getUnit() {
        return this.unit;
    }

    public double getMajorInterval() {
        return this.majorDivisions;
    }

    public int getSubDivisions() {
        return this.subDivisions;
    }

    @Override
    public Point2D getMajorTicDistance() {
        double d = this.unit.toBp(this.majorDivisions);
        return new Point2D.Double(d, d);
    }

    @Override
    public Point2D getMinorTicDistance() {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        if (this.subDivisions > 0) {
            double d = this.unit.toBp(this.majorDivisions) / (double)this.subDivisions;
            ((Point2D)double_).setLocation(d, d);
        }
        return double_;
    }

    @Override
    public Point2D getFromCartesian(JDRPaper jDRPaper, double d, double d2) {
        return new Point2D.Double(this.unit.fromBp(d), this.unit.fromBp(d2));
    }

    @Override
    public void getFromCartesian(JDRPaper jDRPaper, Point2D point2D, Point2D point2D2) {
        point2D2.setLocation(this.unit.fromBp(point2D.getX()), this.unit.fromBp(point2D.getY()));
    }

    @Override
    public void getCartesian(JDRPaper jDRPaper, Point2D point2D, Point2D point2D2) {
        point2D2.setLocation(this.unit.toBp(point2D.getX()), this.unit.toBp(point2D.getY()));
    }

    @Override
    public Point2D getClosestTic(JDRPaper jDRPaper, double d, double d2) {
        double d3 = this.unit.toBp(this.majorDivisions);
        double d4 = jDRPaper.getWidth();
        double d5 = jDRPaper.getHeight();
        int n = (int)Math.floor(d / d3);
        int n2 = (int)Math.floor(d2 / d3);
        if (this.subDivisions == 0) {
            double d6 = (double)n * d3;
            double d7 = (double)n2 * d3;
            double d8 = d6 - d;
            double d9 = d7 - d2;
            double d10 = d8 * d8 + d9 * d9;
            double d11 = d6 + d3;
            double d12 = d7;
            d8 = d11 - d;
            d9 = d12 - d2;
            double d13 = d8 * d8 + d9 * d9;
            double d14 = d6;
            double d15 = d7 + d3;
            d8 = d14 - d;
            d9 = d15 - d2;
            double d16 = d8 * d8 + d9 * d9;
            double d17 = d11;
            double d18 = d15;
            d8 = d17 - d;
            d9 = d18 - d2;
            double d19 = d8 * d8 + d9 * d9;
            if (d10 <= d13 && d10 <= d16 && d10 <= d19) {
                return new Point2D.Double(d6, d7);
            }
            if (d13 <= d10 && d13 <= d16 && d13 <= d19) {
                return new Point2D.Double(d11, d12);
            }
            if (d16 <= d10 && d16 <= d13 && d16 <= d19) {
                return new Point2D.Double(d14, d15);
            }
            return new Point2D.Double(d17, d18);
        }
        double d20 = d3 / (double)this.subDivisions;
        double d21 = (double)n * d3;
        double d22 = (double)n2 * d3;
        double d23 = d - d21;
        double d24 = d2 - d22;
        int n3 = (int)Math.floor(d23 / d20);
        int n4 = (int)Math.floor(d24 / d20);
        double d25 = (double)n3 * d20;
        double d26 = (double)n4 * d20;
        double d27 = d25 - d23;
        double d28 = d26 - d24;
        double d29 = d27 * d27 + d28 * d28;
        double d30 = d25 + d20;
        double d31 = d26;
        d27 = d30 - d23;
        d28 = d31 - d24;
        double d32 = d27 * d27 + d28 * d28;
        double d33 = d25;
        double d34 = d26 + d20;
        d27 = d33 - d23;
        d28 = d34 - d24;
        double d35 = d27 * d27 + d28 * d28;
        double d36 = d30;
        double d37 = d34;
        d27 = d36 - d23;
        d28 = d37 - d24;
        double d38 = d27 * d27 + d28 * d28;
        if (d29 <= d32 && d29 <= d35 && d29 <= d38) {
            return new Point2D.Double(d21 + d25, d22 + d26);
        }
        if (d32 <= d29 && d32 <= d35 && d32 <= d38) {
            return new Point2D.Double(d21 + d30, d22 + d31);
        }
        if (d35 <= d29 && d35 <= d32 && d35 <= d38) {
            return new Point2D.Double(d21 + d33, d22 + d34);
        }
        return new Point2D.Double(d21 + d36, d22 + d37);
    }

    @Override
    public void drawGrid(Graphics2D graphics2D, JDRPaper jDRPaper, double d) {
        double d2 = this.unit.toBp(this.getMajorInterval());
        double d3 = this.getSubDivisions();
        if (d3 > 0.0) {
            d3 = d2 / d3;
        }
        double d4 = jDRPaper.getWidth() * d;
        double d5 = jDRPaper.getHeight() * d;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d2 * d;
        double d9 = d3 * d;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            d6 = Math.floor(rectangle.getX() / d8);
            d7 = Math.floor(rectangle.getY() / d8);
            d4 = Math.min(d4, rectangle.getX() + rectangle.getWidth());
            d5 = Math.min(d5, rectangle.getY() + rectangle.getHeight());
        }
        if (this.subDivisions == 0) {
            graphics2D.setColor(majorGridColor);
        }
        for (double d10 = d6; d10 < d4; d10 += d8) {
            for (double d11 = d7; d11 < d5; d11 += d8) {
                if (this.subDivisions > 0) {
                    int n;
                    graphics2D.setColor(minorGridColor);
                    for (double d12 = 0.0; d12 <= d8 && !((double)(n = (int)Math.round(d10 + d12)) > d4); d12 += d9) {
                        int n2;
                        for (double d13 = 0.0; d13 <= d8 && !((double)(n2 = (int)Math.round(d11 + d13)) > d5); d13 += d9) {
                            this.drawMinorTic(graphics2D, n, n2);
                        }
                    }
                }
                if (this.subDivisions != 0) {
                    graphics2D.setColor(majorGridColor);
                }
                this.drawMajorTic(graphics2D, (int)Math.round(d10), (int)Math.round(d11));
            }
        }
    }

    @Override
    public String getUnitLabel() {
        return this.unit.getLabel();
    }

    @Override
    public JDRUnit getMainUnit() {
        return this.unit;
    }

    @Override
    public String formatLocation(Point2D point2D) {
        DecimalFormat decimalFormat = new DecimalFormat(this.unit == JDRUnit.bp ? "0" : "0.0");
        return decimalFormat.format(point2D.getX()) + "," + decimalFormat.format(point2D.getY()) + " " + this.unit.getLabel();
    }

    @Override
    public JDRGridLoaderListener getListener() {
        return listener;
    }
}

