/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.geom.Point2D;

public class JDRRadialPoint
extends Point2D {
    private double radius;
    private double angle;

    public JDRRadialPoint() {
        this.radius = 0.0;
        this.angle = 0.0;
    }

    public JDRRadialPoint(double d, double d2) throws IllegalArgumentException {
        this.setRadius(d);
        this.setAngle(d2);
    }

    public void setParameters(double d, double d2) throws IllegalArgumentException {
        this.setRadius(d);
        this.setAngle(d2);
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public void setRadius(double d) throws IllegalArgumentException {
        if (this.radius < 0.0) {
            throw new IllegalArgumentException("Radius must be non-negative. R=" + d);
        }
        this.radius = d;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public double getX() {
        return this.radius * Math.cos(this.angle);
    }

    @Override
    public double getY() {
        return this.radius * Math.sin(this.angle);
    }

    public Point2D.Double getPoint2D() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public void getPoint2D(Point2D.Double double_) {
        double_.setLocation(this.getX(), this.getY());
    }

    public static JDRRadialPoint createRadialPoint(Point2D point2D) {
        JDRRadialPoint jDRRadialPoint = new JDRRadialPoint();
        jDRRadialPoint.setLocation(point2D);
        return jDRRadialPoint;
    }

    @Override
    public void setLocation(Point2D point2D) {
        if (point2D instanceof JDRRadialPoint) {
            this.angle = ((JDRRadialPoint)point2D).getAngle();
            this.radius = ((JDRRadialPoint)point2D).getRadius();
        } else {
            this.setLocation(point2D.getX(), point2D.getY());
        }
    }

    @Override
    public void setLocation(double d, double d2) {
        this.angle = Math.atan2(d2, d);
        this.radius = Math.sqrt(d * d + d2 * d2);
    }

    @Override
    public Object clone() {
        JDRRadialPoint jDRRadialPoint = new JDRRadialPoint();
        jDRRadialPoint.angle = this.angle;
        jDRRadialPoint.radius = this.radius;
        return jDRRadialPoint;
    }

    public String toString() {
        return "JDRRadialPoint[radius=" + this.radius + ",angle=" + this.angle + "]";
    }
}

