/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidUnitIDException;
import uk.ac.uea.cmp.nlct.jdr.JDRGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRGridLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRRectangularGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRRadialGridListener
implements JDRGridLoaderListener {
    @Override
    public byte getJDRid(float f) {
        return 1;
    }

    @Override
    public void writeJDR(JDRGrid jDRGrid, DataOutputStream dataOutputStream, float f) throws IOException {
        JDRRadialGrid jDRRadialGrid = (JDRRadialGrid)jDRGrid;
        if (f < 1.6f) {
            dataOutputStream.writeByte((byte)jDRRadialGrid.getUnit().getID());
            dataOutputStream.writeInt((int)Math.round(jDRRadialGrid.getMajorInterval()));
            dataOutputStream.writeInt(jDRRadialGrid.getSubDivisions());
        } else {
            dataOutputStream.writeByte((byte)jDRRadialGrid.getUnit().getID());
            dataOutputStream.writeDouble(jDRRadialGrid.getMajorInterval());
            dataOutputStream.writeInt(jDRRadialGrid.getSubDivisions());
            dataOutputStream.writeInt(jDRRadialGrid.getSpokes());
        }
    }

    @Override
    public JDRGrid readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        byte by = dataInputStream.readByte();
        JDRUnit jDRUnit = JDRUnit.getUnit(by);
        if (jDRUnit == null) {
            throw new InvalidUnitIDException(by);
        }
        double d = f < 1.6f ? (double)dataInputStream.readInt() : dataInputStream.readDouble();
        int n = dataInputStream.readInt();
        if (f < 1.6f) {
            return new JDRRectangularGrid(jDRUnit, d, n);
        }
        int n2 = dataInputStream.readInt();
        return new JDRRadialGrid(jDRUnit, d, n, n2);
    }

    @Override
    public byte getAJRid(float f) {
        return 1;
    }

    @Override
    public void writeAJR(JDRGrid jDRGrid, PrintWriter printWriter, float f) throws IOException {
        JDRRadialGrid jDRRadialGrid = (JDRRadialGrid)jDRGrid;
        AJR.writeInt(printWriter, jDRRadialGrid.getUnit().getID());
        if (f < 1.6f) {
            AJR.writeInt(printWriter, (int)Math.round(jDRRadialGrid.getMajorInterval()));
            AJR.writeInt(printWriter, jDRRadialGrid.getSubDivisions());
        } else {
            AJR.writeDouble(printWriter, jDRRadialGrid.getMajorInterval());
            AJR.writeInt(printWriter, jDRRadialGrid.getSubDivisions());
            AJR.writeInt(printWriter, jDRRadialGrid.getSpokes());
        }
    }

    @Override
    public JDRGrid readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        int n = AJR.readInt(bufferedReader);
        JDRUnit jDRUnit = JDRUnit.getUnit(n);
        if (jDRUnit == null) {
            throw new InvalidUnitIDException(n, AJR.getLineNum());
        }
        double d = f < 1.6f ? (double)AJR.readInt(bufferedReader) : AJR.readDouble(bufferedReader);
        int n2 = AJR.readInt(bufferedReader);
        if (f < 1.6f) {
            return new JDRRectangularGrid(jDRUnit, d, n2);
        }
        int n3 = AJR.readInt(bufferedReader);
        return new JDRRadialGrid(jDRUnit, d, n2, n3);
    }
}

