/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import uk.ac.uea.cmp.nlct.jdr.InvalidGridArgumentException;
import uk.ac.uea.cmp.nlct.jdr.JDRGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRGridLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialGridListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;

public class JDRRadialGrid
extends JDRGrid {
    private static JDRRadialGridListener listener = new JDRRadialGridListener();
    private double majorDivisions;
    private int subDivisions;
    private int spokes;
    private JDRUnit unit;

    public JDRRadialGrid() {
        try {
            this.set(JDRUnit.bp, 100.0, 10, 8);
        }
        catch (InvalidGridArgumentException invalidGridArgumentException) {
            // empty catch block
        }
    }

    public JDRRadialGrid(JDRUnit jDRUnit, double d, int n, int n2) throws InvalidGridArgumentException {
        this.set(jDRUnit, d, n, n2);
    }

    @Override
    public Object clone() {
        JDRRadialGrid jDRRadialGrid = null;
        try {
            jDRRadialGrid = new JDRRadialGrid(this.unit, this.majorDivisions, this.subDivisions, this.spokes);
        }
        catch (InvalidGridArgumentException invalidGridArgumentException) {
            // empty catch block
        }
        return jDRRadialGrid;
    }

    public void set(JDRUnit jDRUnit, double d, int n, int n2) throws InvalidGridArgumentException {
        this.setUnit(jDRUnit);
        this.setMajorInterval(d);
        this.setSubDivisions(n);
        this.setSpokes(n2);
    }

    public void setUnit(JDRUnit jDRUnit) {
        this.unit = jDRUnit;
    }

    public void setMajorInterval(double d) throws InvalidGridArgumentException {
        if (d <= 0.0) {
            throw new InvalidGridArgumentException(d);
        }
        this.majorDivisions = d;
    }

    public void setSubDivisions(int n) throws InvalidGridArgumentException {
        if (n < 0) {
            throw new InvalidGridArgumentException(n);
        }
        this.subDivisions = n;
    }

    public void setSpokes(int n) throws InvalidGridArgumentException {
        if (n < 0) {
            throw new InvalidGridArgumentException(n);
        }
        this.spokes = n;
    }

    public JDRUnit getUnit() {
        return this.unit;
    }

    public double getMajorInterval() {
        return this.majorDivisions;
    }

    public int getSubDivisions() {
        return this.subDivisions;
    }

    public int getSpokes() {
        return this.spokes;
    }

    @Override
    public Point2D getMajorTicDistance() {
        double d = this.unit.toBp(this.majorDivisions);
        return new Point2D.Double(d, d);
    }

    @Override
    public Point2D getMinorTicDistance() {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        if (this.subDivisions > 0) {
            double d = this.unit.toBp(this.majorDivisions) / (double)this.subDivisions;
            ((Point2D)double_).setLocation(d, d);
        }
        return double_;
    }

    @Override
    public Point2D getFromCartesian(JDRPaper jDRPaper, double d, double d2) {
        JDRRadialPoint jDRRadialPoint = new JDRRadialPoint();
        jDRRadialPoint.setLocation(this.unit.fromBp(d) - 0.5 * jDRPaper.getWidth(), this.unit.fromBp(d2) - 0.5 * jDRPaper.getHeight());
        return jDRRadialPoint;
    }

    @Override
    public void getFromCartesian(JDRPaper jDRPaper, Point2D point2D, Point2D point2D2) {
        point2D2.setLocation(this.unit.fromBp(point2D.getX()) - 0.5 * jDRPaper.getWidth(), this.unit.fromBp(point2D.getY()) - 0.5 * jDRPaper.getHeight());
    }

    @Override
    public void getCartesian(JDRPaper jDRPaper, Point2D point2D, Point2D point2D2) {
        JDRRadialPoint jDRRadialPoint = (JDRRadialPoint)point2D;
        point2D2.setLocation(this.unit.toBp(jDRRadialPoint.getX()) + 0.5 * jDRPaper.getWidth(), this.unit.toBp(jDRRadialPoint.getY()) + 0.5 * jDRPaper.getHeight());
    }

    @Override
    public void drawGrid(Graphics2D graphics2D, JDRPaper jDRPaper, double d) {
        double d2 = this.unit.toBp(this.getMajorInterval());
        double d3 = this.getSubDivisions();
        if (d3 > 0.0) {
            d3 = d2 / d3;
        }
        double d4 = this.getSpokeAngle();
        JDRRadialPoint jDRRadialPoint = new JDRRadialPoint();
        Point2D.Double double_ = new Point2D.Double();
        double d5 = 0.5 * jDRPaper.getWidth();
        double d6 = 0.5 * jDRPaper.getHeight();
        double d7 = 1.5707963267948966;
        double d8 = Math.PI * 2;
        double d9 = Math.atan(d6 / d5);
        double d10 = d7 - d9;
        if (this.subDivisions == 0) {
            graphics2D.setColor(majorGridColor);
        }
        for (double d11 = 0.0; d11 < d8; d11 += d4) {
            try {
                jDRRadialPoint.setParameters(0.0, d11);
                double d12 = d11 <= d9 ? d5 / Math.cos(d11) : (d11 <= d7 + d10 ? d6 / Math.sin(d11) : (d11 <= Math.PI + d9 ? -d5 / Math.cos(d11) : -d6 / Math.sin(d11)));
                for (double d13 = 0.0; d13 <= d12; d13 += d2) {
                    jDRRadialPoint.setRadius(d13);
                    this.getCartesian(jDRPaper, jDRRadialPoint, double_);
                    if (this.subDivisions == 0) {
                        this.drawMajorTic(graphics2D, (int)Math.round(double_.getX() * d), (int)Math.round(double_.getY() * d));
                        continue;
                    }
                    graphics2D.setColor(majorGridColor);
                    this.drawMajorTic(graphics2D, (int)Math.round(double_.getX() * d), (int)Math.round(double_.getY() * d));
                    graphics2D.setColor(minorGridColor);
                    for (int i = 1; i < this.getSubDivisions(); ++i) {
                        jDRRadialPoint.setRadius(d13 + (double)i * d3);
                        this.getCartesian(jDRPaper, jDRRadialPoint, double_);
                        this.drawMinorTic(graphics2D, (int)Math.round(double_.getX() * d), (int)Math.round(double_.getY() * d));
                    }
                }
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public double getSpokeAngle() {
        return Math.PI * 2 / (double)this.spokes;
    }

    @Override
    public String getUnitLabel() {
        return this.unit.getLabel();
    }

    @Override
    public JDRUnit getMainUnit() {
        return this.unit;
    }

    @Override
    public String formatLocation(Point2D point2D) {
        JDRRadialPoint jDRRadialPoint = (JDRRadialPoint)point2D;
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        return decimalFormat.format(jDRRadialPoint.getRadius()) + this.unit.getLabel() + "," + decimalFormat.format(Math.toDegrees(jDRRadialPoint.getAngle()));
    }

    @Override
    public Point2D getClosestTic(JDRPaper jDRPaper, double d, double d2) {
        JDRRadialPoint jDRRadialPoint = (JDRRadialPoint)this.getFromCartesian(jDRPaper, d, d2);
        double d3 = this.getSpokeAngle();
        int n = (int)Math.round(jDRRadialPoint.getAngle() / d3);
        jDRRadialPoint.setAngle((double)n * d3);
        if (this.subDivisions > 0) {
            n = (int)Math.floor(jDRRadialPoint.getRadius() / this.majorDivisions);
            double d4 = (double)n * this.majorDivisions;
            double d5 = jDRRadialPoint.getRadius() - d4;
            double d6 = this.majorDivisions / (double)this.subDivisions;
            int n2 = (int)Math.round(d5 / d6);
            jDRRadialPoint.setRadius(d4 + (double)n2 * d6);
        } else {
            n = (int)Math.round(jDRRadialPoint.getRadius() / this.majorDivisions);
            jDRRadialPoint.setRadius((double)n * this.majorDivisions);
        }
        Point2D.Double double_ = new Point2D.Double();
        this.getCartesian(jDRPaper, jDRRadialPoint, double_);
        return double_;
    }

    @Override
    public JDRGridLoaderListener getListener() {
        return listener;
    }
}

