/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidEndColourException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidGradientDirectionException;
import uk.ac.uea.cmp.nlct.jdr.InvalidStartColourException;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRadialListener;
import uk.ac.uea.cmp.nlct.jdr.JDRShading;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.RadialPaintContext;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class JDRRadial
implements JDRPaint,
Serializable,
Paint,
JDRShading {
    private JDRPaint startColor;
    private JDRPaint endColor;
    private int direction;
    public static final int NORTH = 0;
    public static final int NORTH_EAST = 1;
    public static final int EAST = 2;
    public static final int SOUTH_EAST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTH_WEST = 5;
    public static final int WEST = 6;
    public static final int NORTH_WEST = 7;
    public static final int CENTER = 8;
    private static int pgfshadeid = 0;
    private double startPtx;
    private double startPty;
    private double endPtx;
    private double endPty;
    private static JDRPaintLoaderListener listener = new JDRRadialListener();

    public JDRRadial(JDRPaint jDRPaint, JDRPaint jDRPaint2) throws InvalidStartColourException, InvalidEndColourException {
        if (jDRPaint instanceof JDRShading) {
            throw new InvalidStartColourException();
        }
        if (jDRPaint2 instanceof JDRShading) {
            throw new InvalidEndColourException();
        }
        this.startColor = jDRPaint;
        this.endColor = jDRPaint2;
        this.direction = 8;
        this.startPtx = 0.0;
        this.startPty = 0.0;
        this.endPtx = 1.0;
        this.endPty = 1.0;
    }

    public JDRRadial(int n, JDRPaint jDRPaint, JDRPaint jDRPaint2) throws InvalidGradientDirectionException, InvalidStartColourException, InvalidEndColourException {
        if (jDRPaint instanceof JDRShading) {
            throw new InvalidStartColourException();
        }
        if (jDRPaint2 instanceof JDRShading) {
            throw new InvalidEndColourException();
        }
        if (n < 0 || n > 8) {
            throw new InvalidGradientDirectionException(n);
        }
        this.startColor = jDRPaint;
        this.endColor = jDRPaint2;
        this.direction = n;
        this.startPtx = 0.0;
        this.startPty = 0.0;
        this.endPtx = 1.0;
        this.endPty = 1.0;
    }

    public JDRRadial() {
        this.startColor = new JDRColor();
        this.endColor = new JDRColor();
        this.direction = 8;
        this.startPtx = 0.0;
        this.startPty = 0.0;
        this.endPtx = 1.0;
        this.endPty = 1.0;
    }

    @Override
    public Color getColor() {
        return this.startColor.getColor();
    }

    @Override
    public JDRColor getJDRColor() {
        return this.startColor.getJDRColor();
    }

    @Override
    public JDRColorCMYK getJDRColorCMYK() {
        return this.startColor.getJDRColorCMYK();
    }

    @Override
    public JDRColorHSB getJDRColorHSB() {
        return this.startColor.getJDRColorHSB();
    }

    @Override
    public JDRGray getJDRGray() {
        return this.startColor.getJDRGray();
    }

    private void setStartPoint(double d, double d2) {
        this.startPtx = d;
        this.startPty = d2;
    }

    private void setEndPoint(double d, double d2) {
        this.endPtx = d;
        this.endPty = d2;
    }

    public void update(BBox bBox) {
        double d = bBox.getWidth();
        double d2 = bBox.getHeight();
        double d3 = d / 6.0;
        double d4 = d2 / 6.0;
        double d5 = d / 2.0;
        double d6 = d2 / 2.0;
        double d7 = bBox.getMinX();
        double d8 = bBox.getMinY();
        double d9 = bBox.getMaxX();
        double d10 = bBox.getMaxY();
        switch (this.direction) {
            case 0: {
                this.setStartPoint(d7 + d5, d8 + d4);
                this.setEndPoint(d7, d10);
                break;
            }
            case 1: {
                this.setStartPoint(d7 + 5.0 * d3, d8 + d4);
                this.setEndPoint(d7, d10);
                break;
            }
            case 2: {
                this.setStartPoint(d7 + 5.0 * d3, d8 + d6);
                this.setEndPoint(d7, d8);
                break;
            }
            case 3: {
                this.setStartPoint(d7 + 5.0 * d3, d8 + 5.0 * d4);
                this.setEndPoint(d7, d8);
                break;
            }
            case 4: {
                this.setStartPoint(d7 + d5, d8 + 5.0 * d4);
                this.setEndPoint(d9, d8);
                break;
            }
            case 5: {
                this.setStartPoint(d7 + d3, d8 + 5.0 * d4);
                this.setEndPoint(d9, d8);
                break;
            }
            case 6: {
                this.setStartPoint(d7 + d3, d8 + d6);
                this.setEndPoint(d9, d10);
                break;
            }
            case 7: {
                this.setStartPoint(d7 + d3, d8 + d4);
                this.setEndPoint(d9, d10);
                break;
            }
            default: {
                this.setStartPoint(d7 + d5, d8 + d6);
                this.setEndPoint(d7, d8);
            }
        }
    }

    public double getRadius() {
        double d = this.startPtx - this.endPtx;
        double d2 = this.startPty - this.endPty;
        return Math.sqrt(d * d + d2 * d2);
    }

    @Override
    public Paint getPaint(BBox bBox) {
        this.update(bBox);
        return this;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D.Double double_ = new Point2D.Double(this.startPtx, this.startPty);
        Point2D.Double double_2 = new Point2D.Double(this.endPtx, this.endPty);
        Point2D point2D = affineTransform.transform(double_, null);
        Point2D point2D2 = affineTransform.transform(double_2, null);
        return new RadialPaintContext(point2D, this.startColor.getColor(), point2D2, this.endColor.getColor());
    }

    @Override
    public int getTransparency() {
        return (this.startColor.getColor().getAlpha() & this.endColor.getColor().getAlpha()) == 255 ? 1 : 3;
    }

    @Override
    public Object clone() {
        try {
            return new JDRRadial(this.direction, this.startColor, this.endColor);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRRadial();
        }
    }

    @Override
    public String toString() {
        return new String("JDRRadial@D:" + this.direction + this.startColor + this.endColor);
    }

    private String pgfdeclareradialshading(BBox bBox) {
        String string = System.getProperty("line.separator", "\n");
        this.update(bBox);
        String string2 = "\\pgfdeclareradialshading{jdrradial" + pgfshadeid + "}{\\pgfpoint{";
        double d = bBox.getMidX();
        double d2 = bBox.getMidY();
        string2 = string2 + PGF.format(this.startPtx - d) + "bp}{";
        string2 = string2 + PGF.format(d2 - this.startPty) + "bp}";
        string2 = string2 + "}{";
        Color color = this.startColor.getColor();
        double d3 = (double)color.getRed() / 255.0;
        double d4 = (double)color.getGreen() / 255.0;
        double d5 = (double)color.getBlue() / 255.0;
        string2 = string2 + "rgb(0bp)=(" + PGF.format(d3) + "," + PGF.format(d4) + "," + PGF.format(d5) + ");";
        Color color2 = this.endColor.getColor();
        d3 = (double)color2.getRed() / 255.0;
        d4 = (double)color2.getGreen() / 255.0;
        d5 = (double)color2.getBlue() / 255.0;
        String string3 = "(" + PGF.format(d3) + "," + PGF.format(d4) + "," + PGF.format(d5) + ")";
        string2 = string2 + "rgb(32.5bp)=" + string3 + "; ";
        string2 = string2 + "rgb(50bp)=" + string3;
        string2 = string2 + "}" + string;
        double d6 = bBox.getWidth();
        double d7 = bBox.getHeight();
        string2 = string2 + "\\pgfsetadditionalshadetransform{";
        if (d6 < d7 && d6 != 0.0) {
            string2 = string2 + "\\pgftransformxscale{" + PGF.format(d7 / d6) + "}";
        } else if (d7 != 0.0) {
            string2 = string2 + "\\pgftransformyscale{" + PGF.format(d6 / d7) + "}";
        }
        string2 = string2 + "}" + string;
        return string2;
    }

    @Override
    public String pgffillcolor(BBox bBox) {
        if (bBox == null) {
            return this.startColor.pgffillcolor(bBox);
        }
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = this.pgfdeclareradialshading(bBox);
        double d = this.getAlpha();
        if (d != 1.0) {
            string2 = string2 + "\\pgfsetfillopacity{" + PGF.format(d) + "}";
        }
        string2 = string2 + string + "\\pgfshadepath{jdrradial" + pgfshadeid + "}{0}";
        ++pgfshadeid;
        return string2;
    }

    @Override
    public String getID() {
        return "radial-" + this.startColor.getID() + "-" + this.endColor.getID() + "-" + this.direction;
    }

    private void svgDef(PrintWriter printWriter) throws IOException {
        Point2D.Double double_;
        Point2D.Double double_2;
        printWriter.println("      <radialGradient id=\"" + this.getID() + "\"");
        printWriter.println("         gradientUnits=\"objectBoundingBox\"");
        double d = 83.33333333333333;
        double d2 = 16.666666666666668;
        switch (this.direction) {
            case 0: {
                double_2 = new Point2D.Double(50.0, d);
                double_ = new Point2D.Double(0.0, 0.0);
                break;
            }
            case 1: {
                double_2 = new Point2D.Double(d, d);
                double_ = new Point2D.Double(0.0, 0.0);
                break;
            }
            case 2: {
                double_2 = new Point2D.Double(d, 50.0);
                double_ = new Point2D.Double(0.0, 0.0);
                break;
            }
            case 3: {
                double_2 = new Point2D.Double(d, d2);
                double_ = new Point2D.Double(0.0, 100.0);
                break;
            }
            case 4: {
                double_2 = new Point2D.Double(50.0, d2);
                double_ = new Point2D.Double(0.0, 100.0);
                break;
            }
            case 5: {
                double_2 = new Point2D.Double(d2, d2);
                double_ = new Point2D.Double(100.0, 100.0);
                break;
            }
            case 6: {
                double_2 = new Point2D.Double(d2, 50.0);
                double_ = new Point2D.Double(100.0, 100.0);
                break;
            }
            case 7: {
                double_2 = new Point2D.Double(d2, d);
                double_ = new Point2D.Double(100.0, 0.0);
                break;
            }
            default: {
                double_2 = new Point2D.Double(50.0, 50.0);
                double_ = new Point2D.Double(0.0, 0.0);
            }
        }
        double d3 = double_2.distance(double_);
        printWriter.println("         cx=\"" + ((Point2D)double_2).getX() + "%\" " + "cy=\"" + ((Point2D)double_2).getY() + "%\" " + "r=\"" + d3 + "%\" " + ">");
        printWriter.println("         <stop offset=\"0%\" stop-color=\"" + this.startColor.svg() + "\" stroke-opacity=\"" + this.startColor.getAlpha() + "\"/>");
        printWriter.println("         <stop offset=\"100%\" stop-color=\"" + this.endColor.svg() + "\" stroke-opacity=\"" + this.endColor.getAlpha() + "\"/>");
        printWriter.println("      </radialGradient>");
    }

    public static void svgDefs(PrintWriter printWriter, JDRGroup jDRGroup) throws IOException {
        JDRPaint jDRPaint;
        Object object;
        Hashtable<String, JDRRadial> hashtable = new Hashtable<String, JDRRadial>();
        for (int i = 0; i < jDRGroup.size(); ++i) {
            object = jDRGroup.get(i);
            if (object instanceof JDRShape) {
                jDRPaint = ((JDRShape)object).getLinePaint();
                if (jDRPaint instanceof JDRRadial) {
                    hashtable.put(((JDRRadial)jDRPaint).getID(), (JDRRadial)jDRPaint);
                }
                if ((jDRPaint = ((JDRShape)object).getFillPaint()) instanceof JDRRadial) {
                    hashtable.put(((JDRRadial)jDRPaint).getID(), (JDRRadial)jDRPaint);
                }
            }
            if (!(object instanceof JDRTextual) || !((jDRPaint = ((JDRTextual)object).getTextPaint()) instanceof JDRRadial)) continue;
            hashtable.put(((JDRRadial)jDRPaint).getID(), (JDRRadial)jDRPaint);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            jDRPaint = (JDRRadial)hashtable.get(object);
            super.svgDef(printWriter);
        }
    }

    @Override
    public String svgFill() {
        return "fill=\"url(#" + this.getID() + ")\"";
    }

    @Override
    public String svgLine() {
        return "stroke=\"url(#" + this.getID() + ")\"";
    }

    @Override
    public String svg() {
        return "url(#" + this.getID() + ")";
    }

    @Override
    public double getAlpha() {
        return 0.5 * (this.startColor.getAlpha() + this.endColor.getAlpha());
    }

    public int getStartLocation() {
        return this.direction;
    }

    @Override
    public JDRPaint getStartColor() {
        return this.startColor;
    }

    @Override
    public JDRPaint getEndColor() {
        return this.endColor;
    }

    public void setStartColor(JDRPaint jDRPaint) throws InvalidStartColourException {
        if (jDRPaint instanceof JDRShading) {
            throw new InvalidStartColourException();
        }
        this.startColor = jDRPaint;
    }

    public void setEndColor(JDRPaint jDRPaint) throws InvalidEndColourException {
        if (jDRPaint instanceof JDRShading) {
            throw new InvalidEndColourException();
        }
        this.endColor = jDRPaint;
    }

    public void setStartLocation(int n) throws InvalidGradientDirectionException {
        if (n < 0 || n > 8) {
            throw new InvalidGradientDirectionException(n);
        }
        this.direction = n;
    }

    @Override
    public void reduceToGreyScale() {
        this.startColor = this.startColor.getJDRGray();
        this.endColor = this.endColor.getJDRGray();
    }

    @Override
    public String pgf(BBox bBox) {
        return this.startColor.pgf(bBox);
    }

    @Override
    public String pgfstrokecolor(BBox bBox) {
        return this.startColor.pgfstrokecolor(bBox);
    }

    public JDRGradient getJDRGradient() {
        try {
            return new JDRGradient(this.direction == 8 ? 0 : this.direction, this.startColor, this.endColor);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRGradient();
        }
    }

    @Override
    public JDRShading convertShading(String string) throws InvalidFormatException {
        if (string.equals("JDRRadial")) {
            return this;
        }
        if (string.equals("JDRGradient")) {
            return this.getJDRGradient();
        }
        throw new InvalidFormatException("Can't convert from JDRRadial to " + string);
    }

    @Override
    public int psLevel() {
        return 2;
    }

    @Override
    public void saveEPS(PrintWriter printWriter, BBox bBox) throws IOException {
        String string;
        String string2;
        if (bBox == null) {
            this.startColor.saveEPS(printWriter, bBox);
            return;
        }
        double d = bBox.getMinX();
        double d2 = bBox.getMaxX();
        double d3 = bBox.getMinY();
        double d4 = bBox.getMaxY();
        this.update(bBox);
        double d5 = this.getRadius();
        printWriter.println("<<");
        printWriter.println("   /ShadingType 3");
        if (this.startColor instanceof JDRColor) {
            JDRColor jDRColor = (JDRColor)this.startColor;
            printWriter.println("   /ColorSpace /DeviceRGB");
            string2 = "/C0 [" + jDRColor.getRed() + " " + jDRColor.getGreen() + " " + jDRColor.getBlue() + "]";
            jDRColor = this.endColor instanceof JDRColor ? (JDRColor)this.endColor : ((JDRColorCMYK)this.endColor).getJDRColor();
            string = "/C1 [" + jDRColor.getRed() + " " + jDRColor.getGreen() + " " + jDRColor.getBlue() + "]";
        } else {
            JDRColorCMYK jDRColorCMYK = (JDRColorCMYK)this.startColor;
            printWriter.println("   /ColorSpace /DeviceCMYK");
            string2 = "/C0 [" + jDRColorCMYK.getCyan() + " " + jDRColorCMYK.getMagenta() + " " + jDRColorCMYK.getYellow() + " " + jDRColorCMYK.getKey() + "]";
            jDRColorCMYK = this.endColor instanceof JDRColorCMYK ? (JDRColorCMYK)this.endColor : ((JDRColor)this.endColor).getJDRColorCMYK();
            string = "/C1 [" + jDRColorCMYK.getCyan() + " " + jDRColorCMYK.getMagenta() + " " + jDRColorCMYK.getYellow() + " " + jDRColorCMYK.getKey() + "]";
        }
        printWriter.println("   /BBox [" + d + " " + d3 + " " + d2 + " " + d4 + "]");
        printWriter.println("   /Coords [" + this.startPtx + " " + this.startPty + " 0 " + this.startPtx + " " + this.startPty + " " + d5 + "]");
        printWriter.println("      /Function <<");
        printWriter.println("         /FunctionType 2");
        printWriter.println("         /Domain [0 1]");
        printWriter.println("         " + string2);
        printWriter.println("         " + string);
        printWriter.println("         /N 1");
        printWriter.println("   >>");
        printWriter.print(">> ");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRRadial)) {
            return false;
        }
        JDRRadial jDRRadial = (JDRRadial)object;
        return this.direction == jDRRadial.direction && this.startColor.equals(jDRRadial.startColor) && this.endColor.equals(jDRRadial.endColor);
    }

    @Override
    public JDRPaintLoaderListener getListener() {
        return listener;
    }

    @Override
    public void fade(double d) {
        this.startColor.fade(d);
        this.endColor.fade(d);
    }
}

