/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;

public class JDRPointIterator
implements Iterator<JDRPoint>,
Serializable {
    protected JDRShape path_;
    protected int index = -1;
    protected int pointIndex = -1;
    protected JDRPoint point = null;
    protected int segmentIndex = 0;

    public JDRPointIterator(JDRShape jDRShape) {
        this.path_ = jDRShape;
        this.reset();
    }

    protected JDRPointIterator() {
        this.path_ = null;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (this.path_.isEmpty()) {
            return false;
        }
        JDRPoint jDRPoint = this.path_.getLastControl();
        return this.point != jDRPoint;
    }

    @Override
    public JDRPoint next() throws NoSuchElementException {
        if (this.pointIndex == -1) {
            this.point = this.path_.getFirstControl();
            if (this.point == null) {
                throw new NoSuchElementException();
            }
            this.pointIndex = 0;
            this.index = 0;
            this.segmentIndex = 0;
            return this.point;
        }
        JDRPathSegment jDRPathSegment = this.path_.get(this.segmentIndex);
        JDRPathSegment jDRPathSegment2 = this.path_.getLastSegment();
        int n = jDRPathSegment.controlCount();
        if (this.path_.segmentHasEnd(jDRPathSegment)) {
            ++n;
        }
        if (jDRPathSegment == jDRPathSegment2) {
            JDRPoint jDRPoint = this.path_.getLastControl();
            if (this.point == jDRPoint) {
                throw new NoSuchElementException();
            }
            ++this.index;
            if (this.path_.segmentHasEnd(jDRPathSegment) && this.index > n) {
                ++this.pointIndex;
                this.point = jDRPathSegment.getEnd();
                return this.point;
            }
        } else {
            ++this.index;
            if (this.index >= n) {
                ++this.segmentIndex;
                this.index = 0;
                try {
                    jDRPathSegment = this.path_.get(this.segmentIndex);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException(indexOutOfBoundsException.getMessage());
                }
                n = jDRPathSegment.controlCount();
                if (this.path_.segmentHasEnd(jDRPathSegment)) {
                    ++n;
                }
            }
        }
        ++this.pointIndex;
        if (this.index == jDRPathSegment.controlCount()) {
            this.point = jDRPathSegment.getEnd();
        } else {
            try {
                this.point = jDRPathSegment.getControl(this.index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException(indexOutOfBoundsException.getMessage());
            }
        }
        return this.point;
    }

    public int getCurrentPointIndex() {
        return this.pointIndex;
    }

    public int getCurrentSegmentIndex() {
        return this.segmentIndex;
    }

    @Override
    public void remove() throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.point = null;
        this.index = -1;
        this.pointIndex = -1;
        this.segmentIndex = 0;
    }

    public void set(int n, int n2, JDRPoint jDRPoint) throws ArrayIndexOutOfBoundsException, NoSuchElementException {
        this.pointIndex = n;
        this.segmentIndex = n2;
        this.point = jDRPoint;
        JDRPathSegment jDRPathSegment = this.path_.get(n2);
        this.index = this.path_.segmentHasEnd(jDRPathSegment) && this.point == jDRPathSegment.getEnd() ? jDRPathSegment.controlCount() : jDRPathSegment.getControlIndex(this.point);
    }

    public JDRShape getPath() {
        return this.path_;
    }
}

