/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.io.SVG;

public class JDRPoint
extends JDRObject {
    public double x;
    public double y;
    public static double pointSize = 10.0;
    public static Color innerColour = new Color(192, 192, 192, 127);
    public static Paint controlColor = new Color(255, 200, 0, 200);
    public static Paint selectColor = new Color(255, 0, 0, 200);

    public JDRPoint() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public JDRPoint(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public JDRPoint(Point2D point2D) {
        this.x = point2D.getX();
        this.y = point2D.getY();
    }

    public JDRPoint(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void set(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Paint getSelectedPaint() {
        return selectColor;
    }

    public void setSelectedPaint(Paint paint) {
        selectColor = paint;
    }

    public Paint getUnselectedPaint() {
        return controlColor;
    }

    public void setUnselectedPaint(Paint paint) {
        controlColor = paint;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        if (this.selected) {
            graphics2D.setPaint(this.getUnselectedPaint());
        }
        double d = pointSize * 0.5;
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.x - d, this.y - d, pointSize, pointSize);
        graphics2D.draw(double_);
        double_.x += 1.0;
        double_.y += 1.0;
        double_.width -= 2.0;
        double_.height -= 2.0;
        graphics2D.setPaint(innerColour);
        graphics2D.draw(double_);
        graphics2D.setPaint(paint);
    }

    public void draw(Graphics graphics, double d) {
        this.draw(graphics, d, this.selected ? this.getSelectedPaint() : this.getUnselectedPaint(), pointSize);
    }

    public void draw(Graphics graphics, double d, Paint paint, double d2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(paint);
        double d3 = d2 * 0.5;
        double d4 = d2 * d;
        Rectangle2D.Double double_ = new Rectangle2D.Double((this.x - d3) * d, (this.y - d3) * d, d4, d4);
        graphics2D.draw(double_);
        double d5 = 2.0 * d;
        double_.x += d;
        double_.y += d;
        double_.width -= d5;
        double_.height -= d5;
        graphics2D.setPaint(innerColour);
        graphics2D.draw(double_);
    }

    @Override
    public BBox getBBox() {
        double d = pointSize * 0.5;
        return new BBox(this.x - d, this.y - d, this.x + d, this.y + d);
    }

    @Override
    public void mergeBBox(BBox bBox) {
        double d = pointSize * 0.5;
        double d2 = this.x - d;
        double d3 = this.y - d;
        double d4 = this.x + d;
        double d5 = this.y + d;
        bBox.merge(d2, d3, d4, d5);
    }

    public boolean contains(JDRPoint jDRPoint) {
        if (this == jDRPoint) {
            return true;
        }
        return this.x - pointSize * 0.5 - 1.0 <= jDRPoint.x && jDRPoint.x <= this.x + pointSize * 0.5 && this.y - pointSize * 0.5 - 1.0 <= jDRPoint.y && jDRPoint.y <= this.y + pointSize * 0.5;
    }

    public boolean contains(Point point) {
        return this.x - pointSize * 0.5 - 1.0 <= (double)point.x && (double)point.x <= this.x + pointSize * 0.5 && this.y - pointSize * 0.5 - 1.0 <= (double)point.y && (double)point.y <= this.y + pointSize * 0.5;
    }

    public boolean contains(Point2D point2D) {
        return this.x - pointSize * 0.5 - 1.0 <= point2D.getX() && point2D.getX() <= this.x + pointSize * 0.5 && this.y - pointSize * 0.5 - 1.0 <= point2D.getY() && point2D.getY() <= this.y + pointSize * 0.5;
    }

    @Override
    public void transform(double[] dArray) {
        double d = dArray[0] * this.x + dArray[2] * this.y + dArray[4];
        double d2 = dArray[1] * this.x + dArray[3] * this.y + dArray[5];
        this.x = d;
        this.y = d2;
    }

    @Override
    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public void moveToLine(JDRLine jDRLine) {
        this.moveToLine(jDRLine.start.x, jDRLine.start.y, jDRLine.end.x, jDRLine.end.y);
    }

    public void moveToLine(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        double d7 = d6 / d5;
        double d8 = d5 / d6;
        if (Math.abs(d5) < 1.0) {
            this.x = d8 * (this.y - d2) + d;
        } else if (Math.abs(d6) < 1.0) {
            this.y = d7 * (this.x - d) + d2;
        } else {
            double d9 = (this.x * d8 + this.y + d7 * d - d2) / (d7 + d8);
            double d10 = d7 * (d9 - d) + d2;
            this.x = d9;
            this.y = d10;
        }
    }

    @Override
    public void scale(double d, double d2) {
        this.x = d * this.x;
        this.y = d2 * this.y;
    }

    @Override
    public void scaleX(double d) {
        this.x = d * this.x;
    }

    @Override
    public void scaleY(double d) {
        this.y = d * this.y;
    }

    @Override
    public void shear(double d, double d2) {
        double d3 = this.x;
        double d4 = this.y;
        this.x = d3 - d * d4;
        this.y = d4 - d2 * d3;
    }

    @Override
    public void shear(double d) {
        this.shear(d, d);
    }

    @Override
    public void shearX(double d) {
        this.shear(d, 0.0);
    }

    @Override
    public void shearY(double d) {
        this.shear(0.0, d);
    }

    @Override
    public void rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.x;
        double d5 = this.y;
        this.x = d4 * d2 - d5 * d3;
        this.y = d4 * d3 + d5 * d2;
    }

    public Point2D getPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }

    public Point2D getReflection(JDRLine jDRLine) {
        return JDRPoint.getReflection(this.x, this.y, jDRLine);
    }

    public void reflect2D(JDRLine jDRLine) {
        Point2D point2D = JDRPoint.getReflection(this.x, this.y, jDRLine);
        this.x = point2D.getX();
        this.y = point2D.getY();
    }

    public static Point2D getReflection(double d, double d2, JDRLine jDRLine) {
        double d3;
        double d4;
        double d5 = jDRLine.start.x - jDRLine.end.x;
        double d6 = jDRLine.start.y - jDRLine.end.y;
        if (Math.abs(d5) < 1.0) {
            d4 = 2.0 * jDRLine.end.x - d;
            d3 = d2;
        } else if (Math.abs(d6) < 1.0) {
            d4 = d;
            d3 = 2.0 * jDRLine.end.y - d2;
        } else {
            double d7 = d6 / d5;
            double d8 = d5 / d6;
            double d9 = (d * d8 + d2 + d7 * jDRLine.start.x - jDRLine.start.y) / (d7 + d8);
            double d10 = d7 * (d9 - jDRLine.start.x) + jDRLine.start.y;
            d4 = 2.0 * d9 - d;
            d3 = 2.0 * d10 - d2;
        }
        return new Point2D.Double(d4, d3);
    }

    public Point getPoint() {
        return new Point((int)Math.round(this.x), (int)Math.round(this.y));
    }

    @Override
    public Object clone() {
        JDRPoint jDRPoint = new JDRPoint(this.x, this.y);
        jDRPoint.makeEqual(this);
        return jDRPoint;
    }

    public void makeEqual(JDRPoint jDRPoint) {
        super.makeEqual(jDRPoint);
        this.x = jDRPoint.x;
        this.y = jDRPoint.y;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof JDRPoint)) {
            return false;
        }
        JDRPoint jDRPoint = (JDRPoint)object;
        return this.x == jDRPoint.x && this.y == jDRPoint.y;
    }

    public String toString() {
        return new String("JDRPoint(" + this.x + "," + this.y + ")");
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        return PGF.point(affineTransform, this.x, this.y);
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        SVG.savePoint(printWriter, this.x, this.y);
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        EPS.savePoint(printWriter, this.x, this.y);
    }

    public String info() {
        return "(" + this.x + "," + this.y + ")";
    }
}

