/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.util.NoSuchElementException;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPointIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;

public class JDRPatternPointIterator
extends JDRPointIterator {
    public JDRPatternPointIterator(JDRShape jDRShape) {
        this.path_ = jDRShape;
        this.reset();
    }

    protected JDRPatternPointIterator() {
        this.path_ = null;
        this.reset();
    }

    @Override
    public JDRPoint next() throws NoSuchElementException {
        JDRPattern jDRPattern = (JDRPattern)this.path_;
        if (this.pointIndex == -1 || this.segmentIndex == -1) {
            this.point = this.path_.getFirstControl();
            if (this.point == null) {
                throw new NoSuchElementException();
            }
            this.pointIndex = 0;
            this.index = 0;
            this.segmentIndex = 0;
            return this.point;
        }
        JDRPoint jDRPoint = jDRPattern.getPatternAnchor();
        if (this.point == jDRPoint) {
            throw new NoSuchElementException();
        }
        if (jDRPattern.hasAdjust() && this.point == jDRPattern.getPatternAdjust()) {
            this.point = jDRPoint;
            ++this.pointIndex;
            this.index = 1;
            return this.point;
        }
        JDRPathSegment jDRPathSegment = this.path_.get(this.segmentIndex);
        JDRPathSegment jDRPathSegment2 = this.path_.getLastSegment();
        int n = jDRPathSegment.controlCount();
        if (this.path_.segmentHasEnd(jDRPathSegment)) {
            ++n;
        }
        if (jDRPathSegment == jDRPathSegment2) {
            JDRPoint jDRPoint2 = jDRPattern.getUnderlyingShape().getLastControl();
            if (this.point == jDRPoint2) {
                JDRPoint jDRPoint3 = jDRPattern.getPatternAdjust();
                ++this.pointIndex;
                ++this.segmentIndex;
                if (jDRPoint3 != null) {
                    this.index = 0;
                    this.point = jDRPoint3;
                } else {
                    this.index = 1;
                    this.point = jDRPoint;
                }
                return this.point;
            }
            ++this.index;
            if (this.path_.segmentHasEnd(jDRPathSegment) && this.index > n) {
                ++this.pointIndex;
                this.point = jDRPathSegment.getEnd();
                return this.point;
            }
        } else {
            ++this.index;
            if (this.index >= n) {
                ++this.segmentIndex;
                this.index = 0;
                try {
                    jDRPathSegment = this.path_.get(this.segmentIndex);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException(indexOutOfBoundsException.getMessage());
                }
                n = jDRPathSegment.controlCount();
                if (this.path_.segmentHasEnd(jDRPathSegment)) {
                    ++n;
                }
            }
        }
        ++this.pointIndex;
        if (this.index == jDRPathSegment.controlCount()) {
            this.point = jDRPathSegment.getEnd();
        } else {
            try {
                this.point = jDRPathSegment.getControl(this.index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException(indexOutOfBoundsException.getMessage());
            }
        }
        return this.point;
    }

    @Override
    public void set(int n, int n2, JDRPoint jDRPoint) throws ArrayIndexOutOfBoundsException, NoSuchElementException {
        this.pointIndex = n;
        this.segmentIndex = n2;
        this.point = jDRPoint;
        JDRPattern jDRPattern = (JDRPattern)this.path_;
        JDRPoint jDRPoint2 = jDRPattern.getPatternAdjust();
        if (jDRPoint == jDRPattern.getPatternAnchor()) {
            this.index = jDRPoint2 == null ? 0 : 1;
            return;
        }
        if (jDRPoint == jDRPoint2) {
            this.index = 0;
            return;
        }
        JDRPathSegment jDRPathSegment = this.path_.get(n2);
        this.index = this.path_.segmentHasEnd(jDRPathSegment) && this.point == jDRPathSegment.getEnd() ? jDRPathSegment.controlCount() : jDRPathSegment.getControlIndex(this.point);
    }
}

