/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.EmptyPathException;
import uk.ac.uea.cmp.nlct.jdr.IllFittingPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidReplicaException;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRCompoundShape;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPathIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAdjustPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternAnchorPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRPatternPointIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPointIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRShading;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPath;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;

public abstract class JDRPattern
extends JDRCompoundShape {
    protected JDRPatternIterator iterator;
    protected JDRPatternPointIterator pointIterator;
    protected int replicas_;
    protected boolean singlemode_;
    protected boolean showoriginal_ = true;
    protected JDRShape path_;
    protected JDRPoint point_;
    protected JDRPoint adjust_ = null;

    protected void initIterators() {
        this.iterator = new JDRPatternIterator(this);
        this.pointIterator = new JDRPatternPointIterator(this);
    }

    @Override
    public boolean hasPattern() {
        return true;
    }

    @Override
    public JDRPattern getPattern() {
        return this;
    }

    @Override
    public void setSelected(boolean bl) {
        if (this.path_ != null) {
            this.path_.setSelected(bl);
        }
    }

    @Override
    public boolean isSelected() {
        return this.path_ == null ? false : this.path_.isSelected();
    }

    @Override
    public JDRPathIterator getIterator() {
        this.iterator.reset();
        return this.iterator;
    }

    @Override
    public JDRPointIterator getPointIterator() {
        this.pointIterator.reset();
        return this.pointIterator;
    }

    @Override
    public JDRPathSegment getFirstSegment() {
        return this.path_.getFirstSegment();
    }

    @Override
    public JDRPathSegment getLastSegment() {
        return this.path_.getLastSegment();
    }

    @Override
    public JDRPoint getFirstControl() {
        return this.path_.getFirstControl();
    }

    @Override
    public JDRPoint getLastControl() {
        return this.point_;
    }

    @Override
    public JDRShape getUnderlyingShape() {
        return this.path_;
    }

    @Override
    public void setUnderlyingShape(JDRShape jDRShape) {
        this.path_ = jDRShape;
    }

    @Override
    public void add(JDRSegment jDRSegment) {
        this.path_.add(jDRSegment);
    }

    public int getNumReplicas() {
        return this.replicas_;
    }

    public void setNumReplicas(int n) throws InvalidReplicaException {
        if (n < 1) {
            throw new InvalidReplicaException(n);
        }
        this.replicas_ = n;
    }

    public abstract void getReplicaTransform(double[] var1, int var2);

    @Override
    public JDRGroup separate(Graphics graphics) {
        JDRGroup jDRGroup = new JDRGroup();
        jDRGroup.add((JDRShape)this.path_.clone());
        double[] dArray = new double[6];
        for (int i = 1; i <= this.replicas_; ++i) {
            JDRShape jDRShape = (JDRShape)this.path_.clone();
            this.getReplicaTransform(dArray, i);
            jDRShape.transform(dArray);
            jDRGroup.add(jDRShape);
        }
        return jDRGroup;
    }

    @Override
    public JDRShape intersect(JDRShape jDRShape) throws InvalidPathException {
        return this.path_.intersect(jDRShape);
    }

    @Override
    public JDRShape pathUnion(JDRShape jDRShape) throws InvalidPathException {
        return this.path_.pathUnion(jDRShape);
    }

    @Override
    public JDRShape exclusiveOr(JDRShape jDRShape) throws InvalidPathException {
        return this.path_.exclusiveOr(jDRShape);
    }

    @Override
    public JDRShape subtract(JDRShape jDRShape) throws InvalidPathException {
        return this.path_.subtract(jDRShape);
    }

    @Override
    public BBox getControlBBox() {
        BBox bBox = this.path_.getControlBBox();
        if (bBox == null) {
            return null;
        }
        GeneralPath generalPath = this.getReplicasGeneralPath();
        bBox.merge(generalPath.getBounds2D());
        this.point_.mergeBBox(bBox);
        if (this.adjust_ != null) {
            this.adjust_.mergeBBox(bBox);
        }
        return bBox;
    }

    @Override
    public void mergeControlBBox(BBox bBox) {
        this.path_.mergeControlBBox(bBox);
        GeneralPath generalPath = this.getReplicasGeneralPath();
        bBox.merge(generalPath.getBounds2D());
        this.point_.mergeBBox(bBox);
        if (this.adjust_ != null) {
            this.adjust_.mergeBBox(bBox);
        }
    }

    @Override
    public void convertSegment(int n, JDRPathSegment jDRPathSegment) {
        this.path_.convertSegment(n, jDRPathSegment);
    }

    public void shearAnchor(double d, double d2) {
        this.point_.shear(d, d2);
        this.shearAdjust(d, d2);
    }

    public void shearAdjust(double d, double d2) {
        if (this.adjust_ != null) {
            this.adjust_.shear(d, d2);
        }
    }

    public void shearAnchor(Point2D point2D, double d, double d2) {
        this.point_.shear(point2D, d, d2);
        this.shearAdjust(point2D, d, d2);
    }

    public void shearAdjust(Point2D point2D, double d, double d2) {
        if (this.adjust_ != null) {
            this.adjust_.shear(point2D, d, d2);
        }
    }

    @Override
    public void shearParams(Point2D point2D, double d, double d2) {
        this.shearAnchor(point2D, d, d2);
    }

    public void scaleAnchor(double d, double d2) {
        this.point_.scale(d, d2);
        this.scaleAdjust(d, d2);
    }

    public void scaleAdjust(double d, double d2) {
        if (this.adjust_ != null) {
            this.adjust_.scale(d, d2);
        }
    }

    public void scaleAnchor(Point2D point2D, double d, double d2) {
        this.point_.scale(point2D, d, d2);
        this.scaleAdjust(point2D, d, d2);
    }

    public void scaleAdjust(Point2D point2D, double d, double d2) {
        if (this.adjust_ != null) {
            this.adjust_.scale(point2D, d, d2);
        }
    }

    @Override
    public void scaleParams(Point2D point2D, double d, double d2) {
        this.scaleAnchor(point2D, d, d2);
    }

    public void rotateAnchor(double d) {
        this.point_.rotate(d);
        this.rotateAdjust(d);
    }

    public void rotateAdjust(double d) {
        if (this.adjust_ != null) {
            this.adjust_.rotate(d);
        }
    }

    public void rotateAnchor(Point2D point2D, double d) {
        this.point_.rotate(point2D, d);
        this.rotateAdjust(point2D, d);
    }

    public void rotateAdjust(Point2D point2D, double d) {
        if (this.adjust_ != null) {
            this.adjust_.rotate(point2D, d);
        }
    }

    @Override
    public void rotateParams(Point2D point2D, double d) {
        this.rotateAnchor(point2D, d);
    }

    public void translateAnchor(double d, double d2) {
        this.point_.translate(d, d2);
    }

    public void translateAdjust(double d, double d2) {
        if (this.adjust_ != null) {
            this.adjust_.translate(d, d2);
        }
    }

    @Override
    public void translateParams(double d, double d2) {
        this.translateAnchor(d, d2);
        this.translateAdjust(d, d2);
    }

    @Override
    public void translateControl(JDRPathSegment jDRPathSegment, JDRPoint jDRPoint, double d, double d2) {
        if (jDRPoint == this.point_) {
            this.translateAnchor(d, d2);
        } else if (jDRPoint == this.adjust_) {
            this.translateAdjust(d, d2);
        } else {
            this.path_.translateControl(jDRPathSegment, jDRPoint, d, d2);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isClosed() {
        return this.path_.isClosed();
    }

    @Override
    public void open() {
        this.path_.open();
    }

    @Override
    public void open(boolean bl) {
        this.path_.open(bl);
    }

    @Override
    public void close(JDRPathSegment jDRPathSegment) throws EmptyPathException, IllFittingPathException {
        this.path_.close(jDRPathSegment);
    }

    @Override
    public Shape getStrokedPath() {
        return this.getStrokedPath(this.showoriginal_);
    }

    public Shape getStrokedPath(boolean bl) {
        if (this.singlemode_) {
            return super.getStrokedPath();
        }
        Shape shape = this.path_.getStrokedPath();
        double[] dArray = new double[6];
        AffineTransform affineTransform = new AffineTransform();
        GeneralPath generalPath = null;
        if (bl) {
            generalPath = new GeneralPath(shape);
        }
        for (int i = 1; i <= this.replicas_; ++i) {
            GeneralPath generalPath2 = new GeneralPath(shape);
            this.getReplicaTransform(dArray, i);
            affineTransform.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            generalPath2.transform(affineTransform);
            if (generalPath == null) {
                generalPath = generalPath2;
                continue;
            }
            generalPath.append(generalPath2, false);
        }
        return generalPath;
    }

    @Override
    public Area getStrokedArea() {
        return this.getStrokedArea(this.showoriginal_);
    }

    public Area getStrokedArea(boolean bl) {
        if (this.singlemode_) {
            return super.getStrokedArea();
        }
        Area area = this.path_.getStrokedArea();
        double[] dArray = new double[6];
        AffineTransform affineTransform = new AffineTransform();
        Area area2 = null;
        if (bl) {
            area2 = new Area(area);
        }
        for (int i = 1; i <= this.replicas_; ++i) {
            Area area3 = new Area(area);
            this.getReplicaTransform(dArray, i);
            affineTransform.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            area3.transform(affineTransform);
            if (area2 == null) {
                area2 = area3;
                continue;
            }
            area2.add(area3);
        }
        return area2;
    }

    @Override
    public JDRStroke getStroke() {
        return this.path_.getStroke();
    }

    @Override
    public void setStroke(JDRStroke jDRStroke) {
        this.path_.setStroke(jDRStroke);
    }

    @Override
    public JDRPaint getLinePaint() {
        return this.path_.getLinePaint();
    }

    @Override
    public void setLinePaint(JDRPaint jDRPaint) {
        this.path_.setLinePaint(jDRPaint);
    }

    @Override
    public JDRPaint getFillPaint() {
        return this.path_.getFillPaint();
    }

    @Override
    public void setFillPaint(JDRPaint jDRPaint) {
        this.path_.setFillPaint(jDRPaint);
    }

    public GeneralPath getReplicasGeneralPath() {
        if (this.isEmpty()) {
            return null;
        }
        GeneralPath generalPath = this.path_.getGeneralPath();
        GeneralPath generalPath2 = null;
        double[] dArray = new double[6];
        AffineTransform affineTransform = new AffineTransform();
        for (int i = 1; i <= this.replicas_; ++i) {
            GeneralPath generalPath3 = (GeneralPath)generalPath.clone();
            this.getReplicaTransform(dArray, i);
            affineTransform.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            generalPath3.transform(affineTransform);
            if (generalPath2 == null) {
                generalPath2 = generalPath3;
                continue;
            }
            generalPath2.append(generalPath3, false);
        }
        return generalPath2;
    }

    @Override
    public GeneralPath getGeneralPath() {
        return this.getGeneralPath(this.showoriginal_);
    }

    public GeneralPath getGeneralPath(boolean bl) {
        if (this.isEmpty()) {
            return null;
        }
        GeneralPath generalPath = this.path_.getGeneralPath();
        GeneralPath generalPath2 = null;
        if (bl) {
            generalPath2 = (GeneralPath)generalPath.clone();
        }
        double[] dArray = new double[6];
        AffineTransform affineTransform = new AffineTransform();
        for (int i = 1; i <= this.replicas_; ++i) {
            GeneralPath generalPath3 = (GeneralPath)generalPath.clone();
            this.getReplicaTransform(dArray, i);
            affineTransform.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            generalPath3.transform(affineTransform);
            if (generalPath2 == null) {
                generalPath2 = generalPath3;
                continue;
            }
            generalPath2.append(generalPath3, false);
        }
        return generalPath2;
    }

    @Override
    public void makeEqual(JDRObject jDRObject) {
        super.makeEqual(jDRObject);
        JDRPattern jDRPattern = (JDRPattern)jDRObject;
        if (jDRPattern.path_ == null) {
            this.path_ = null;
        } else if (this.path_ == null) {
            this.path_ = (JDRShape)jDRPattern.path_.clone();
        } else {
            this.path_.makeEqual(jDRPattern.path_);
        }
        if (jDRPattern.point_ == null) {
            this.point_ = null;
        } else if (this.point_ == null) {
            this.point_ = (JDRPatternAnchorPoint)jDRPattern.point_.clone();
        } else {
            this.point_.makeEqual(jDRPattern.point_);
        }
        this.replicas_ = jDRPattern.replicas_;
        this.singlemode_ = jDRPattern.singlemode_;
        this.showoriginal_ = jDRPattern.showoriginal_;
        if (jDRPattern.adjust_ == null) {
            this.adjust_ = null;
        } else if (this.adjust_ == null) {
            this.adjust_ = (JDRPatternAdjustPoint)jDRPattern.adjust_.clone();
        } else {
            this.adjust_.makeEqual(jDRPattern.adjust_);
        }
        this.makeParametersEqual(jDRPattern);
    }

    @Override
    public Object clone() {
        JDRPattern jDRPattern = this.createTemplate();
        if (this.path_ != null) {
            jDRPattern.path_ = (JDRShape)this.path_.clone();
        }
        if (this.point_ != null) {
            jDRPattern.point_ = (JDRPatternAnchorPoint)this.point_.clone();
        }
        if (this.adjust_ != null) {
            jDRPattern.adjust_ = (JDRPatternAdjustPoint)this.adjust_.clone();
        }
        jDRPattern.singlemode_ = this.singlemode_;
        jDRPattern.showoriginal_ = this.showoriginal_;
        return jDRPattern;
    }

    public abstract JDRPattern createTemplate();

    public abstract void makeParametersEqual(JDRPattern var1);

    @Override
    public JDRShape reverse() throws InvalidPathException {
        JDRShape jDRShape = this.path_.reverse();
        JDRPattern jDRPattern = this.createTemplate();
        jDRPattern.path_ = jDRShape;
        jDRPattern.point_ = (JDRPatternAnchorPoint)this.point_.clone();
        if (this.adjust_ != null) {
            jDRPattern.adjust_ = (JDRPatternAdjustPoint)this.adjust_.clone();
        }
        return jDRPattern;
    }

    @Override
    public JDRTextual getTextual() {
        return this.path_.getTextual();
    }

    @Override
    public boolean hasTextual() {
        return this.path_.hasTextual();
    }

    @Override
    public boolean showPath() {
        return this.path_.showPath();
    }

    @Override
    public boolean hasSymmetricPath() {
        return this.path_.hasSymmetricPath();
    }

    @Override
    public JDRSymmetricPath getSymmetricPath() {
        return this.path_.getSymmetricPath();
    }

    public JDRPoint getPatternAnchor() {
        return this.point_;
    }

    public JDRPoint getPatternAdjust() {
        return this.adjust_;
    }

    public void setPatternAnchor(JDRPoint jDRPoint) {
        this.point_ = jDRPoint == null || jDRPoint instanceof JDRPatternAnchorPoint ? jDRPoint : new JDRPatternAnchorPoint(jDRPoint.x, jDRPoint.y);
    }

    public void setPatternAnchor(double d, double d2) {
        if (this.point_ == null) {
            this.point_ = new JDRPatternAnchorPoint(d, d2);
        } else {
            this.point_.x = d;
            this.point_.y = d2;
        }
    }

    public void setPatternAdjust(JDRPoint jDRPoint) {
        this.adjust_ = jDRPoint == null || jDRPoint instanceof JDRPatternAdjustPoint ? jDRPoint : new JDRPatternAdjustPoint(jDRPoint.x, jDRPoint.y);
    }

    public void setPatternAdjust(double d, double d2) {
        if (this.adjust_ == null) {
            this.adjust_ = new JDRPatternAdjustPoint(d, d2);
        } else {
            this.adjust_.x = d;
            this.adjust_.y = d2;
        }
    }

    public boolean hasAdjust() {
        return false;
    }

    public void setDefaultPatternAdjust() {
        this.adjust_ = null;
        if (!this.hasAdjust()) {
            return;
        }
        if (this.point_ == null || this.path_ == null) {
            return;
        }
        JDRPoint jDRPoint = this.path_.getFirstControl();
        double[] dArray = new double[6];
        this.getReplicaTransform(dArray, 1);
        this.adjust_ = new JDRPatternAdjustPoint(dArray[0] * jDRPoint.x + dArray[2] * jDRPoint.y + dArray[4], dArray[1] * jDRPoint.x + dArray[3] * jDRPoint.y + dArray[5]);
    }

    public void setSinglePath(boolean bl) {
        this.singlemode_ = bl;
    }

    public boolean isSinglePath() {
        return this.singlemode_;
    }

    public void setShowOriginal(boolean bl) {
        this.showoriginal_ = bl;
    }

    public boolean showOriginal() {
        return this.showoriginal_;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.singlemode_) {
            super.draw(graphics);
            return;
        }
        if (this.showPath()) {
            if (this.showoriginal_) {
                this.path_.draw(graphics);
            }
            AffineTransform affineTransform = graphics2D.getTransform();
            double[] dArray = new double[6];
            AffineTransform affineTransform2 = new AffineTransform();
            for (int i = 1; i <= this.replicas_; ++i) {
                graphics2D.setTransform(affineTransform);
                this.getReplicaTransform(dArray, i);
                affineTransform2.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                graphics2D.transform(affineTransform2);
                this.path_.draw(graphics);
            }
            graphics2D.setTransform(affineTransform);
        } else {
            Paint paint = graphics2D.getPaint();
            JDRPaint jDRPaint = this.getLinePaint();
            Area area = this.getStrokedArea();
            BBox bBox = null;
            if (jDRPaint instanceof JDRShading) {
                bBox = new BBox(area.getBounds2D());
            }
            graphics2D.setPaint(jDRPaint.getPaint(bBox));
            if (this.showoriginal_) {
                graphics2D.fill(area);
            }
            graphics2D.setPaint(paint);
        }
    }

    @Override
    public void drawDraft(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        double[] dArray = new double[6];
        AffineTransform affineTransform = new AffineTransform();
        GeneralPath generalPath = this.path_.getGeneralPath();
        graphics2D.setPaint(draftColor);
        for (int i = 1; i <= this.replicas_; ++i) {
            this.getReplicaTransform(dArray, i);
            int n = 0;
            while (n < 6) {
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
            affineTransform.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            Shape shape = affineTransform.createTransformedShape(generalPath);
            graphics2D.draw(shape);
        }
        affineTransform.setToScale(d, d);
        generalPath.transform(affineTransform);
        graphics2D.setPaint(draftColor);
        graphics2D.draw(generalPath);
        JDRPathSegment jDRPathSegment = this.getSelectedSegment();
        if (jDRPathSegment != null) {
            jDRPathSegment.drawSelectedNoControls(graphics, d);
        }
        int n = this.path_.size();
        for (int i = 0; i < n; ++i) {
            jDRPathSegment = this.get(i);
            jDRPathSegment.drawControls(graphics, this.segmentHasEnd(jDRPathSegment), d);
        }
        this.point_.draw(graphics, d);
        if (this.adjust_ != null) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(this.adjust_.isSelected() ? this.adjust_.getSelectedPaint() : this.adjust_.getUnselectedPaint());
            graphics2D.setStroke(JDRSegment.guideStroke);
            graphics2D.drawLine((int)(this.point_.x * d), (int)(this.point_.y * d), (int)(this.adjust_.x * d), (int)(this.adjust_.y * d));
            graphics2D.setStroke(stroke);
            this.adjust_.draw(graphics, d);
        }
    }

    @Override
    public void setCapacity(int n) throws IllegalArgumentException {
        this.path_.setCapacity(n);
    }

    @Override
    public int getCapacity() {
        return this.path_.getCapacity();
    }

    @Override
    public JDRPoint addPoint() {
        return this.path_.addPoint();
    }

    @Override
    public void makeContinuous(boolean bl) {
        this.path_.makeContinuous(bl);
    }

    @Override
    protected void stopEditing() {
        this.path_.stopEditing();
        this.editMode = false;
    }

    @Override
    public void setEditMode(boolean bl) {
        if (bl) {
            this.selectNextControl();
        } else {
            this.stopEditing();
        }
    }

    @Override
    public JDRPoint selectPreviousControl() {
        int n = this.path_.size();
        int n2 = this.getSelectedIndex();
        JDRPoint jDRPoint = this.getSelectedControl();
        if (jDRPoint == this.point_) {
            if (this.adjust_ != null) {
                this.selectControl(this.adjust_, this.getSelectedControlIndex() - 1, n);
                return this.adjust_;
            }
            this.selectControl(this.path_.getFirstControl(), 0, 0);
            return this.path_.selectPreviousControl();
        }
        if (this.adjust_ != null && jDRPoint == this.adjust_) {
            this.selectControl(this.path_.getFirstControl(), 0, 0);
            return this.path_.selectPreviousControl();
        }
        return super.selectPreviousControl();
    }

    @Override
    protected void setSelectedElements(int n, int n2, JDRPathSegment jDRPathSegment, JDRPoint jDRPoint) {
        this.path_.setSelectedElements(n, n2, jDRPathSegment, jDRPoint);
    }

    @Override
    public void selectControl(JDRPoint jDRPoint, int n, int n2) {
        if (jDRPoint == this.point_) {
            this.stopEditing();
            this.setSelectedElements(n2, n, null, this.point_);
            this.point_.setSelected(true);
            if (this.adjust_ != null) {
                this.adjust_.setSelected(false);
            }
        } else if (this.adjust_ != null && jDRPoint == this.adjust_) {
            this.stopEditing();
            this.setSelectedElements(n2, n, null, this.adjust_);
            this.adjust_.setSelected(true);
            this.point_.setSelected(false);
        } else {
            this.point_.setSelected(false);
            if (this.adjust_ != null) {
                this.adjust_.setSelected(false);
            }
            this.path_.selectControl(jDRPoint, n, n2);
        }
        this.editMode = true;
        this.selected = true;
    }

    @Override
    public int getSelectedControlIndex() {
        return this.path_.getSelectedControlIndex();
    }

    @Override
    public JDRPathSegment removeSelectedSegment() {
        return this.path_.removeSelectedSegment();
    }

    @Override
    public JDRPathSegment remove(JDRPathSegment jDRPathSegment) {
        return this.path_.remove(jDRPathSegment);
    }

    @Override
    public JDRSegment removeSegment(int n) throws ArrayIndexOutOfBoundsException {
        return (JDRSegment)this.path_.remove(n);
    }

    @Override
    public JDRPathSegment setSegment(int n, JDRPathSegment jDRPathSegment) throws ArrayIndexOutOfBoundsException {
        return this.path_.setSegment(n, jDRPathSegment);
    }

    @Override
    public JDRPathSegment remove(int n) {
        return this.path_.remove(n);
    }

    @Override
    public int getSelectedIndex() {
        return this.path_.getSelectedIndex();
    }

    @Override
    public JDRPoint getSelectedControl() {
        return this.path_.getSelectedControl();
    }

    @Override
    public JDRPathSegment getSelectedSegment() {
        return this.path_.getSelectedSegment();
    }

    @Override
    public boolean segmentHasEnd(JDRPathSegment jDRPathSegment) {
        return this.path_.segmentHasEnd(jDRPathSegment);
    }

    @Override
    public int size() {
        return this.path_.size();
    }

    @Override
    public int getTotalPathSegments() {
        return (this.replicas_ + 1) * this.path_.size() + this.replicas_;
    }

    @Override
    public JDRPathSegment get(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = this.getTotalPathSegments();
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < this.path_.size()) {
            return this.path_.get(n);
        }
        int n3 = this.path_.size();
        JDRSegment jDRSegment = null;
        int n4 = n % (n3 + 1);
        int n5 = n / (n3 + 1);
        double[] dArray = new double[6];
        if (n4 == n3) {
            JDRPathSegment jDRPathSegment = this.path_.getLastSegment();
            JDRPathSegment jDRPathSegment2 = this.path_.getFirstSegment();
            JDRPoint jDRPoint = jDRPathSegment.getEnd();
            if (!(jDRPathSegment instanceof JDRPartialSegment)) {
                jDRPoint = (JDRPoint)jDRPoint.clone();
            }
            if (n5 > 0) {
                this.getReplicaTransform(dArray, n5);
                jDRPoint.transform(dArray);
            }
            JDRPoint jDRPoint2 = (JDRPoint)jDRPathSegment2.getStart().clone();
            this.getReplicaTransform(dArray, n5 + 1);
            jDRPoint2.transform(dArray);
            jDRSegment = new JDRSegment(jDRPoint, jDRPoint2);
        } else {
            jDRSegment = (JDRSegment)this.path_.get(n4).clone();
            this.getReplicaTransform(dArray, n5);
            jDRSegment.transform(dArray);
        }
        return jDRSegment;
    }

    @Override
    public int getIndex(JDRPathSegment jDRPathSegment) {
        return this.path_.getIndex(jDRPathSegment);
    }

    @Override
    public int getLastIndex(JDRPathSegment jDRPathSegment) {
        return this.path_.getLastIndex(jDRPathSegment);
    }

    @Override
    public JDRShape breakPath() throws InvalidPathException {
        JDRShape jDRShape = this.path_.breakPath();
        JDRPattern jDRPattern = this.createTemplate();
        jDRPattern.path_ = jDRShape;
        if (this.point_ != null) {
            jDRPattern.point_ = (JDRPatternAnchorPoint)this.point_.clone();
        }
        if (this.adjust_ != null) {
            jDRPattern.adjust_ = (JDRPatternAdjustPoint)this.adjust_.clone();
        }
        return jDRPattern;
    }

    @Override
    public JDRShape getFullPath() throws EmptyPathException, IllFittingPathException {
        int n = this.path_.size();
        JDRShape jDRShape = null;
        JDRPoint jDRPoint = null;
        if (this.showoriginal_) {
            jDRShape = this.path_.getFullPath();
            if (jDRShape.isClosed()) {
                jDRShape.open(false);
            }
            jDRPoint = jDRShape.getLastSegment().getEnd();
        }
        double[] dArray = new double[6];
        for (int i = 1; i <= this.replicas_; ++i) {
            JDRShape jDRShape2 = (JDRShape)this.path_.clone();
            this.getReplicaTransform(dArray, i);
            jDRShape2.transform(dArray);
            if (jDRShape == null) {
                jDRShape = jDRShape2;
                jDRPoint = jDRShape.getLastSegment().getEnd();
                if (!jDRShape.isClosed()) continue;
                jDRShape.open(false);
                continue;
            }
            for (int j = 0; j < n; ++j) {
                JDRPathSegment jDRPathSegment = jDRShape2.get(j);
                if (j == 0) {
                    jDRShape.add(new JDRSegment(jDRPoint, jDRPathSegment.getStart()));
                }
                if (jDRPathSegment instanceof JDRPartialSegment) {
                    jDRPathSegment = ((JDRPartialSegment)jDRPathSegment).getFullSegment();
                }
                jDRShape.add((JDRSegment)jDRPathSegment);
                jDRPoint = jDRPathSegment.getEnd();
            }
        }
        return jDRShape;
    }

    public JDRCompleteObject getFullObject() throws EmptyPathException, IllFittingPathException {
        if (this.singlemode_) {
            return this.getFullPath();
        }
        JDRGroup jDRGroup = new JDRGroup(this.replicas_ + 1);
        JDRShape jDRShape = this.path_.getFullPath();
        if (this.showoriginal_) {
            jDRGroup.add(jDRShape);
        }
        double[] dArray = new double[6];
        for (int i = 1; i <= this.replicas_; ++i) {
            JDRShape jDRShape2 = (JDRShape)jDRShape.clone();
            this.getReplicaTransform(dArray, i);
            jDRShape2.transform(dArray);
            jDRGroup.add(jDRShape2);
        }
        return jDRGroup;
    }

    @Override
    public int psLevel() {
        return this.path_.psLevel();
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        if (this.singlemode_) {
            try {
                this.getFullPath().saveEPS(printWriter);
            }
            catch (InvalidPathException invalidPathException) {}
        } else {
            if (this.showoriginal_) {
                this.path_.saveEPS(printWriter);
            }
            double[] dArray = new double[6];
            for (int i = 1; i <= this.replicas_; ++i) {
                JDRShape jDRShape = (JDRShape)this.path_.clone();
                this.getReplicaTransform(dArray, i);
                jDRShape.transform(dArray);
                jDRShape.saveEPS(printWriter);
            }
        }
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        if (this.singlemode_) {
            try {
                this.getFullPath().saveSVG(printWriter);
            }
            catch (InvalidPathException invalidPathException) {}
        } else {
            if (this.showoriginal_) {
                this.path_.saveSVG(printWriter);
            }
            double[] dArray = new double[6];
            for (int i = 1; i <= this.replicas_; ++i) {
                JDRShape jDRShape = (JDRShape)this.path_.clone();
                this.getReplicaTransform(dArray, i);
                jDRShape.transform(dArray);
                jDRShape.saveSVG(printWriter);
            }
        }
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        if (this.singlemode_) {
            try {
                return this.getFullPath().pgf(affineTransform);
            }
            catch (InvalidPathException invalidPathException) {
                return "";
            }
        }
        String string = System.getProperty("line.separator", "\n");
        String string2 = string + "% pattern (" + this.replicas_ + " " + (this.replicas_ == 1 ? "replica" : "replicas") + ")" + string;
        if (this.showoriginal_) {
            string2 = string2 + "% Original " + string;
            string2 = string2 + this.path_.pgf(affineTransform);
        }
        double[] dArray = new double[6];
        for (int i = 1; i <= this.replicas_; ++i) {
            JDRShape jDRShape = (JDRShape)this.path_.clone();
            this.getReplicaTransform(dArray, i);
            jDRShape.transform(dArray);
            string2 = string2 + string + "% replica " + i + string;
            string2 = string2 + jDRShape.pgf(affineTransform);
        }
        return string2;
    }

    @Override
    public void fade(double d) {
        this.path_.fade(d);
    }
}

