/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import java.util.Enumeration;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidObjectException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathStyleIDException;
import uk.ac.uea.cmp.nlct.jdr.JDRPathStyleListener;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRPathStyleLoader {
    private Vector<JDRPathStyleListener> listeners_ = new Vector();

    public void saveJDR(JDRShape jDRShape, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRPathStyleListener jDRPathStyleListener = jDRShape.getPathStyleListener();
        if (jDRPathStyleListener == null) {
            throw new InvalidObjectException("Shape " + jDRShape.getClass().getName() + " doesn't have a valid listener");
        }
        dataOutputStream.writeByte(jDRPathStyleListener.getJDRid(f));
        jDRPathStyleListener.writeJDR(jDRShape, dataOutputStream, f);
    }

    public void loadJDR(DataInputStream dataInputStream, float f, JDRShape jDRShape) throws IOException, InvalidFormatException {
        byte by = dataInputStream.readByte();
        Enumeration<JDRPathStyleListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRPathStyleListener jDRPathStyleListener = enumeration.nextElement();
            if (jDRPathStyleListener.getJDRid(f) != by) continue;
            jDRPathStyleListener.readJDR(dataInputStream, f, jDRShape);
            return;
        }
        throw new InvalidPathStyleIDException(by);
    }

    public void saveAJR(JDRShape jDRShape, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRPathStyleListener jDRPathStyleListener = jDRShape.getPathStyleListener();
        if (jDRPathStyleListener == null) {
            throw new InvalidObjectException("Shape " + jDRShape.getClass().getName() + " doesn't have a valid listener");
        }
        AJR.writeInt(printWriter, jDRPathStyleListener.getAJRid(f));
        jDRPathStyleListener.writeAJR(jDRShape, printWriter, f);
    }

    public void loadAJR(BufferedReader bufferedReader, float f, JDRShape jDRShape) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        int n = AJR.readInt(bufferedReader);
        Enumeration<JDRPathStyleListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRPathStyleListener jDRPathStyleListener = enumeration.nextElement();
            if (jDRPathStyleListener.getAJRid(f) != n) continue;
            jDRPathStyleListener.readAJR(bufferedReader, f, jDRShape);
            return;
        }
        throw new InvalidPathStyleIDException(n);
    }

    public void addListener(JDRPathStyleListener jDRPathStyleListener) {
        this.listeners_.add(jDRPathStyleListener);
    }

    public Vector<JDRPathStyleListener> getListeners() {
        return this.listeners_;
    }
}

