/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidOpenCloseIDException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPathStyleLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRSegmentLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class JDRPathListener
implements JDRObjectLoaderListener {
    @Override
    public char getJDRid(float f) {
        return 'P';
    }

    @Override
    public void writeJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRPath jDRPath = (JDRPath)jDRObject;
        if ((double)f < 1.6) {
            JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
            jDRPaintLoader.saveJDR(jDRPath.getLinePaint(), dataOutputStream, f);
            jDRPaintLoader.saveJDR(jDRPath.getFillPaint(), dataOutputStream, f);
            jDRPath.getStroke().save(dataOutputStream, f);
        } else {
            JDRPathStyleLoader jDRPathStyleLoader = JDR.getPathStyleLoader();
            jDRPathStyleLoader.saveJDR(jDRPath, dataOutputStream, f);
        }
        this.writeJDRPathSpecs(jDRPath, dataOutputStream, f);
    }

    protected void writeJDRPathSpecs(JDRShape jDRShape, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        dataOutputStream.writeChar(jDRShape.isClosed() ? 67 : 79);
        int n = jDRShape.size();
        dataOutputStream.writeInt(n);
        JDRSegmentLoader jDRSegmentLoader = JDR.getSegmentLoader();
        for (int i = 0; i < n; ++i) {
            JDRSegment jDRSegment = (JDRSegment)jDRShape.get(i);
            if (i == 0 && f >= 1.3f) {
                dataOutputStream.writeDouble(jDRSegment.getStartX());
                dataOutputStream.writeDouble(jDRSegment.getStartY());
            }
            jDRSegmentLoader.saveJDR(jDRSegment, dataOutputStream, f);
        }
    }

    @Override
    public JDRObject readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        JDRPath jDRPath = new JDRPath();
        if ((double)f < 1.6) {
            JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
            jDRPath.setLinePaint(jDRPaintLoader.loadJDR(dataInputStream, f));
            jDRPath.setFillPaint(jDRPaintLoader.loadJDR(dataInputStream, f));
            jDRPath.setStroke(JDRBasicStroke.read(dataInputStream, f));
        } else {
            JDRPathStyleLoader jDRPathStyleLoader = JDR.getPathStyleLoader();
            jDRPathStyleLoader.loadJDR(dataInputStream, f, jDRPath);
        }
        this.readJDRPathSpecs(jDRPath, dataInputStream, f);
        return jDRPath;
    }

    protected void readJDRPathSpecs(JDRShape jDRShape, DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        boolean bl;
        char c = dataInputStream.readChar();
        if (c == 'O') {
            bl = false;
        } else if (c == 'C') {
            bl = true;
        } else {
            throw new InvalidOpenCloseIDException(c);
        }
        int n = dataInputStream.readInt();
        if (n > jDRShape.getCapacity()) {
            jDRShape.setCapacity(n);
        }
        double d = 0.0;
        double d2 = 0.0;
        if (f >= 1.3f) {
            d = dataInputStream.readDouble();
            d2 = dataInputStream.readDouble();
        }
        JDRSegmentLoader jDRSegmentLoader = JDR.getSegmentLoader();
        for (int i = 0; i < n; ++i) {
            JDRSegment jDRSegment = (JDRSegment)jDRSegmentLoader.loadJDR(d, d2, dataInputStream, f);
            if (bl && i == n - 1) {
                jDRShape.close(jDRSegment);
            } else {
                jDRShape.add(jDRSegment);
            }
            d = jDRSegment.end.x;
            d2 = jDRSegment.end.y;
        }
    }

    @Override
    public char getAJRid(float f) {
        return 'P';
    }

    protected void writeAJRPathSpecs(JDRShape jDRShape, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        AJR.writeChar(printWriter, jDRShape.isClosed() ? (char)'C' : 'O');
        int n = jDRShape.size();
        AJR.writeInt(printWriter, n);
        JDRSegmentLoader jDRSegmentLoader = AJR.getSegmentLoader();
        for (int i = 0; i < n; ++i) {
            JDRSegment jDRSegment = (JDRSegment)jDRShape.get(i);
            if (i == 0 && f >= 1.3f) {
                AJR.writeDouble(printWriter, jDRSegment.getStartX());
                AJR.writeDouble(printWriter, jDRSegment.getStartY());
            }
            jDRSegmentLoader.saveAJR(jDRSegment, printWriter, f);
        }
    }

    @Override
    public void writeAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRPath jDRPath = (JDRPath)jDRObject;
        if ((double)f < 1.6) {
            JDRPaintLoader jDRPaintLoader = AJR.getPaintLoader();
            jDRPaintLoader.saveAJR(jDRPath.getLinePaint(), printWriter, f);
            jDRPaintLoader.saveAJR(jDRPath.getFillPaint(), printWriter, f);
            jDRPath.getStroke().saveAJR(printWriter, f);
        } else {
            JDRPathStyleLoader jDRPathStyleLoader = AJR.getPathStyleLoader();
            jDRPathStyleLoader.saveAJR(jDRPath, printWriter, f);
        }
        this.writeAJRPathSpecs(jDRPath, printWriter, f);
    }

    protected void readAJRPathSpecs(JDRShape jDRShape, BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        boolean bl;
        char c = AJR.readChar(bufferedReader);
        if (c == 'O') {
            bl = false;
        } else if (c == 'C') {
            bl = true;
        } else {
            throw new InvalidOpenCloseIDException(c);
        }
        int n = AJR.readInt(bufferedReader);
        if (n > jDRShape.getCapacity()) {
            jDRShape.setCapacity(n);
        }
        double d = 0.0;
        double d2 = 0.0;
        if (f >= 1.3f) {
            d = AJR.readDouble(bufferedReader);
            d2 = AJR.readDouble(bufferedReader);
        }
        JDRSegmentLoader jDRSegmentLoader = AJR.getSegmentLoader();
        for (int i = 0; i < n; ++i) {
            JDRSegment jDRSegment = (JDRSegment)jDRSegmentLoader.loadAJR(d, d2, bufferedReader, f);
            if (bl && i == n - 1) {
                jDRShape.close(jDRSegment);
            } else {
                jDRShape.add(jDRSegment);
            }
            d = jDRSegment.end.x;
            d2 = jDRSegment.end.y;
        }
    }

    @Override
    public JDRObject readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        JDRPath jDRPath = new JDRPath();
        if ((double)f < 1.6) {
            JDRPaintLoader jDRPaintLoader = AJR.getPaintLoader();
            jDRPath.setLinePaint(jDRPaintLoader.loadAJR(bufferedReader, f));
            jDRPath.setFillPaint(jDRPaintLoader.loadAJR(bufferedReader, f));
            jDRPath.setStroke(JDRBasicStroke.readAJR(bufferedReader, f));
        } else {
            JDRPathStyleLoader jDRPathStyleLoader = AJR.getPathStyleLoader();
            jDRPathStyleLoader.loadAJR(bufferedReader, f, jDRPath);
        }
        this.readAJRPathSpecs(jDRPath, bufferedReader, f);
        return jDRPath;
    }
}

