/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;

public class JDRPathIterator
implements Iterator<JDRPathSegment>,
Serializable {
    protected JDRShape path_;
    protected int index = 0;

    public JDRPathIterator(JDRShape jDRShape) {
        this.path_ = jDRShape;
        this.index = 0;
    }

    protected JDRPathIterator() {
        this.path_ = null;
        this.index = 0;
    }

    public int pathSize() {
        return this.path_.size();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.pathSize();
    }

    public boolean hasPrev() {
        return this.index > 0;
    }

    @Override
    public JDRPathSegment next() throws NoSuchElementException {
        int n = this.pathSize();
        if (this.index >= n) {
            throw new NoSuchElementException();
        }
        JDRPathSegment jDRPathSegment = this.path_.get(this.index);
        if (this.path_.getStroke() instanceof JDRBasicStroke) {
            JDRBasicStroke jDRBasicStroke = (JDRBasicStroke)this.path_.getStroke();
            if (this.index == 0) {
                jDRPathSegment.setStartMarker(jDRBasicStroke.getStartArrow());
            } else {
                jDRPathSegment.setStartMarker(null);
            }
            if (this.index == n - 1) {
                jDRPathSegment.setEndMarker(jDRBasicStroke.getEndArrow());
            } else {
                jDRPathSegment.setEndMarker(jDRBasicStroke.getMidArrow());
            }
        }
        ++this.index;
        return jDRPathSegment;
    }

    public JDRPathSegment prev() throws NoSuchElementException {
        --this.index;
        if (this.index < 0) {
            throw new NoSuchElementException();
        }
        JDRPathSegment jDRPathSegment = this.path_.get(this.index);
        if (this.path_.getStroke() instanceof JDRBasicStroke) {
            JDRBasicStroke jDRBasicStroke = (JDRBasicStroke)this.path_.getStroke();
            if (this.index == 0) {
                jDRPathSegment.setStartMarker(jDRBasicStroke.getStartArrow());
            } else {
                jDRPathSegment.setStartMarker(null);
            }
            if (this.index == this.pathSize() - 1) {
                jDRPathSegment.setEndMarker(jDRBasicStroke.getEndArrow());
            } else {
                jDRPathSegment.setEndMarker(jDRBasicStroke.getMidArrow());
            }
        }
        return jDRPathSegment;
    }

    @Override
    public void remove() throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.index = 0;
    }

    public void reset(boolean bl) {
        this.index = bl ? 0 : this.pathSize();
    }

    public JDRShape getPath() {
        return this.path_;
    }
}

