/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.DashPattern;
import uk.ac.uea.cmp.nlct.jdr.EmptyPathException;
import uk.ac.uea.cmp.nlct.jdr.FlowFrame;
import uk.ac.uea.cmp.nlct.jdr.IllFittingPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidCapStyleException;
import uk.ac.uea.cmp.nlct.jdr.InvalidJoinStyleException;
import uk.ac.uea.cmp.nlct.jdr.InvalidMitreLimitException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPenWidthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidShapeException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPathIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRPathListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRPointIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPath;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdr.MissingMoveException;
import uk.ac.uea.cmp.nlct.jdr.NoSegmentSelectedException;
import uk.ac.uea.cmp.nlct.jdr.Parshape;
import uk.ac.uea.cmp.nlct.jdr.SelectedSegmentNotFoundException;
import uk.ac.uea.cmp.nlct.jdr.ShapeHasNoHeightException;
import uk.ac.uea.cmp.nlct.jdr.ShapeHasNoWidthException;
import uk.ac.uea.cmp.nlct.jdr.TooManyIntersectsException;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class JDRPath
extends JDRShape {
    private boolean closed;
    protected int selectedSegmentIndex = -1;
    protected JDRPathSegment selectedSegment = null;
    protected JDRPoint selectedControl = null;
    protected int selectedControlIndex;
    private JDRSegment[] segmentList_;
    private int capacity_ = 10;
    private int size_ = 0;
    protected JDRPathIterator iterator;
    protected JDRPointIterator pointIterator;
    private static JDRPathListener pathListener = new JDRPathListener();
    public static int init_capacity_memory = 5;
    public static int init_capacity_speed = 20;
    private JDRPaint fillPaint;
    private JDRPaint linePaint;
    private JDRStroke stroke;

    public JDRPath() {
        this.init();
    }

    public JDRPath(JDRPaint jDRPaint) {
        this();
        this.setLinePaint(jDRPaint);
    }

    public JDRPath(JDRPaint jDRPaint, JDRPaint jDRPaint2) {
        this(jDRPaint);
        this.setFillPaint(jDRPaint2);
    }

    public JDRPath(JDRPaint jDRPaint, JDRPaint jDRPaint2, JDRStroke jDRStroke) {
        this(jDRPaint, jDRPaint2);
        this.setStroke(jDRStroke);
    }

    public JDRPath(JDRPaint jDRPaint, JDRPaint jDRPaint2, double d, int n, int n2, double d2, DashPattern dashPattern) throws InvalidPenWidthException, InvalidCapStyleException, InvalidJoinStyleException, InvalidMitreLimitException {
        this();
        this.setStyle(jDRPaint, jDRPaint2, d, n, n2, d2, dashPattern);
    }

    public JDRPath(int n) {
        this.init(n);
    }

    public JDRPath(int n, JDRPaint jDRPaint) {
        this.init(n);
        this.setLinePaint(jDRPaint);
    }

    public JDRPath(int n, JDRPaint jDRPaint, JDRPaint jDRPaint2) {
        this.init(n);
        this.setLinePaint(jDRPaint);
        this.setFillPaint(jDRPaint2);
    }

    public JDRPath(int n, JDRPaint jDRPaint, JDRPaint jDRPaint2, JDRStroke jDRStroke) {
        this.init(n);
        this.setLinePaint(jDRPaint);
        this.setFillPaint(jDRPaint2);
        this.setStroke(jDRStroke);
    }

    public JDRPath(int n, JDRPaint jDRPaint, JDRPaint jDRPaint2, double d, int n2, int n3, double d2, DashPattern dashPattern) throws InvalidPenWidthException, InvalidCapStyleException, InvalidJoinStyleException, InvalidMitreLimitException {
        this(n);
        this.setStyle(jDRPaint, jDRPaint2, d, n2, n3, d2, dashPattern);
    }

    public JDRPath(JDRShape jDRShape) {
        this(jDRShape.getLinePaint(), jDRShape.getFillPaint());
        if (jDRShape.getStroke() instanceof JDRBasicStroke) {
            this.setStroke(jDRShape.getStroke());
        } else {
            this.setStroke(new JDRBasicStroke());
        }
        JDRPathIterator jDRPathIterator = jDRShape.getIterator();
        while (jDRPathIterator.hasNext()) {
            JDRPathSegment jDRPathSegment = jDRPathIterator.next();
            if (jDRPathSegment instanceof JDRPartialSegment) {
                jDRPathSegment = ((JDRPartialSegment)jDRPathSegment).getFullSegment();
            }
            this.add((JDRSegment)jDRPathSegment);
        }
        if (jDRShape.isClosed()) {
            try {
                this.close();
            }
            catch (EmptyPathException emptyPathException) {
                // empty catch block
            }
        }
    }

    private void init() {
        this.init(JDRPath.getInitCapacity());
    }

    private void init(int n) {
        this.capacity_ = n;
        this.size_ = 0;
        this.segmentList_ = new JDRSegment[n];
        this.closed = false;
        this.initIterators();
    }

    protected void initIterators() {
        this.iterator = new JDRPathIterator(this);
        this.pointIterator = new JDRPointIterator(this);
    }

    @Override
    public JDRPathIterator getIterator() {
        this.iterator.reset();
        return this.iterator;
    }

    @Override
    public JDRPointIterator getPointIterator() {
        this.pointIterator.reset();
        return this.pointIterator;
    }

    public void setStyle(JDRPaint jDRPaint, JDRPaint jDRPaint2, double d, int n, int n2, double d2, DashPattern dashPattern) throws InvalidPenWidthException, InvalidCapStyleException, InvalidJoinStyleException, InvalidMitreLimitException {
        this.setLinePaint(jDRPaint);
        this.setFillPaint(jDRPaint2);
        this.stroke = new JDRBasicStroke(d, n, n2, d2, dashPattern);
    }

    public void setStyle(JDRPaint jDRPaint, JDRPaint jDRPaint2, JDRStroke jDRStroke) {
        this.setLinePaint(jDRPaint);
        this.setFillPaint(jDRPaint2);
        this.setStroke(jDRStroke);
    }

    @Override
    public JDRPaint getLinePaint() {
        return this.linePaint;
    }

    @Override
    public JDRPaint getFillPaint() {
        return this.fillPaint;
    }

    @Override
    public JDRStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(JDRStroke jDRStroke) {
        this.stroke = jDRStroke;
    }

    @Override
    public void setLinePaint(JDRPaint jDRPaint) {
        this.linePaint = jDRPaint;
    }

    @Override
    public void setFillPaint(JDRPaint jDRPaint) {
        this.fillPaint = jDRPaint;
    }

    public static JDRPath getPath(PathIterator pathIterator) throws MissingMoveException, EmptyPathException {
        JDRSegment jDRSegment;
        JDRShape jDRShape = null;
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        boolean bl = false;
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    if (jDRShape == null) {
                        d = dArray[0];
                        d2 = dArray[1];
                        jDRShape = new JDRPath();
                    } else {
                        jDRSegment = new JDRSegment(d, d2, dArray[0], dArray[1]);
                        d = dArray[0];
                        d2 = dArray[1];
                        if (jDRShape == null) {
                            throw new MissingMoveException();
                        }
                        ((JDRPath)jDRShape).add(jDRSegment);
                    }
                    d3 = dArray[0];
                    d4 = dArray[1];
                    ++n;
                    break;
                }
                case 1: {
                    jDRSegment = new JDRLine(d, d2, dArray[0], dArray[1]);
                    d = dArray[0];
                    d2 = dArray[1];
                    ((JDRPath)jDRShape).add(jDRSegment);
                    if (jDRShape != null) break;
                    throw new MissingMoveException();
                }
                case 2: {
                    JDRBezier jDRBezier = JDRBezier.quadToCubic(d, d2, dArray[0], dArray[1], dArray[2], dArray[3]);
                    d = dArray[2];
                    d2 = dArray[3];
                    ((JDRPath)jDRShape).add(jDRBezier);
                    if (jDRShape != null) break;
                    throw new MissingMoveException();
                }
                case 3: {
                    JDRBezier jDRBezier = new JDRBezier(d, d2, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    d = dArray[4];
                    d2 = dArray[5];
                    ((JDRPath)jDRShape).add(jDRBezier);
                    if (jDRShape != null) break;
                    throw new MissingMoveException();
                }
                case 4: {
                    bl = true;
                    JDRLine jDRLine = new JDRLine(dArray[0], dArray[1], d3, d4);
                    d = dArray[0];
                    d2 = dArray[1];
                    ((JDRPath)jDRShape).add(jDRLine);
                    if (jDRShape != null) break;
                    throw new MissingMoveException();
                }
            }
            pathIterator.next();
        }
        if (jDRShape == null || jDRShape.isEmpty()) {
            throw new EmptyPathException();
        }
        if (bl) {
            JDRSegment jDRSegment2 = (JDRSegment)((JDRPath)jDRShape).getFirstSegment();
            jDRSegment = (JDRSegment)((JDRPath)jDRShape).getLastSegment();
            if (n == 1) {
                jDRSegment.end = jDRSegment2.start;
                ((JDRPath)jDRShape).closed = true;
            }
        }
        return jDRShape;
    }

    public static JDRCompleteObject getPaths(PathIterator pathIterator) throws MissingMoveException, EmptyPathException {
        JDRGroup jDRGroup = null;
        JDRShape jDRShape = null;
        JDRShape jDRShape2 = null;
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    JDRSegment jDRSegment;
                    if (jDRShape == null) {
                        if (jDRShape2 != null && jDRGroup == null) {
                            jDRGroup = new JDRGroup();
                            jDRGroup.add(jDRShape2);
                        }
                        d = dArray[0];
                        d2 = dArray[1];
                        jDRShape = new JDRPath();
                    } else {
                        jDRSegment = new JDRSegment(d, d2, dArray[0], dArray[1]);
                        d = dArray[0];
                        d2 = dArray[1];
                        if (jDRShape == null) {
                            throw new MissingMoveException();
                        }
                        ((JDRPath)jDRShape).add(jDRSegment);
                    }
                    d3 = dArray[0];
                    d4 = dArray[1];
                    break;
                }
                case 1: {
                    JDRSegment jDRSegment = new JDRLine(d, d2, dArray[0], dArray[1]);
                    d = dArray[0];
                    d2 = dArray[1];
                    ((JDRPath)jDRShape).add(jDRSegment);
                    if (jDRShape != null) break;
                    throw new MissingMoveException();
                }
                case 2: {
                    JDRBezier jDRBezier = JDRBezier.quadToCubic(d, d2, dArray[0], dArray[1], dArray[2], dArray[3]);
                    d = dArray[2];
                    d2 = dArray[3];
                    ((JDRPath)jDRShape).add(jDRBezier);
                    if (jDRShape != null) break;
                    throw new MissingMoveException();
                }
                case 3: {
                    JDRBezier jDRBezier = new JDRBezier(d, d2, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    d = dArray[4];
                    d2 = dArray[5];
                    ((JDRPath)jDRShape).add(jDRBezier);
                    if (jDRShape != null) break;
                    throw new MissingMoveException();
                }
                case 4: {
                    if (jDRShape == null || jDRShape.isEmpty()) {
                        throw new EmptyPathException();
                    }
                    JDRSegment jDRSegment = (JDRSegment)((JDRPath)jDRShape).getFirstSegment();
                    JDRSegment jDRSegment2 = (JDRSegment)((JDRPath)jDRShape).getLastSegment();
                    jDRSegment2.end = jDRSegment.start;
                    ((JDRPath)jDRShape).closed = true;
                    if (jDRGroup != null) {
                        jDRGroup.add(jDRShape);
                    }
                    jDRShape2 = jDRShape;
                    jDRShape = null;
                }
            }
            pathIterator.next();
        }
        if (jDRGroup != null) {
            return jDRGroup;
        }
        if (jDRShape2 == null) {
            throw new EmptyPathException();
        }
        return jDRShape2;
    }

    public void smoothLines(double d) {
        this.smoothLines(0, d);
    }

    public void smoothLines(int n, double d) {
        int n2 = this.size_;
        JDRPathSegment jDRPathSegment = null;
        for (int i = 0; i < n2; ++i) {
            JDRPathSegment jDRPathSegment2 = this.get(i);
            if (!(jDRPathSegment2 instanceof JDRLine)) {
                jDRPathSegment = null;
                continue;
            }
            if (jDRPathSegment == null) {
                jDRPathSegment = jDRPathSegment2;
                continue;
            }
            double d2 = jDRPathSegment.getStartX();
            double d3 = jDRPathSegment.getStartY();
            double d4 = jDRPathSegment2.getStartX();
            double d5 = jDRPathSegment2.getStartY();
            double d6 = jDRPathSegment2.getEndX();
            double d7 = jDRPathSegment2.getEndY();
            double d8 = Math.atan2(d3 - d5, d2 - d4) - Math.atan2(d5 - d7, d4 - d6);
            if (Math.abs(d8) < d || Math.abs(d8 - Math.PI) < d) {
                JDRLine jDRLine = new JDRLine(jDRPathSegment.getStart(), jDRPathSegment2.getEnd());
                this.removeSegmentFromList(i);
                this.setSegment(i - 1, jDRLine);
                this.smoothLines(i - 1, d);
                return;
            }
            jDRPathSegment = jDRPathSegment2;
        }
    }

    public static double computeArea(Shape shape, double d) {
        PathIterator pathIterator = shape.getPathIterator(null, d);
        if (pathIterator.isDone()) {
            return 0.0;
        }
        double d2 = 0.0;
        double[] dArray = new double[6];
        pathIterator.currentSegment(dArray);
        pathIterator.next();
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = d3;
        double d6 = d4;
        boolean bl = false;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: 
                case 1: {
                    double d7 = dArray[0];
                    double d8 = dArray[1];
                    d2 += d3 * d8 - d7 * d4;
                    d3 = d7;
                    d4 = d8;
                    break;
                }
                case 4: {
                    bl = true;
                }
            }
            pathIterator.next();
        }
        if (!bl) {
            d2 += d3 * d6 - d5 * d4;
        }
        return d2 *= 0.5;
    }

    public double computeArea(double d) {
        if (this.size() == 0) {
            return 0.0;
        }
        return JDRPath.computeArea(this.getGeneralPath(), d);
    }

    @Override
    public JDRShape reverse() throws EmptyPathException {
        int n = this.size_;
        JDRPath jDRPath = new JDRPath(n, this.getLinePaint(), this.getFillPaint(), this.getStroke());
        jDRPath.flowframe = this.flowframe == null ? null : (FlowFrame)this.flowframe.clone();
        jDRPath.description = this.description;
        jDRPath.setSelected(this.isSelected());
        for (int i = n - 1; i >= 0; --i) {
            JDRSegment jDRSegment = ((JDRSegment)this.get(i)).reverse();
            if (i == 0 && this.closed) {
                try {
                    jDRPath.close(jDRSegment);
                }
                catch (IllFittingPathException illFittingPathException) {}
                continue;
            }
            jDRPath.add(jDRSegment);
        }
        return jDRPath;
    }

    @Override
    public JDRShape exclusiveOr(JDRShape jDRShape) throws MissingMoveException, EmptyPathException {
        Area area = new Area(this.getGeneralPath());
        Area area2 = new Area(jDRShape.getGeneralPath());
        area.exclusiveOr(area2);
        JDRPath jDRPath = JDRPath.getPath(area.getPathIterator(null));
        jDRPath.setLinePaint((JDRPaint)this.getLinePaint().clone());
        jDRPath.setFillPaint((JDRPaint)this.getFillPaint().clone());
        jDRPath.setStroke((JDRStroke)this.getStroke().clone());
        jDRPath.setSelected(this.isSelected());
        jDRPath.flowframe = this.flowframe == null ? null : (FlowFrame)this.flowframe.clone();
        jDRPath.description = this.description;
        return jDRPath;
    }

    @Override
    public JDRShape pathUnion(JDRShape jDRShape) throws MissingMoveException, EmptyPathException {
        Area area = new Area(this.getGeneralPath());
        Area area2 = new Area(jDRShape.getGeneralPath());
        area.add(area2);
        JDRPath jDRPath = JDRPath.getPath(area.getPathIterator(null));
        jDRPath.setLinePaint((JDRPaint)this.getLinePaint().clone());
        jDRPath.setFillPaint((JDRPaint)this.getFillPaint().clone());
        jDRPath.setStroke((JDRStroke)this.getStroke().clone());
        jDRPath.setSelected(this.isSelected());
        jDRPath.flowframe = this.flowframe == null ? null : (FlowFrame)this.flowframe.clone();
        jDRPath.description = this.description;
        return jDRPath;
    }

    @Override
    public JDRShape intersect(JDRShape jDRShape) throws MissingMoveException, EmptyPathException {
        Area area = new Area(this.getGeneralPath());
        Area area2 = new Area(jDRShape.getGeneralPath());
        area.intersect(area2);
        JDRPath jDRPath = JDRPath.getPath(area.getPathIterator(null));
        jDRPath.setLinePaint((JDRPaint)this.getLinePaint().clone());
        jDRPath.setFillPaint((JDRPaint)this.getFillPaint().clone());
        jDRPath.setStroke((JDRStroke)this.getStroke().clone());
        jDRPath.setSelected(this.isSelected());
        jDRPath.flowframe = this.flowframe == null ? null : (FlowFrame)this.flowframe.clone();
        jDRPath.description = this.description;
        return jDRPath;
    }

    @Override
    public JDRShape subtract(JDRShape jDRShape) throws InvalidPathException {
        Area area = new Area(this.getGeneralPath());
        Area area2 = new Area(jDRShape.getGeneralPath());
        area.subtract(area2);
        JDRPath jDRPath = JDRPath.getPath(area.getPathIterator(null));
        jDRPath.setLinePaint((JDRPaint)this.getLinePaint().clone());
        jDRPath.setFillPaint((JDRPaint)this.getFillPaint().clone());
        jDRPath.setStroke((JDRStroke)this.getStroke().clone());
        jDRPath.setSelected(this.isSelected());
        jDRPath.flowframe = this.flowframe == null ? null : (FlowFrame)this.flowframe.clone();
        jDRPath.description = this.description;
        return jDRPath;
    }

    @Override
    public int size() {
        return this.size_;
    }

    @Override
    public int getCapacity() {
        return this.capacity_;
    }

    @Override
    public void setCapacity(int n) throws IllegalArgumentException {
        if (n < this.size_) {
            throw new IllegalArgumentException("Can't set capacity to " + n + " for path of size " + this.size_);
        }
        this.enlargeList(n);
    }

    private void enlargeList() {
        if (JDR.getOptimize() == 0) {
            this.enlargeList(2 * this.capacity_);
        } else {
            this.enlargeList(this.capacity_ + 5);
        }
    }

    private void enlargeList(int n) {
        this.capacity_ = n;
        JDRSegment[] jDRSegmentArray = new JDRSegment[this.capacity_];
        for (int i = 0; i < this.size_; ++i) {
            jDRSegmentArray[i] = this.segmentList_[i];
        }
        this.segmentList_ = jDRSegmentArray;
    }

    private void addSegmentToList(JDRSegment jDRSegment) throws NullPointerException {
        if (jDRSegment == null) {
            throw new NullPointerException("Null segments may not be added to path");
        }
        if (this.capacity_ == this.size_) {
            this.enlargeList();
        }
        this.segmentList_[this.size_] = jDRSegment;
        ++this.size_;
    }

    private void addSegmentToList(int n, JDRSegment jDRSegment) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (n < 0 || n > this.size_) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (jDRSegment == null) {
            throw new NullPointerException("Null segments may not be added to path");
        }
        if (this.capacity_ == this.size_) {
            this.enlargeList();
        }
        for (int i = this.size_; i > n; --i) {
            this.segmentList_[i] = this.segmentList_[i - 1];
        }
        this.segmentList_[n] = jDRSegment;
        ++this.size_;
    }

    protected JDRSegment removeSegmentFromList(JDRSegment jDRSegment) {
        int n = -1;
        for (int i = 0; i < this.size_; ++i) {
            if (this.segmentList_[i] != jDRSegment) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return null;
        }
        return this.removeSegmentFromList(n);
    }

    protected JDRSegment removeSegmentFromList(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.size_) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        JDRSegment jDRSegment = this.segmentList_[n];
        for (int i = n; i < this.size_ - 1; ++i) {
            this.segmentList_[i] = this.segmentList_[i + 1];
        }
        --this.size_;
        return jDRSegment;
    }

    @Override
    public JDRSegment removeSegment(int n) throws ArrayIndexOutOfBoundsException {
        JDRSegment jDRSegment = this.removeSegmentFromList(n);
        if (n > 0) {
            this.segmentList_[n].setStart(this.segmentList_[n - 1].getEnd());
        }
        if (n < this.size() - 2) {
            this.segmentList_[n + 1].setStart(this.segmentList_[n].getEnd());
        } else if (n == this.size() - 1 && this.isClosed()) {
            this.segmentList_[n].setEnd(this.segmentList_[0].getStart());
        }
        return jDRSegment;
    }

    @Override
    public JDRPathSegment setSegment(int n, JDRPathSegment jDRPathSegment) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (n < 0 || n >= this.size_) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (jDRPathSegment == null) {
            throw new NullPointerException("Path can't contain null segments");
        }
        JDRSegment jDRSegment = this.segmentList_[n];
        this.segmentList_[n] = (JDRSegment)jDRPathSegment;
        if (n > 0) {
            jDRPathSegment.setStart(this.segmentList_[n - 1].getEnd());
        }
        if (n == this.size() - 1 && this.isClosed()) {
            jDRPathSegment.setEnd(this.segmentList_[0].getStart());
        }
        return jDRSegment;
    }

    @Override
    public void add(JDRSegment jDRSegment) {
        JDRPathSegment jDRPathSegment = this.getLastSegment();
        if (jDRPathSegment != null) {
            jDRSegment.start = jDRPathSegment.getEnd();
        }
        this.addSegmentToList(jDRSegment);
    }

    @Override
    public JDRPoint addPoint() {
        int n = this.getSelectedIndex();
        int n2 = this.getSelectedControlIndex();
        JDRPathSegment jDRPathSegment = this.getSelectedSegment();
        if (jDRPathSegment == null || n2 == -1 || n == -1) {
            return null;
        }
        this.stopEditing();
        JDRPathSegment jDRPathSegment2 = jDRPathSegment.split();
        this.addSegmentToList(n + 1, (JDRSegment)jDRPathSegment2);
        JDRPoint jDRPoint = this.selectControl(n2);
        return jDRPoint;
    }

    @Override
    public void makeContinuous(boolean bl) {
        if (this.selectedSegment == null || !(this.selectedSegment instanceof JDRBezier)) {
            return;
        }
        JDRBezier jDRBezier = (JDRBezier)this.selectedSegment;
        int n = this.getIndex(jDRBezier);
        int n2 = -1;
        if (bl) {
            n2 = n - 1;
            if (n2 == -1 && this.closed) {
                n2 = this.size_ - 1;
            }
        } else {
            n2 = n + 1;
            if (n2 == this.size_) {
                int n3 = n2 = this.closed ? 0 : -1;
            }
        }
        if (n == -1) {
            return;
        }
        JDRSegment jDRSegment = (JDRSegment)this.get(n2);
        if (bl) {
            Point2D point2D = jDRSegment.getdP1();
            jDRBezier.setStartGradient(point2D);
        } else {
            Point2D point2D = jDRSegment.getdP0();
            jDRBezier.setEndGradient(point2D);
        }
    }

    @Override
    public int getIndex(JDRPathSegment jDRPathSegment) {
        for (int i = 0; i < this.size_; ++i) {
            if (this.segmentList_[i] != jDRPathSegment) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean segmentHasEnd(JDRPathSegment jDRPathSegment) {
        return !this.isClosed() && jDRPathSegment == this.getLastSegment();
    }

    @Override
    public int getLastIndex(JDRPathSegment jDRPathSegment) {
        for (int i = this.size_ - 1; i >= 0; --i) {
            if (this.segmentList_[i] != jDRPathSegment) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void convertSegment(int n, JDRPathSegment jDRPathSegment) {
        int n2;
        JDRPathSegment jDRPathSegment2 = this.setSegment(n, jDRPathSegment);
        if (this.selectedSegment == jDRPathSegment2) {
            this.selectedSegment = jDRPathSegment;
        }
        jDRPathSegment.getStart().setSelected(jDRPathSegment2.getStart().isSelected());
        jDRPathSegment.getEnd().setSelected(jDRPathSegment2.getEnd().isSelected());
        if (this.selectedControl == jDRPathSegment2.getStart()) {
            this.selectedControl = jDRPathSegment.getStart();
        } else if (this.selectedControl == jDRPathSegment2.getEnd()) {
            this.selectedControl = jDRPathSegment.getEnd();
        }
        if (jDRPathSegment2 instanceof JDRBezier) {
            JDRBezier jDRBezier = (JDRBezier)jDRPathSegment2;
            if (jDRBezier.control1.selected) {
                jDRBezier.control1.setSelected(false);
                jDRBezier.getStart().setSelected(false);
                jDRPathSegment.getStart().setSelected(true);
            } else if (jDRBezier.control2.selected) {
                jDRBezier.control2.setSelected(false);
                jDRBezier.getEnd().setSelected(false);
                jDRPathSegment.getEnd().setSelected(true);
            }
            if (this.selectedControl == jDRBezier.control1) {
                this.selectedControl = jDRPathSegment.getStart();
            } else if (this.selectedControl == jDRBezier.control2) {
                this.selectedControl = jDRPathSegment.getEnd();
            }
        }
        if (n != (n2 = this.size_ - 1)) {
            JDRSegment jDRSegment = (JDRSegment)this.get(n + 1);
            jDRSegment.setStart(jDRPathSegment.getEnd());
        } else if (this.closed && n == n2) {
            JDRSegment jDRSegment = (JDRSegment)this.get(0);
            jDRSegment.setStart(jDRPathSegment.getEnd());
        }
        if (n > 0) {
            jDRPathSegment.setStart(this.get(n - 1).getEnd());
        } else if (n == 0 && this.closed) {
            jDRPathSegment.setStart(this.get(n2).getEnd());
        }
    }

    @Override
    public JDRSegment remove(int n) {
        JDRSegment jDRSegment;
        JDRSegment jDRSegment2 = (JDRSegment)this.get(n);
        JDRPoint jDRPoint = jDRSegment2.getEnd();
        int n2 = this.getSelectedControlIndex();
        if (jDRPoint == this.selectedControl || jDRSegment2 instanceof JDRBezier && this.selectedControl == ((JDRBezier)jDRSegment2).control2) {
            jDRPoint = jDRSegment2.getStart();
        }
        if (n == 0) {
            if (this.closed) {
                jDRSegment = (JDRSegment)this.get(this.size_ - 1);
                jDRSegment.setEnd(jDRPoint);
            }
        } else {
            jDRSegment = (JDRSegment)this.get(n - 1);
            jDRSegment.setEnd(jDRPoint);
        }
        jDRSegment = this.removeSegmentFromList(n);
        this.stopEditing();
        jDRPoint = this.selectControl(n2);
        if (jDRPoint == null) {
            this.selectControl(0);
        }
        return jDRSegment;
    }

    @Override
    public JDRPathSegment remove(JDRPathSegment jDRPathSegment) {
        for (int i = 0; i < this.size_; ++i) {
            if (this.get(i) != jDRPathSegment) continue;
            return this.remove(i);
        }
        return null;
    }

    @Override
    public JDRPathSegment removeSelectedSegment() {
        JDRPathSegment jDRPathSegment = null;
        if (this.selectedSegment != null) {
            jDRPathSegment = this.remove(this.selectedSegment);
        }
        return jDRPathSegment;
    }

    @Override
    public JDRShape breakPath() throws InvalidPathException {
        if (this.selectedSegment == null) {
            throw new NoSegmentSelectedException();
        }
        JDRPath jDRPath = new JDRPath(this.size_, (JDRPaint)this.getLinePaint().clone(), (JDRPaint)this.getFillPaint().clone(), (JDRStroke)this.getStroke().clone());
        int n = -1;
        for (int i = 0; i < this.size_; ++i) {
            JDRSegment jDRSegment = (JDRSegment)this.get(i);
            if (jDRSegment == this.selectedSegment) {
                n = i;
                continue;
            }
            if (n <= -1) continue;
            jDRPath.add((JDRSegment)jDRSegment.clone());
        }
        if (n == -1) {
            throw new SelectedSegmentNotFoundException();
        }
        if (this.closed) {
            this.open(false);
        }
        this.size_ = n + 1;
        return jDRPath;
    }

    @Override
    public JDRPathSegment get(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.size_) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.segmentList_[n];
    }

    @Override
    public JDRPathSegment getLastSegment() {
        if (this.size_ == 0) {
            return null;
        }
        return this.segmentList_[this.size_ - 1];
    }

    @Override
    public JDRPathSegment getFirstSegment() {
        if (this.size_ == 0) {
            return null;
        }
        return this.segmentList_[0];
    }

    @Override
    public void open() {
        this.open(true);
    }

    @Override
    public void open(boolean bl) {
        if (this.size_ == 0) {
            return;
        }
        if (this.closed) {
            if (bl) {
                --this.size_;
            } else {
                JDRSegment jDRSegment = (JDRSegment)this.getLastSegment();
                JDRPoint jDRPoint = jDRSegment.end;
                jDRSegment.end = (JDRPoint)jDRPoint.clone();
                jDRSegment.end.setSelected(false);
            }
            this.closed = false;
        }
    }

    public void closeMatch() {
        if (this.isEmpty()) {
            return;
        }
        if (!this.closed) {
            JDRSegment jDRSegment = (JDRSegment)this.getFirstSegment();
            JDRSegment jDRSegment2 = (JDRSegment)this.getLastSegment();
            if (jDRSegment2 instanceof JDRLine) {
                JDRLine jDRLine = new JDRLine(jDRSegment2.end, jDRSegment.start);
                this.add(jDRLine);
                jDRLine.end = jDRSegment.start;
            } else {
                JDRBezier jDRBezier = JDRBezier.constructBezier(jDRSegment2, jDRSegment.start.getPoint2D());
                this.add(jDRBezier);
                jDRBezier.end = jDRSegment.start;
            }
            this.closed = true;
        }
    }

    @Override
    public void close(JDRPathSegment jDRPathSegment) throws EmptyPathException, IllFittingPathException {
        if (this.isEmpty()) {
            throw new EmptyPathException();
        }
        JDRSegment jDRSegment = (JDRSegment)this.getLastSegment();
        JDRSegment jDRSegment2 = (JDRSegment)this.getFirstSegment();
        JDRPoint jDRPoint = jDRPathSegment.getEnd();
        JDRPoint jDRPoint2 = jDRPathSegment.getStart();
        if (jDRSegment.end.x != jDRPoint2.getX() && jDRSegment.end.y != jDRPoint2.getY() && jDRSegment2.start.x != jDRPoint.getX() && jDRSegment2.start.y != jDRPoint.getY()) {
            throw new IllFittingPathException();
        }
        ((JDRSegment)jDRPathSegment).end = jDRSegment2.start;
        this.add((JDRSegment)jDRPathSegment);
        this.closed = true;
    }

    @Override
    public void close(int n) throws EmptyPathException {
        if (this.size() == 0) {
            throw new EmptyPathException();
        }
        JDRSegment jDRSegment = (JDRSegment)this.getFirstSegment();
        JDRSegment jDRSegment2 = (JDRSegment)this.getLastSegment();
        switch (n) {
            case 0: {
                JDRLine jDRLine = new JDRLine(jDRSegment2.end.x, jDRSegment2.end.y, jDRSegment.start.x, jDRSegment.start.y);
                jDRLine.end = jDRSegment.start;
                this.add(jDRLine);
                this.closed = true;
                break;
            }
            case 1: {
                Point2D point2D = jDRSegment2.getdP1();
                Point2D point2D2 = jDRSegment.getdP0();
                JDRBezier jDRBezier = new JDRBezier(jDRSegment2.end.x, jDRSegment2.end.y, jDRSegment2.end.x, jDRSegment2.end.y, jDRSegment.start.x, jDRSegment.start.y, jDRSegment.start.x, jDRSegment.start.y);
                jDRBezier.setGradients(point2D, point2D2);
                jDRBezier.end = jDRSegment.start;
                this.add(jDRBezier);
                this.closed = true;
                break;
            }
            case 2: {
                jDRSegment2.end = jDRSegment.start;
                this.closed = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid close type " + n);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public GeneralPath getGeneralPath() {
        if (this.isEmpty()) {
            return null;
        }
        JDRStroke jDRStroke = this.getStroke();
        GeneralPath generalPath = new GeneralPath();
        if (jDRStroke != null) {
            generalPath.setWindingRule(jDRStroke.getWindingRule());
        }
        JDRPathIterator jDRPathIterator = this.getIterator();
        JDRPathSegment jDRPathSegment = jDRPathIterator.next();
        generalPath.moveTo((float)jDRPathSegment.getStart().x, (float)jDRPathSegment.getStart().y);
        jDRPathSegment.appendToGeneralPath(generalPath);
        while (jDRPathIterator.hasNext()) {
            jDRPathSegment = jDRPathIterator.next();
            jDRPathSegment.appendToGeneralPath(generalPath);
        }
        jDRPathSegment = null;
        if (this.closed) {
            generalPath.closePath();
        }
        return generalPath;
    }

    @Override
    public JDRShape outlineToPath() throws EmptyPathException, IllFittingPathException {
        Area area = this.getStrokedArea();
        PathIterator pathIterator = area.getPathIterator(null);
        double[] dArray = new double[6];
        int n = pathIterator.currentSegment(dArray);
        double d = dArray[0];
        double d2 = dArray[1];
        Point2D.Double double_ = new Point2D.Double(dArray[0], dArray[1]);
        pathIterator.next();
        JDRPath jDRPath = new JDRPath(this.capacity_);
        jDRPath.setLinePaint(new JDRTransparent());
        jDRPath.setFillPaint((JDRPaint)this.getLinePaint().clone());
        jDRPath.setStroke(new JDRBasicStroke());
        boolean bl = false;
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 3: {
                    JDRSegment jDRSegment = new JDRBezier(double_, new Point2D.Double(dArray[0], dArray[1]), new Point2D.Double(dArray[2], dArray[3]), new Point2D.Double(dArray[4], dArray[5]));
                    double_ = new Point2D.Double(dArray[4], dArray[4]);
                    jDRPath.add(jDRSegment);
                    break;
                }
                case 2: {
                    JDRSegment jDRSegment = JDRBezier.quadToCubic(((Point2D)double_).getX(), ((Point2D)double_).getY(), dArray[0], dArray[1], dArray[2], dArray[3]);
                    double_ = new Point2D.Double(dArray[4], dArray[4]);
                    jDRPath.add(jDRSegment);
                    break;
                }
                case 1: {
                    JDRSegment jDRSegment = new JDRLine(((Point2D)double_).getX(), ((Point2D)double_).getY(), dArray[0], dArray[1]);
                    double_ = new Point2D.Double(dArray[0], dArray[1]);
                    jDRPath.add(jDRSegment);
                    break;
                }
                case 0: {
                    JDRSegment jDRSegment = new JDRSegment(((Point2D)double_).getX(), ((Point2D)double_).getY(), dArray[0], dArray[1]);
                    double_ = new Point2D.Double(dArray[0], dArray[1]);
                    jDRPath.add(jDRSegment);
                    break;
                }
                case 4: {
                    bl = true;
                }
            }
            pathIterator.next();
        }
        if (bl) {
            jDRPath.close(new JDRSegment(((Point2D)double_).getX(), ((Point2D)double_).getY(), d, d2));
        }
        return jDRPath;
    }

    public Parshape parshape(Graphics2D graphics2D, double d, boolean bl) throws InvalidShapeException {
        int n;
        Area area;
        String string = System.getProperty("line.separator", "\n");
        Area area2 = area = bl ? this.getStrokedArea() : new Area(this.getGeneralPath());
        if (graphics2D != null) {
            graphics2D.setColor(Color.gray);
            graphics2D.draw(area);
            graphics2D.setColor(Color.lightGray);
        }
        Rectangle2D rectangle2D = area.getBounds2D();
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMinY();
        int n2 = (int)Math.ceil(rectangle2D.getWidth());
        double d4 = rectangle2D.getHeight();
        if (n2 == 0) {
            throw new ShapeHasNoWidthException();
        }
        if (d4 == 0.0) {
            throw new ShapeHasNoHeightException();
        }
        int n3 = n = (int)Math.ceil(d4 / d);
        String string2 = "";
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            int n5 = 0;
            int n6 = 0;
            double d5 = d3 + (double)i * d;
            if (graphics2D != null) {
                graphics2D.drawLine((int)d2, (int)d5, (int)d2 + n2, (int)d5);
            }
            generalPath.moveTo((float)d2, (float)d5);
            generalPath.lineTo((float)d2 + (float)n2, (float)d5);
            for (int j = -1; j <= n2; ++j) {
                double d6 = d2 + (double)j;
                bl3 = area.contains(d6, d5);
                if (bl3 && !bl2 || !bl3 && bl2) {
                    ++n4;
                }
                if (n4 > 2) {
                    throw new TooManyIntersectsException(d6, d5);
                }
                if (bl3 && !bl2) {
                    n5 = j;
                }
                if (!bl3 && bl2) {
                    n6 = j - n5;
                }
                bl2 = bl3;
            }
            if (n6 != 0) {
                string2 = string2 + string + PGF.format(n5) + "bp " + PGF.format(n6) + "bp ";
                continue;
            }
            --n;
        }
        return new Parshape("\\parshape=" + n + string2, generalPath, area);
    }

    public Parshape shapepar(Graphics2D graphics2D, double d, boolean bl) throws InvalidShapeException {
        String string = System.getProperty("line.separator", "\n");
        Area area = bl ? this.getStrokedArea() : new Area(this.getGeneralPath());
        Rectangle2D rectangle2D = area.getBounds2D();
        if (graphics2D != null) {
            graphics2D.setColor(Color.gray);
            graphics2D.draw(area);
            graphics2D.setColor(Color.lightGray);
        }
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getWidth();
        double d5 = 0.5 * d4;
        double d6 = rectangle2D.getHeight();
        if (d4 == 0.0) {
            throw new ShapeHasNoWidthException();
        }
        if (d6 == 0.0) {
            throw new ShapeHasNoHeightException();
        }
        String string2 = "\\shapepar{{" + PGF.format(d5) + "}%" + string;
        double d7 = 1.0;
        boolean bl2 = true;
        Vector<Double> vector = new Vector<Double>();
        for (double d8 = 0.0; d8 <= d6; d8 += d) {
            vector.add(new Double(d8));
        }
        PathIterator pathIterator = area.getPathIterator(null);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            double d9;
            int n;
            int n2 = pathIterator.currentSegment(dArray);
            double d10 = dArray[1] - d3;
            boolean bl3 = false;
            double d11 = (Double)vector.get(0);
            int n3 = vector.size();
            for (n = 0; n < n3; ++n) {
                d9 = (Double)vector.get(n);
                if (d10 == d9) {
                    bl3 = true;
                    break;
                }
                if (d10 > d11 && d10 < d9) {
                    vector.add(n, new Double(d10));
                    bl3 = true;
                    break;
                }
                if (n == n3 - 1 && d10 > d9) {
                    vector.add(new Double(d10));
                    bl3 = true;
                    break;
                }
                d11 = d9;
            }
            if (!bl3 && n2 == 3) {
                d10 = dArray[5] - d3;
                d11 = (Double)vector.get(0);
                n3 = vector.size();
                for (n = 0; n < n3 && d10 != (d9 = ((Double)vector.get(n)).doubleValue()); ++n) {
                    if (d10 > d11 && d10 < d9) {
                        vector.add(n, new Double(d10));
                        break;
                    }
                    d11 = d9;
                }
            }
            pathIterator.next();
        }
        GeneralPath generalPath = new GeneralPath();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            double d12 = (Double)vector.get(i);
            Vector<ScanLine> vector2 = new Vector<ScanLine>();
            double d13 = 0.0;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d12 + d3 - 0.5, d7, d7);
            boolean bl8 = area.intersects(double_);
            double_ = new Rectangle2D.Double(d2, d12 + d3 + 0.5, d7, d7);
            boolean bl9 = area.intersects(double_);
            double_ = new Rectangle2D.Double(d2, d12 + d3 - 1.5, d7, d7);
            boolean bl10 = area.intersects(double_);
            double d14 = -1.0;
            double d15 = -1.0;
            if (graphics2D != null) {
                graphics2D.drawLine((int)d2, (int)(d3 + d12), (int)(d2 + d4), (int)(d3 + d12));
            }
            generalPath.moveTo((float)d2, (float)(d3 + d12));
            generalPath.lineTo((float)(d2 + d4), (float)(d3 + d12));
            for (double d16 = 0.0; d16 <= d4; d16 += 1.0) {
                ScanLine scanLine;
                boolean bl11;
                boolean bl12;
                double d17;
                double_ = new Rectangle2D.Double(d16 + d2 + 1.0, d12 + d3 - 0.5, d7, d7);
                bl7 = area.intersects(double_);
                double_ = new Rectangle2D.Double(d16 + 1.0 + d2, d12 + d3 + 0.5, d7, d7);
                boolean bl13 = area.intersects(double_);
                double_ = new Rectangle2D.Double(d16 + 1.0 + d2, d12 + d3 - 1.5, d7, d7);
                boolean bl14 = area.intersects(double_);
                if (bl8 && !bl4 && !bl6 && !bl10) {
                    d13 = d16;
                    boolean bl15 = true;
                    for (d17 = d16 + 1.0; d17 <= d4; d17 += 1.0) {
                        double_ = new Rectangle2D.Double(d17 + d2, d12 + d3 - 0.5, d7, d7);
                        bl12 = area.intersects(double_);
                        double_ = new Rectangle2D.Double(d17 + d2, d12 + d3 - 1.5, d7, d7);
                        bl11 = area.intersects(double_);
                        if (bl11) {
                            bl15 = false;
                            break;
                        }
                        if (!bl12) break;
                    }
                    if (bl15) {
                        vector2.add(new Begin(d16));
                    }
                } else if (bl8 && !bl4 && !bl5 && !bl9) {
                    d13 = d16;
                    boolean bl16 = true;
                    for (d17 = d16 + 1.0; d17 <= d4; d17 += 1.0) {
                        double_ = new Rectangle2D.Double(d17 + d2, d12 + d3 - 0.5, d7, d7);
                        bl12 = area.intersects(double_);
                        double_ = new Rectangle2D.Double(d17 + d2, d12 + d3 + 0.5, d7, d7);
                        bl11 = area.intersects(double_);
                        if (bl11) {
                            bl16 = false;
                            break;
                        }
                        if (!bl12) break;
                    }
                    if (bl16) {
                        vector2.add(new End(d16));
                    }
                } else if (bl8 && bl4 && bl7 && bl6 && !bl10) {
                    d15 = d16;
                } else if (bl8 && bl4 && bl7 && bl5 && !bl9) {
                    d14 = d16;
                } else if (bl8 && bl7 && bl14 && !bl10 && d15 != -1.0) {
                    double d18 = d15 + 0.5 * (d16 - d15);
                    scanLine = new ScanLine(d13, d18);
                    vector2.add(scanLine);
                    vector2.add(new Join());
                    d13 = d18;
                    d15 = -1.0;
                } else if (bl8 && bl7 && bl13 && !bl9 && d14 != -1.0) {
                    double d19 = d14 + 0.5 * (d16 - d14);
                    scanLine = new ScanLine(d13, d19);
                    vector2.add(scanLine);
                    vector2.add(new Split());
                    d13 = d19;
                    d14 = -1.0;
                } else if (!bl4 && bl8) {
                    d13 = d16;
                } else if (bl8 && !bl7) {
                    ScanLine scanLine2 = new ScanLine(d13, d16 + 1.0);
                    vector2.add(scanLine2);
                }
                bl4 = bl8;
                bl8 = bl7;
                bl5 = bl9;
                bl6 = bl10;
                bl9 = bl13;
                bl10 = bl14;
            }
            int n4 = vector2.size();
            if (n4 <= 0) continue;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            for (int j = 0; j < n4; ++j) {
                ScanLine scanLine = (ScanLine)vector2.get(j);
                if (scanLine instanceof Split) {
                    string3 = string3 + "s";
                    continue;
                }
                if (scanLine instanceof Join) {
                    string3 = string3 + "j";
                    continue;
                }
                if (scanLine instanceof Begin) {
                    string5 = string5 + "b{" + PGF.format(((Begin)scanLine).x) + "}";
                    continue;
                }
                if (scanLine instanceof End) {
                    string4 = string4 + "e{" + PGF.format(((End)scanLine).x) + "}";
                    continue;
                }
                double d20 = scanLine.x1 - scanLine.x;
                string3 = string3 + "t{" + PGF.format(scanLine.x) + "}{" + PGF.format(d20) + "}";
            }
            if (!string5.equals("")) {
                string2 = string2 + (bl2 ? "" : "\\\\") + "{" + PGF.format(d12) + "}" + string5 + "%" + string;
            }
            if (!string3.equals("")) {
                string2 = string2 + "\\\\{" + PGF.format(d12) + "}" + string3 + "%" + string;
            }
            if (!string4.equals("")) {
                string2 = string2 + "\\\\{" + PGF.format(d12) + "}" + string4 + "%" + string;
            }
            bl2 = false;
        }
        string2 = string2 + "}";
        return new Parshape(string2, generalPath, area);
    }

    @Override
    public void translateControl(JDRPathSegment jDRPathSegment, JDRPoint jDRPoint, double d, double d2) {
        if (jDRPathSegment instanceof JDRBezier) {
            if (jDRPoint == ((JDRBezier)jDRPathSegment).control1 || jDRPoint == ((JDRBezier)jDRPathSegment).control2) {
                jDRPoint.translate(d, d2);
                return;
            }
            JDRSegment jDRSegment = null;
            JDRSegment jDRSegment2 = null;
            JDRSegment jDRSegment3 = null;
            int n = this.size_ - 1;
            for (int i = 0; i < this.size_; ++i) {
                jDRSegment = jDRSegment3;
                jDRSegment3 = (JDRSegment)this.get(i);
                if (jDRSegment3 != jDRPathSegment) continue;
                if (i < n) {
                    jDRSegment2 = (JDRSegment)this.get(i + 1);
                }
                if (i != 0 || !this.closed) break;
                jDRSegment = (JDRSegment)this.get(n);
                break;
            }
            if (jDRPoint == jDRPathSegment.getStart()) {
                if (jDRSegment != null && jDRSegment instanceof JDRBezier) {
                    ((JDRBezier)jDRSegment).control2.translate(d, d2);
                }
                ((JDRBezier)jDRPathSegment).control1.translate(d, d2);
            } else if (jDRPoint == jDRPathSegment.getEnd()) {
                if (jDRSegment2 != null && jDRSegment2 instanceof JDRBezier) {
                    ((JDRBezier)jDRSegment2).control1.translate(d, d2);
                }
                ((JDRBezier)jDRPathSegment).control2.translate(d, d2);
            }
        }
        jDRPoint.translate(d, d2);
    }

    public static JDRPath constructRectangle(Point2D point2D, Point2D point2D2) {
        return JDRPath.constructRectangle(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public static JDRPath constructRectangle(double d, double d2, double d3, double d4) {
        JDRPath jDRPath = new JDRPath();
        jDRPath.add(new JDRLine(new Point2D.Double(d, d2), new Point2D.Double(d, d4)));
        jDRPath.add(new JDRLine(new Point2D.Double(d, d4), new Point2D.Double(d3, d4)));
        jDRPath.add(new JDRLine(new Point2D.Double(d3, d4), new Point2D.Double(d3, d2)));
        try {
            jDRPath.close();
        }
        catch (EmptyPathException emptyPathException) {
            // empty catch block
        }
        return jDRPath;
    }

    public static JDRPath constructEllipse(Point2D point2D, double d, double d2) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - d, point2D.getY() - d2, 2.0 * d, 2.0 * d2);
        PathIterator pathIterator = new GeneralPath(double_).getPathIterator(null);
        JDRPath jDRPath = new JDRPath();
        double[] dArray = new double[6];
        int n = 0;
        Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            if (n2 == 0) {
                double_2 = new Point2D.Double(dArray[0], dArray[1]);
            } else if (n2 == 3) {
                JDRBezier jDRBezier = new JDRBezier(double_2, new Point2D.Double(dArray[0], dArray[1]), new Point2D.Double(dArray[2], dArray[3]), new Point2D.Double(dArray[4], dArray[5]));
                double_2 = new Point2D.Double(dArray[4], dArray[4]);
                ++n;
                try {
                    if (n == 4) {
                        jDRPath.close(jDRBezier);
                    } else {
                        jDRPath.add(jDRBezier);
                    }
                }
                catch (EmptyPathException emptyPathException) {
                }
                catch (IllFittingPathException illFittingPathException) {
                    // empty catch block
                }
            }
            pathIterator.next();
        }
        return jDRPath;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRPath)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        JDRPath jDRPath = (JDRPath)object;
        if (!this.getLinePaint().equals(jDRPath.getLinePaint())) {
            return false;
        }
        if (!this.getFillPaint().equals(jDRPath.getFillPaint())) {
            return false;
        }
        if (!this.getStroke().equals(jDRPath.getStroke())) {
            return false;
        }
        if (this.size_ != jDRPath.size_) {
            return false;
        }
        for (int i = 0; i < this.size_; ++i) {
            if (this.get(i) == jDRPath.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void makeEqual(JDRObject jDRObject) {
        JDRPath jDRPath = (JDRPath)jDRObject;
        super.makeEqual(jDRPath);
        this.setLinePaint((JDRPaint)jDRPath.getLinePaint().clone());
        if (jDRPath.getFillPaint() == null) {
            this.setFillPaint(JDRTransparent.Transparent);
        } else {
            this.setFillPaint((JDRPaint)jDRPath.getFillPaint().clone());
        }
        this.setStroke((JDRStroke)jDRPath.getStroke().clone());
        if (jDRPath.capacity_ != this.capacity_) {
            this.capacity_ = jDRPath.size_;
            this.segmentList_ = new JDRSegment[this.capacity_];
        }
        this.size_ = 0;
        for (int i = 0; i < jDRPath.size_; ++i) {
            JDRSegment jDRSegment = (JDRSegment)jDRPath.get(i);
            JDRSegment jDRSegment2 = (JDRSegment)jDRSegment.clone();
            try {
                if (i == jDRPath.size_ - 1 && jDRPath.closed) {
                    this.close(jDRSegment2);
                    continue;
                }
                this.add(jDRSegment2);
                continue;
            }
            catch (EmptyPathException emptyPathException) {
                continue;
            }
            catch (IllFittingPathException illFittingPathException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object clone() {
        JDRPath jDRPath = new JDRPath(this.capacity_);
        jDRPath.makeEqual(this);
        return jDRPath;
    }

    @Override
    public JDRShape getFullPath() throws EmptyPathException, IllFittingPathException {
        return (JDRPath)this.clone();
    }

    @Override
    protected void stopEditing() {
        if (this.selectedSegment != null) {
            this.selectedSegment.setSelected(false);
        }
        this.selectedSegment = null;
        this.selectedSegmentIndex = -1;
        this.selectedControl = null;
        this.selectedControlIndex = -1;
        this.editMode = false;
    }

    @Override
    public void setEditMode(boolean bl) {
        if (bl) {
            this.selectNextControl();
        } else {
            this.stopEditing();
        }
    }

    @Override
    public int getSelectedControlIndex() {
        return this.selectedControlIndex;
    }

    @Override
    public JDRPathSegment getSelectedSegment() {
        return this.selectedSegment;
    }

    @Override
    public JDRPoint getSelectedControl() {
        return this.selectedControl;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedSegmentIndex;
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return "";
        }
        String string = System.getProperty("line.separator", "\n");
        String string2 = new String("");
        if (!this.description.equals("")) {
            string2 = string2 + "% " + this.description + string;
        }
        string2 = string2 + this.pgfPath(affineTransform);
        String string3 = new String();
        JDRPaint jDRPaint = this.getFillPaint();
        JDRPaint jDRPaint2 = this.getLinePaint();
        JDRBasicStroke jDRBasicStroke = (JDRBasicStroke)this.getStroke();
        string3 = string3 + "\\begin{pgfscope}" + string;
        string3 = string3 + jDRBasicStroke.pgf();
        if (jDRPaint instanceof JDRTransparent) {
            string3 = string3 + string2;
            if (!(jDRPaint2 instanceof JDRTransparent)) {
                string3 = string3 + jDRPaint2.pgfstrokecolor(bBox);
                string3 = string3 + string;
                string3 = string3 + "\\pgfusepath{stroke}" + string;
            }
        } else {
            string3 = string3 + string2;
            string3 = string3 + jDRPaint.pgffillcolor(bBox);
            string3 = string3 + (jDRBasicStroke.windingRule == 0 ? "\\pgfseteorule" : "\\pgfsetnonzerorule");
            if (jDRPaint instanceof JDRGradient || jDRPaint instanceof JDRRadial) {
                string3 = string3 + jDRPaint2.pgfstrokecolor(bBox);
                string3 = string3 + string;
                if (jDRPaint2 instanceof JDRTransparent) {
                    string3 = string3 + "\\pgfsetstrokeopacity{0.0}" + string;
                }
                string3 = string3 + "\\pgfusepath{stroke}" + string;
            } else if (jDRPaint2 instanceof JDRTransparent) {
                string3 = string3 + "\\pgfusepath{fill}" + string;
            } else {
                string3 = string3 + "\\pgfusepath{fill}" + string;
                string3 = string3 + string2;
                string3 = string3 + jDRPaint2.pgfstrokecolor(bBox);
                string3 = string3 + string;
                string3 = string3 + "\\pgfusepath{stroke}" + string;
            }
        }
        string3 = string3 + "\\end{pgfscope}" + string;
        string3 = string3 + this.pgfMarkers(affineTransform, bBox);
        return string3;
    }

    public String pgfMarkers(AffineTransform affineTransform, BBox bBox) {
        String string = "";
        JDRBasicStroke jDRBasicStroke = (JDRBasicStroke)this.getStroke();
        if (jDRBasicStroke.getStartArrow().getType() == 0 && jDRBasicStroke.getEndArrow().getType() == 0 && jDRBasicStroke.getMidArrow().getType() == 0) {
            return string;
        }
        JDRPaint jDRPaint = this.getLinePaint();
        JDRPathIterator jDRPathIterator = this.getIterator();
        while (jDRPathIterator.hasNext()) {
            JDRPathSegment jDRPathSegment = jDRPathIterator.next();
            JDRMarker jDRMarker = jDRPathSegment.getStartMarker();
            if (jDRMarker != null && jDRMarker.getType() != 0) {
                string = string + jDRMarker.pgfShape(jDRPaint, bBox, jDRPathSegment, true, affineTransform);
            }
            if ((jDRMarker = jDRPathSegment.getEndMarker()) == null || jDRMarker.getType() == 0) continue;
            string = string + jDRMarker.pgfShape(jDRPaint, bBox, jDRPathSegment, false, affineTransform);
        }
        return string;
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        JDRPaint jDRPaint = this.getFillPaint();
        GeneralPath generalPath = this.getGeneralPath();
        printWriter.println("gsave");
        EPS.fillPath(generalPath, jDRPaint, printWriter);
        printWriter.println("grestore");
        printWriter.println("gsave");
        this.getStroke().saveEPS(this, printWriter);
        printWriter.println("grestore");
    }

    @Override
    public int psLevel() {
        int n = 1;
        n = Math.max(n, this.getFillPaint().psLevel());
        n = Math.max(n, this.getLinePaint().psLevel());
        return n;
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        JDRPathSegment jDRPathSegment = this.get(0);
        printWriter.print("   <path d=\"M ");
        jDRPathSegment.getStart().saveSVG(printWriter);
        jDRPathSegment.saveSVG(printWriter);
        for (int i = 1; i < this.size_; ++i) {
            jDRPathSegment = this.get(i);
            jDRPathSegment.saveSVG(printWriter);
        }
        if (this.closed) {
            printWriter.print("z");
        }
        printWriter.println("\"");
        printWriter.println("      " + this.getLinePaint().svgLine());
        printWriter.println("      " + this.getFillPaint().svgFill());
        printWriter.println("      " + ((JDRBasicStroke)this.getStroke()).svg(this.getLinePaint()));
        printWriter.println("   />");
    }

    public String toString() {
        String string = "Path: size=" + this.size_ + ", segments=[";
        for (int i = 0; i < this.size_; ++i) {
            string = string + this.get(i) + ",";
        }
        string = string + "]";
        return string;
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return pathListener;
    }

    public static int getInitCapacity() {
        return JDR.getOptimize() == 0 ? init_capacity_speed : init_capacity_memory;
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "Path:" + string;
        string2 = string2 + "size: " + this.size_ + string;
        for (int i = 0; i < this.size_; ++i) {
            string2 = string2 + "Segment " + i + ":" + string;
            string2 = string2 + this.segmentList_[i].info() + string;
        }
        string2 = string2 + "closed: " + this.closed + string;
        string2 = string2 + "line paint: " + this.getLinePaint() + string;
        string2 = string2 + "fill paint: " + this.getFillPaint() + string;
        string2 = string2 + "capacity: " + this.capacity_ + string;
        string2 = string2 + "edited segment: " + this.selectedSegment + string;
        string2 = string2 + "edited control: " + this.selectedControl + string;
        string2 = string2 + "edited index: " + this.selectedControlIndex + string;
        string2 = string2 + "stroke: " + this.getStroke().info() + string;
        return string2 + super.info();
    }

    protected void setSegmentList(JDRSegment[] jDRSegmentArray, int n) {
        this.segmentList_ = jDRSegmentArray;
        this.size_ = n;
    }

    protected JDRSegment[] getSegmentList() {
        return this.segmentList_;
    }

    @Override
    protected void selectControl(JDRPoint jDRPoint, int n, int n2) {
        JDRPathSegment jDRPathSegment;
        this.stopEditing();
        this.selected = true;
        try {
            jDRPathSegment = this.get(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            jDRPathSegment = null;
        }
        this.setSelectedElements(n2, n, jDRPathSegment, jDRPoint);
        if (this.selectedControl != null) {
            this.selectedControl.setSelected(true);
        }
        if (this.selectedSegment != null) {
            this.selectedSegment.setSelected(true);
        }
        this.editMode = true;
    }

    @Override
    public JDRTextual getTextual() {
        return null;
    }

    @Override
    public boolean hasTextual() {
        return false;
    }

    @Override
    public boolean showPath() {
        return true;
    }

    @Override
    public boolean hasSymmetricPath() {
        return false;
    }

    @Override
    public JDRSymmetricPath getSymmetricPath() {
        return null;
    }

    @Override
    public boolean hasPattern() {
        return false;
    }

    @Override
    public JDRPattern getPattern() {
        return null;
    }

    @Override
    protected void setSelectedElements(int n, int n2, JDRPathSegment jDRPathSegment, JDRPoint jDRPoint) {
        this.selectedSegmentIndex = n;
        this.selectedSegment = jDRPathSegment;
        this.selectedControl = jDRPoint;
        this.selectedControlIndex = n2;
    }

    @Override
    public void fade(double d) {
        this.getLinePaint().fade(d);
        this.getFillPaint().fade(d);
        ((JDRBasicStroke)this.getStroke()).fade(d);
    }

    private class Split
    extends ScanLine {
        public Split() {
            super(0.0, 0.0);
        }
    }

    private class Join
    extends ScanLine {
        public Join() {
            super(0.0, 0.0);
        }
    }

    private class End
    extends ScanLine {
        public End(double d) {
            super(d, d);
        }
    }

    private class Begin
    extends ScanLine {
        public Begin(double d) {
            super(d, d);
        }
    }

    private class ScanLine {
        public double x = 0.0;
        public double x1 = 0.0;

        public ScanLine(double d, double d2) {
            this.x = d;
            this.x1 = d2;
        }
    }
}

