/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialLine;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegmentLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.io.SVG;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class JDRPartialSegment
extends JDRObject
implements JDRPathSegment {
    private JDRMarker startMarker = null;
    private JDRMarker endMarker = null;
    protected JDRPoint start;
    protected JDRLine line_;
    private static JDRPartialSegmentLoaderListener listener = new JDRPartialSegmentLoaderListener();

    public JDRPartialSegment() {
        this.start = null;
    }

    public JDRPartialSegment(JDRPoint jDRPoint, JDRLine jDRLine) {
        this.start = jDRPoint;
        this.line_ = jDRLine;
    }

    @Override
    public void setStart(JDRPoint jDRPoint) {
        this.start = jDRPoint;
    }

    @Override
    public void setStart(Point2D point2D) {
        if (this.start == null) {
            this.start = new JDRPoint(point2D);
        } else {
            this.start.x = point2D.getX();
            this.start.y = point2D.getY();
        }
    }

    @Override
    public void setEnd(JDRPoint jDRPoint) {
        Point2D point2D = jDRPoint.getReflection(this.line_);
        if (this.start == null) {
            this.start = new JDRPoint(point2D);
        } else {
            this.start.x = point2D.getX();
            this.start.y = point2D.getY();
        }
    }

    @Override
    public JDRPathSegment getReflection(JDRLine jDRLine) {
        return new JDRPartialSegment(this.getEnd(), jDRLine);
    }

    @Override
    public JDRPathSegment reverse() {
        return this.getReflection(this.line_);
    }

    public void setSymmetryLine(JDRLine jDRLine) {
        this.line_ = jDRLine;
    }

    public JDRLine getSymmetryLine() {
        return this.line_;
    }

    @Override
    public JDRPathSegment split() {
        Point2D point2D = this.getP(0.5);
        return new JDRPartialSegment(new JDRPoint(point2D), this.line_);
    }

    @Override
    public Object clone() {
        return new JDRPartialSegment((JDRPoint)this.start.clone(), this.line_);
    }

    @Override
    public void appendToGeneralPath(GeneralPath generalPath) {
        Point2D point2D = this.start.getReflection(this.line_);
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
    }

    @Override
    public JDRPathSegment convertToSegment() {
        return this;
    }

    @Override
    public JDRPathSegment convertToLine() {
        return new JDRPartialLine(this.start, this.line_);
    }

    @Override
    public JDRPathSegment convertToBezier() {
        return new JDRPartialBezier(this.start, this.line_);
    }

    @Override
    public double getStartX() {
        return this.start.x;
    }

    @Override
    public double getStartY() {
        return this.start.y;
    }

    @Override
    public JDRPoint getStart() {
        return this.start;
    }

    @Override
    public JDRPoint getEnd() {
        Point2D point2D = this.start.getReflection(this.line_);
        return new JDRPoint(point2D);
    }

    public Point2D getEnd2D() {
        return this.start.getReflection(this.line_);
    }

    public JDRSegment getFullSegment() {
        return new JDRSegment(this.getStart(), this.getEnd());
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        Point2D point2D = this.start.getReflection(this.line_);
        return "\\pgfpathmoveto{" + PGF.point(affineTransform, point2D.getX(), point2D.getY()) + "}";
    }

    @Override
    public double getEndX() {
        Point2D point2D = this.start.getReflection(this.line_);
        return point2D.getX();
    }

    @Override
    public double getEndY() {
        Point2D point2D = this.start.getReflection(this.line_);
        return point2D.getY();
    }

    @Override
    public Point2D getP(double d) {
        Point2D point2D = this.start.getReflection(this.line_);
        return new Point2D.Double(this.start.x + (point2D.getX() - this.start.x) * d, this.start.y + (point2D.getY() - this.start.y) * d);
    }

    @Override
    public Point2D getdP(double d) {
        return this.getdP();
    }

    @Override
    public Point2D getdP() {
        Point2D point2D = this.start.getReflection(this.line_);
        point2D.setLocation(point2D.getX() - this.start.getX(), point2D.getY() - this.start.getY());
        return point2D;
    }

    @Override
    public Point2D getdP0() {
        return this.getdP();
    }

    @Override
    public Point2D getdP1() {
        return this.getdP();
    }

    @Override
    public void setSelected(boolean bl) {
        this.selected = bl;
        if (!bl) {
            this.start.selected = false;
        }
    }

    @Override
    public void setEditedControls(boolean bl) {
        this.start.selected = bl;
    }

    public boolean isEdited() {
        return false;
    }

    @Override
    public void drawControls(Graphics graphics, boolean bl, double d) {
    }

    @Override
    public void drawSelectedNoControls(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D point2D = this.start.getReflection(this.line_);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(this.start.getSelectedPaint());
        graphics2D.setStroke(JDRSegment.guideStroke);
        graphics2D.drawLine((int)(this.start.x * d), (int)(this.start.y * d), (int)(point2D.getX() * d), (int)(point2D.getY() * d));
        graphics2D.setStroke(stroke);
    }

    @Override
    public void drawDraft(Graphics graphics, double d, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.draw(graphics, d);
        if (this.isSelected()) {
            this.drawSelectedNoControls(graphics, d);
        }
    }

    @Override
    public void draw(Graphics graphics, double d) {
    }

    @Override
    public BBox getControlBBox() {
        BBox bBox = this.start.getBBox();
        bBox.merge(this.start.getReflection(this.line_));
        return bBox;
    }

    @Override
    public void mergeControlBBox(BBox bBox) {
        this.start.mergeBBox(bBox);
        bBox.merge(this.start.getReflection(this.line_));
    }

    @Override
    public void draw(Graphics graphics) {
        this.draw(graphics, 1.0);
    }

    @Override
    public void transform(double[] dArray) {
    }

    @Override
    public void translate(double d, double d2) {
    }

    @Override
    public void rotate(Point2D point2D, double d) {
    }

    @Override
    public void rotate(double d) {
    }

    @Override
    public void scale(Point2D point2D, double d, double d2) {
    }

    @Override
    public void scale(double d, double d2) {
    }

    @Override
    public void shear(Point2D point2D, double d, double d2) {
    }

    @Override
    public void shear(double d, double d2) {
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRPartialSegment)) {
            return false;
        }
        JDRPartialSegment jDRPartialSegment = (JDRPartialSegment)object;
        return jDRPartialSegment.start.equals(this.start) && this.line_.equals(jDRPartialSegment.getSymmetryLine());
    }

    public void makeEqual(JDRPartialSegment jDRPartialSegment) {
        this.start = jDRPartialSegment.start;
        this.line_ = jDRPartialSegment.line_;
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        printWriter.println("M ");
        SVG.savePoint(printWriter, this.getEnd2D());
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        EPS.savePoint(printWriter, this.getEnd2D());
    }

    @Override
    public JDRMarker getStartMarker() {
        return this.startMarker;
    }

    @Override
    public JDRMarker getEndMarker() {
        return this.endMarker;
    }

    @Override
    public void setStartMarker(JDRMarker jDRMarker) {
        this.startMarker = jDRMarker;
    }

    @Override
    public void setEndMarker(JDRMarker jDRMarker) {
        this.endMarker = jDRMarker;
    }

    @Override
    public int controlCount() {
        return 1;
    }

    @Override
    public JDRPoint getControl(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.start;
        }
        throw new IndexOutOfBoundsException("No control point at index " + n);
    }

    @Override
    public int getControlIndex(JDRPoint jDRPoint) throws NoSuchElementException {
        if (jDRPoint == this.start) {
            return 0;
        }
        throw new NoSuchElementException();
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return listener;
    }

    public String info() {
        return "partial segment: start=" + this.start.info() + ", symmetry=" + this.line_.info();
    }

    @Override
    public BBox getBBox() {
        Point2D point2D = this.getEnd2D();
        double d = this.start.x < point2D.getX() ? this.start.x : point2D.getX();
        double d2 = this.start.y < point2D.getY() ? this.start.y : point2D.getY();
        double d3 = this.start.x > point2D.getX() ? this.start.x : point2D.getX();
        double d4 = this.start.y > point2D.getY() ? this.start.y : point2D.getY();
        return new BBox(d, d2, d3, d4);
    }

    @Override
    public boolean isGap() {
        return true;
    }
}

