/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialLineLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.io.SVG;

public class JDRPartialLine
extends JDRPartialSegment {
    private static JDRPartialLineLoaderListener listener = new JDRPartialLineLoaderListener();

    public JDRPartialLine() {
    }

    public JDRPartialLine(JDRPoint jDRPoint, JDRLine jDRLine) {
        super(jDRPoint, jDRLine);
    }

    @Override
    public Object clone() {
        return new JDRPartialLine((JDRPoint)this.start.clone(), this.line_);
    }

    @Override
    public JDRPathSegment getReflection(JDRLine jDRLine) {
        return new JDRPartialLine(this.getEnd(), jDRLine);
    }

    @Override
    public JDRSegment getFullSegment() {
        return new JDRLine(this.getStart(), this.getEnd());
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        Point2D point2D = this.start.getReflection(this.line_);
        return "\\pgfpathlineto{" + PGF.point(affineTransform, point2D.getX(), point2D.getY()) + "}";
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        printWriter.println("L ");
        SVG.savePoint(printWriter, this.getEnd2D());
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        EPS.savePoint(printWriter, this.getEnd2D());
        printWriter.println("lineto");
    }

    @Override
    public void appendToGeneralPath(GeneralPath generalPath) {
        Point2D point2D = this.start.getReflection(this.line_);
        generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
    }

    @Override
    public JDRPathSegment convertToSegment() {
        return new JDRPartialSegment(this.start, this.line_);
    }

    @Override
    public JDRPathSegment convertToLine() {
        return this;
    }

    @Override
    public JDRPathSegment convertToBezier() {
        return new JDRPartialBezier(this.start, this.line_);
    }

    @Override
    public void drawControls(Graphics graphics, boolean bl, double d) {
    }

    @Override
    public void draw(Graphics graphics, double d) {
        Point2D point2D = this.start.getReflection(this.line_);
        graphics.drawLine((int)(d * this.start.x), (int)(d * this.start.y), (int)(d * point2D.getX()), (int)(d * point2D.getY()));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRPartialLine)) {
            return false;
        }
        JDRPartialLine jDRPartialLine = (JDRPartialLine)object;
        return jDRPartialLine.start.equals(this.start) && this.line_.equals(jDRPartialLine.getSymmetryLine());
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return listener;
    }

    @Override
    public boolean isGap() {
        return false;
    }

    @Override
    public String info() {
        return "partial line: start=" + this.start.info() + ", symmetry=" + this.line_.info();
    }
}

