/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRSegmentLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRPartialBezierLoaderListener
extends JDRSegmentLoaderListener {
    @Override
    public char getJDRid(float f) {
        return 'b';
    }

    @Override
    public JDRObject readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        return new JDRPartialBezier(null, new JDRPoint(d, d2), null);
    }

    @Override
    public void writeJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRPartialBezier jDRPartialBezier = (JDRPartialBezier)jDRObject;
        JDRPoint jDRPoint = jDRPartialBezier.getControl1();
        dataOutputStream.writeDouble(jDRPoint.getX());
        dataOutputStream.writeDouble(jDRPoint.getY());
    }

    @Override
    public char getAJRid(float f) {
        return 'b';
    }

    @Override
    public JDRObject readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        double d = AJR.readDouble(bufferedReader);
        double d2 = AJR.readDouble(bufferedReader);
        return new JDRPartialBezier(null, new JDRPoint(d, d2), null);
    }

    @Override
    public void writeAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRPartialBezier jDRPartialBezier = (JDRPartialBezier)jDRObject;
        JDRPoint jDRPoint = jDRPartialBezier.getControl1();
        AJR.writeDouble(printWriter, jDRPoint.getX());
        AJR.writeDouble(printWriter, jDRPoint.getY());
    }
}

