/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialBezierLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialLine;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.io.SVG;

public class JDRPartialBezier
extends JDRPartialSegment {
    protected JDRPoint control;
    private static JDRPartialBezierLoaderListener listener = new JDRPartialBezierLoaderListener();

    public JDRPartialBezier() {
        this.control = new JDRPoint();
    }

    public JDRPartialBezier(JDRPoint jDRPoint, JDRLine jDRLine) {
        super(jDRPoint, jDRLine);
        this.control = new JDRPoint();
        this.flatten();
    }

    public JDRPartialBezier(JDRPoint jDRPoint, JDRPoint jDRPoint2, JDRLine jDRLine) {
        super(jDRPoint, jDRLine);
        this.control = jDRPoint2;
    }

    @Override
    public Object clone() {
        return new JDRPartialBezier((JDRPoint)this.start.clone(), (JDRPoint)this.control.clone(), this.line_);
    }

    public void flatten() {
        Point2D point2D = this.getdP();
        this.setGradient(point2D);
    }

    public void setGradient(Point2D point2D) {
        this.control.set(point2D.getX() / 3.0 + this.start.x, point2D.getY() / 3.0 + this.start.y);
    }

    @Override
    public Point2D getdP0() {
        return new Point2D.Double(3.0 * (this.control.x - this.start.x), 3.0 * (this.control.y - this.start.y));
    }

    @Override
    public Point2D getdP1() {
        Point2D point2D = this.getControl2();
        Point2D point2D2 = this.start.getReflection(this.line_);
        point2D2.setLocation(3.0 * (point2D2.getX() - point2D.getX()), 3.0 * (point2D2.getY() - point2D.getY()));
        return point2D2;
    }

    @Override
    public Point2D getP(double d) {
        Point2D point2D = this.getControl2();
        Point2D point2D2 = this.start.getReflection(this.line_);
        double d2 = 1.0 - d;
        double d3 = d2 * d2;
        double d4 = d * d;
        double d5 = d3 * d2;
        double d6 = 3.0 * d * d3;
        double d7 = 3.0 * d4 * d2;
        double d8 = d4 * d;
        point2D2.setLocation(d5 * this.start.x + d6 * this.control.x + d7 * point2D.getX() + d8 * point2D2.getX(), d5 * this.start.y + d6 * this.control.y + d7 * point2D.getY() + d8 * point2D2.getY());
        return point2D2;
    }

    @Override
    public void setEditedControls(boolean bl) {
        super.setEditedControls(bl);
        this.control.selected = bl;
    }

    @Override
    public void setSelected(boolean bl) {
        this.selected = bl;
        if (!bl) {
            this.start.selected = false;
            this.control.selected = false;
        }
    }

    @Override
    public boolean isSelected() {
        return this.control.selected;
    }

    public JDRPoint getControl1() {
        return this.control;
    }

    public void setControl(double d, double d2) {
        this.control.x = d;
        this.control.y = d2;
    }

    public Point2D getControl2() {
        return this.control.getReflection(this.line_);
    }

    @Override
    public JDRPathSegment getReflection(JDRLine jDRLine) {
        return new JDRPartialBezier(this.getEnd(), new JDRPoint(this.getControl2()), jDRLine);
    }

    @Override
    public JDRSegment getFullSegment() {
        return new JDRBezier(this.getStart(), (JDRPoint)this.control.clone(), new JDRPoint(this.getControl2()), this.getEnd());
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        Point2D point2D = this.start.getReflection(this.line_);
        Point2D point2D2 = this.getControl2();
        return "\\pgfpathcurveto{" + this.control.pgf(affineTransform) + "}{" + PGF.point(affineTransform, point2D2.getX(), point2D2.getY()) + "}{" + PGF.point(affineTransform, point2D.getX(), point2D.getY()) + "}";
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        printWriter.println("C ");
        this.control.saveSVG(printWriter);
        SVG.savePoint(printWriter, this.getControl2());
        SVG.savePoint(printWriter, this.getEnd2D());
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        this.control.saveEPS(printWriter);
        EPS.savePoint(printWriter, this.getControl2());
        EPS.savePoint(printWriter, this.getEnd2D());
        printWriter.println("curveto");
    }

    @Override
    public void appendToGeneralPath(GeneralPath generalPath) {
        Point2D point2D = this.start.getReflection(this.line_);
        Point2D point2D2 = this.control.getReflection(this.line_);
        generalPath.curveTo((float)this.control.getX(), (float)this.control.getY(), (float)point2D2.getX(), (float)point2D2.getY(), (float)point2D.getX(), (float)point2D.getY());
    }

    @Override
    public JDRPathSegment convertToSegment() {
        return new JDRPartialSegment(this.start, this.line_);
    }

    @Override
    public JDRPathSegment convertToLine() {
        return new JDRPartialLine(this.start, this.line_);
    }

    @Override
    public JDRPathSegment convertToBezier() {
        return this;
    }

    @Override
    public void drawControls(Graphics graphics, boolean bl, double d) {
        Point2D point2D = this.start.getReflection(this.line_);
        Point2D point2D2 = this.control.getReflection(this.line_);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setStroke(JDRSegment.guideStroke);
        graphics2D.setPaint(JDRObject.draftColor);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(this.start.x * d), (float)(this.start.y * d));
        generalPath.lineTo((float)(this.control.x * d), (float)(this.control.y * d));
        generalPath.lineTo((float)(point2D2.getX() * d), (float)(point2D2.getY() * d));
        generalPath.lineTo((float)(point2D.getX() * d), (float)(point2D.getY() * d));
        graphics2D.draw(generalPath);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        this.control.draw(graphics, d);
    }

    @Override
    public void draw(Graphics graphics, double d) {
        Point2D point2D = this.start.getReflection(this.line_);
        Point2D point2D2 = this.control.getReflection(this.line_);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.draw(new CubicCurve2D.Double(d * this.start.x, d * this.start.y, d * this.control.getX(), d * this.control.getY(), d * point2D2.getX(), d * point2D2.getY(), d * point2D.getX(), d * point2D.getY()));
    }

    @Override
    public void drawSelectedNoControls(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(this.start.getSelectedPaint());
        graphics2D.setStroke(JDRSegment.guideStroke);
        this.draw(graphics, d);
        graphics2D.setStroke(stroke);
    }

    @Override
    public void drawDraft(Graphics graphics, double d, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.draw(graphics, d);
        if (this.isSelected()) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(this.start.getSelectedPaint());
            graphics2D.setStroke(JDRSegment.guideStroke);
            this.draw(graphics, d);
            graphics2D.setStroke(stroke);
        }
        this.drawControls(graphics, bl, d);
    }

    @Override
    public BBox getControlBBox() {
        BBox bBox = super.getControlBBox();
        this.control.mergeBBox(bBox);
        bBox.merge(this.control.getReflection(this.line_));
        return bBox;
    }

    @Override
    public void mergeControlBBox(BBox bBox) {
        super.mergeControlBBox(bBox);
        this.control.mergeBBox(bBox);
        bBox.merge(this.control.getReflection(this.line_));
    }

    @Override
    public void transform(double[] dArray) {
        this.control.transform(dArray);
    }

    @Override
    public void translate(double d, double d2) {
        this.control.translate(d, d2);
    }

    @Override
    public void rotate(Point2D point2D, double d) {
        this.control.rotate(point2D, d);
    }

    @Override
    public void rotate(double d) {
        this.control.rotate(d);
    }

    @Override
    public void scale(Point2D point2D, double d, double d2) {
        this.control.scale(point2D, d, d2);
    }

    @Override
    public void scale(double d, double d2) {
        this.control.scale(d, d2);
    }

    @Override
    public void shear(Point2D point2D, double d, double d2) {
        this.control.shear(point2D, d, d2);
    }

    @Override
    public void shear(double d, double d2) {
        this.control.shear(d, d2);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRPartialBezier)) {
            return false;
        }
        JDRPartialBezier jDRPartialBezier = (JDRPartialBezier)object;
        return jDRPartialBezier.start.equals(this.start) && jDRPartialBezier.control.equals(this.control) && this.line_.equals(jDRPartialBezier.getSymmetryLine());
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return listener;
    }

    @Override
    public int controlCount() {
        return 2;
    }

    @Override
    public JDRPoint getControl(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.start;
        }
        if (n == 1) {
            return this.control;
        }
        throw new IndexOutOfBoundsException("No control point at index " + n);
    }

    @Override
    public int getControlIndex(JDRPoint jDRPoint) throws NoSuchElementException {
        if (jDRPoint == this.start) {
            return 0;
        }
        if (jDRPoint == this.control) {
            return 1;
        }
        throw new NoSuchElementException();
    }

    @Override
    public BBox getBBox() {
        Point2D point2D = this.getEnd2D();
        Point2D point2D2 = this.getControl2();
        double d = this.start.x;
        double d2 = this.start.y;
        double d3 = this.start.x;
        double d4 = this.start.y;
        if (d > this.control.x) {
            d = this.control.x;
        }
        if (d > point2D2.getX()) {
            d = point2D2.getX();
        }
        if (d > point2D.getX()) {
            d = point2D.getX();
        }
        if (d2 > this.control.y) {
            d2 = this.control.y;
        }
        if (d2 > point2D2.getY()) {
            d2 = point2D2.getY();
        }
        if (d2 > point2D.getY()) {
            d2 = point2D.getY();
        }
        if (d3 < this.control.x) {
            d3 = this.control.x;
        }
        if (d3 < point2D2.getX()) {
            d3 = point2D2.getX();
        }
        if (d3 < point2D.getX()) {
            d3 = point2D.getX();
        }
        if (d4 < this.control.y) {
            d4 = this.control.y;
        }
        if (d4 < point2D2.getY()) {
            d4 = point2D2.getY();
        }
        if (d4 < point2D.getX()) {
            d4 = point2D.getX();
        }
        return new BBox(d, d2, d3, d4);
    }

    @Override
    public boolean isGap() {
        return false;
    }

    @Override
    public String info() {
        return "partial Bezier: start=" + this.start.info() + ", control=" + this.control.info() + ", symmetry=" + this.line_.info();
    }
}

