/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPaperIDException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPaperNameException;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRPaper {
    protected boolean portrait;
    private double width_;
    private double height_;
    private byte id_ = (byte)18;
    private Rectangle2D imageableArea;
    public static final byte ID_A0 = 0;
    public static final byte ID_A1 = 1;
    public static final byte ID_A2 = 2;
    public static final byte ID_A3 = 3;
    public static final byte ID_A4 = 4;
    public static final byte ID_A5 = 5;
    public static final byte ID_LETTER = 6;
    public static final byte ID_LEGAL = 7;
    public static final byte ID_EXECUTIVE = 8;
    public static final byte ID_A0R = 9;
    public static final byte ID_A1R = 10;
    public static final byte ID_A2R = 11;
    public static final byte ID_A3R = 12;
    public static final byte ID_A4R = 13;
    public static final byte ID_A5R = 14;
    public static final byte ID_LETTERR = 15;
    public static final byte ID_LEGALR = 16;
    public static final byte ID_EXECUTIVER = 17;
    public static final byte ID_USER = 18;
    public static final byte ID_A6 = 19;
    public static final byte ID_A7 = 20;
    public static final byte ID_A8 = 21;
    public static final byte ID_A9 = 22;
    public static final byte ID_A10 = 23;
    public static final byte ID_B0 = 24;
    public static final byte ID_B1 = 25;
    public static final byte ID_B2 = 26;
    public static final byte ID_B3 = 27;
    public static final byte ID_B4 = 28;
    public static final byte ID_B5 = 29;
    public static final byte ID_B6 = 30;
    public static final byte ID_B7 = 31;
    public static final byte ID_B8 = 32;
    public static final byte ID_B9 = 33;
    public static final byte ID_B10 = 34;
    public static final byte ID_C0 = 35;
    public static final byte ID_C1 = 36;
    public static final byte ID_C2 = 37;
    public static final byte ID_C3 = 38;
    public static final byte ID_C4 = 39;
    public static final byte ID_C5 = 40;
    public static final byte ID_C6 = 41;
    public static final byte ID_C7 = 42;
    public static final byte ID_C8 = 43;
    public static final byte ID_C9 = 44;
    public static final byte ID_C10 = 45;
    public static final byte ID_A6R = 46;
    public static final byte ID_A7R = 47;
    public static final byte ID_A8R = 48;
    public static final byte ID_A9R = 49;
    public static final byte ID_A10R = 50;
    public static final byte ID_B0R = 51;
    public static final byte ID_B1R = 52;
    public static final byte ID_B2R = 53;
    public static final byte ID_B3R = 54;
    public static final byte ID_B4R = 55;
    public static final byte ID_B5R = 56;
    public static final byte ID_B6R = 57;
    public static final byte ID_B7R = 58;
    public static final byte ID_B8R = 59;
    public static final byte ID_B9R = 60;
    public static final byte ID_B10R = 61;
    public static final byte ID_C0R = 62;
    public static final byte ID_C1R = 63;
    public static final byte ID_C2R = 64;
    public static final byte ID_C3R = 65;
    public static final byte ID_C4R = 66;
    public static final byte ID_C5R = 67;
    public static final byte ID_C6R = 68;
    public static final byte ID_C7R = 69;
    public static final byte ID_C8R = 70;
    public static final byte ID_C9R = 71;
    public static final byte ID_C10R = 72;
    public static final byte MAX_ID_1_0 = 18;
    public static final byte MAX_ID_1_3 = 72;
    public static final JDRPaper A0 = new JDRPaper(JDRUnit.mm.toBp(841.0), JDRUnit.mm.toBp(1189.0), 0);
    public static final JDRPaper A1 = new JDRPaper(JDRUnit.mm.toBp(594.0), JDRUnit.mm.toBp(841.0), 1);
    public static final JDRPaper A2 = new JDRPaper(JDRUnit.mm.toBp(420.0), JDRUnit.mm.toBp(594.0), 2);
    public static final JDRPaper A3 = new JDRPaper(JDRUnit.mm.toBp(297.0), JDRUnit.mm.toBp(420.0), 3);
    public static final JDRPaper A4 = new JDRPaper(JDRUnit.mm.toBp(210.0), JDRUnit.mm.toBp(297.0), 4);
    public static final JDRPaper A5 = new JDRPaper(JDRUnit.mm.toBp(148.0), JDRUnit.mm.toBp(210.0), 5);
    public static final JDRPaper LETTER = new JDRPaper(JDRUnit.mm.toBp(216.0), JDRUnit.mm.toBp(279.0), 6);
    public static final JDRPaper LEGAL = new JDRPaper(JDRUnit.mm.toBp(216.0), JDRUnit.mm.toBp(356.0), 7);
    public static final JDRPaper EXECUTIVE = new JDRPaper(JDRUnit.mm.toBp(184.0), JDRUnit.mm.toBp(267.0), 8);
    public static final JDRPaper A0R = new JDRPaper(JDRUnit.mm.toBp(1189.0), JDRUnit.mm.toBp(841.0), 9);
    public static final JDRPaper A1R = new JDRPaper(JDRUnit.mm.toBp(841.0), JDRUnit.mm.toBp(594.0), 10);
    public static final JDRPaper A2R = new JDRPaper(JDRUnit.mm.toBp(594.0), JDRUnit.mm.toBp(420.0), 11);
    public static final JDRPaper A3R = new JDRPaper(JDRUnit.mm.toBp(420.0), JDRUnit.mm.toBp(297.0), 12);
    public static final JDRPaper A4R = new JDRPaper(JDRUnit.mm.toBp(297.0), JDRUnit.mm.toBp(210.0), 13);
    public static final JDRPaper A5R = new JDRPaper(JDRUnit.mm.toBp(210.0), JDRUnit.mm.toBp(148.0), 14);
    public static final JDRPaper LETTERR = new JDRPaper(JDRUnit.mm.toBp(279.0), JDRUnit.mm.toBp(216.0), 15);
    public static final JDRPaper LEGALR = new JDRPaper(JDRUnit.mm.toBp(356.0), JDRUnit.mm.toBp(216.0), 16);
    public static final JDRPaper EXECUTIVER = new JDRPaper(JDRUnit.mm.toBp(267.0), JDRUnit.mm.toBp(184.0), 17);
    public static final JDRPaper A6 = new JDRPaper(JDRUnit.mm.toBp(105.0), JDRUnit.mm.toBp(148.0), 19);
    public static final JDRPaper A7 = new JDRPaper(JDRUnit.mm.toBp(74.0), JDRUnit.mm.toBp(105.0), 20);
    public static final JDRPaper A8 = new JDRPaper(JDRUnit.mm.toBp(52.0), JDRUnit.mm.toBp(74.0), 21);
    public static final JDRPaper A9 = new JDRPaper(JDRUnit.mm.toBp(37.0), JDRUnit.mm.toBp(52.0), 22);
    public static final JDRPaper A10 = new JDRPaper(JDRUnit.mm.toBp(26.0), JDRUnit.mm.toBp(37.0), 23);
    public static final JDRPaper B0 = new JDRPaper(JDRUnit.mm.toBp(1000.0), JDRUnit.mm.toBp(1414.0), 24);
    public static final JDRPaper B1 = new JDRPaper(JDRUnit.mm.toBp(707.0), JDRUnit.mm.toBp(1000.0), 25);
    public static final JDRPaper B2 = new JDRPaper(JDRUnit.mm.toBp(500.0), JDRUnit.mm.toBp(707.0), 26);
    public static final JDRPaper B3 = new JDRPaper(JDRUnit.mm.toBp(353.0), JDRUnit.mm.toBp(500.0), 27);
    public static final JDRPaper B4 = new JDRPaper(JDRUnit.mm.toBp(250.0), JDRUnit.mm.toBp(353.0), 28);
    public static final JDRPaper B5 = new JDRPaper(JDRUnit.mm.toBp(176.0), JDRUnit.mm.toBp(250.0), 29);
    public static final JDRPaper B6 = new JDRPaper(JDRUnit.mm.toBp(125.0), JDRUnit.mm.toBp(176.0), 30);
    public static final JDRPaper B7 = new JDRPaper(JDRUnit.mm.toBp(88.0), JDRUnit.mm.toBp(125.0), 31);
    public static final JDRPaper B8 = new JDRPaper(JDRUnit.mm.toBp(62.0), JDRUnit.mm.toBp(88.0), 32);
    public static final JDRPaper B9 = new JDRPaper(JDRUnit.mm.toBp(44.0), JDRUnit.mm.toBp(62.0), 33);
    public static final JDRPaper B10 = new JDRPaper(JDRUnit.mm.toBp(31.0), JDRUnit.mm.toBp(44.0), 34);
    public static final JDRPaper C0 = new JDRPaper(JDRUnit.mm.toBp(917.0), JDRUnit.mm.toBp(1297.0), 35);
    public static final JDRPaper C1 = new JDRPaper(JDRUnit.mm.toBp(648.0), JDRUnit.mm.toBp(917.0), 36);
    public static final JDRPaper C2 = new JDRPaper(JDRUnit.mm.toBp(458.0), JDRUnit.mm.toBp(648.0), 37);
    public static final JDRPaper C3 = new JDRPaper(JDRUnit.mm.toBp(324.0), JDRUnit.mm.toBp(458.0), 38);
    public static final JDRPaper C4 = new JDRPaper(JDRUnit.mm.toBp(229.0), JDRUnit.mm.toBp(324.0), 39);
    public static final JDRPaper C5 = new JDRPaper(JDRUnit.mm.toBp(162.0), JDRUnit.mm.toBp(229.0), 40);
    public static final JDRPaper C6 = new JDRPaper(JDRUnit.mm.toBp(114.0), JDRUnit.mm.toBp(162.0), 41);
    public static final JDRPaper C7 = new JDRPaper(JDRUnit.mm.toBp(81.0), JDRUnit.mm.toBp(114.0), 42);
    public static final JDRPaper C8 = new JDRPaper(JDRUnit.mm.toBp(57.0), JDRUnit.mm.toBp(81.0), 43);
    public static final JDRPaper C9 = new JDRPaper(JDRUnit.mm.toBp(40.0), JDRUnit.mm.toBp(57.0), 44);
    public static final JDRPaper C10 = new JDRPaper(JDRUnit.mm.toBp(28.0), JDRUnit.mm.toBp(40.0), 45);
    public static final JDRPaper A6R = new JDRPaper(JDRUnit.mm.toBp(148.0), JDRUnit.mm.toBp(105.0), 46);
    public static final JDRPaper A7R = new JDRPaper(JDRUnit.mm.toBp(105.0), JDRUnit.mm.toBp(74.0), 47);
    public static final JDRPaper A8R = new JDRPaper(JDRUnit.mm.toBp(74.0), JDRUnit.mm.toBp(52.0), 48);
    public static final JDRPaper A9R = new JDRPaper(JDRUnit.mm.toBp(52.0), JDRUnit.mm.toBp(37.0), 49);
    public static final JDRPaper A10R = new JDRPaper(JDRUnit.mm.toBp(37.0), JDRUnit.mm.toBp(26.0), 50);
    public static final JDRPaper B0R = new JDRPaper(JDRUnit.mm.toBp(1414.0), JDRUnit.mm.toBp(1000.0), 51);
    public static final JDRPaper B1R = new JDRPaper(JDRUnit.mm.toBp(1000.0), JDRUnit.mm.toBp(707.0), 52);
    public static final JDRPaper B2R = new JDRPaper(JDRUnit.mm.toBp(707.0), JDRUnit.mm.toBp(500.0), 53);
    public static final JDRPaper B3R = new JDRPaper(JDRUnit.mm.toBp(500.0), JDRUnit.mm.toBp(353.0), 54);
    public static final JDRPaper B4R = new JDRPaper(JDRUnit.mm.toBp(353.0), JDRUnit.mm.toBp(250.0), 55);
    public static final JDRPaper B5R = new JDRPaper(JDRUnit.mm.toBp(250.0), JDRUnit.mm.toBp(176.0), 56);
    public static final JDRPaper B6R = new JDRPaper(JDRUnit.mm.toBp(176.0), JDRUnit.mm.toBp(125.0), 57);
    public static final JDRPaper B7R = new JDRPaper(JDRUnit.mm.toBp(125.0), JDRUnit.mm.toBp(88.0), 58);
    public static final JDRPaper B8R = new JDRPaper(JDRUnit.mm.toBp(88.0), JDRUnit.mm.toBp(62.0), 59);
    public static final JDRPaper B9R = new JDRPaper(JDRUnit.mm.toBp(62.0), JDRUnit.mm.toBp(44.0), 60);
    public static final JDRPaper B10R = new JDRPaper(JDRUnit.mm.toBp(44.0), JDRUnit.mm.toBp(31.0), 61);
    public static final JDRPaper C0R = new JDRPaper(JDRUnit.mm.toBp(1297.0), JDRUnit.mm.toBp(917.0), 62);
    public static final JDRPaper C1R = new JDRPaper(JDRUnit.mm.toBp(917.0), JDRUnit.mm.toBp(648.0), 63);
    public static final JDRPaper C2R = new JDRPaper(JDRUnit.mm.toBp(648.0), JDRUnit.mm.toBp(458.0), 64);
    public static final JDRPaper C3R = new JDRPaper(JDRUnit.mm.toBp(458.0), JDRUnit.mm.toBp(324.0), 65);
    public static final JDRPaper C4R = new JDRPaper(JDRUnit.mm.toBp(324.0), JDRUnit.mm.toBp(229.0), 66);
    public static final JDRPaper C5R = new JDRPaper(JDRUnit.mm.toBp(229.0), JDRUnit.mm.toBp(162.0), 67);
    public static final JDRPaper C6R = new JDRPaper(JDRUnit.mm.toBp(162.0), JDRUnit.mm.toBp(114.0), 68);
    public static final JDRPaper C7R = new JDRPaper(JDRUnit.mm.toBp(114.0), JDRUnit.mm.toBp(81.0), 69);
    public static final JDRPaper C8R = new JDRPaper(JDRUnit.mm.toBp(81.0), JDRUnit.mm.toBp(57.0), 70);
    public static final JDRPaper C9R = new JDRPaper(JDRUnit.mm.toBp(57.0), JDRUnit.mm.toBp(40.0), 71);
    public static final JDRPaper C10R = new JDRPaper(JDRUnit.mm.toBp(40.0), JDRUnit.mm.toBp(28.0), 72);
    private static final String[] name = new String[]{"a0", "a1", "a2", "a3", "a4", "a5", "letter", "legal", "executive", "a0r", "a1r", "a2r", "a3r", "a4r", "a5r", "letterr", "legalr", "executiver", "user", "a6", "a7", "a8", "a9", "a10", "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "b10", "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "c10", "a6r", "a7r", "a8r", "a9r", "a10r", "b0r", "b1r", "b2r", "b3r", "b4r", "b5r", "b6r", "b7r", "b8r", "b9r", "b10r", "c0r", "c1r", "c2r", "c3r", "c4r", "c5r", "c6r", "c7r", "c8r", "c9r", "c10r"};

    public JDRPaper(double d, double d2) {
        this.portrait = d < d2;
        this.width_ = this.portrait ? d : d2;
        this.height_ = this.portrait ? d2 : d;
        double d3 = this.width_ < 180.0 ? 0.0 : 54.0;
        double d4 = this.height_ < 180.0 ? 0.0 : 54.0;
        this.imageableArea = new Rectangle2D.Double(d3, d4, this.width_ - d3 * 2.0, this.height_ - d4 * 2.0);
    }

    private JDRPaper(double d, double d2, byte by) {
        this.portrait = d < d2;
        this.width_ = this.portrait ? d : d2;
        this.height_ = this.portrait ? d2 : d;
        this.id_ = by;
        double d3 = this.width_ < 180.0 ? 0.0 : 54.0;
        double d4 = this.height_ < 180.0 ? 0.0 : 54.0;
        this.imageableArea = new Rectangle2D.Double(d3, d4, this.width_ - d3 * 2.0, this.height_ - d4 * 2.0);
    }

    public Rectangle2D getImageableArea() {
        return this.imageableArea;
    }

    public void setImageableArea(double d, double d2, double d3, double d4) {
        this.imageableArea.setRect(d, d2, d3, d4);
    }

    public void setImageableArea(PageFormat pageFormat) {
        this.setImageableArea(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
    }

    public MediaPrintableArea getMediaPrintableArea() {
        return new MediaPrintableArea((float)(this.imageableArea.getX() / 72.0), (float)(this.imageableArea.getY() / 72.0), (float)(this.imageableArea.getWidth() / 72.0), (float)(this.imageableArea.getHeight() / 72.0), 25400);
    }

    public double getWidth() {
        return this.portrait ? this.width_ : this.height_;
    }

    public double getHeight() {
        return this.portrait ? this.height_ : this.width_;
    }

    public boolean isPortrait() {
        return this.portrait;
    }

    public JDRPaper getPaper(boolean bl) {
        if (this.portrait == bl) {
            return this;
        }
        if (this.id_ == 18) {
            return new JDRPaper(this.getHeight(), this.getWidth());
        }
        JDRPaper jDRPaper = JDRPaper.getPredefinedPaper(this.getHeight(), this.getWidth());
        if (jDRPaper != null) {
            return jDRPaper;
        }
        return new JDRPaper(this.getHeight(), this.getWidth());
    }

    public String tex() {
        if (this == A0) {
            return "a0paper,portrait";
        }
        if (this == A0R) {
            return "a0paper,landscape";
        }
        if (this == A1) {
            return "a1paper,portrait";
        }
        if (this == A1R) {
            return "a1paper,landscape";
        }
        if (this == A2) {
            return "a2paper,portrait";
        }
        if (this == A2R) {
            return "a2paper,landscape";
        }
        if (this == A3) {
            return "a3paper,portrait";
        }
        if (this == A3R) {
            return "a3paper,landscape";
        }
        if (this == A4) {
            return "a4paper,portrait";
        }
        if (this == A4R) {
            return "a4paper,landscape";
        }
        if (this == A5) {
            return "a5paper,portrait";
        }
        if (this == A5R) {
            return "a5paper,landscape";
        }
        if (this == A6) {
            return "a6paper,portrait";
        }
        if (this == A6R) {
            return "a6paper,landscape";
        }
        if (this == B0) {
            return "b0paper,portrait";
        }
        if (this == B0R) {
            return "b0paper,landscape";
        }
        if (this == B1) {
            return "b1paper,portrait";
        }
        if (this == B1R) {
            return "b1paper,landscape";
        }
        if (this == B2) {
            return "b2paper,portrait";
        }
        if (this == B2R) {
            return "b2paper,landscape";
        }
        if (this == B3) {
            return "b3paper,portrait";
        }
        if (this == B3R) {
            return "b3paper,landscape";
        }
        if (this == B4) {
            return "b4paper,portrait";
        }
        if (this == B4R) {
            return "b4paper,landscape";
        }
        if (this == B5) {
            return "b5paper,portrait";
        }
        if (this == B5R) {
            return "b5paper,landscape";
        }
        if (this == B6) {
            return "b6paper,portrait";
        }
        if (this == B6R) {
            return "b6paper,landscape";
        }
        if (this == LETTER) {
            return "letter,portrait";
        }
        if (this == LETTERR) {
            return "letter,landscape";
        }
        if (this == LEGAL) {
            return "legal,portrait";
        }
        if (this == LEGALR) {
            return "legal,landscape";
        }
        if (this == EXECUTIVE) {
            return "executive,portrait";
        }
        if (this == EXECUTIVER) {
            return "executive,landscape";
        }
        return "paperwidth=" + this.getWidth() + "bp,paperheight=" + this.getHeight() + "bp";
    }

    public MediaSizeName getMediaSizeName() {
        if (this == A0) {
            return MediaSizeName.ISO_A0;
        }
        if (this == A1) {
            return MediaSizeName.ISO_A1;
        }
        if (this == A2) {
            return MediaSizeName.ISO_A2;
        }
        if (this == A3) {
            return MediaSizeName.ISO_A3;
        }
        if (this == A4) {
            return MediaSizeName.ISO_A4;
        }
        if (this == A5) {
            return MediaSizeName.ISO_A5;
        }
        if (this == A6) {
            return MediaSizeName.ISO_A6;
        }
        if (this == A7) {
            return MediaSizeName.ISO_A7;
        }
        if (this == A8) {
            return MediaSizeName.ISO_A8;
        }
        if (this == A9) {
            return MediaSizeName.ISO_A9;
        }
        if (this == A10) {
            return MediaSizeName.ISO_A10;
        }
        if (this == LETTER) {
            return MediaSizeName.NA_LETTER;
        }
        if (this == LEGAL) {
            return MediaSizeName.NA_LEGAL;
        }
        if (this == EXECUTIVE) {
            return MediaSizeName.EXECUTIVE;
        }
        if (this == B0) {
            return MediaSizeName.ISO_B0;
        }
        if (this == B1) {
            return MediaSizeName.ISO_B1;
        }
        if (this == B2) {
            return MediaSizeName.ISO_B2;
        }
        if (this == B3) {
            return MediaSizeName.ISO_B3;
        }
        if (this == B4) {
            return MediaSizeName.ISO_B4;
        }
        if (this == B5) {
            return MediaSizeName.ISO_B5;
        }
        if (this == B6) {
            return MediaSizeName.ISO_B6;
        }
        if (this == B7) {
            return MediaSizeName.ISO_B7;
        }
        if (this == B8) {
            return MediaSizeName.ISO_B8;
        }
        if (this == B9) {
            return MediaSizeName.ISO_B9;
        }
        if (this == B10) {
            return MediaSizeName.ISO_B10;
        }
        if (this == C0) {
            return MediaSizeName.ISO_C0;
        }
        if (this == C1) {
            return MediaSizeName.ISO_C1;
        }
        if (this == C2) {
            return MediaSizeName.ISO_C2;
        }
        if (this == C3) {
            return MediaSizeName.ISO_C3;
        }
        if (this == C4) {
            return MediaSizeName.ISO_C4;
        }
        if (this == C5) {
            return MediaSizeName.ISO_C5;
        }
        if (this == C6) {
            return MediaSizeName.ISO_C6;
        }
        JDRUnit jDRUnit = JDRUnit.in;
        return MediaSize.findMedia((float)jDRUnit.fromBp(this.width_), (float)jDRUnit.fromBp(this.height_), 25400);
    }

    public byte getID() {
        return this.id_;
    }

    public String getName() {
        return name[this.id_];
    }

    public String toString() {
        if (this.id_ == 18) {
            return "" + this.getWidth() + "bp x " + this.getHeight() + "bp" + (this.portrait ? " portrait" : " landscape");
        }
        return name[this.id_];
    }

    public static JDRPaper getPredefinedPaper(double d, double d2) {
        for (int i = 0; i < 72; ++i) {
            JDRPaper jDRPaper = JDRPaper.getPredefinedPaper(i);
            if (jDRPaper == null || jDRPaper.getWidth() != d || jDRPaper.getHeight() != d2) continue;
            return jDRPaper;
        }
        return null;
    }

    public static JDRPaper getPredefinedPaper(String string) {
        for (int i = 0; i < name.length; ++i) {
            if (!string.equals(name[i])) continue;
            return JDRPaper.getPredefinedPaper((byte)i);
        }
        return null;
    }

    public static JDRPaper getPredefinedPaper(int n) {
        return JDRPaper.getPredefinedPaper((byte)n);
    }

    public static JDRPaper getPredefinedPaper(byte by) {
        switch (by) {
            case 0: {
                return A0;
            }
            case 1: {
                return A1;
            }
            case 2: {
                return A2;
            }
            case 3: {
                return A3;
            }
            case 4: {
                return A4;
            }
            case 5: {
                return A5;
            }
            case 19: {
                return A6;
            }
            case 20: {
                return A7;
            }
            case 21: {
                return A8;
            }
            case 22: {
                return A9;
            }
            case 23: {
                return A10;
            }
            case 24: {
                return B0;
            }
            case 25: {
                return B1;
            }
            case 26: {
                return B2;
            }
            case 27: {
                return B3;
            }
            case 28: {
                return B4;
            }
            case 29: {
                return B5;
            }
            case 30: {
                return B6;
            }
            case 31: {
                return B7;
            }
            case 32: {
                return B8;
            }
            case 33: {
                return B9;
            }
            case 34: {
                return B10;
            }
            case 35: {
                return C0;
            }
            case 36: {
                return C1;
            }
            case 37: {
                return C2;
            }
            case 38: {
                return C3;
            }
            case 39: {
                return C4;
            }
            case 40: {
                return C5;
            }
            case 41: {
                return C6;
            }
            case 42: {
                return C7;
            }
            case 43: {
                return C8;
            }
            case 44: {
                return C9;
            }
            case 45: {
                return C10;
            }
            case 6: {
                return LETTER;
            }
            case 7: {
                return LEGAL;
            }
            case 8: {
                return EXECUTIVE;
            }
            case 9: {
                return A0R;
            }
            case 10: {
                return A1R;
            }
            case 11: {
                return A2R;
            }
            case 12: {
                return A3R;
            }
            case 13: {
                return A4R;
            }
            case 14: {
                return A5R;
            }
            case 46: {
                return A6R;
            }
            case 47: {
                return A7R;
            }
            case 48: {
                return A8R;
            }
            case 49: {
                return A9R;
            }
            case 50: {
                return A10R;
            }
            case 51: {
                return B0R;
            }
            case 52: {
                return B1R;
            }
            case 53: {
                return B2R;
            }
            case 54: {
                return B3R;
            }
            case 55: {
                return B4R;
            }
            case 56: {
                return B5R;
            }
            case 57: {
                return B6R;
            }
            case 58: {
                return B7R;
            }
            case 59: {
                return B8R;
            }
            case 60: {
                return B9R;
            }
            case 61: {
                return B10R;
            }
            case 62: {
                return C0R;
            }
            case 63: {
                return C1R;
            }
            case 64: {
                return C2R;
            }
            case 65: {
                return C3R;
            }
            case 66: {
                return C4R;
            }
            case 67: {
                return C5R;
            }
            case 68: {
                return C6R;
            }
            case 69: {
                return C7R;
            }
            case 70: {
                return C8R;
            }
            case 71: {
                return C9R;
            }
            case 72: {
                return C10R;
            }
            case 15: {
                return LETTERR;
            }
            case 16: {
                return LEGALR;
            }
            case 17: {
                return EXECUTIVER;
            }
        }
        return null;
    }

    public static JDRPaper getClosestPredefinedPaper(double d, double d2, float f) {
        double d3;
        JDRPaper jDRPaper = JDRPaper.getPredefinedPaper(0);
        double d4 = d - jDRPaper.getWidth();
        double d5 = d2 - jDRPaper.getHeight();
        double d6 = d3 = d4 * d4 + d5 * d5;
        int n = f < 1.3f ? 18 : 72;
        for (int i = 1; i <= n; ++i) {
            JDRPaper jDRPaper2;
            if (i == 18 || !((d3 = (d4 = d - (jDRPaper2 = JDRPaper.getPredefinedPaper(i)).getWidth()) * d4 + (d5 = d2 - jDRPaper2.getHeight()) * d5) < d6)) continue;
            jDRPaper = jDRPaper2;
            d6 = d3;
        }
        return jDRPaper;
    }

    public static JDRPaper getClosestEnclosingPredefinedPaper(double d, double d2, float f) {
        JDRPaper jDRPaper = null;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = Double.MAX_VALUE;
        int n = f < 1.3f ? 18 : 72;
        for (int i = 0; i <= n; ++i) {
            JDRPaper jDRPaper2;
            if (i == 18 || !((d5 = (d3 = (jDRPaper2 = JDRPaper.getPredefinedPaper(i)).getWidth() - d) * d3 + (d4 = jDRPaper2.getHeight() - d2) * d4) < d6) || !(d3 >= 0.0) || !(d4 >= 0.0)) continue;
            jDRPaper = jDRPaper2;
            d6 = d5;
        }
        return jDRPaper;
    }

    public void save(DataOutputStream dataOutputStream, float f) throws IOException {
        if (f < 1.3f) {
            JDRPaper jDRPaper = this;
            if (jDRPaper.getID() > 18) {
                jDRPaper = new JDRPaper(this.getWidth(), this.getHeight());
            }
            dataOutputStream.writeByte(jDRPaper.id_);
            if (jDRPaper.id_ == 18) {
                dataOutputStream.writeDouble(jDRPaper.getWidth());
                dataOutputStream.writeDouble(jDRPaper.getHeight());
                dataOutputStream.writeBoolean(jDRPaper.portrait);
            }
        } else {
            dataOutputStream.writeByte(this.id_);
            if (this.id_ == 18) {
                dataOutputStream.writeDouble(this.getWidth());
                dataOutputStream.writeDouble(this.getHeight());
            }
        }
    }

    public static JDRPaper read(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        byte by = dataInputStream.readByte();
        JDRPaper jDRPaper = null;
        if (by == 18) {
            double d = dataInputStream.readDouble();
            double d2 = dataInputStream.readDouble();
            jDRPaper = new JDRPaper(d, d2);
            if (f < 1.3f) {
                jDRPaper.portrait = dataInputStream.readBoolean();
            }
        } else {
            jDRPaper = JDRPaper.getPredefinedPaper(by);
            if (jDRPaper == null) {
                throw new InvalidPaperIDException(by);
            }
        }
        return jDRPaper;
    }

    public void saveAJR(PrintWriter printWriter, float f) throws IOException {
        if (f < 1.3f) {
            JDRPaper jDRPaper = this;
            if (jDRPaper.getID() > 18) {
                jDRPaper = new JDRPaper(this.getWidth(), this.getHeight());
            }
            AJR.writeInt(printWriter, jDRPaper.id_);
            if (jDRPaper.id_ == 18) {
                AJR.writeDouble(printWriter, jDRPaper.getWidth());
                AJR.writeDouble(printWriter, jDRPaper.getHeight());
                AJR.writeBoolean(printWriter, jDRPaper.portrait);
            }
        } else {
            printWriter.print(this.getName() + " ");
            if (this.id_ == 18) {
                AJR.writeDouble(printWriter, this.getWidth());
                AJR.writeDouble(printWriter, this.getHeight());
            }
        }
    }

    public static JDRPaper readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, EOFException, BufferOverflowException {
        JDRPaper jDRPaper;
        block11: {
            jDRPaper = null;
            if (f < 1.3f) {
                int n = AJR.readInt(bufferedReader);
                if (n == 18) {
                    double d = AJR.readDouble(bufferedReader);
                    double d2 = AJR.readDouble(bufferedReader);
                    jDRPaper = new JDRPaper(d, d2);
                    jDRPaper.portrait = AJR.readBoolean(bufferedReader);
                } else {
                    jDRPaper = JDRPaper.getPredefinedPaper(n);
                    if (jDRPaper == null) {
                        throw new InvalidPaperIDException(n, AJR.getLineNum());
                    }
                }
            } else {
                String string = AJR.readWord(bufferedReader);
                try {
                    int n = Integer.parseInt(string);
                    if (n == 18) {
                        String string2 = AJR.readWord(bufferedReader);
                        double d = JDRUnit.parseUnit(string2);
                        string2 = AJR.readWord(bufferedReader);
                        double d3 = JDRUnit.parseUnit(string2);
                        jDRPaper = new JDRPaper(d, d3);
                    } else {
                        jDRPaper = JDRPaper.getPredefinedPaper(n);
                        if (jDRPaper == null) {
                            throw new InvalidPaperIDException(n, AJR.getLineNum());
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (string.equals(name[18])) {
                        String string3 = AJR.readWord(bufferedReader);
                        double d = JDRUnit.parseUnit(string3);
                        string3 = AJR.readWord(bufferedReader);
                        double d4 = JDRUnit.parseUnit(string3);
                        jDRPaper = new JDRPaper(d, d4);
                    }
                    jDRPaper = JDRPaper.getPredefinedPaper(string);
                    if (jDRPaper != null) break block11;
                    throw new InvalidPaperNameException(string, AJR.getLineNum());
                }
            }
        }
        return jDRPaper;
    }
}

