/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import java.util.Enumeration;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPaintIDException;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRPaintLoader {
    private Vector<JDRPaintLoaderListener> listeners_ = new Vector();
    private String remainder = "";

    public void saveJDR(JDRPaint jDRPaint, DataOutputStream dataOutputStream, float f) throws IOException {
        if (jDRPaint == null) {
            dataOutputStream.writeChar(84);
        } else {
            dataOutputStream.writeChar(jDRPaint.getListener().getJDRid(f));
            jDRPaint.getListener().writeJDR(jDRPaint, dataOutputStream, f);
        }
    }

    public JDRPaint loadJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        char c = dataInputStream.readChar();
        Enumeration<JDRPaintLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRPaintLoaderListener jDRPaintLoaderListener = enumeration.nextElement();
            if (jDRPaintLoaderListener.getJDRid(f) != c) continue;
            return jDRPaintLoaderListener.readJDR(dataInputStream, f);
        }
        throw new InvalidPaintIDException(c);
    }

    public void saveAJR(JDRPaint jDRPaint, PrintWriter printWriter, float f) throws IOException {
        if (jDRPaint == null) {
            AJR.writeChar(printWriter, 'T');
        } else {
            AJR.writeChar(printWriter, jDRPaint.getListener().getAJRid(f));
            jDRPaint.getListener().writeAJR(jDRPaint, printWriter, f);
        }
    }

    public JDRPaint loadAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        char c = AJR.readChar(bufferedReader);
        Enumeration<JDRPaintLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRPaintLoaderListener jDRPaintLoaderListener = enumeration.nextElement();
            if (jDRPaintLoaderListener.getAJRid(f) != c) continue;
            return jDRPaintLoaderListener.readAJR(bufferedReader, f);
        }
        throw new InvalidPaintIDException(c);
    }

    public String getConfigString(JDRPaint jDRPaint) {
        int n = jDRPaint.getListener().getConfigId();
        String string = jDRPaint.getListener().getConfigString(jDRPaint);
        if (string.equals("")) {
            return "" + n;
        }
        return "" + n + "," + string;
    }

    public JDRPaint parseConfig(String string) throws InvalidFormatException {
        String[] stringArray = string.split(",", 2);
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("Invalid paint identifier '" + stringArray[0] + "'");
        }
        String string2 = stringArray.length < 2 ? "" : stringArray[1];
        Enumeration<JDRPaintLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRPaintLoaderListener jDRPaintLoaderListener = enumeration.nextElement();
            if (jDRPaintLoaderListener.getConfigId() != n) continue;
            JDRPaint jDRPaint = jDRPaintLoaderListener.parseConfig(string2);
            this.remainder = jDRPaintLoaderListener.getConfigRemainder();
            return jDRPaint;
        }
        this.remainder = string2;
        throw new InvalidPaintIDException(n);
    }

    public String getConfigRemainder() {
        return this.remainder;
    }

    public void addListener(JDRPaintLoaderListener jDRPaintLoaderListener) {
        this.listeners_.add(jDRPaintLoaderListener);
    }

    public Vector<JDRPaintLoaderListener> getListeners() {
        return this.listeners_;
    }
}

