/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import java.util.Enumeration;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.FlowFrame;
import uk.ac.uea.cmp.nlct.jdr.InvalidDescriptionLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidObjectException;
import uk.ac.uea.cmp.nlct.jdr.InvalidObjectIDException;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRObjectLoader {
    private Vector<JDRObjectLoaderListener> listeners_ = new Vector();

    public void saveJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRObjectLoaderListener jDRObjectLoaderListener = jDRObject.getListener();
        if (jDRObjectLoaderListener == null) {
            throw new InvalidObjectException("Object " + jDRObject + " doesn't have a valid listener");
        }
        dataOutputStream.writeChar(jDRObjectLoaderListener.getJDRid(f));
        jDRObjectLoaderListener.writeJDR(jDRObject, dataOutputStream, f);
        if (jDRObject instanceof JDRCompleteObject) {
            JDRCompleteObject jDRCompleteObject = (JDRCompleteObject)jDRObject;
            if (jDRCompleteObject.flowframe == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                jDRCompleteObject.flowframe.save(dataOutputStream, f);
            }
            if (f >= 1.2f) {
                int n = jDRCompleteObject.description.length();
                dataOutputStream.writeInt(n);
                if (n > 0) {
                    dataOutputStream.writeChars(jDRCompleteObject.description);
                }
            }
        }
    }

    public JDRObject loadJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        char c = dataInputStream.readChar();
        Enumeration<JDRObjectLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRObjectLoaderListener jDRObjectLoaderListener = enumeration.nextElement();
            if (jDRObjectLoaderListener.getJDRid(f) != c) continue;
            JDRObject jDRObject = jDRObjectLoaderListener.readJDR(dataInputStream, f);
            if (jDRObject instanceof JDRCompleteObject) {
                JDRCompleteObject jDRCompleteObject = (JDRCompleteObject)jDRObject;
                FlowFrame flowFrame = null;
                if (dataInputStream.readBoolean()) {
                    flowFrame = FlowFrame.read(dataInputStream, f);
                }
                String string = "";
                if (f >= 1.2f) {
                    int n = dataInputStream.readInt();
                    if (n > 0) {
                        char[] cArray = new char[n];
                        for (int i = 0; i < n; ++i) {
                            cArray[i] = dataInputStream.readChar();
                        }
                        string = new String(cArray);
                    } else if (n < 0) {
                        throw new InvalidDescriptionLengthException(n);
                    }
                }
                if (jDRCompleteObject != null) {
                    jDRCompleteObject.flowframe = flowFrame;
                    jDRCompleteObject.description = string;
                }
            }
            return jDRObject;
        }
        throw new InvalidObjectIDException(c);
    }

    public void saveAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRObjectLoaderListener jDRObjectLoaderListener = jDRObject.getListener();
        if (jDRObjectLoaderListener == null) {
            throw new InvalidObjectException("Object " + jDRObject + " doesn't have a valid listener");
        }
        AJR.writeChar(printWriter, jDRObjectLoaderListener.getAJRid(f));
        jDRObjectLoaderListener.writeAJR(jDRObject, printWriter, f);
        if (jDRObject instanceof JDRCompleteObject) {
            JDRCompleteObject jDRCompleteObject = (JDRCompleteObject)jDRObject;
            if (jDRCompleteObject.flowframe == null) {
                AJR.writeBoolean(printWriter, false);
            } else {
                AJR.writeBoolean(printWriter, true);
                jDRCompleteObject.flowframe.saveAJR(printWriter, f);
            }
            if (f >= 1.2f) {
                int n = jDRCompleteObject.description.length();
                AJR.writeInt(printWriter, n);
                if (n > 0) {
                    printWriter.println(jDRCompleteObject.description);
                }
            }
        }
    }

    public JDRObject loadAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        char c = AJR.readChar(bufferedReader);
        Enumeration<JDRObjectLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRObjectLoaderListener jDRObjectLoaderListener = enumeration.nextElement();
            if (jDRObjectLoaderListener.getAJRid(f) != c) continue;
            JDRObject jDRObject = jDRObjectLoaderListener.readAJR(bufferedReader, f);
            if (jDRObject instanceof JDRCompleteObject) {
                JDRCompleteObject jDRCompleteObject = (JDRCompleteObject)jDRObject;
                FlowFrame flowFrame = null;
                if (AJR.readBoolean(bufferedReader)) {
                    flowFrame = FlowFrame.readAJR(bufferedReader, f);
                }
                String string = "";
                if (f >= 1.2f) {
                    int n = AJR.readInt(bufferedReader);
                    if (n > 0) {
                        string = AJR.readString(bufferedReader, n);
                    } else if (n < 0) {
                        throw new InvalidDescriptionLengthException(n);
                    }
                }
                if (jDRObject != null) {
                    jDRCompleteObject.flowframe = flowFrame;
                    jDRCompleteObject.description = string;
                }
            }
            return jDRObject;
        }
        throw new InvalidObjectIDException(c);
    }

    public void addListener(JDRObjectLoaderListener jDRObjectLoaderListener) {
        this.listeners_.add(jDRObjectLoaderListener);
    }

    public Vector<JDRObjectLoaderListener> getListeners() {
        return this.listeners_;
    }
}

